/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Vec2;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourIntersection;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeArtifexKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u001a\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a\u0014\u0010\t\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0013\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"contains", "", "Lorg/openrndr/shape/ShapeContour;", "point", "Lorg/openrndr/math/Vector2;", "split", "", "cutter", "cutters", "removeLoops", "attempts", "", "union", "Lorg/openrndr/shape/Shape;", "other", "difference", "intersection", "intersections", "Lorg/openrndr/shape/ContourIntersection;", "Lorg/openrndr/shape/Segment2D;", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nShapeContourExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeContourExtensions.kt\norg/openrndr/shape/ShapeContourExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n2341#2,14:81\n*S KotlinDebug\n*F\n+ 1 ShapeContourExtensions.kt\norg/openrndr/shape/ShapeContourExtensionsKt\n*L\n32#1:81,14\n*E\n"})
public final class ShapeContourExtensionsKt {
    public static final boolean contains(@NotNull ShapeContour $this$contains, @NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(point, "point");
        return $this$contains.getClosed() && $this$contains.getRing2$openrndr_shape().test(new Vec2(point.x(), point.y())).getInside();
    }

    @NotNull
    public static final List<ShapeContour> split(@NotNull ShapeContour $this$split, @NotNull ShapeContour cutter) {
        Intrinsics.checkNotNullParameter($this$split, "<this>");
        Intrinsics.checkNotNullParameter(cutter, "cutter");
        return ShapeArtifexKt.split($this$split, cutter);
    }

    @NotNull
    public static final List<ShapeContour> split(@NotNull ShapeContour $this$split, @NotNull List<ShapeContour> cutters) {
        Intrinsics.checkNotNullParameter($this$split, "<this>");
        Intrinsics.checkNotNullParameter(cutters, "cutters");
        return ShapeArtifexKt.split($this$split, cutters);
    }

    @NotNull
    public static final ShapeContour removeLoops(@NotNull ShapeContour $this$removeLoops, int attempts) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$removeLoops, "<this>");
        if (attempts > 10) {
            throw new IllegalStateException("tried more than 10 times to remove loops".toString());
        }
        if ($this$removeLoops.getClosed()) {
            return $this$removeLoops;
        }
        List selfIntersections = ShapeArtifexKt.intersections$default($this$removeLoops, $this$removeLoops, 0.0, 4, null);
        if (selfIntersections.isEmpty()) {
            return $this$removeLoops;
        }
        Iterable $this$minByOrNull$iv = selfIntersections;
        boolean $i$f$minByOrNull22 = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ContourIntersection it = (ContourIntersection)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.a().contourT();
                do {
                    Object e$iv = iterator$iv.next();
                    ContourIntersection it2 = (ContourIntersection)e$iv;
                    $i$a$-minByOrNull-ShapeContourExtensionsKt$removeLoops$toFix$1 = false;
                    double v$iv = it2.a().contourT();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        ContourIntersection toFix = v0;
        Double[] $i$f$minByOrNull22 = new Double[]{toFix.a().contourT(), toFix.b().contourT()};
        List sorted2 = CollectionsKt.sorted((Iterable)CollectionsKt.listOf($i$f$minByOrNull22));
        ShapeContour head = $this$removeLoops.sub(0.0, ((Number)sorted2.get(0)).doubleValue());
        ShapeContour tail = $this$removeLoops.sub(((Number)sorted2.get(1)).doubleValue(), 1.0);
        List tailSegments = CollectionsKt.toMutableList((Collection)tail.getSegments());
        if (head.getSegments().isEmpty()) {
            return tail;
        }
        if (tail.getSegments().isEmpty()) {
            return head;
        }
        tailSegments.set(0, Segment2D.copy$default((Segment2D)CollectionsKt.first(tailSegments), CollectionsKt.last(head.getSegments()).getEnd(), null, null, false, 14, null));
        ShapeContour fixedTail = new ShapeContour(tailSegments, false, null, 4, null);
        return ShapeContourExtensionsKt.removeLoops(head, attempts + 1).plus(ShapeContourExtensionsKt.removeLoops(fixedTail, attempts + 1));
    }

    public static /* synthetic */ ShapeContour removeLoops$default(ShapeContour shapeContour, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ShapeContourExtensionsKt.removeLoops(shapeContour, n);
    }

    @NotNull
    public static final Shape union(@NotNull ShapeContour $this$union, @NotNull Shape other) {
        Intrinsics.checkNotNullParameter($this$union, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.union($this$union.getShape(), other);
    }

    @NotNull
    public static final Shape difference(@NotNull ShapeContour $this$difference, @NotNull Shape other) {
        Intrinsics.checkNotNullParameter($this$difference, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.difference($this$difference, other);
    }

    @NotNull
    public static final Shape intersection(@NotNull ShapeContour $this$intersection, @NotNull Shape other) {
        Intrinsics.checkNotNullParameter($this$intersection, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.intersection($this$intersection, other);
    }

    @NotNull
    public static final List<ContourIntersection> intersections(@NotNull ShapeContour $this$intersections, @NotNull Segment2D other) {
        Intrinsics.checkNotNullParameter($this$intersections, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.intersections$default($this$intersections, other.getContour(), 0.0, 4, null);
    }

    @NotNull
    public static final List<ContourIntersection> intersections(@NotNull ShapeContour $this$intersections, @NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter($this$intersections, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.intersections$default($this$intersections, other, 0.0, 4, null);
    }

    @NotNull
    public static final List<ContourIntersection> intersections(@NotNull ShapeContour $this$intersections, @NotNull Shape other) {
        Intrinsics.checkNotNullParameter($this$intersections, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeArtifexKt.intersections($this$intersections.getShape(), other);
    }
}

