/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.utils.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lorg/openrndr/utils/buffer/MPPBuffer;", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "rewind", "", "int", "", "getInt", "()I", "float", "", "getFloat", "()F", "double", "", "getDouble", "()D", "byte", "", "getByte", "()B", "get", "capacity", "target", "", "remaining", "put", "putFloat", "putDouble", "putInt", "Companion", "openrndr-utils"})
public final class MPPBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer byteBuffer;

    public MPPBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter(byteBuffer, "byteBuffer");
        this.byteBuffer = byteBuffer;
    }

    @NotNull
    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public final void rewind() {
        this.byteBuffer.rewind();
    }

    public final int getInt() {
        return this.byteBuffer.getInt();
    }

    public final float getFloat() {
        return this.byteBuffer.getFloat();
    }

    public final double getDouble() {
        return this.byteBuffer.getDouble();
    }

    public final byte getByte() {
        return this.byteBuffer.get();
    }

    public final byte get() {
        return this.byteBuffer.get();
    }

    public final int capacity() {
        return this.byteBuffer.capacity();
    }

    public final void get(@NotNull byte[] target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.byteBuffer.get(target);
    }

    public final int remaining() {
        return this.byteBuffer.remaining();
    }

    public final void put(byte by) {
        this.byteBuffer.put(by);
    }

    public final void putFloat(float f) {
        this.byteBuffer.putFloat(f);
    }

    public final void putDouble(double d) {
        this.byteBuffer.putDouble(d);
    }

    public final void putInt(int n) {
        this.byteBuffer.putInt(n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/utils/buffer/MPPBuffer$Companion;", "", "<init>", "()V", "allocate", "Lorg/openrndr/utils/buffer/MPPBuffer;", "size", "", "createFrom", "fromBytes", "", "openrndr-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MPPBuffer allocate(int size) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
            byteBuffer.order(ByteOrder.nativeOrder());
            Intrinsics.checkNotNull(byteBuffer);
            return new MPPBuffer(byteBuffer);
        }

        @NotNull
        public final MPPBuffer createFrom(@NotNull byte[] fromBytes) {
            Intrinsics.checkNotNullParameter(fromBytes, "fromBytes");
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fromBytes.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.put(fromBytes);
            byteBuffer.flip();
            Intrinsics.checkNotNull(byteBuffer);
            return new MPPBuffer(byteBuffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

