/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.VorbisTrack;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Extension;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.events.Event;
import org.openrndr.events.EventKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00103\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Laudio/AudioPlayer;", "Lorg/openrndr/Extension;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "audioFile", "", "getAudioFile", "()Ljava/lang/String;", "setAudioFile", "(Ljava/lang/String;)V", "duration", "", "getDuration", "()D", "setDuration", "(D)V", "loop", "getLoop", "setLoop", "drawProgress", "getDrawProgress", "setDrawProgress", "useAudioClock", "getUseAudioClock", "setUseAudioClock", "useScrub", "getUseScrub", "setUseScrub", "showProgress", "getShowProgress", "setShowProgress", "vt", "Laudio/VorbisTrack;", "getVt", "()Laudio/VorbisTrack;", "setVt", "(Laudio/VorbisTrack;)V", "frameTime", "setup", "", "program", "Lorg/openrndr/Program;", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "afterDraw", "deminityy"})
@SourceDebugExtension(value={"SMAP\nAudioPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioPlayer.kt\naudio/AudioPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1#2:472\n*E\n"})
public final class AudioPlayer
implements Extension {
    private boolean enabled = true;
    @NotNull
    private String audioFile = "data/audio/audio.ogg";
    private double duration;
    private boolean loop;
    private boolean drawProgress = true;
    private boolean useAudioClock = true;
    private boolean useScrub = true;
    private boolean showProgress = true;
    @Nullable
    private VorbisTrack vt;
    private double frameTime;

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final String getAudioFile() {
        return this.audioFile;
    }

    public final void setAudioFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.audioFile = string;
    }

    public final double getDuration() {
        return this.duration;
    }

    public final void setDuration(double d) {
        this.duration = d;
    }

    public final boolean getLoop() {
        return this.loop;
    }

    public final void setLoop(boolean bl) {
        this.loop = bl;
    }

    public final boolean getDrawProgress() {
        return this.drawProgress;
    }

    public final void setDrawProgress(boolean bl) {
        this.drawProgress = bl;
    }

    public final boolean getUseAudioClock() {
        return this.useAudioClock;
    }

    public final void setUseAudioClock(boolean bl) {
        this.useAudioClock = bl;
    }

    public final boolean getUseScrub() {
        return this.useScrub;
    }

    public final void setUseScrub(boolean bl) {
        this.useScrub = bl;
    }

    public final boolean getShowProgress() {
        return this.showProgress;
    }

    public final void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    @Nullable
    public final VorbisTrack getVt() {
        return this.vt;
    }

    public final void setVt(@Nullable VorbisTrack vorbisTrack) {
        this.vt = vorbisTrack;
    }

    public void setup(@NotNull Program program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        File f = new File(this.audioFile);
        if (!f.exists()) {
            boolean bl = false;
            String string = "file '" + this.audioFile + "' does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        VorbisTrack vorbisTrack = this.vt = new VorbisTrack(this.audioFile);
        if (vorbisTrack != null) {
            VorbisTrack.play$default(vorbisTrack, null, this.loop, 1, null);
        }
        if (this.useScrub) {
            Object[] objectArray = new Event[]{program.getMouse().getButtonUp(), program.getMouse().getDragged()};
            EventKt.listen((Iterable)CollectionsKt.listOf((Object[])objectArray), arg_0 -> AudioPlayer.setup$lambda$1(program, this, arg_0));
        }
        if (this.useAudioClock) {
            program.setClock(() -> AudioPlayer.setup$lambda$2(this));
        }
    }

    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program) {
        Intrinsics.checkNotNullParameter((Object)drawer, (String)"drawer");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
    }

    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program) {
        Intrinsics.checkNotNullParameter((Object)drawer, (String)"drawer");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        if (this.showProgress) {
            DrawerKt.isolated((Drawer)drawer, arg_0 -> AudioPlayer.afterDraw$lambda$3(drawer, this, arg_0));
        }
    }

    public void shutdown(@NotNull Program program) {
        Extension.DefaultImpls.shutdown((Extension)this, (Program)program);
    }

    private static final Unit setup$lambda$1(Program $program, AudioPlayer this$0, MouseEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$program, (String)"$program");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            double dx = it.getPosition().x() / (double)$program.getWidth();
            VorbisTrack vorbisTrack = this$0.vt;
            if (vorbisTrack == null) break block0;
            vorbisTrack.skipTo((float)dx);
        }
        return Unit.INSTANCE;
    }

    private static final double setup$lambda$2(AudioPlayer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VorbisTrack vorbisTrack = this$0.vt;
        return vorbisTrack != null ? vorbisTrack.position() : 0.0;
    }

    private static final Unit afterDraw$lambda$3(Drawer $drawer, AudioPlayer this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        $drawer.defaults();
        VorbisTrack vorbisTrack = this$0.vt;
        double dx = RangesKt.coerceIn((double)(vorbisTrack != null ? vorbisTrack.relativePosition() : 0.0), (double)0.0, (double)1.0);
        $drawer.rectangle(10.0, (double)$drawer.getHeight() - 20.0, ((double)$drawer.getWidth() - 20.0) * dx, 10.0);
        return Unit.INSTANCE;
    }
}

