/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import demo.model.Demo;
import demo.view.DatasetLoaderKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fJ\n\u0010\r\u001a\u00020\u0001*\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR)\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Ldemo/view/DatasetLoader;", "", "demo", "Ldemo/model/Demo;", "<init>", "(Ldemo/model/Demo;)V", "getDemo", "()Ldemo/model/Demo;", "datasets", "", "", "getDatasets", "()Ljava/util/Map;", "function", "Lkotlin/Function1;", "", "Lkotlinx/serialization/json/JsonElement;", "environment", "getEnvironment", "()Lkotlin/jvm/functions/Function1;", "environment$delegate", "Lkotlin/Lazy;", "loadDatasets", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nDatasetLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasetLoader.kt\ndemo/view/DatasetLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n1557#2:83\n1628#2,3:84\n1863#2,2:90\n1863#2,2:95\n1557#2:97\n1628#2,3:98\n3829#3:87\n4344#3,2:88\n3829#3:92\n4344#3,2:93\n*S KotlinDebug\n*F\n+ 1 DatasetLoader.kt\ndemo/view/DatasetLoader\n*L\n41#1:83\n41#1:84,3\n68#1:90,2\n73#1:95,2\n20#1:97\n20#1:98,3\n68#1:87\n68#1:88,2\n73#1:92\n73#1:93,2\n*E\n"})
public final class DatasetLoader {
    @NotNull
    private final Demo demo;
    @NotNull
    private final Map<String, Object> datasets;
    @NotNull
    private final Lazy environment$delegate;

    public DatasetLoader(@NotNull Demo demo) {
        Intrinsics.checkNotNullParameter((Object)demo, (String)"demo");
        this.demo = demo;
        this.datasets = new LinkedHashMap();
        this.environment$delegate = LazyKt.lazy(() -> DatasetLoader.environment_delegate$lambda$5(this));
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final Map<String, Object> getDatasets() {
        return this.datasets;
    }

    @NotNull
    public final Function1<String, Object> function(@NotNull Map<?, ?> $this$function) {
        Intrinsics.checkNotNullParameter($this$function, (String)"<this>");
        return arg_0 -> DatasetLoader.function$lambda$1($this$function, this, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object function(@NotNull JsonElement $this$function) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$function, (String)"<this>");
        JsonElement obj = $this$function;
        JsonElement jsonElement = $this$function;
        if (jsonElement instanceof JsonPrimitive) {
            object = ((JsonPrimitive)$this$function).isString() ? ((JsonPrimitive)$this$function).getContent() : Double.valueOf(JsonElementKt.getDouble((JsonPrimitive)((JsonPrimitive)$this$function)));
        } else if (jsonElement instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$function;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.function((JsonElement)it));
            }
            object = (List)destination$iv$iv;
        } else if (jsonElement instanceof JsonObject) {
            object = arg_0 -> DatasetLoader.function$lambda$3(obj, this, arg_0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final Function1<String, Object> getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Function1)lazy.getValue();
    }

    public final void loadDatasets() {
        File it;
        Object[] $this$filterTo$iv$iv;
        File datasetsDir = new File(this.demo.getDataBase(), "datasets");
        if (!datasetsDir.exists()) {
            return;
        }
        File[] fileArray = datasetsDir.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it2 = (File)element$iv;
            int n = 0;
            DatasetLoaderKt.access$getLogger$p().info(() -> DatasetLoader.loadDatasets$lambda$8$lambda$7(it2));
            Intrinsics.checkNotNull((Object)it2);
            JsonElement jsonObject = Json.Default.parseToJsonElement(FilesKt.readText$default((File)it2, null, (int)1, null));
            this.datasets.put(FilesKt.getNameWithoutExtension((File)it2), jsonObject);
        }
        File[] fileArray2 = datasetsDir.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray2, (String)"listFiles(...)");
        $this$filter$iv = fileArray2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"cbor")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object cborObject;
            File it3 = (File)element$iv;
            boolean bl = false;
            DatasetLoaderKt.access$getLogger$p().info(() -> DatasetLoader.loadDatasets$lambda$11$lambda$10(it3));
            ObjectMapper mapper = (ObjectMapper)new CBORMapper();
            Intrinsics.checkNotNull((Object)it3);
            Intrinsics.checkNotNullExpressionValue((Object)mapper.readValue(FilesKt.readBytes((File)it3), Object.class), (String)"readValue(...)");
            this.datasets.put(FilesKt.getNameWithoutExtension((File)it3), cborObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object function$lambda$1(Map<?, ?> $this_function, DatasetLoader this$0, String n) {
        Object object;
        Object o = $this_function.get(n);
        Object obj = o;
        if (obj instanceof Map) {
            object = this$0.function((Map)o);
        } else if (obj instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)o;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof Map ? this$0.function((Map)it) : it);
            }
            object = (List)destination$iv$iv;
        } else {
            object = o;
        }
        return object;
    }

    private static final Object function$lambda$3(JsonElement $obj, DatasetLoader this$0, String n) {
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        JsonElement jsonElement = (JsonElement)((JsonObject)$obj).get((Object)n);
        return jsonElement != null ? this$0.function(jsonElement) : null;
    }

    private static final Object environment_delegate$lambda$5$lambda$4(DatasetLoader this$0, String property) {
        Object set = this$0.datasets.get(property);
        Object object = set;
        return object instanceof Map ? this$0.function((Map)set) : (object instanceof JsonElement ? this$0.function((JsonElement)set) : set);
    }

    private static final Function1 environment_delegate$lambda$5(DatasetLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return arg_0 -> DatasetLoader.environment_delegate$lambda$5$lambda$4(this$0, arg_0);
    }

    private static final Object loadDatasets$lambda$8$lambda$7(File $it) {
        return "loading data set " + $it.getPath();
    }

    private static final Object loadDatasets$lambda$11$lambda$10(File $it) {
        return "loading data set " + $it.getPath();
    }
}

