/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Demo;
import demo.model.Layer;
import demo.model.PaintStyle;
import demo.view.AssetLoader;
import demo.view.DemoController;
import demo.view.LayerRendererExtensionsKt;
import demo.view.LayerRendererKt;
import demo.view.LayerView;
import demo.view.LazyMap;
import demo.view.ObjectView;
import demo.view.PaintView;
import demo.view.TargetManager;
import filewatcher.FileWatcherKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import lib.Matrix44Kt;
import lib.ShapeContourKt;
import lib.ShapeNodeKt;
import lib.Subtitle;
import lib.SubtitlesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferJVM;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorTransformsKt;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.draw.WrapMode;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.composition.CompositionDrawer;
import org.openrndr.extra.composition.CompositionDrawerKt;
import org.openrndr.extra.composition.ShapeNode;
import org.openrndr.extra.fx.blend.Multiply;
import org.openrndr.extra.objloader.MeshData;
import org.openrndr.extra.objloader.MeshDataExtensionsKt;
import org.openrndr.extra.objloader.OBJLoaderKt;
import org.openrndr.extra.objloader.WireframeKt;
import org.openrndr.extra.shapes.rectify.Path3DExtensionsKt;
import org.openrndr.extra.shapes.rectify.RectifiedContour;
import org.openrndr.extra.shapes.rectify.RectifiedPath3D;
import org.openrndr.extra.shapes.rectify.ShapeContourExtensionsKt;
import org.openrndr.extra.svg.SVGLoaderKt;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Path3D;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeTopology;
import org.openrndr.shape.Triangle;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0004ghijB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZJ5\u0010[\u001a\u00020\\*\u00020]2\u0006\u0010^\u001a\u00020L2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020`\u0012\u0004\u0012\u00020R0\u001e2\u0006\u0010a\u001a\u00020ZH\u0000\u00a2\u0006\u0002\bbJ \u0010c\u001a\u00020\\2\u0006\u0010d\u001a\u00020\\2\u0006\u0010e\u001a\u00020\\2\u0006\u0010f\u001a\u00020ZH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R)\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0018R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\"0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u001c\u001a\u0004\b-\u0010.R\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002030'0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050'0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\b\u0012\u0004\u0012\u0002070$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u001b\u00109\u001a\u00020:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u001c\u001a\u0004\b;\u0010<R\u001b\u0010>\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010\u001c\u001a\u0004\b?\u0010@R\u001b\u0010B\u001a\u00020C8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u001c\u001a\u0004\bD\u0010ER\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\f0H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001d\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0\u001f0'\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u001a\u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020R0PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010S\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020T0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010V\u00a8\u0006k"}, d2={"Ldemo/view/LayerRenderer;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "targetManager", "Ldemo/view/TargetManager;", "demoController", "Ldemo/view/DemoController;", "selectorContext", "Lkotlin/Function1;", "", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;Ldemo/view/TargetManager;Ldemo/view/DemoController;Lkotlin/jvm/functions/Function1;)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getTargetManager", "()Ldemo/view/TargetManager;", "getDemoController", "()Ldemo/view/DemoController;", "getSelectorContext", "()Lkotlin/jvm/functions/Function1;", "environment", "getEnvironment", "environment$delegate", "Lkotlin/Lazy;", "paintStyles", "Ldemo/view/LazyMap;", "Lkotlin/Function0;", "Ldemo/model/PaintStyle;", "shadeStyles", "Lorg/openrndr/draw/ShadeStyle;", "meshes", "Ldemo/view/AssetLoader;", "Ldemo/view/LayerRenderer$MeshAsset;", "subtitles", "", "Llib/Subtitle;", "getSubtitles$deminityy", "()Ldemo/view/AssetLoader;", "textPathRenderer", "LCFontImageMapDrawer;", "getTextPathRenderer", "()LCFontImageMapDrawer;", "textPathRenderer$delegate", "compositions", "Lorg/openrndr/extra/composition/Composition;", "compositionShapes", "Lorg/openrndr/extra/composition/ShapeNode;", "compositionDraws3D", "Ldemo/view/LayerRenderer$ObjectDraw3D;", "images", "Lorg/openrndr/draw/ColorBuffer;", "getImages$deminityy", "blendModeTarget", "Lorg/openrndr/draw/RenderTarget;", "getBlendModeTarget", "()Lorg/openrndr/draw/RenderTarget;", "blendModeTarget$delegate", "blendModeResolved", "getBlendModeResolved", "()Lorg/openrndr/draw/ColorBuffer;", "blendModeResolved$delegate", "multiplyFilter", "Lorg/openrndr/extra/fx/blend/Multiply;", "getMultiplyFilter", "()Lorg/openrndr/extra/fx/blend/Multiply;", "multiplyFilter$delegate", "billOfMaterials", "", "getBillOfMaterials", "()Ljava/util/Set;", "layerWatchers", "Ldemo/model/Layer;", "getLayerWatchers", "()Ljava/util/List;", "rectified", "", "Lorg/openrndr/shape/ShapeContour;", "Lorg/openrndr/extra/shapes/rectify/RectifiedContour;", "layerViews", "Ldemo/view/LayerView;", "getLayerViews", "()Ldemo/view/LazyMap;", "renderLayers", "", "renderTime", "", "pathTransform", "Lorg/openrndr/math/Matrix44;", "Ldemo/model/Layer$Object;", "layer", "resolvedPaths", "Ldemo/model/Layer$Path;", "objectTime", "pathTransform$deminityy", "mixRotation", "translation", "pose", "poseRotation", "ObjectDraw3D", "MeshAsset", "ObjectPath3D", "ObjectContext", "deminityy"})
@SourceDebugExtension(value={"SMAP\nLayerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerRenderer.kt\ndemo/view/LayerRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Functions.kt\norg/openrndr/math/FunctionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,756:1\n11102#2:757\n11437#2,3:758\n1557#3:761\n1628#3,3:762\n774#3:765\n865#3,2:766\n1557#3:770\n1628#3,3:771\n1557#3:774\n1628#3,3:775\n1368#3:778\n1454#3,5:779\n1567#3:784\n1598#3,3:785\n1557#3:788\n1628#3,3:789\n1601#3:792\n774#3:800\n865#3,2:801\n1863#3,2:803\n774#3:805\n865#3,2:806\n1053#3:808\n1485#3:809\n1510#3,3:810\n1513#3,3:820\n111#4:768\n1#5:769\n381#6,7:793\n381#6,7:813\n*S KotlinDebug\n*F\n+ 1 LayerRenderer.kt\ndemo/view/LayerRenderer\n*L\n192#1:757\n192#1:758,3\n251#1:761\n251#1:762,3\n252#1:765\n252#1:766,2\n91#1:770\n91#1:771,3\n97#1:774\n97#1:775,3\n108#1:778\n108#1:779,5\n117#1:784\n117#1:785,3\n119#1:788\n119#1:789,3\n117#1:792\n622#1:800\n622#1:801,2\n624#1:803,2\n278#1:805\n278#1:806,2\n279#1:808\n280#1:809\n280#1:810,3\n280#1:820,3\n713#1:768\n489#1:793,7\n280#1:813,7\n*E\n"})
public final class LayerRenderer {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    @NotNull
    private final TargetManager targetManager;
    @NotNull
    private final DemoController demoController;
    @NotNull
    private final Function1<String, Object> selectorContext;
    @NotNull
    private final Lazy environment$delegate;
    @NotNull
    private final LazyMap<String, Function0<PaintStyle>> paintStyles;
    @NotNull
    private final LazyMap<PaintStyle, ShadeStyle> shadeStyles;
    @NotNull
    private final AssetLoader<MeshAsset> meshes;
    @NotNull
    private final AssetLoader<List<Subtitle>> subtitles;
    @NotNull
    private final Lazy textPathRenderer$delegate;
    @NotNull
    private final AssetLoader<Composition> compositions;
    @NotNull
    private final AssetLoader<List<ShapeNode>> compositionShapes;
    @NotNull
    private final AssetLoader<List<ObjectDraw3D>> compositionDraws3D;
    @NotNull
    private final AssetLoader<ColorBuffer> images;
    @NotNull
    private final Lazy blendModeTarget$delegate;
    @NotNull
    private final Lazy blendModeResolved$delegate;
    @NotNull
    private final Lazy multiplyFilter$delegate;
    @NotNull
    private final Set<String> billOfMaterials;
    @NotNull
    private final List<Function0<Layer>> layerWatchers;
    @NotNull
    private final Map<ShapeContour, RectifiedContour> rectified;
    @NotNull
    private final LazyMap<Layer, LayerView> layerViews;

    /*
     * WARNING - void declaration
     */
    public LayerRenderer(@NotNull Program program, @NotNull Demo demo, @NotNull TargetManager targetManager, @NotNull DemoController demoController, @NotNull Function1<? super String, ? extends Object> selectorContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$compositionShapes_u24lambda_u2418;
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter((Object)demo, (String)"demo");
        Intrinsics.checkNotNullParameter((Object)targetManager, (String)"targetManager");
        Intrinsics.checkNotNullParameter((Object)demoController, (String)"demoController");
        Intrinsics.checkNotNullParameter(selectorContext, (String)"selectorContext");
        this.program = program;
        this.demo = demo;
        this.targetManager = targetManager;
        this.demoController = demoController;
        this.selectorContext = selectorContext;
        this.environment$delegate = LazyKt.lazy(() -> LayerRenderer.environment_delegate$lambda$4(this));
        this.paintStyles = new LazyMap((arg_0, arg_1) -> LayerRenderer.paintStyles$lambda$5(this, arg_0, arg_1));
        this.shadeStyles = new LazyMap(LayerRenderer::shadeStyles$lambda$7);
        this.meshes = new AssetLoader(this.program, this.demo.getAssetPath(), null, LayerRenderer::meshes$lambda$9, 4, null);
        this.subtitles = new AssetLoader<List>(this.program, this.demo.getAssetPath(), CollectionsKt.emptyList(), LayerRenderer::subtitles$lambda$11);
        this.textPathRenderer$delegate = LazyKt.lazy(LayerRenderer::textPathRenderer_delegate$lambda$12);
        this.compositions = new AssetLoader<Composition>(this.program, this.demo.getAssetPath(), CompositionDrawerKt.drawComposition$default(null, null, null, LayerRenderer::compositions$lambda$13, (int)7, null), LayerRenderer::compositions$lambda$14);
        File[] fileArray2 = fileArray = new AssetLoader(this.program, this.demo.getAssetPath(), CollectionsKt.emptyList(), LayerRenderer::compositionShapes$lambda$16);
        LayerRenderer layerRenderer = this;
        boolean $i$a$-apply-LayerRenderer$compositionShapes$32 = false;
        $this$compositionShapes_u24lambda_u2418.getOnError().listen(arg_0 -> LayerRenderer.compositionShapes$lambda$18$lambda$17(this, arg_0));
        layerRenderer.compositionShapes = fileArray;
        this.compositionDraws3D = new AssetLoader<List>(this.program, this.demo.getAssetPath(), CollectionsKt.emptyList(), LayerRenderer::compositionDraws3D$lambda$23);
        this.images = new AssetLoader(this.program, this.demo.getAssetPath(), null, LayerRenderer::images$lambda$25, 4, null);
        this.blendModeTarget$delegate = LazyKt.lazy(LayerRenderer::blendModeTarget_delegate$lambda$27);
        this.blendModeResolved$delegate = LazyKt.lazy(LayerRenderer::blendModeResolved_delegate$lambda$28);
        this.multiplyFilter$delegate = LazyKt.lazy(LayerRenderer::multiplyFilter_delegate$lambda$29);
        this.billOfMaterials = new LinkedHashSet();
        File[] fileArray3 = new File(this.demo.getDataBase(), "layers").listFiles(LayerRenderer::layerWatchers$lambda$30);
        Intrinsics.checkNotNull((Object)fileArray3);
        fileArray = fileArray3;
        layerRenderer = this;
        boolean $i$f$map = false;
        void $i$a$-apply-LayerRenderer$compositionShapes$32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Function0<Layer> function0;
            void it;
            void item$iv$iv;
            void var14_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Function0<Layer> $this$layerWatchers_u24lambda_u2434_u24lambda_u2433 = function0 = Layer.Companion.watch(this.program, this.demo, this.selectorContext, (File)it);
            boolean bl2 = false;
            FileWatcherKt.watch($this$layerWatchers_u24lambda_u2434_u24lambda_u2433, arg_0 -> LayerRenderer.layerWatchers$lambda$34$lambda$33$lambda$32(this, (File)it, arg_0));
            collection.add(function0);
        }
        layerRenderer.layerWatchers = (List)destination$iv$iv;
        this.rectified = new LinkedHashMap();
        this.layerViews = new LazyMap((arg_0, arg_1) -> LayerRenderer.layerViews$lambda$35(this, arg_0, arg_1));
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final TargetManager getTargetManager() {
        return this.targetManager;
    }

    @NotNull
    public final DemoController getDemoController() {
        return this.demoController;
    }

    @NotNull
    public final Function1<String, Object> getSelectorContext() {
        return this.selectorContext;
    }

    @NotNull
    public final Function1<String, Object> getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Function1)lazy.getValue();
    }

    @NotNull
    public final AssetLoader<List<Subtitle>> getSubtitles$deminityy() {
        return this.subtitles;
    }

    private final CFontImageMapDrawer getTextPathRenderer() {
        Lazy lazy = this.textPathRenderer$delegate;
        return (CFontImageMapDrawer)lazy.getValue();
    }

    @NotNull
    public final AssetLoader<ColorBuffer> getImages$deminityy() {
        return this.images;
    }

    private final RenderTarget getBlendModeTarget() {
        Lazy lazy = this.blendModeTarget$delegate;
        return (RenderTarget)lazy.getValue();
    }

    private final ColorBuffer getBlendModeResolved() {
        Lazy lazy = this.blendModeResolved$delegate;
        return (ColorBuffer)lazy.getValue();
    }

    private final Multiply getMultiplyFilter() {
        Lazy lazy = this.multiplyFilter$delegate;
        return (Multiply)lazy.getValue();
    }

    @NotNull
    public final Set<String> getBillOfMaterials() {
        return this.billOfMaterials;
    }

    @NotNull
    public final List<Function0<Layer>> getLayerWatchers() {
        return this.layerWatchers;
    }

    @NotNull
    public final LazyMap<Layer, LayerView> getLayerViews() {
        return this.layerViews;
    }

    /*
     * WARNING - void declaration
     */
    public final void renderLayers(double renderTime) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Layer it;
        void $this$mapTo$iv$iv;
        Drawer drawer = this.program.getDrawer();
        Iterable $this$map$iv = this.layerWatchers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Function0 function0 = (Function0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Layer)it.invoke());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!(it.getEnabled() && renderTime >= it.getTime() && renderTime < it.getTime() + it.getDuration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List layers = (List)destination$iv$iv;
        Function1[] $i$f$filter22 = new Function1[]{LayerRenderer::renderLayers$lambda$38, LayerRenderer::renderLayers$lambda$39};
        List sortedLayers = CollectionsKt.sortedWith((Iterable)layers, (Comparator)ComparisonsKt.compareBy((Function1[])$i$f$filter22));
        List<String> targetOrder = this.targetManager.targetOrder();
        for (Layer layer : sortedLayers) {
            LayerView layerView = this.layerViews.get(layer);
            layerView.getAnimation().invoke(renderTime);
            double time = layerView.getAnimation().getTime();
            LazyMap resolvedPathContours = new LazyMap((arg_0, arg_1) -> LayerRenderer.renderLayers$lambda$40(layerView, time, arg_0, arg_1));
            LazyMap resolvedPathPath3Ds = new LazyMap((arg_0, arg_1) -> LayerRenderer.renderLayers$lambda$41(resolvedPathContours, arg_0, arg_1));
            LazyMap<Layer.Object, Matrix44> objectTransforms = layerView.objectTransforms(renderTime);
            DrawerKt.isolated((Drawer)drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58(layerView, drawer, renderTime, objectTransforms, layer, targetOrder, this, time, resolvedPathContours, resolvedPathPath3Ds, arg_0));
        }
    }

    @NotNull
    public final Matrix44 pathTransform$deminityy(@NotNull Layer.Object $this$pathTransform, @NotNull Layer layer, @NotNull LazyMap<Layer.Path, RectifiedContour> resolvedPaths, double objectTime) {
        double d;
        double d2;
        double d3;
        Intrinsics.checkNotNullParameter((Object)$this$pathTransform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(resolvedPaths, (String)"resolvedPaths");
        Layer.Object obj = $this$pathTransform;
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        ObjectView.ObjectFunctions of = this.layerViews.get(layer).getObjects().get($this$pathTransform).getObjectFunctions();
        IntRange intRange = obj.getPaths();
        if (intRange == null || (intRange = CollectionsKt.getIndices((Collection)((Collection)intRange))) == null) {
            throw new IllegalStateException(("no paths for object " + layer.getSourceFile() + "/" + obj).toString());
        }
        int pi = RangesKt.coerceIn((int)((Number)of.getPathIndex().invoke((Object)objectTime)).intValue(), (ClosedRange)((ClosedRange)intRange));
        String pathName = obj.getPaths().get(pi);
        Layer.Path path = layer.getPaths().get(pathName);
        if (path == null) {
            throw new IllegalStateException("path not found".toString());
        }
        Layer.Path path2 = path;
        RectifiedContour rectifiedContour = resolvedPaths.get(path2);
        if (rectifiedContour == null) {
            throw new IllegalStateException("rectified not found".toString());
        }
        RectifiedContour rectified = rectifiedContour;
        double t = rectified.getContour().getClosed() ? (!((d3 = (d2 = ((Number)of.getPathPosition().invoke((Object)objectTime)).doubleValue()) % (d = 1.0)) == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3) : ((Number)of.getPathPosition().invoke((Object)objectTime)).doubleValue();
        Matrix44 rawRotation = (Matrix44)ShapeContourKt.poseParts(rectified, t).component1();
        Layer.Pose pose = obj.getPose();
        Matrix44 rotation = switch (pose == null ? -1 : WhenMappings.$EnumSwitchMapping$4[pose.ordinal()]) {
            case -1, 1 -> rawRotation;
            case 2 -> Matrix44Kt.smoothLimitRotation(rawRotation, ((Number)of.getPoseLimit().invoke((Object)objectTime)).doubleValue(), ((Number)of.getPoseLimitSmoothing().invoke((Object)objectTime)).doubleValue(), 1.0);
            case 3 -> {
                void $this$asDegrees$iv;
                double lookAhead = ((Number)of.getPathLookAhead().invoke((Object)objectTime)).doubleValue();
                double var24_19 = ((Number)of.getPathPosition().invoke((Object)objectTime)).doubleValue() + lookAhead;
                double var26_21 = 1.0;
                double var28_23 = var24_19 % var26_21;
                double lookAheadT = !(var28_23 == 0.0) && !(Math.signum(var28_23) == Math.signum(var26_21)) ? var28_23 + var26_21 : var28_23;
                Vector2 position0 = (Vector2)rectified.position(t);
                Vector2 position1 = (Vector2)rectified.position(lookAheadT);
                Vector2 d = position1.minus(position0);
                double var29_26 = Math.atan2(d.y(), d.x());
                boolean $i$f$getAsDegrees = false;
                void a = $this$asDegrees$iv * 57.29577951308232;
                yield TransformBuilderKt.buildTransform$default(null, arg_0 -> LayerRenderer.pathTransform$lambda$59((double)a, arg_0), (int)1, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if ($this$pathTransform.getPose() != Layer.Pose.STATIONARY) {
            modelTransform = modelTransform.times(TransformBuilderKt.buildTransform$default(null, arg_0 -> LayerRenderer.pathTransform$lambda$60(rectified, t, of, objectTime, arg_0), (int)1, null));
        }
        modelTransform = modelTransform.times(rotation);
        if ($this$pathTransform.getPose() == Layer.Pose.STATIONARY) {
            modelTransform = modelTransform.times(TransformBuilderKt.buildTransform$default(null, arg_0 -> LayerRenderer.pathTransform$lambda$61(rectified, t, arg_0), (int)1, null));
        }
        return modelTransform;
    }

    private final Matrix44 mixRotation(Matrix44 translation, Matrix44 pose, double poseRotation) {
        double d = poseRotation;
        return d == 0.0 ? translation : (d == 1.0 ? pose : Matrix44.Companion.fromColumnVectors((Vector4)translation.get(0).mix(pose.get(0), poseRotation).getNormalized(), (Vector4)translation.get(1).mix(pose.get(1), poseRotation).getNormalized(), (Vector4)translation.get(2).mix(pose.get(2), poseRotation).getNormalized(), pose.get(3)));
    }

    private static final Function1 environment_delegate$lambda$4$lambda$3$lambda$2(LayerRenderer this$0, String nn) {
        Function1<String, Object> function1;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)nn, (String)"nn");
            Iterable iterable = this$0.layerWatchers;
            for (Object t : iterable) {
                Function0 it = (Function0)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Layer)it.invoke()).getId(), (Object)nn)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Function0 function0 = v0;
        if (function0 != null) {
            Function0 it = function0;
            boolean bl = false;
            function1 = this$0.layerViews.get((Layer)it.invoke()).getEnvironment();
        } else {
            function1 = null;
        }
        return function1;
    }

    private static final Object environment_delegate$lambda$4$lambda$3(LayerRenderer this$0, String n) {
        return Intrinsics.areEqual((Object)n, (Object)"layers") ? arg_0 -> LayerRenderer.environment_delegate$lambda$4$lambda$3$lambda$2(this$0, arg_0) : null;
    }

    private static final Function1 environment_delegate$lambda$4(LayerRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return arg_0 -> LayerRenderer.environment_delegate$lambda$4$lambda$3(this$0, arg_0);
    }

    private static final Function0 paintStyles$lambda$5(LayerRenderer this$0, LazyMap $this$LazyMap, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PaintStyle.Companion.watch(this$0.program, this$0.demo, new File(this$0.demo.getDataBase(), "paints/" + it + ".conf"));
    }

    private static final Unit shadeStyles$lambda$7$lambda$6(PaintStyle $it, ShadeStyle $this$shadeStyle) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$shadeStyle, (String)"$this$shadeStyle");
        $this$shadeStyle.setFragmentPreamble($it.getFragmentPreamble());
        $this$shadeStyle.setFragmentTransform($it.getFragmentTransform());
        $this$shadeStyle.setVertexPreamble($it.getVertexPreamble());
        $this$shadeStyle.setVertexTransform($it.getVertexTransform());
        return Unit.INSTANCE;
    }

    private static final ShadeStyle shadeStyles$lambda$7(LazyMap $this$LazyMap, PaintStyle it) {
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ShadeStyleKt.shadeStyle(arg_0 -> LayerRenderer.shadeStyles$lambda$7$lambda$6(it, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final MeshAsset meshes$lambda$9(File file) {
        Collection<Path3D> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MeshData meshData = OBJLoaderKt.loadOBJMeshData((List)FilesKt.readLines$default((File)file, null, (int)1, null));
        Iterable iterable = WireframeKt.wireframe((MeshData)meshData);
        MeshData meshData2 = meshData;
        VertexBuffer vertexBuffer = MeshDataExtensionsKt.toVertexBuffer((MeshData)meshData);
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path3D.Companion.fromPoints((List)it, true));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        MeshData meshData3 = meshData2;
        VertexBuffer vertexBuffer2 = vertexBuffer;
        return new MeshAsset(vertexBuffer2, meshData3, list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List subtitles$lambda$11(File file) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$map$iv = SubtitlesKt.readSRT(file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Subtitle subtitle = (Subtitle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Subtitle.copy$default((Subtitle)it, it.getStartTime() - (double)3600, it.getEndTime() - (double)3600, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    private static final CFontImageMapDrawer textPathRenderer_delegate$lambda$12() {
        return new CFontImageMapDrawer();
    }

    private static final Unit compositions$lambda$13(CompositionDrawer $this$drawComposition) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComposition, (String)"$this$drawComposition");
        return Unit.INSTANCE;
    }

    private static final Composition compositions$lambda$14(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SVGLoaderKt.loadSVG((File)file);
    }

    /*
     * WARNING - void declaration
     */
    private static final List compositionShapes$lambda$16(File file) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$flatMap$iv = SVGLoaderKt.loadSVG((File)file).findShapes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ShapeNode shapeNode = (ShapeNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ShapeNodeKt.splitCompounds(shapeNode.flatten());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit compositionShapes$lambda$18$lambda$17(LayerRenderer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)"kapot");
        this$0.demoController.error();
        return Unit.INSTANCE;
    }

    private static final Unit compositionDraws3D$lambda$23$lambda$22$lambda$20(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$vertexFormat, (String)"$this$vertexFormat");
        $this$vertexFormat.position(3);
        VertexFormat.textureCoordinate$default((VertexFormat)$this$vertexFormat, (int)2, (int)0, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit compositionDraws3D$lambda$23$lambda$22$lambda$21(List $triangles, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter((Object)$triangles, (String)"$triangles");
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"$this$put");
        for (Triangle triangle : $triangles) {
            $this$put.write(triangle.getX1().xy0());
            $this$put.write(triangle.getX1().div(new Vector2(1280.0, 720.0)));
            $this$put.write(triangle.getX2().xy0());
            $this$put.write(triangle.getX2().div(new Vector2(1280.0, 720.0)));
            $this$put.write(triangle.getX3().xy0());
            $this$put.write(triangle.getX3().div(new Vector2(1280.0, 720.0)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List compositionDraws3D$lambda$23(File file) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Composition composition = SVGLoaderKt.loadSVG((File)file);
        int contourIndex = 0;
        Iterable $this$mapIndexed$iv = composition.findShapes();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void shapeIndex;
            VertexBuffer vertexBuffer;
            void $this$mapTo$iv$iv;
            void shape;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShapeNode shapeNode = (ShapeNode)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ShapeNode flattened = shape.flatten();
            Iterable $this$map$iv = flattened.getShape().getContours();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void contour;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Path3D path = org.openrndr.extra.shapes.path3d.Path3DExtensionsKt.toPath3D((ShapeContour)contour);
                ++contourIndex;
                collection2.add(new ObjectPath3D(shape.getEffectiveStroke(), shape.getEffectiveStrokeWeight(), Path3DExtensionsKt.rectified$default((Path3D)path, (double)0.0, (double)0.0, (int)3, null)));
            }
            List paths = (List)destination$iv$iv2;
            if (shape.getShape().getTopology() != ShapeTopology.OPEN) {
                Shape fixedShape = flattened.getShape();
                List triangles = fixedShape.getTriangulation();
                VertexBuffer vb = VertexBufferKt.vertexBuffer$default((VertexFormat)VertexFormatKt.vertexFormat(LayerRenderer::compositionDraws3D$lambda$23$lambda$22$lambda$20), (int)(triangles.size() * 3), null, (int)4, null);
                VertexBuffer.put$default((VertexBuffer)vb, (int)0, arg_0 -> LayerRenderer.compositionDraws3D$lambda$23$lambda$22$lambda$21(triangles, arg_0), (int)1, null);
                vertexBuffer = vb;
            } else {
                vertexBuffer = null;
            }
            VertexBuffer triangulation = vertexBuffer;
            collection.add(new ObjectDraw3D((int)shapeIndex, shape.getEffectiveFill(), triangulation, paths));
        }
        return (List)destination$iv$iv;
    }

    private static final ColorBuffer images$lambda$25(File file) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ColorBuffer $this$images_u24lambda_u2425_u24lambda_u2424 = colorBuffer = ColorBufferJVM.loadImage$default((File)file, null, null, (int)6, null);
        boolean bl = false;
        $this$images_u24lambda_u2425_u24lambda_u2424.generateMipmaps();
        $this$images_u24lambda_u2425_u24lambda_u2424.setWrapU(WrapMode.REPEAT);
        $this$images_u24lambda_u2425_u24lambda_u2424.setWrapV(WrapMode.REPEAT);
        return colorBuffer;
    }

    private static final Unit blendModeTarget_delegate$lambda$27$lambda$26(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTarget, (String)"$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default((RenderTargetBuilder)$this$renderTarget, null, null, (int)3, null);
        RenderTargetBuilder.depthBuffer$default((RenderTargetBuilder)$this$renderTarget, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final RenderTarget blendModeTarget_delegate$lambda$27() {
        return RenderTargetKt.renderTarget$default((int)RenderTarget.Companion.getActive().getWidth(), (int)RenderTarget.Companion.getActive().getHeight(), (double)0.0, (BufferMultisample)((BufferMultisample)new BufferMultisample.SampleCount(8)), null, LayerRenderer::blendModeTarget_delegate$lambda$27$lambda$26, (int)20, null);
    }

    private static final ColorBuffer blendModeResolved_delegate$lambda$28() {
        return ColorBufferKt.colorBuffer$default((int)RenderTarget.Companion.getActive().getWidth(), (int)RenderTarget.Companion.getActive().getHeight(), (double)0.0, null, null, null, (int)0, null, (int)252, null);
    }

    private static final Multiply multiplyFilter_delegate$lambda$29() {
        return new Multiply();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean layerWatchers$lambda$30(File it) {
        if (!it.isFile()) return false;
        Intrinsics.checkNotNull((Object)it);
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"conf")) return false;
        return true;
    }

    private static final Object layerWatchers$lambda$34$lambda$33$lambda$32$lambda$31(File $it, LayerRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $it.getPath() + " changed, jumping to " + this$0.demoController.getCuePoint() / this$0.demo.getTimeScale();
    }

    private static final Unit layerWatchers$lambda$34$lambda$33$lambda$32(LayerRenderer this$0, File $it, Layer layer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        LayerRendererKt.access$getLogger$p().info(() -> LayerRenderer.layerWatchers$lambda$34$lambda$33$lambda$32$lambda$31($it, this$0));
        this$0.demoController.jumpToCuePoint();
        return Unit.INSTANCE;
    }

    private static final LayerView layerViews$lambda$35(LayerRenderer this$0, LazyMap $this$LazyMap, Layer layer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        return new LayerView(this$0.demo, layer, this$0.compositions, this$0.paintStyles, this$0.shadeStyles, this$0.selectorContext);
    }

    private static final Comparable renderLayers$lambda$38(Layer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getZIndex());
    }

    private static final Comparable renderLayers$lambda$39(Layer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        File file = it.getSourceFile();
        return (Comparable)((Object)(file != null ? file.getName() : null));
    }

    private static final RectifiedContour renderLayers$lambda$40(LayerView $layerView, double $time, LazyMap $this$LazyMap, Layer.Path path) {
        Intrinsics.checkNotNullParameter((Object)$layerView, (String)"$layerView");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return $layerView.getPaths().get(path).provide($time);
    }

    private static final RectifiedPath3D renderLayers$lambda$41(LazyMap $resolvedPathContours, LazyMap $this$LazyMap, Layer.Path path) {
        Intrinsics.checkNotNullParameter((Object)$resolvedPathContours, (String)"$resolvedPathContours");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Path3DExtensionsKt.rectified$default((Path3D)org.openrndr.extra.shapes.path3d.Path3DExtensionsKt.toPath3D((ShapeContour)((RectifiedContour)$resolvedPathContours.get(path)).getContour()), (double)0.0, (double)0.0, (int)3, null);
    }

    private static final Unit renderLayers$lambda$58$lambda$46(ObjectView $ov, Drawer $drawer, LayerRenderer this$0, ObjectContext $objectContext, double $ot, Layer.Object $obj, Layer $layer, LazyMap $resolvedPathContours, LazyMap $objectTransforms, ColorBuffer $image, LayerView $layerView, Drawer $this$isolated) {
        PaintView paint;
        Intrinsics.checkNotNullParameter((Object)$ov, (String)"$ov");
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$objectContext, (String)"$objectContext");
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)$layer, (String)"$layer");
        Intrinsics.checkNotNullParameter((Object)$resolvedPathContours, (String)"$resolvedPathContours");
        Intrinsics.checkNotNullParameter((Object)$objectTransforms, (String)"$objectTransforms");
        Intrinsics.checkNotNullParameter((Object)$layerView, (String)"$layerView");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        Pair<Layer.Paint, Map<String, Double>> pair = $ov.getEffectivePaint();
        if (pair != null) {
            Pair<Layer.Paint, Map<String, Double>> it = pair;
            boolean bl = false;
            v1 = $layerView.getPaints().get(it);
        } else {
            v1 = paint = null;
        }
        if (paint != null) {
            paint.apply($drawer, this$0.targetManager, this$0.images, ((Number)$objectContext.getFunctions().getPaintTime().invoke((Object)$ot)).doubleValue());
            $drawer.setShadeStyle(paint.getShadeStyle());
        }
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        if ($obj.getPosition() == Layer.Position.ON_PATH) {
            modelTransform = modelTransform.times(this$0.pathTransform$deminityy($obj, $layer, $resolvedPathContours, $ot));
        }
        modelTransform = modelTransform.times((Matrix44)$objectTransforms.get($obj));
        $drawer.setModel($drawer.getModel().times(modelTransform));
        Drawer.scale$default((Drawer)$drawer, (double)1.0, (double)-1.0, (double)1.0, null, (int)8, null);
        $drawer.getDrawStyle().setColorMatrix(ColorTransformsKt.tint((ColorRGBa)((ColorRGBa)$objectContext.getFunctions().getImageTint().invoke((Object)$ot))));
        Rectangle sourceRect = $image.getBounds().sub(((Number)$objectContext.getFunctions().getImageLeft().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageTop().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageRight().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageBottom().invoke((Object)$ot)).doubleValue());
        Vector2 anchor = (Vector2)$objectContext.getFunctions().getAnchor().invoke((Object)$ot);
        Double d = $obj.getImageWidth();
        Double d2 = $obj.getImageHeight();
        Double d3 = $obj.getImageWidth();
        Double d4 = $obj.getImageHeight();
        Rectangle targetRect = RectangleKt.Rectangle((double)0.0, (double)0.0, (double)(d != null ? d : (double)$image.getWidth()), (double)(d2 != null ? d2 : (double)$image.getHeight())).sub(((Number)$objectContext.getFunctions().getImageLeft().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageTop().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageRight().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getImageBottom().invoke((Object)$ot)).doubleValue()).movedBy(new Vector2(-(d3 != null ? d3 : (double)$image.getWidth()) * anchor.x(), -(d4 != null ? d4 : (double)$image.getHeight()) * anchor.y()));
        $drawer.image($image, sourceRect, targetRect);
        return Unit.INSTANCE;
    }

    private static final ColorRGBa renderLayers$lambda$58$fill(Layer.Object $this$renderLayers_u24lambda_u2458_u24fill, ObjectView.Animation animation, double ot, ColorRGBa objectFill) {
        ColorRGBa colorRGBa;
        Layer.Object.Attributes.AttributeSource attributeSource = $this$renderLayers_u24lambda_u2458_u24fill.getAttributes().getFill();
        switch (attributeSource == null ? -1 : WhenMappings.$EnumSwitchMapping$1[attributeSource.ordinal()]) {
            case -1: 
            case 1: {
                colorRGBa = animation.fill(ot);
                break;
            }
            case 2: {
                colorRGBa = objectFill;
                if (colorRGBa != null) break;
                colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
                break;
            }
            case 3: {
                ColorRGBa colorRGBa2 = animation.fill(ot);
                ColorRGBa colorRGBa3 = objectFill;
                if (colorRGBa3 == null) {
                    colorRGBa3 = ColorRGBa.Companion.getTRANSPARENT();
                }
                colorRGBa = LayerRendererKt.access$times(colorRGBa2, colorRGBa3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return colorRGBa;
    }

    private static final ColorRGBa renderLayers$lambda$58$stroke(Layer.Object $this$renderLayers_u24lambda_u2458_u24stroke, ObjectView.Animation animation, double ot, ColorRGBa objectStroke) {
        ColorRGBa colorRGBa;
        Layer.Object.Attributes.AttributeSource attributeSource = $this$renderLayers_u24lambda_u2458_u24stroke.getAttributes().getStroke();
        switch (attributeSource == null ? -1 : WhenMappings.$EnumSwitchMapping$1[attributeSource.ordinal()]) {
            case -1: 
            case 1: {
                colorRGBa = animation.stroke(ot);
                break;
            }
            case 2: {
                colorRGBa = objectStroke;
                if (colorRGBa != null) break;
                colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
                break;
            }
            case 3: {
                ColorRGBa colorRGBa2 = animation.fill(ot);
                ColorRGBa colorRGBa3 = objectStroke;
                if (colorRGBa3 == null) {
                    colorRGBa3 = ColorRGBa.Companion.getTRANSPARENT();
                }
                colorRGBa = LayerRendererKt.access$times(colorRGBa2, colorRGBa3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return colorRGBa;
    }

    private static final double renderLayers$lambda$58$strokeWeight(Layer.Object $this$renderLayers_u24lambda_u2458_u24strokeWeight, ObjectContext objectContext, double ot, Double objectStrokeWeight) {
        Layer.Object.Attributes.AttributeSource attributeSource = $this$renderLayers_u24lambda_u2458_u24strokeWeight.getAttributes().getStrokeWeight();
        return switch (attributeSource == null ? -1 : WhenMappings.$EnumSwitchMapping$1[attributeSource.ordinal()]) {
            case -1, 1 -> ((Number)objectContext.getFunctions().getStrokeWeight().invoke((Object)ot)).doubleValue();
            case 2 -> {
                Double v2 = objectStrokeWeight;
                if (v2 != null) {
                    yield v2;
                }
                yield 0.0;
            }
            case 3 -> {
                Double v3 = objectStrokeWeight;
                yield ((Number)objectContext.getFunctions().getStrokeWeight().invoke((Object)ot)).doubleValue() * (v3 != null ? v3 : 1.0);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit renderLayers$lambda$58$lambda$50$lambda$48(TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTransform, (String)"$this$buildTransform");
        $this$buildTransform.scale(1.0, -1.0, 1.0);
        TransformBuilder.translate$default((TransformBuilder)$this$buildTransform, (double)-640.0, (double)-360.0, (double)0.0, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderLayers$lambda$58$lambda$50(Layer.Object $obj, LayerRenderer this$0, Layer $layer, LazyMap $resolvedPathContours, double $ot, ObjectView.Animation $animation, Drawer $drawer, ShapeNode $shape, ObjectContext $objectContext, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$layer, (String)"$layer");
        Intrinsics.checkNotNullParameter((Object)$resolvedPathContours, (String)"$resolvedPathContours");
        Intrinsics.checkNotNullParameter((Object)((Object)$animation), (String)"$animation");
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
        Intrinsics.checkNotNullParameter((Object)$objectContext, (String)"$objectContext");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        if ($obj.getPosition() == Layer.Position.ON_PATH) {
            modelTransform = modelTransform.times(this$0.pathTransform$deminityy($obj, $layer, $resolvedPathContours, $ot));
        }
        modelTransform = modelTransform.times($animation.transform($ot));
        if ($obj.getType() != Layer.Object.ObjectType.SVG_PATH) {
            modelTransform = modelTransform.times(TransformBuilderKt.buildTransform$default(null, LayerRenderer::renderLayers$lambda$58$lambda$50$lambda$48, (int)1, null));
        }
        $drawer.setFill(LayerRenderer.renderLayers$lambda$58$fill($obj, $animation, $ot, $shape.getEffectiveFill()));
        $drawer.setStrokeWeight(0.0);
        $drawer.setStroke(null);
        $drawer.shape($shape.getShape().transform(modelTransform));
        $drawer.setFill(null);
        for (ShapeContour contour : $shape.getShape().getContours()) {
            RectifiedContour rectifiedContour;
            double distanceThreshold = ((Number)$objectContext.getFunctions().getDistanceThreshold().invoke((Object)$ot)).doubleValue();
            if (distanceThreshold == 0.0) {
                RectifiedContour rectifiedContour2;
                Map<ShapeContour, RectifiedContour> $this$getOrPut$iv = this$0.rectified;
                boolean $i$f$getOrPut = false;
                RectifiedContour value$iv = $this$getOrPut$iv.get(contour);
                if (value$iv == null) {
                    boolean bl = false;
                    RectifiedContour answer$iv = ShapeContourExtensionsKt.rectified$default((ShapeContour)contour, (double)0.0, (double)0.0, (int)3, null);
                    $this$getOrPut$iv.put(contour, answer$iv);
                    rectifiedContour2 = answer$iv;
                } else {
                    rectifiedContour2 = value$iv;
                }
                rectifiedContour = rectifiedContour2;
            } else {
                rectifiedContour = ShapeContourExtensionsKt.rectified$default((ShapeContour)contour.sampleLinear(distanceThreshold), (double)0.0, (double)0.0, (int)3, null);
            }
            RectifiedContour rectified = rectifiedContour;
            ShapeContour drawContour = ((Number)$objectContext.getFunctions().getC0().invoke((Object)$ot)).doubleValue() == 0.0 && ((Number)$objectContext.getFunctions().getC1().invoke((Object)$ot)).doubleValue() == 1.0 ? contour : rectified.sub(((Number)$objectContext.getFunctions().getC0().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getC1().invoke((Object)$ot)).doubleValue());
            $drawer.setStroke(LayerRenderer.renderLayers$lambda$58$stroke($obj, $animation, $ot, $shape.getEffectiveStroke()));
            $drawer.setStrokeWeight(LayerRenderer.renderLayers$lambda$58$strokeWeight($obj, $objectContext, $ot, $shape.getEffectiveStrokeWeight()));
            $drawer.contour(drawContour.transform(modelTransform));
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderLayers$lambda$58$lambda$52$lambda$51(TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTransform, (String)"$this$buildTransform");
        $this$buildTransform.scale(1.0, -1.0, 1.0);
        TransformBuilder.translate$default((TransformBuilder)$this$buildTransform, (double)-640.0, (double)-360.0, (double)0.0, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderLayers$lambda$58$lambda$52(Layer.Object $obj, LayerRenderer this$0, Layer $layer, LazyMap $resolvedPathContours, double $ot, ObjectView.Animation $animation, Drawer $drawer, ObjectDraw3D $objectDraw, ObjectContext $objectContext, double $strokeGain, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$layer, (String)"$layer");
        Intrinsics.checkNotNullParameter((Object)$resolvedPathContours, (String)"$resolvedPathContours");
        Intrinsics.checkNotNullParameter((Object)((Object)$animation), (String)"$animation");
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)$objectDraw, (String)"$objectDraw");
        Intrinsics.checkNotNullParameter((Object)$objectContext, (String)"$objectContext");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        if ($obj.getPosition() == Layer.Position.ON_PATH) {
            modelTransform = modelTransform.times(this$0.pathTransform$deminityy($obj, $layer, $resolvedPathContours, $ot));
        }
        modelTransform = modelTransform.times($animation.transform($ot));
        if ($obj.getType() != Layer.Object.ObjectType.SVG_PATH_3D) {
            modelTransform = modelTransform.times(TransformBuilderKt.buildTransform$default(null, LayerRenderer::renderLayers$lambda$58$lambda$52$lambda$51, (int)1, null));
        }
        $drawer.setModel($drawer.getModel().times(modelTransform));
        if ($objectDraw.getTriangulation() != null) {
            $drawer.setStroke(null);
            $drawer.setFill(LayerRenderer.renderLayers$lambda$58$fill($obj, $animation, $ot, $objectDraw.getFill()));
            if ($drawer.getFill() != null) {
                ColorRGBa colorRGBa = $drawer.getFill();
                double d = colorRGBa != null ? colorRGBa.getAlpha() : 0.0;
                if (d > 0.0) {
                    Drawer.vertexBuffer$default((Drawer)$drawer, (VertexBuffer)$objectDraw.getTriangulation(), (DrawPrimitive)DrawPrimitive.TRIANGLES, (int)0, (int)0, (int)12, null);
                }
            }
        }
        for (ObjectPath3D objectPath : $objectDraw.getPaths()) {
            Path3D drawPath = ((Number)$objectContext.getFunctions().getC0().invoke((Object)$ot)).doubleValue() == 0.0 && ((Number)$objectContext.getFunctions().getC1().invoke((Object)$ot)).doubleValue() == 1.0 ? objectPath.getPath3D().getPath() : objectPath.getPath3D().sub(((Number)$objectContext.getFunctions().getC0().invoke((Object)$ot)).doubleValue(), ((Number)$objectContext.getFunctions().getC1().invoke((Object)$ot)).doubleValue());
            $drawer.setStroke(LayerRenderer.renderLayers$lambda$58$stroke($obj, $animation, $ot, objectPath.getStroke()));
            $drawer.setStrokeWeight(LayerRenderer.renderLayers$lambda$58$strokeWeight($obj, $objectContext, $ot, objectPath.getStrokeWeight()) * $strokeGain);
            $drawer.setFill(null);
            $drawer.path(drawPath);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderLayers$lambda$58$lambda$53(Drawer $drawer, LayerView $layerView, Layer.Font $layerFont, LayerRenderer this$0, String $text, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)$layerView, (String)"$layerView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        $drawer.setFontMap((FontMap)$layerView.getFonts().get($layerFont).getFontMap());
        RectifiedContour contour = ShapeContourExtensionsKt.rectified$default((ShapeContour)ShapeContour.Companion.getEMPTY(), (double)0.0, (double)0.0, (int)3, null);
        CFontImageMapDrawer.drawTextOnPath$default(this$0.getTextPathRenderer(), contour, $drawer.getContext(), $drawer.getDrawStyle(), $text, 0.0, 0.0, 0.0, 0.0, 240, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderLayers$lambda$58$lambda$56(Drawer $drawer, LazyMap $objectTransforms, Layer.Object $obj, ObjectContext $objectContext, double $ot, LayerView $layerView, Layer.Font $layerFont, LayerRenderer this$0, Drawer $this$isolated) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)$objectTransforms, (String)"$objectTransforms");
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)$objectContext, (String)"$objectContext");
        Intrinsics.checkNotNullParameter((Object)$layerView, (String)"$layerView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        $drawer.setModel($drawer.getModel().times((Matrix44)$objectTransforms.get($obj)));
        Drawer.scale$default((Drawer)$drawer, (double)1.0, (double)-1.0, (double)1.0, null, (int)8, null);
        $drawer.setFill((ColorRGBa)$objectContext.getFunctions().getFill().invoke((Object)$ot));
        FontImageMap font = $layerView.getFonts().get($layerFont).getFontMap();
        $drawer.setFontMap((FontMap)font);
        AssetLoader<List<Subtitle>> assetLoader = this$0.subtitles;
        String string = $objectContext.getAssetName();
        Intrinsics.checkNotNull((Object)string);
        List<Subtitle> subtitleAsset = assetLoader.get(string);
        Iterable $this$filter$iv = subtitleAsset;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Subtitle it = (Subtitle)element$iv$iv;
            boolean bl = false;
            if (!(it.getStartTime() <= $ot && it.getEndTime() > $ot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subtitle it = (Subtitle)element$iv;
            boolean bl = false;
            TextWriter writer = new TextWriter($drawer);
            double y = 0.0;
            writer.setCursor(new Cursor(0.0, y));
            for (String text : it.getTexts()) {
                double w = writer.textWidth(text);
                writer.setCursor(new Cursor(-w / 2.0, writer.getCursor().getY()));
                TextWriter.text$default((TextWriter)writer, (String)text, (boolean)false, (int)2, null);
                writer.newLine();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object renderLayers$lambda$58$lambda$57(Layer.Font $layerFont, ObjectContext $objectContext) {
        Intrinsics.checkNotNullParameter((Object)$objectContext, (String)"$objectContext");
        return "something is missing: " + $layerFont + " " + $objectContext.getAssetName();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderLayers$lambda$58(LayerView $layerView, Drawer $drawer, double $renderTime, LazyMap $objectTransforms, Layer $layer, List $targetOrder, LayerRenderer this$0, double $time, LazyMap $resolvedPathContours, LazyMap $resolvedPathPath3Ds, Drawer $this$isolated) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$sortedBy$iv;
        Layer.Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$layerView, (String)"$layerView");
        Intrinsics.checkNotNullParameter((Object)$drawer, (String)"$drawer");
        Intrinsics.checkNotNullParameter((Object)$objectTransforms, (String)"$objectTransforms");
        Intrinsics.checkNotNullParameter((Object)$layer, (String)"$layer");
        Intrinsics.checkNotNullParameter((Object)$targetOrder, (String)"$targetOrder");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resolvedPathContours, (String)"$resolvedPathContours");
        Intrinsics.checkNotNullParameter((Object)$resolvedPathPath3Ds, (String)"$resolvedPathPath3Ds");
        Intrinsics.checkNotNullParameter((Object)$this$isolated, (String)"$this$isolated");
        $layerView.setupCameraTransforms($drawer, $renderTime, $objectTransforms);
        Iterable iterable = $layer.getObjects();
        boolean $i$f$filter = false;
        void var16_14 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer.Object)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getTime());
            if (!($time >= it.getTime() && $time < it.getTime() + $layerView.getObjects().get(it).getEffectiveDuration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($layerView, $time){
            final /* synthetic */ LayerView $layerView$inlined;
            final /* synthetic */ double $time$inlined;
            {
                this.$layerView$inlined = layerView;
                this.$time$inlined = d;
            }

            public final int compare(T a, T b) {
                Layer.Object it = (Layer.Object)a;
                boolean bl = false;
                Function1<Double, Integer> function1 = this.$layerView$inlined.getObjects().get(it).getObjectFunctions().getZIndex();
                Double d = it.getTime();
                Intrinsics.checkNotNull((Object)d);
                it = (Layer.Object)b;
                Comparable comparable = (Integer)function1.invoke((Object)(this.$time$inlined - d));
                bl = false;
                Function1<Double, Integer> function12 = this.$layerView$inlined.getObjects().get(it).getObjectFunctions().getZIndex();
                Double d2 = it.getTime();
                Intrinsics.checkNotNull((Object)d2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)function12.invoke((Object)(this.$time$inlined - d2))));
            }
        });
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Layer.Object)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getTarget();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object objectGroups = destination$iv$iv;
        for (String target : $targetOrder) {
            List renderObjects;
            List list = (List)objectGroups.get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (!((Collection)(renderObjects = list)).isEmpty()) {
                RenderTarget layerTarget = this$0.targetManager.getRenderTargets().get(target);
                layerTarget.bind();
                if ($layer.getBlend().mode() != Layer.Blend.BlendMode.normal) {
                    this$0.getBlendModeTarget().clearColor(0, ColorRGBa.Companion.getTRANSPARENT());
                    RenderTarget.DefaultImpls.clearDepth$default((RenderTarget)this$0.getBlendModeTarget(), (double)0.0, (int)0, (int)3, null);
                    this$0.getBlendModeTarget().bind();
                }
            }
            for (Layer.Object obj : renderObjects) {
                Layer.Font layerFont;
                Object paint;
                ObjectContext objectContext = this$0.new ObjectContext($time, obj, $layerView, $objectTransforms);
                ObjectView ov = objectContext.getObjectView();
                double ot = objectContext.getObjectTime();
                Layer.Object.ObjectType objectType = obj.getType();
                switch (objectType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[objectType.ordinal()]) {
                    case 1: {
                        LayerRendererExtensionsKt.drawBlit(this$0, $drawer, objectContext);
                        break;
                    }
                    case 2: {
                        LayerRendererExtensionsKt.drawWireframe(this$0, $drawer, objectContext);
                        break;
                    }
                    case 3: {
                        LayerRendererExtensionsKt.drawMesh(this$0, $drawer, objectContext);
                        break;
                    }
                    case 4: {
                        LayerRendererExtensionsKt.drawMeshInstances(this$0, $drawer, objectContext);
                        break;
                    }
                    case 5: {
                        LayerRendererExtensionsKt.drawCircles(this$0, $drawer, objectContext);
                    }
                }
                if (obj.getType() == Layer.Object.ObjectType.IMAGE) {
                    Intrinsics.checkNotNull((Object)obj.getTime());
                    Intrinsics.checkNotNull(obj.getAssets());
                    ColorBuffer image = objectContext.getImageOrTarget();
                    if (image == null) continue;
                    DrawerKt.isolated((Drawer)$drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58$lambda$46(ov, $drawer, this$0, objectContext, ot, obj, $layer, $resolvedPathContours, $objectTransforms, image, $layerView, arg_0));
                    continue;
                }
                if (obj.getType() == Layer.Object.ObjectType.SVG || obj.getType() == Layer.Object.ObjectType.SVG_3D || obj.getType() == Layer.Object.ObjectType.SVG_PATH || obj.getType() == Layer.Object.ObjectType.SVG_PATH_3D) {
                    ObjectView.Animation animation = ov.getAnimation();
                    if (ov.getEffectivePaint() != null) {
                        Pair<Layer.Paint, Map<String, Double>> it2;
                        boolean bl = false;
                        v3 = $layerView.getPaints().get(it2);
                    } else {
                        v3 = paint = null;
                    }
                    if (paint != null) {
                        ((PaintView)paint).apply($drawer, this$0.targetManager, this$0.images, ((Number)objectContext.getFunctions().getPaintTime().invoke((Object)ot)).doubleValue());
                        $drawer.setShadeStyle(((PaintView)paint).getShadeStyle());
                    }
                    Layer.Object.ObjectType objectType2 = obj.getType();
                    switch (objectType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[objectType2.ordinal()]) {
                        case 8: 
                        case 9: {
                            List list2;
                            if (obj.getType() == Layer.Object.ObjectType.SVG) {
                                AssetLoader<List<ShapeNode>> assetLoader = this$0.compositionShapes;
                                String string = objectContext.getAssetName();
                                Intrinsics.checkNotNull((Object)string);
                                list2 = assetLoader.get(string);
                            } else {
                                Layer.Path path;
                                IntRange intRange = obj.getPaths();
                                if (intRange == null || (intRange = CollectionsKt.getIndices((Collection)((Collection)intRange))) == null) {
                                    throw new IllegalStateException(("no paths for object " + $layer.getSourceFile() + "/" + obj).toString());
                                }
                                int pi = RangesKt.coerceIn((int)((Number)objectContext.getFunctions().getPathIndex().invoke((Object)ot)).intValue(), (ClosedRange)((ClosedRange)intRange));
                                String pathName = obj.getPaths().get(pi);
                                if ($layer.getPaths().get(pathName) == null) {
                                    throw new IllegalStateException("path not found".toString());
                                }
                                RectifiedContour rectifiedContour = (RectifiedContour)$resolvedPathContours.get(path);
                                if (rectifiedContour == null || (rectifiedContour = rectifiedContour.getContour()) == null) {
                                    throw new IllegalStateException("contour not found".toString());
                                }
                                list2 = CollectionsKt.listOf((Object)new ShapeNode(new Shape(CollectionsKt.listOf((Object)rectifiedContour))));
                            }
                            List drawShapes = list2;
                            Iterator iterator = ((Iterable)drawShapes).iterator();
                            int pathName = 0;
                            while (iterator.hasNext()) {
                                int shapeIndex = pathName++;
                                ShapeNode shape = (ShapeNode)iterator.next();
                                DrawerKt.isolated((Drawer)$drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58$lambda$50(obj, this$0, $layer, $resolvedPathContours, ot, animation, $drawer, shape, objectContext, arg_0));
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            double strokeGain = switch (WhenMappings.$EnumSwitchMapping$2[$layer.getCamera().type().ordinal()]) {
                                case 1 -> 1.0;
                                case 2 -> 256.0;
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            Layer.Object.ObjectType objectType3 = obj.getType();
                            List objectDraws = switch (objectType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[objectType3.ordinal()]) {
                                case 6 -> {
                                    AssetLoader<List<ObjectDraw3D>> v12 = this$0.compositionDraws3D;
                                    String v13 = objectContext.getAssetName();
                                    Intrinsics.checkNotNull((Object)v13);
                                    yield v12.get(v13);
                                }
                                case 7 -> {
                                    RectifiedPath3D resolvedPath;
                                    Layer.Path path;
                                    IntRange v15 = obj.getPaths();
                                    if (v15 == null || (v15 = CollectionsKt.getIndices((Collection)((Collection)v15))) == null) {
                                        throw new IllegalStateException(("no paths for object " + $layer.getSourceFile() + "/" + obj).toString());
                                    }
                                    int pathIndex = RangesKt.coerceIn((int)((Number)objectContext.getFunctions().getPathIndex().invoke((Object)ot)).intValue(), (ClosedRange)((ClosedRange)v15));
                                    String pathName = obj.getPaths().get(pathIndex);
                                    if ($layer.getPaths().get(pathName) == null) {
                                        throw new IllegalStateException(("path '" + pathName + "' not found").toString());
                                    }
                                    if ((RectifiedPath3D)$resolvedPathPath3Ds.get(path) == null) {
                                        throw new IllegalStateException("path not found".toString());
                                    }
                                    yield CollectionsKt.listOf((Object)new ObjectDraw3D(0, null, null, CollectionsKt.listOf((Object)new ObjectPath3D(null, null, Path3DExtensionsKt.rectified$default((Path3D)resolvedPath.getPath(), (double)0.0, (double)0.0, (int)3, null)))));
                                }
                                default -> throw new IllegalStateException("not implemented".toString());
                            };
                            for (ObjectDraw3D objectDraw : objectDraws) {
                                DrawerKt.isolated((Drawer)$drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58$lambda$52(obj, this$0, $layer, $resolvedPathContours, ot, animation, $drawer, objectDraw, objectContext, strokeGain, arg_0));
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unreachable".toString());
                        }
                    }
                    $drawer.setShadeStyle(null);
                    continue;
                }
                if (obj.getType() == Layer.Object.ObjectType.TEXT_PATH) {
                    List<String> text;
                    paint = $layer.getFonts();
                    List<String> list3 = obj.getFonts();
                    layerFont = (Layer.Font)paint.get(list3 != null ? (String)CollectionsKt.getOrNull(list3, (int)((Number)objectContext.getFunctions().getFontIndex().invoke((Object)ot)).intValue()) : null);
                    List<String> list4 = obj.getTexts();
                    if (list4 == null || (list4 = (String)CollectionsKt.getOrNull((List)list4, (int)((Number)ov.getAnimation().getTextIndexSampler().invoke((Object)ot)).intValue())) == null) {
                        list4 = text = "ERROR no text";
                    }
                    if (layerFont == null) continue;
                    DrawerKt.isolated((Drawer)$drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58$lambda$53($drawer, $layerView, layerFont, this$0, (String)((Object)text), arg_0));
                    continue;
                }
                if (obj.getType() == Layer.Object.ObjectType.TEXT) {
                    LayerRendererExtensionsKt.drawText(this$0, $drawer, objectContext);
                    continue;
                }
                if (obj.getType() != Layer.Object.ObjectType.SUBTITLES) continue;
                Intrinsics.checkNotNull((Object)obj.getTime());
                Map<String, Layer.Font> map = $layer.getFonts();
                List<String> list5 = obj.getFonts();
                layerFont = map.get(list5 != null ? (String)CollectionsKt.getOrNull(list5, (int)((Number)objectContext.getFunctions().getFontIndex().invoke((Object)ot)).intValue()) : null);
                if (objectContext.getAssetName() != null && layerFont != null) {
                    DrawerKt.isolated((Drawer)$drawer, arg_0 -> LayerRenderer.renderLayers$lambda$58$lambda$56($drawer, $objectTransforms, obj, objectContext, ot, $layerView, layerFont, this$0, arg_0));
                    continue;
                }
                LayerRendererKt.access$getLogger$p().error(() -> LayerRenderer.renderLayers$lambda$58$lambda$57(layerFont, objectContext));
            }
            if (!(!((Collection)renderObjects).isEmpty())) continue;
            RenderTarget layerTarget = this$0.targetManager.getRenderTargets().get(target);
            layerTarget.unbind();
            if ($layer.getBlend().mode() == Layer.Blend.BlendMode.normal) continue;
            this$0.getBlendModeTarget().unbind();
            ColorBuffer.copyTo$default((ColorBuffer)this$0.getBlendModeTarget().colorBuffer(0), (ColorBuffer)this$0.getBlendModeResolved(), (int)0, (int)0, null, (int)14, null);
            ColorBuffer layerResolved = this$0.targetManager.getColorBuffers().get(target + "-resolved");
            ColorBuffer.copyTo$default((ColorBuffer)layerTarget.colorBuffer(0), (ColorBuffer)layerResolved, (int)0, (int)0, null, (int)14, null);
            if (WhenMappings.$EnumSwitchMapping$3[$layer.getBlend().mode().ordinal()] != 1) {
                throw new IllegalStateException("unreachable".toString());
            }
            ColorBuffer[] colorBufferArray = new ColorBuffer[]{layerResolved, this$0.getBlendModeResolved()};
            Filter.apply$default((Filter)((Filter)this$0.getMultiplyFilter()), (ColorBuffer[])colorBufferArray, (ColorBuffer)layerResolved, null, (int)4, null);
            ColorBuffer.copyTo$default((ColorBuffer)layerResolved, (ColorBuffer)layerTarget.colorBuffer(0), (int)0, (int)0, null, (int)14, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit pathTransform$lambda$59(double $a, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTransform, (String)"$this$buildTransform");
        $this$buildTransform.rotate(-$a + 90.0);
        return Unit.INSTANCE;
    }

    private static final Unit pathTransform$lambda$60(RectifiedContour $rectified, double $t, ObjectView.ObjectFunctions $of, double $objectTime, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter((Object)$rectified, (String)"$rectified");
        Intrinsics.checkNotNullParameter((Object)$of, (String)"$of");
        Intrinsics.checkNotNullParameter((Object)$this$buildTransform, (String)"$this$buildTransform");
        $this$buildTransform.translate(((Vector2)$rectified.position($t)).times(((Number)$of.getPathScale().invoke((Object)$objectTime)).doubleValue()));
        return Unit.INSTANCE;
    }

    private static final Unit pathTransform$lambda$61(RectifiedContour $rectified, double $t, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter((Object)$rectified, (String)"$rectified");
        Intrinsics.checkNotNullParameter((Object)$this$buildTransform, (String)"$this$buildTransform");
        $this$buildTransform.translate(((Vector2)$rectified.position($t)).unaryMinus());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Ldemo/view/LayerRenderer$MeshAsset;", "", "vertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "meshData", "Lorg/openrndr/extra/objloader/MeshData;", "paths", "", "Lorg/openrndr/shape/Path3D;", "<init>", "(Lorg/openrndr/draw/VertexBuffer;Lorg/openrndr/extra/objloader/MeshData;Ljava/util/List;)V", "getVertexBuffer", "()Lorg/openrndr/draw/VertexBuffer;", "getMeshData", "()Lorg/openrndr/extra/objloader/MeshData;", "getPaths", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "deminityy"})
    public static final class MeshAsset {
        @NotNull
        private final VertexBuffer vertexBuffer;
        @NotNull
        private final MeshData meshData;
        @NotNull
        private final List<Path3D> paths;

        public MeshAsset(@NotNull VertexBuffer vertexBuffer, @NotNull MeshData meshData, @NotNull List<Path3D> paths) {
            Intrinsics.checkNotNullParameter((Object)vertexBuffer, (String)"vertexBuffer");
            Intrinsics.checkNotNullParameter((Object)meshData, (String)"meshData");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.vertexBuffer = vertexBuffer;
            this.meshData = meshData;
            this.paths = paths;
        }

        @NotNull
        public final VertexBuffer getVertexBuffer() {
            return this.vertexBuffer;
        }

        @NotNull
        public final MeshData getMeshData() {
            return this.meshData;
        }

        @NotNull
        public final List<Path3D> getPaths() {
            return this.paths;
        }

        @NotNull
        public final VertexBuffer component1() {
            return this.vertexBuffer;
        }

        @NotNull
        public final MeshData component2() {
            return this.meshData;
        }

        @NotNull
        public final List<Path3D> component3() {
            return this.paths;
        }

        @NotNull
        public final MeshAsset copy(@NotNull VertexBuffer vertexBuffer, @NotNull MeshData meshData, @NotNull List<Path3D> paths) {
            Intrinsics.checkNotNullParameter((Object)vertexBuffer, (String)"vertexBuffer");
            Intrinsics.checkNotNullParameter((Object)meshData, (String)"meshData");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            return new MeshAsset(vertexBuffer, meshData, paths);
        }

        public static /* synthetic */ MeshAsset copy$default(MeshAsset meshAsset, VertexBuffer vertexBuffer, MeshData meshData, List list, int n, Object object) {
            if ((n & 1) != 0) {
                vertexBuffer = meshAsset.vertexBuffer;
            }
            if ((n & 2) != 0) {
                meshData = meshAsset.meshData;
            }
            if ((n & 4) != 0) {
                list = meshAsset.paths;
            }
            return meshAsset.copy(vertexBuffer, meshData, list);
        }

        @NotNull
        public String toString() {
            return "MeshAsset(vertexBuffer=" + this.vertexBuffer + ", meshData=" + this.meshData + ", paths=" + this.paths + ")";
        }

        public int hashCode() {
            int result = this.vertexBuffer.hashCode();
            result = result * 31 + this.meshData.hashCode();
            result = result * 31 + ((Object)this.paths).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeshAsset)) {
                return false;
            }
            MeshAsset meshAsset = (MeshAsset)other;
            if (!Intrinsics.areEqual((Object)this.vertexBuffer, (Object)meshAsset.vertexBuffer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.meshData, (Object)meshAsset.meshData)) {
                return false;
            }
            return Intrinsics.areEqual(this.paths, meshAsset.paths);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010 \u001a\u0004\u0018\u00010!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0018\u001a\u0004\b\"\u0010#R\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0018\u001a\u0004\b'\u0010(R\u001b\u0010*\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0018\u001a\u0004\b+\u0010,R\u001d\u0010.\u001a\u0004\u0018\u00010/8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0018\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Ldemo/view/LayerRenderer$ObjectContext;", "", "time", "", "obj", "Ldemo/model/Layer$Object;", "layerView", "Ldemo/view/LayerView;", "objectTransforms", "Ldemo/view/LazyMap;", "Lorg/openrndr/math/Matrix44;", "<init>", "(Ldemo/view/LayerRenderer;DLdemo/model/Layer$Object;Ldemo/view/LayerView;Ldemo/view/LazyMap;)V", "getTime", "()D", "getObj", "()Ldemo/model/Layer$Object;", "getLayerView", "()Ldemo/view/LayerView;", "objectView", "Ldemo/view/ObjectView;", "getObjectView", "()Ldemo/view/ObjectView;", "objectView$delegate", "Lkotlin/Lazy;", "objectTime", "getObjectTime", "functions", "Ldemo/view/ObjectView$ObjectFunctions;", "getFunctions", "()Ldemo/view/ObjectView$ObjectFunctions;", "functions$delegate", "assetName", "", "getAssetName", "()Ljava/lang/String;", "assetName$delegate", "mesh", "Ldemo/view/LayerRenderer$MeshAsset;", "getMesh", "()Ldemo/view/LayerRenderer$MeshAsset;", "mesh$delegate", "transform", "getTransform", "()Lorg/openrndr/math/Matrix44;", "transform$delegate", "imageOrTarget", "Lorg/openrndr/draw/ColorBuffer;", "getImageOrTarget", "()Lorg/openrndr/draw/ColorBuffer;", "imageOrTarget$delegate", "deminityy"})
    public final class ObjectContext {
        private final double time;
        @NotNull
        private final Layer.Object obj;
        @NotNull
        private final LayerView layerView;
        @NotNull
        private final Lazy objectView$delegate;
        @NotNull
        private final Lazy functions$delegate;
        @NotNull
        private final Lazy assetName$delegate;
        @NotNull
        private final Lazy mesh$delegate;
        @NotNull
        private final Lazy transform$delegate;
        @NotNull
        private final Lazy imageOrTarget$delegate;

        public ObjectContext(@NotNull double time, @NotNull Layer.Object obj, @NotNull LayerView layerView, LazyMap<Layer.Object, Matrix44> objectTransforms) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)layerView, (String)"layerView");
            Intrinsics.checkNotNullParameter(objectTransforms, (String)"objectTransforms");
            this.time = time;
            this.obj = obj;
            this.layerView = layerView;
            this.objectView$delegate = LazyKt.lazy(() -> ObjectContext.objectView_delegate$lambda$0(this));
            this.functions$delegate = LazyKt.lazy(() -> ObjectContext.functions_delegate$lambda$1(this));
            this.assetName$delegate = LazyKt.lazy(() -> ObjectContext.assetName_delegate$lambda$2(this));
            this.mesh$delegate = LazyKt.lazy(() -> ObjectContext.mesh_delegate$lambda$3(LayerRenderer.this, this));
            this.transform$delegate = LazyKt.lazy(() -> ObjectContext.transform_delegate$lambda$4(objectTransforms, this));
            this.imageOrTarget$delegate = LazyKt.lazy(() -> ObjectContext.imageOrTarget_delegate$lambda$5(this, LayerRenderer.this));
        }

        public final double getTime() {
            return this.time;
        }

        @NotNull
        public final Layer.Object getObj() {
            return this.obj;
        }

        @NotNull
        public final LayerView getLayerView() {
            return this.layerView;
        }

        @NotNull
        public final ObjectView getObjectView() {
            Lazy lazy = this.objectView$delegate;
            return (ObjectView)lazy.getValue();
        }

        public final double getObjectTime() {
            Double d = this.obj.getTime();
            Intrinsics.checkNotNull((Object)d);
            return this.time - d;
        }

        @NotNull
        public final ObjectView.ObjectFunctions getFunctions() {
            Lazy lazy = this.functions$delegate;
            return (ObjectView.ObjectFunctions)lazy.getValue();
        }

        @Nullable
        public final String getAssetName() {
            Lazy lazy = this.assetName$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final MeshAsset getMesh() {
            Lazy lazy = this.mesh$delegate;
            return (MeshAsset)lazy.getValue();
        }

        @NotNull
        public final Matrix44 getTransform() {
            Lazy lazy = this.transform$delegate;
            return (Matrix44)lazy.getValue();
        }

        @Nullable
        public final ColorBuffer getImageOrTarget() {
            Lazy lazy = this.imageOrTarget$delegate;
            return (ColorBuffer)lazy.getValue();
        }

        private static final ObjectView objectView_delegate$lambda$0(ObjectContext this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.layerView.getObjects().get(this$0.obj);
        }

        private static final ObjectView.ObjectFunctions functions_delegate$lambda$1(ObjectContext this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.getObjectView().getObjectFunctions();
        }

        private static final String assetName_delegate$lambda$2(ObjectContext this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            List<String> list = this$0.obj.getAssets();
            return list != null ? (String)CollectionsKt.getOrNull(list, (int)RangesKt.coerceIn((int)((Number)this$0.getFunctions().getAssetIndex().invoke((Object)this$0.getObjectTime())).intValue(), (int)0, (int)(this$0.obj.getAssets().size() - 1))) : null;
        }

        private static final MeshAsset mesh_delegate$lambda$3(LayerRenderer this$0, ObjectContext this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            String string = this$1.getAssetName();
            if (string == null) {
                throw new IllegalStateException("assetName is null".toString());
            }
            return (MeshAsset)this$0.meshes.get(string);
        }

        private static final Matrix44 transform_delegate$lambda$4(LazyMap $objectTransforms, ObjectContext this$0) {
            Intrinsics.checkNotNullParameter((Object)$objectTransforms, (String)"$objectTransforms");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return (Matrix44)$objectTransforms.get(this$0.obj);
        }

        private static final ColorBuffer imageOrTarget_delegate$lambda$5(ObjectContext this$0, LayerRenderer this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            String an = this$0.getAssetName();
            return an != null ? (StringsKt.startsWith$default((String)an, (String)"@", (boolean)false, (int)2, null) ? this$1.getTargetManager().getRenderTargets().get(StringsKt.drop((String)an, (int)1)).colorBuffer(0) : this$1.getImages$deminityy().get(an)) : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldemo/view/LayerRenderer$ObjectDraw3D;", "", "shapeIndex", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "triangulation", "Lorg/openrndr/draw/VertexBuffer;", "paths", "", "Ldemo/view/LayerRenderer$ObjectPath3D;", "<init>", "(ILorg/openrndr/color/ColorRGBa;Lorg/openrndr/draw/VertexBuffer;Ljava/util/List;)V", "getShapeIndex", "()I", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getTriangulation", "()Lorg/openrndr/draw/VertexBuffer;", "getPaths", "()Ljava/util/List;", "deminityy"})
    private static final class ObjectDraw3D {
        private final int shapeIndex;
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final VertexBuffer triangulation;
        @NotNull
        private final List<ObjectPath3D> paths;

        public ObjectDraw3D(int shapeIndex, @Nullable ColorRGBa fill, @Nullable VertexBuffer triangulation, @NotNull List<ObjectPath3D> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.shapeIndex = shapeIndex;
            this.fill = fill;
            this.triangulation = triangulation;
            this.paths = paths;
        }

        public final int getShapeIndex() {
            return this.shapeIndex;
        }

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final VertexBuffer getTriangulation() {
            return this.triangulation;
        }

        @NotNull
        public final List<ObjectPath3D> getPaths() {
            return this.paths;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldemo/view/LayerRenderer$ObjectPath3D;", "", "stroke", "Lorg/openrndr/color/ColorRGBa;", "strokeWeight", "", "path3D", "Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "<init>", "(Lorg/openrndr/color/ColorRGBa;Ljava/lang/Double;Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;)V", "getStroke", "()Lorg/openrndr/color/ColorRGBa;", "getStrokeWeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getPath3D", "()Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "deminityy"})
    private static final class ObjectPath3D {
        @Nullable
        private final ColorRGBa stroke;
        @Nullable
        private final Double strokeWeight;
        @NotNull
        private final RectifiedPath3D path3D;

        public ObjectPath3D(@Nullable ColorRGBa stroke, @Nullable Double strokeWeight, @NotNull RectifiedPath3D path3D) {
            Intrinsics.checkNotNullParameter((Object)path3D, (String)"path3D");
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.path3D = path3D;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        @Nullable
        public final Double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final RectifiedPath3D getPath3D() {
            return this.path3D;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[Layer.Object.ObjectType.values().length];
            try {
                nArray[Layer.Object.ObjectType.BLIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.WIREFRAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.MESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.MESH_INSTANCES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.CIRCLES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.SVG_3D.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.SVG_PATH_3D.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.SVG.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.ObjectType.SVG_PATH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Layer.Object.Attributes.AttributeSource.values().length];
            try {
                nArray[Layer.Object.Attributes.AttributeSource.user.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.Attributes.AttributeSource.asset.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Object.Attributes.AttributeSource.modulate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Layer.Camera.CameraType.values().length];
            try {
                nArray[Layer.Camera.CameraType.ORTHO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Camera.CameraType.PERSPECTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[Layer.Blend.BlendMode.values().length];
            try {
                nArray[Layer.Blend.BlendMode.multiply.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[Layer.Pose.values().length];
            try {
                nArray[Layer.Pose.FREE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Pose.LIMITED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Pose.STATIONARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

