/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Demo;
import demo.model.Targets;
import demo.view.LazyMap;
import filewatcher.FileWatcherKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00190\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Ldemo/view/TargetManager;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "width", "", "height", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;II)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getWidth", "()I", "getHeight", "renderTargets", "Ldemo/view/LazyMap;", "", "Lorg/openrndr/draw/RenderTarget;", "getRenderTargets", "()Ldemo/view/LazyMap;", "colorBuffers", "Lorg/openrndr/draw/ColorBuffer;", "getColorBuffers", "targetOrder", "", "targetDefinitions", "Lkotlin/Function0;", "Ldemo/model/Targets;", "getTargetDefinitions", "()Lkotlin/jvm/functions/Function0;", "clearTargets", "", "resolveTargets", "deminityy"})
@SourceDebugExtension(value={"SMAP\nTargetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetManager.kt\ndemo/view/TargetManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1053#2:82\n1557#2:83\n1628#2,3:84\n*S KotlinDebug\n*F\n+ 1 TargetManager.kt\ndemo/view/TargetManager\n*L\n52#1:82\n52#1:83\n52#1:84,3\n*E\n"})
public final class TargetManager {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    private final int width;
    private final int height;
    @NotNull
    private final LazyMap<String, RenderTarget> renderTargets;
    @NotNull
    private final LazyMap<String, ColorBuffer> colorBuffers;
    @NotNull
    private final Function0<Targets> targetDefinitions;

    public TargetManager(@NotNull Program program, @NotNull Demo demo, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter((Object)demo, (String)"demo");
        this.program = program;
        this.demo = demo;
        this.width = width;
        this.height = height;
        this.renderTargets = new LazyMap((arg_0, arg_1) -> TargetManager.renderTargets$lambda$1(this, arg_0, arg_1));
        this.colorBuffers = new LazyMap((arg_0, arg_1) -> TargetManager.colorBuffers$lambda$2(this, arg_0, arg_1));
        this.targetDefinitions = FileWatcherKt.watchFile(this.program, new File(this.demo.getDataBase(), "post/targets.conf"), TargetManager::targetDefinitions$lambda$5);
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final LazyMap<String, RenderTarget> getRenderTargets() {
        return this.renderTargets;
    }

    @NotNull
    public final LazyMap<String, ColorBuffer> getColorBuffers() {
        return this.colorBuffers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> targetOrder() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = ((Targets)this.targetDefinitions.invoke()).getTargets().entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Targets.Target)it.getValue()).getOrder());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Targets.Target)it.getValue()).getOrder()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Function0<Targets> getTargetDefinitions() {
        return this.targetDefinitions;
    }

    public final void clearTargets() {
        for (Map.Entry<String, Targets.Target> entry : ((Targets)this.targetDefinitions.invoke()).getTargets().entrySet()) {
            String key = entry.getKey();
            Targets.Target value = entry.getValue();
            int n = value.getNames().size();
            for (int i = 0; i < n; ++i) {
                ColorRGBa clearColor = value.getClearColor().get(RangesKt.coerceIn((int)i, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)value.getClearColor()))));
                if (clearColor == null) continue;
                this.renderTargets.get(key).clearColor(i, clearColor);
            }
            if (value.getDepth() == Targets.Target.DepthType.NONE) continue;
            RenderTarget.DefaultImpls.clearDepth$default((RenderTarget)this.renderTargets.get(key), (double)0.0, (int)0, (int)3, null);
        }
    }

    public final void resolveTargets() {
        for (Map.Entry<String, Targets.Target> entry : ((Targets)this.targetDefinitions.invoke()).getTargets().entrySet()) {
            String key = entry.getKey();
            Targets.Target value = entry.getValue();
            if (value.getResolveTo() == null) continue;
            ColorBuffer.copyTo$default((ColorBuffer)this.colorBuffers.get(key), (ColorBuffer)this.colorBuffers.get(value.getResolveTo()), (int)0, (int)0, null, (int)14, null);
        }
    }

    private static final Unit renderTargets$lambda$1$lambda$0(Targets.Target $target, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$this$renderTarget, (String)"$this$renderTarget");
        int count = $target.getNames().size();
        for (int i = 0; i < count; ++i) {
            $this$renderTarget.colorBuffer($target.getNames().get(i), switch (WhenMappings.$EnumSwitchMapping$0[$target.getFormats().get(RangesKt.coerceIn((int)i, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)$target.getFormats())))).ordinal()]) {
                case 1 -> ColorFormat.R;
                case 2 -> ColorFormat.RG;
                case 3 -> ColorFormat.RGB;
                case 4 -> ColorFormat.RGBa;
                default -> throw new NoWhenBranchMatchedException();
            }, switch (WhenMappings.$EnumSwitchMapping$1[$target.getTypes().get(RangesKt.coerceIn((int)i, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)$target.getTypes())))).ordinal()]) {
                case 1 -> ColorType.UINT8;
                case 2 -> ColorType.FLOAT16;
                case 3 -> ColorType.FLOAT32;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        switch (WhenMappings.$EnumSwitchMapping$2[$target.getDepth().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                RenderTargetBuilder.depthBuffer$default((RenderTargetBuilder)$this$renderTarget, null, (int)1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final RenderTarget renderTargets$lambda$1(TargetManager this$0, LazyMap $this$LazyMap, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Targets.Target target = ((Targets)this$0.targetDefinitions.invoke()).getTargets().get(key);
        if (target == null) {
            throw new IllegalStateException(("no target definition for '" + key + "'").toString());
        }
        Targets.Target target2 = target;
        return RenderTargetKt.renderTarget$default((int)this$0.width, (int)this$0.height, (double)target2.getScale(), (BufferMultisample)(target2.getSamples() == 0 ? (BufferMultisample)BufferMultisample.Disabled.INSTANCE : (BufferMultisample)new BufferMultisample.SampleCount(target2.getSamples())), null, arg_0 -> TargetManager.renderTargets$lambda$1$lambda$0(target2, arg_0), (int)16, null);
    }

    private static final ColorBuffer colorBuffers$lambda$2(TargetManager this$0, LazyMap $this$LazyMap, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$LazyMap, (String)"$this$LazyMap");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RenderTarget renderTarget = this$0.renderTargets.get(key);
        Intrinsics.checkNotNull((Object)renderTarget);
        return renderTarget.colorBuffer(0);
    }

    private static final Targets targetDefinitions$lambda$5(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Targets definitions = Targets.Companion.loadFromHocon(it);
        return definitions;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Targets.Target.Format.values().length];
            try {
                nArray[Targets.Target.Format.R.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RGB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RGBA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Targets.Target.Type.values().length];
            try {
                nArray[Targets.Target.Type.UINT_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Type.FLOAT_16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Type.FLOAT_32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Targets.Target.DepthType.values().length];
            try {
                nArray[Targets.Target.DepthType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.DepthType.DEPTH_STENCIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

