/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0002j\u0002`\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0019"}, d2={"Llib/WaveWriter;", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "channel", "Ljava/nio/channels/FileChannel;", "<init>", "(Ljava/nio/channels/FileChannel;)V", "getChannel", "()Ljava/nio/channels/FileChannel;", "totalWritten", "", "getTotalWritten", "()J", "setTotalWritten", "(J)V", "chunkSizePos", "getChunkSizePos", "setChunkSizePos", "writeHeader", "", "writeFrame", "samples", "", "Ljava/nio/ByteBuffer;", "close", "deminityy"})
public final class WaveWriter
implements AutoCloseable {
    @NotNull
    private final FileChannel channel;
    private long totalWritten;
    private long chunkSizePos;

    public WaveWriter(@NotNull FileChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
    }

    @NotNull
    public final FileChannel getChannel() {
        return this.channel;
    }

    public final long getTotalWritten() {
        return this.totalWritten;
    }

    public final void setTotalWritten(long l) {
        this.totalWritten = l;
    }

    public final long getChunkSizePos() {
        return this.chunkSizePos;
    }

    public final void setChunkSizePos(long l) {
        this.chunkSizePos = l;
    }

    public final void writeHeader() {
        ByteBuffer bb = ByteBuffer.allocate(2000);
        bb.order(ByteOrder.nativeOrder());
        String string = "RIFF";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        bb.put(byArray);
        bb.putInt(4);
        string = "WAVE";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        bb.put(byArray2);
        string = "fmt ";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        bb.put(byArray3);
        bb.putInt(16);
        bb.putShort((short)3);
        bb.putShort((short)1);
        bb.putInt(44100);
        bb.putInt(44100);
        bb.putShort((short)4);
        bb.putShort((short)32);
        string = "data";
        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        bb.put(byArray4);
        bb.putInt(0);
        bb.flip();
        this.channel.write(bb);
        this.totalWritten += this.channel.position() - (long)8;
        System.out.println((Object)("total written " + this.totalWritten));
        this.chunkSizePos = this.channel.position() - (long)4;
    }

    public final void writeFrame(@NotNull float[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ByteBuffer bb = ByteBuffer.allocate(samples.length * 4 + 8);
        bb.order(ByteOrder.nativeOrder());
        String string = "data";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        bb.put(byArray);
        bb.putInt(samples.length * 4);
        for (float sample : samples) {
            bb.putFloat(sample);
        }
        bb.flip();
        this.channel.write(bb);
    }

    public final void writeFrame(@NotNull ByteBuffer samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ByteBuffer bb = ByteBuffer.allocate(samples.remaining() + 8);
        bb.order(ByteOrder.nativeOrder());
        bb.put(samples);
        bb.flip();
        int bytesWritten = this.channel.write(bb);
        long cp = this.channel.position();
        this.totalWritten += (long)bytesWritten;
        ByteBuffer bbSize = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        bbSize.putInt((int)this.totalWritten);
        bbSize.flip();
        this.channel.position(4L);
        this.channel.write(bbSize);
        bbSize.rewind();
        this.channel.position(this.chunkSizePos);
        this.channel.write(bbSize);
        this.channel.position(cp);
        long l = this.totalWritten;
        System.out.println(l);
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

