#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main()
{
    TexCoords = aTexCoords;
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform float t;
uniform float tend;
uniform float beat;

uniform sampler2D screenTexture;
#define pi 3.14159265358979323846

void main()
{
    vec2 newCoords = TexCoords;
float n = 3;

// Transformación a coordenadas polares
float angle = atan(newCoords.y - 0.5, newCoords.x - 0.5);
float radius = length(newCoords - vec2(0.5));

// Normalización del ángulo a un rango entre 0 y 2π
float segmentAngle = 2.0 * pi / n;

// Reflejo del ángulo dentro del segmento
float mirroredAngle = mod(angle, segmentAngle);

if (mod(floor(angle / segmentAngle), 2.0) == 1.0) {
mirroredAngle = segmentAngle - mirroredAngle;
}

// Reconversión a coordenadas cartesianas
newCoords.x = 0.5 + radius * cos(mirroredAngle);
newCoords.y = 0.5 + radius * sin(mirroredAngle);

    // Si ponemos esto, la imagen se repite al salirse de los bordes
    if (newCoords.x > 1)
        newCoords.x -=1;
    if (newCoords.x < 0)
        newCoords.x +=1;
    if (newCoords.y > 1)
        newCoords.y -= 1;
    if (newCoords.y < 0)
        newCoords.y +=1;

/* Si ponemos esto, la imagen se termina al salirse de los border
if (newCoords.x > 1)
discard;
if (newCoords.x < 0)
discard;
if (newCoords.y > 1)
discard;
if (newCoords.y < 0)
discard; */   

    vec4 col = texture(screenTexture, newCoords).rgba;
    FragColor = vec4(col);
} 