#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main() {
TexCoords = aTexCoords;
gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0);
}

#type fragment
#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

// General parameters
uniform float aspect;
uniform float t;

// Parameters of the gear
uniform float intensity;
uniform float radius;
uniform float teeth;    // Number of teeth
uniform float rotation;
uniform float toothDepth; // Depth of the teeth

// Drawing parameters
uniform float startAngle;
uniform float endAngle;

vec2 rotate_point(float cx, float cy, float angle, vec2 p) {
float s = sin(angle);
float c = cos(angle);

// translate point back to origin:
p.x -= cx;
p.y -= cy;

// rotate point
float xnew = p.x * c - p.y * s;
float ynew = p.x * s + p.y * c;

// translate point back:
p.x = xnew + cx;
p.y = ynew + cy;
return p;
}

void main(void) {
// Normalized coordinates (-1.0 to 1.0)
vec2 position = vec2(aspect * (2.0 * TexCoords.x - 1.0), 2.0 * TexCoords.y - 1.0);

// Rotate the entire gear
position = rotate_point(0.0, 0.0, rotation, position);

// Calculate the distance from the center of the screen
float distance = length(position) / radius;

// Calculate the angle of the current point
float angle = atan(position.y, position.x);
if (angle < 0.0) angle += 2.0 * 3.141592654;

// Angle step for each tooth
float angleStep = 2.0 * 3.141592654 / teeth;

// Determine if we're in the tooth or the gap
float toothAngle = mod(angle, angleStep);
float toothRadius = radius * (1.0 + toothDepth * (toothAngle < (angleStep / 2.0) ? 1.0 : -1.0));

// Calculate the glow intensity
float color = intensity / abs(distance - toothRadius);

// Set the color based on whether the angle is within the specified range
if (angle >= startAngle && angle <= endAngle) {
FragColor = vec4(vec3(color), 1.0);
} else {
FragColor = vec4(0.0, 0.0, 0.0, 0.0);
}
}
