#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main() {
TexCoords = aTexCoords;
gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

// General parameters
uniform float aspect;
uniform float t;

// Parameters of the polygon
uniform float intensity;
uniform float radius;
uniform float sides;
uniform float rotation;

// Gear parameters
uniform float gearTeeth; // Número de dientes del engranaje
uniform float toothDepth; // Profundidad de los dientes

// Drawing parameters
uniform float startAngle;
uniform float endAngle;

vec2 rotate_point(float cx,float cy,float angle,vec2 p) {
float s = sin(angle);
float c = cos(angle);

// translate point back to origin:
p.x -= cx;
p.y -= cy;

// rotate point
float xnew = p.x * c - p.y * s;
float ynew = p.x * s + p.y * c;

// translate point back:
p.x = xnew + cx;
p.y = ynew + cy;
return p;
}

void main(void) {
// Normalized coordinates (-1.0 to 1.0)
vec2 position = vec2(aspect*(2.0*TexCoords.x-1), 2.0*TexCoords.y-1);

position = rotate_point(0.0, 0.0, rotation, position);

// Calculate the distance from the center of the screen
float distance = length(position) / radius;

// Calculate the angle
float angle = atan(position.y, position.x);
if (angle < 0.0) angle += 2.0 * 3.141592654;
angle = mod(angle, 2.0 * 3.141592654);

float startAngleNormalized = startAngle;
float endAngleNormalized = endAngle;

// Gear drawing logic
float gearAngleStep = 2.0 * 3.141592654 / gearTeeth;
float toothAngle = mod(angle, gearAngleStep);

float gearRadius = radius * (1.0 - toothDepth * step(gearAngleStep / 2.0, toothAngle));

// Calculate the glow intensity
float color = intensity / abs(2.0 * (gearRadius - distance) - 1.0);

// Set the color based on the angle range and whether the sides equal 1 (for the gear)
if (sides == 1.0) {
FragColor = (angle >= startAngleNormalized && angle <= endAngleNormalized) ? vec4(vec3(color), 1.0) : vec4(0.0, 0.0, 0.0, 0.0);
} else {
// Polygon logic as before
float angleStep = 2.0 * 3.141592654 / sides;
float sideDistance = cos(mod(angle + angleStep * 0.5, angleStep) - angleStep * 0.5) * distance;
color = intensity / abs(2.0 * sideDistance - 1.0);
FragColor = (angle >= startAngleNormalized && angle <= endAngleNormalized) ? vec4(vec3(color), 1.0) : vec4(0.0, 0.0, 0.0, 0.0);
}
}
