// toughtoys - carbon & pet on einklang.net

var screenWidth = 1920;
var screenHeight = 1080;
var screenRatio = screenWidth / screenHeight;
var oldScreenWidth = 0;
var oldScreenHeight = 0;
var fullScreen = false;
var screenCenterY = 0;
var screenOffestY = 0;

var startTime = 0;
var introStartTime = 0;
var time = 0;
var stateTime = 0;

var clickState = 0;
var introState = 1;
var firstSelectionState = 2;
var selectedState = 3;
var normalSelectionState = 4;
var movieState = 5;
var endState = 6;

var demoState = clickState;

//var introDuration = 4000;
var introDuration = 4000;
var firstSelection = 8000;
var selectedDuration = 1000;
var normalSelection = 4000;
var movieDuration = 20000;

var movieLoopId = 0;

var movieWidth = 1080;
var movieHeight = 1920;

var styleWidth = 1080;
var styleHeight = 1920;
var styleScaledWidth = 1080;
var styleScaledHeight = 1920;
var styleRatio = styleWidth / styleHeight;

var einklangWidth = 1080;
var einklangHeight = 140;
var einklangScale = 0.89
var einklangRatio = einklangWidth / einklangHeight;
var einklangScaledWidth = einklangWidth;
var einklangScaledHeight = einklangHeight;

var toughtoysWidth = 2363;
var toughtoysHeight = 560;
var toughtoysScale = 0.8;
var toughtoysRatio = toughtoysWidth / toughtoysHeight;
var toughtoysScaledWidth = toughtoysWidth;
var toughtoysScaledHeight = toughtoysHeight;

var handWidth = 320;
var handHeight = 320;
var handScale = 0.18;
var handRatio = handWidth / handHeight;
var handScaledWidth = handWidth;
var handScaledHeight = handHeight;
var handDistanceX = 0;
var handDistanceY = 0;

var styleX = 4;
var styleY = 2;
var styleCount = styleX * styleY;
var styles = [
	"01_Carbon_TimeOfTheNight",
	"02_Carbon_99Problems",
	"03_Carbon_TrueBeauty",
	"04_JosephDisco_People",
	"05_JosephDisco_People_CarbonRMX",
	"06_JosephDisco_People_SchmeisserRMX",
	"07_Stereophonie_Emotions",
	"08_Stereophonie_Emotions_CarbonRMX",
	"einklang_logo",
	"toughtoys_logo",
	"hand_1",
	"hand_2",
	"start",
	"fade",
	"toughtoys_rotated",
];

var rndStyles = [ 2, 0, 3, 1, 5, 6, 4, 7 ];

function Init() {
	SetScreenLayout();

	// init content
	var content = FindElement("content");

	// styles
	var index = 0;
	for (var j = 0; j < 4; ++j) {
		for (var i = 0; i < styleCount; ++i) {
			content.innerHTML += GenerateImage(i, j, j);
		}
	}
	index += styleCount;

	// einklang logo
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;

	// tougtoys logo
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;

	// hand
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;

	// start
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;
	
	// fade
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;
	
	// toughtoys rotated
	content.innerHTML += GenerateImage(index, 0, 4);
	++index;
	
	// first video play handling
	setOverlayListener();

	//  start frame loop
	startTime = Date.now();
	requestAnimationFrame(OnFrame);
}

function OnFrame() {
	time = Date.now() - startTime;
	introTimer = Clamp(time * 0.5, 0.0, 1.0);

	SetScreenLayout();

	// einklang
	einklangScaledWidthth = screenWidth * einklangScale;
	einklangScaledHeight = einklangScaledWidth / einklangRatio;

	// toughtoys
	toughtoysScaledWidth = screenWidth * toughtoysScale;
	toughtoysScaledHeight = toughtoysScaledWidth / toughtoysRatio;

	// hand
	handScaledWidth = screenWidth * handScale;
	handScaledHeight = handScaledWidth / handRatio;

	// screen offset
	var contentHeight = styleScaledHeight * 2 + toughtoysScaledHeight * 0.55;
	var screenOffest = (contentHeight - screenHeight) / 2;
	screenOffestY = 0.0;
	if (demoState != clickState) {
		screenOffestY = -screenOffest * 2.0 * Math.floor(rndStyles[movieLoopId] / styleY);
	}

	// chanfe movie position & size
	if (oldScreenWidth != screenWidth || oldScreenHeight != screenHeight) {
		if (screenRatio < styleRatio) {
			movieWidth = screenWidth;
			movieHeight = movieWidth * styleRatio; 
		} else {
			movieHeight = screenHeight;
			movieWidth = movieHeight * styleRatio; 
		}

		if (demoState == movieState) {
			SetPlayerSize(movieWidth, movieHeight);
		} else {			
			SetPlayerSize(0, 0);
		}
		setOverlaySize(screenWidth, screenHeight)
	}

	// styles
	var index = 0;
	styleScaledWidth = screenWidth / styleX;
	styleScaledHeight = styleScaledWidth / styleRatio;
	for (var j = 0; j < 4; ++j) {
		for (var i = 0; i < styleCount; ++i) {
			SetStylePosition(i, j);		
		}
	}
	index = styleCount;

	// tougtoys logo
	SetETPosition(index, 0);
	index += 2;

	// hand
	SetHandPosition(index, 0);
	index += 2;

	// start
	SetStartPosition(index, 0);
	++index;

	// fade
	SetFadePosition(index, 0);
	++index;

	// logo rotated
	SetLRPosition(index, 0);
	++index;

	// state switch
	switch(demoState) {
		case introState:
			if (time - stateTime > introDuration) {
				stateTime = time;
				demoState = firstSelectionState;
				SetPlayerSize(0, 0)
				SetMovie();
			}
			break;
		case firstSelectionState:
			if (time - stateTime > firstSelection) {
				stateTime = time;
				demoState = selectedState;
			}
			break;
		case selectedState:
			if (time - stateTime > selectedDuration) {
				stateTime = time;
				demoState = movieState;
				SetPlayerSize(movieWidth, movieHeight)
				PlayMovie();
			}
			break;
		case movieState:
			if (time - stateTime > movieDuration) {
				stateTime = time;
				demoState = normalSelectionState;
				if (movieLoopId == 7) {
					closeWindow();
				}
				++movieLoopId;
				SetPlayerSize(0, 0)
				SetMovie();
			}
			break;
		case normalSelectionState:
			if (time - stateTime > normalSelection) {
				stateTime = time;
				demoState = selectedState;
			}
			break;
	}

	oldScreenWidth = screenWidth;
	oldScreenHeight = screenHeight;

	// next please
	requestAnimationFrame(OnFrame);
}

function SetScreenLayout() {
	screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
	screenHeight = window.innerHeight|| document.documentElement.clientHeight|| document.body.clientHeight;
	screenRatio = screenWidth / screenHeight;
	styleX = screenWidth > screenHeight ? 4 : 2;
	styleY = screenWidth < screenHeight ? 2 : 4;	
}

function FindElement(name) {
	var element = document.getElementById(name);
	if (element) {
		return element;
	} else {
		return null;
	}
}

function GenerateImage(id, layer, kind) {
	var width = 32;
	var height = width / styleRatio;
	var name = styles[id];

	switch (kind) {
		case 0:
			name += "_BG_blur.jpg";
			break;
		case 1:
			name += "_BG_green.jpg";
			break;
		case 2:
			name += "_title.png";
			break;
		case 3:
			name += ".jpg";
			break;
		case 4:
			name += ".png";
			break;
	}

	var html = "<img id='i" + id + "_" + layer + "' ";
	html += "style='position:absolute; opacity:0.5;";
	html += "left:-31px; top:" + height * id + "px; ";
	html += "width:" + width + "px; height:" + height + "px; ";
	html += "z-index:" + (kind + 1) + "'; src='" + name + "'>";
	return html;
}

function SetStylePosition(id, layer) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		var y = Math.floor(id / styleX);

		var t = (time - introStartTime);
		var alpha = Clamp(Math.min(t * 0.0003 - 0.6 - id * 0.1 - layer * 0.5, 
			0.7 - layer * 0.4 + Math.cos(t * 0.0003 - id * 0.05 - layer * 0.3) * 0.1) +
			Math.sin(t * 0.0007 + id * 0.073 + layer * 0.134) * 0.25 + 
			Math.cos(t * 0.0011 + id * 0.225 + layer * 0.233) * 0.3, 0.0, 1.0);
		if (layer == 2) {
			var duration = demoState == firstSelectionState ? firstSelection : normalSelection;
			var hand = Clamp((time - stateTime) / duration, 0.0, 1.0);
			var alpha = Clamp(hand * 2.0 - 1.0, 0.0, 1.0);
			alpha = Math.pow(alpha, 4.0);
			if (id != rndStyles[movieLoopId]) {
				alpha = 0.0;
			}
		}

		image.style.left = styleScaledWidth * (id % styleX) + "px";
		image.style.top = screenOffestY + toughtoysScaledHeight * 0.55 * y + styleScaledHeight * Math.floor(id / styleX) + "px";
		image.style.width = styleScaledWidth + "px";
		image.style.height = styleScaledHeight + "px";
		if (layer == 2) {
			image.style.opacity = demoState == firstSelectionState || demoState == normalSelectionState ? alpha : 0.0;					
		} else if (layer == 3) {
			image.style.opacity = demoState == selectedState && id == rndStyles[movieLoopId] ? 1.0 : 0.0;					
		} else {
			image.style.opacity = demoState != movieState && demoState != clickState ? alpha : 0.0;					
		}
	}
}

function SetETPosition(id, layer, alpha = 0.8) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		var intro = Clamp((time - stateTime) / introDuration, 0.0, 1.0);
		var introMove = Clamp((intro - 0.5) * 2.0, 0.0, 1.0);
		var introMoveP = Math.pow(introMove, 8); 
		image.style.left = screenWidth * 0.5 - screenWidth * introMoveP - einklangScaledWidth * 0.5 + "px";
		image.style.top = screenOffestY + styleScaledHeight + einklangScaledHeight * 0.05 + "px";
		image.style.width = einklangScaledWidth + "px";
		image.style.height = einklangScaledHeight + "px";
		image.style.opacity = demoState == introState ? 0.7 : 0.0;
	}
	var image = FindElement("i" + (id + 1) + "_" + layer);
	if (image) {
		var first = demoState == firstSelectionState ? Clamp((time - stateTime) / firstSelection, 0.0, 1.0) : 1.0;
		var firstMoveP = Math.pow(1.0 - first, 12);
		var alpha = 0.0;

		if (demoState == firstSelectionState || demoState == normalSelectionState) {
			alpha = 0.7;
		} else if (demoState == movieState) {
			alpha = Clamp((time - stateTime) / movieDuration, 0.0, 1.0);
			alpha = Clamp(alpha * 20.0 - 19.0, 0.0, 1.0) + 1.0 - Clamp(alpha * 20.0, 0.0, 1.0);
			alpha = Math.pow(alpha, 3.0) * 0.7;
		}
		image.style.left = screenWidth * 0.5 + screenWidth * firstMoveP - toughtoysScaledWidth * 0.5 + "px";
		image.style.top = screenOffestY + styleScaledHeight - toughtoysScaledHeight * 0.12 + "px";
		image.style.width = toughtoysScaledWidth + "px";
		image.style.height = toughtoysScaledHeight + "px";
		image.style.opacity = alpha;
	}
}

function SetHandPosition(id, layer) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		var styleId = rndStyles[movieLoopId];
		var x = (styleId % styleX);
		var y = Math.floor(styleId / styleX);
		var duration = demoState == firstSelectionState ? firstSelection : normalSelection;
		var hand = Clamp((time - stateTime) / duration, 0.0, 1.0);
		var alpha = Clamp(hand * 4.0, 0.0, 1.0);
		alpha = Math.pow(alpha, 3.0);
		var handMove = Clamp((hand - 0.5) * 2.0, 0.0, 1.0);
		var handMoveP = Math.cos(handMove * Math.PI) * 0.5 + 0.5;
		handDistanceX = (Math.sin(time * 0.00073) + Math.cos(time * 0.00059) + Math.sin(time * 0.00099)) * screenWidth * 0.3;
		handDistanceY = (Math.cos(time * 0.00057) + Math.cos(time * 0.00041) + Math.cos(time * 0.00088)) * screenHeight * 0.3;

		image.style.left = styleScaledWidth * (x + 0.25) + handDistanceX * handMoveP + "px";
		image.style.top = screenOffestY +toughtoysScaledHeight * 0.55 * y + styleScaledHeight * (y + 0.42) + 
			handDistanceY * handMoveP + "px";
		image.style.width = handScaledWidth + "px";
		image.style.height = handScaledHeight + "px";
		image.style.opacity = demoState == firstSelectionState || demoState == normalSelectionState ? 1.0: 0.0;		

		var image2 = FindElement("i" + (id + 1) + "_" + layer);
		if (image2) {
			image2.style.left = styleScaledWidth * (x + 0.25) + "px";
			image2.style.top = screenOffestY + toughtoysScaledHeight * 0.55 * y + styleScaledHeight * (y + 0.42) + "px";
			image2.style.width = handScaledWidth + "px";
			image2.style.height = handScaledHeight + "px";
			image2.style.opacity = demoState == selectedState ? 1.0: 0.0;		
		}
	}
}

function SetStartPosition(id, layer) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		image.style.left = screenWidth * 0.5 - screenWidth * 0.25 + "px";
		image.style.top = screenHeight * 0.5 - screenHeight * 0.125 + "px";
		image.style.width = screenWidth * 0.5 + "px";
		image.style.height = screenHeight * 0.25 + "px";
		image.style.opacity = demoState == clickState ? 1.0 : 0.0;
	}
}


function SetFadePosition(id, layer) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		var alpha = Clamp((time - stateTime) / movieDuration, 0.0, 1.0);
		alpha = 1.0 - Clamp(alpha * 30.0 - 0.5, 0.0, 1.0);
		image.style.left = "0px";
		image.style.top = "0px";
		image.style.width = screenWidth + "px";
		image.style.height = screenHeight + "px";
		image.style.opacity = demoState == movieState ? alpha : 0.0;
	}
}

function SetLRPosition(id, layer) {
	var image = FindElement("i" + id + "_" + layer);
	if (image) {
		alphaD = Clamp((time - stateTime) / movieDuration, 0.0, 1.0);
		alpha = Clamp(alphaD * 20.0 - 19.0, 0.0, 1.0) + 1.0 - Clamp(alphaD * 10.0, 0.0, 1.0);
		alpha = 1.0 - alpha;
		image.style.left = screenWidth * 0.5 + movieWidth * 0.4 + "px";
		image.style.top = -(alphaD - 0.2) * screenHeight * 0.3 + "px";
		image.style.height = screenHeight * 1.4 + "px";
		image.style.width = screenHeight * 1.4 / toughtoysRatio + "px";
		image.style.opacity = demoState == movieState ? alpha * 0.5 : 0.0;
	}
}

function SetPlayerSize(width, height) {
	var video = FindElement("videoPlayer");
	if (video) {
		video.style.width = width + "px";
		video.style.height = height + "px";
    	if (width > 0 && height > 0) {
		    video.style.left = (screenWidth - width) * 0.5 + "px";
		    video.style.top = (screenHeight - height) * 0.5 + "px";
    	} else {
		    video.style.left = "0px";
		    video.style.top = "0px";    		
    	}
	}	
}

function SetMovie() {
	var player = FindElement("videoPlayer");
	var source = FindElement("sourceVideo");
	if (player && source) {
		var container = ".mp4";
		var type = "video/mp4";
		var videoLink = styles[rndStyles[movieLoopId]] + container;
		source.setAttribute("type", type);
		source.setAttribute("src", videoLink);
		player.load();
	}	
}

function PlayMovie() {
	var player = FindElement("videoPlayer");
	if (player) {
		player.play();
	}	
}

function setOverlaySize(width, height) {
    var videoOverlay = FindElement("video-overlay");
    if (videoOverlay) {
	    videoOverlay.style.left = "0px";
	    videoOverlay.style.top = "0px";    		
	    videoOverlay.style.width = width + "px";
	    videoOverlay.style.height = height + "px";
    }
}

function setOverlayListener() {
	var element = FindElement("video-overlay");
	if (element) {
		element.addEventListener("click", function(e) {
			clickHandling();
		});		
	}
}

function clickHandling() {
	if (demoState != clickState) {
		return;
	}

	stateTime = time;
	introStartTime = time;
	demoState = introState;

	goFullscreen();

    var player = FindElement("videoPlayer");
    if (player) {
      	player.play();
    }
 }

function goFullscreen(renderer) {
//	return;
    if (fullScreen) {
      return;
    }

	fullScreen = true;
    var element = document.documentElement;
    if (element.requestFullscreen) {
    	element.requestFullscreen();
    } else if (element.webkitRequestFullscreen) { /* Chrome, Safari and Opera */
    	element.webkitRequestFullscreen();
    } else if (element.mozRequestFullScreen) { /* Firefox */
    	element.mozRequestFullScreen();
    } else if (element.msRequestFullscreen) { /* IE/Edge */
    	element.msRequestFullscreen();
    }
}

function Clamp(number, min, max) {
  return Math.min(Math.max(number, min), max);
};

function closeWindow() {
  if (confirm("Close Window?")) {
    close();
  }
}