let song;

const setupAudio = (audioContext, destination) => {
    song = document.getElementById('song');

    // pre-load fix
    song.play();
    song.pause();

    let source = audioContext.createMediaElementSource(song);
    source.connect(destination);
}

const playAudio = () => {
    song.play();
}

const pauseAudio = () => {
    song.pause();
}

const isAudioPaused = () => {
    return song.paused;
}

const getAudioTime = () => {
    return song.currentTime;
}

const setAudioTime = (time) => {
    song.currentTime = time;
}