

- globals
  Global
    ccFilter =              IntensityFromMidiCC(1,15)
    ccFocX =         filter(             MidiCC(1,16), nnFilterFocusPos)
    ccFocY =         filter(             MidiCC(1,17), nnFilterFocusPos)
    ccFocRot =       filter( MidiCC(1,18) / 128, 0, 0, 1) * 360
    ccZoom =       1-filter(IntensityFromMidiCC(1,19), ccFilter)
    ccZoomRaster = 1-       IntensityFromMidiCC(1,20)
    zoom = ccZoom * ccHardZoom
    zoomRaster = zoom * (1.6 * ccZoomRaster)

//    ccPaperOffset =      (NoteOnTimestampFromMidi(1,20) * 1.217 + NoteOnTimestampFromMidi(1,21) ) % 1      //    IntensityFromMidiCC(1,21) + ccFocX / 4 + ccFocY / 4 // + (time * 10)%1 
//    ccPaperOffset =      IntensityFromMidiCC(1,21) + ccFocX / 4 + ccFocY / 4 // + (time * 10)%1 
    ccPaperOffset =         IntensityFromMidiCC(1,21) 
    ccPattern =             IntensityFromMidiCC(1,22)
    nnGlyphNoise =          IntensityFromMidiCC(1,26) + IntensityFromMidi(1,15)
    nnGlyphNoiseType =      IntensityFromMidiCC(1,27)
    nnGlyphNoiseMinLum =    IntensityFromMidiCC(1,28)
    nnGlyphNoiseMaxLum =    IntensityFromMidiCC(1,30)
    ccHardZoom =         (1-IntensityFromMidiCC(1,25)) * 2
    ccText2Gain =         IntensityFromMidiCC(1,41)
    ccText2Scale =         IntensityFromMidiCC(1,46  )
    cc3D =           filter( MidiCC(1,84) / 128, 0.5, 0, 1) * 360
    cc3DScale =      1.0 - 0.5 * filter( IntensityFromMidiCC(1,85), 0.5 )
    ccGlitchPaper =         IntensityFromMidiCC(1,93)      
    ccPaperAmount = 1 + 1*ccGlitchPaper
    ccBlack =               IntensityFromMidiCC(1,94)      

//    printSat = 
//    printSoft = 
   
    ccGlitch =              IntensityFromMidiCC(1,14)
    ccOrbit =        filter(IntensityFromMidiCC(1,86), 1.7*sf, 0, 1)
    ccOrbitTilt =    filter(IntensityFromMidiCC(1,88), 1.5*sf, 0)
    ccDolly =        filter(IntensityFromMidiCC(1,89), sf)
    ccFOV =          filter(IntensityFromMidiCC(1,90), 1)
    ccCamY =         filter(IntensityFromMidiCC(1,92), 1)
    nc = 1
    bleedFix = 0.5/64

    nnFilterFocusPos = IntensityFromMidi(1,0)
    nnPolarCoords =    IntensityFromMidi(1,1)

    nnColInv = IntensityFromMidi(1,2)
    nnRed = 1 - IntensityFromMidi(1,3)

    nnTextBankSwitch = IntensityFromMidi(1,6)

    red = [0.783, 0.27, 0, 1] 
    gray = [1.93*0.23, 2.06*0.23, 2.21*0.23, 1] 
    warmWhite = [3.18, 3.16, 2.9, 0.28 * 4]/2
    denim = [0.34, 0.42, 0.57, 0.25] * 2 
    denimDark = [0.29, 0.31, 0.38, 1/4]*2 

    textColor =  mix( mix(warmWhite, gray,      nnColInv)   , red  , nnRed)
    bgColor =    mix( mix(denimDark, warmWhite, nnColInv)   , denim, nnRed)  // + [IntensityFromMidiCC(1,23), 0, 0,0]    // *  (1+sin(time))

    textColor2 =  warmWhite 
    bgColor2 = [0,0,0,0]
    
    nnGlyphScale = select( IntensityFromMidi(1,12) <= 0, 1, 1.06 - IntensityFromMidi(1,12))
    nnGlyphGlitch =  1.0 - IntensityFromMidi(1,13)
    nnGlyphNoiseSeed =     NoteOnTimestampFromMidi(1,14) * 100
//    nnGlyphNoise =         IntensityFromMidi(1,15)
//    nnGlyphNoiseType =     IntensityFromMidi(1,16)
//    nnGlyphNoiseMinLum =   IntensityFromMidi(1,17)
//    nnGlyphNoiseMaxLum = 1-IntensityFromMidi(1,18)
    nnGlyphNoiseNoiseCoord = IntensityFromMidi(1,19)
    nnGlyphNoise2 =         IntensityFromMidi(1,20)
    nnColorOffset =     max(select(FrameIntensityFromMidi(3, 28) > 0.01, 0.03, 0.05), IntensityFromMidi(1,21))


    cubeMesh = LoadMesh('cube.obj')


- BLACK
  ShaderRect ; Shader = 'black-fade-on-top' ; Intensity = 1 - ccBlack
  

- PRINT SIMULATION
  Global
    glitch = LoadTexture('analog-glitch.png')
    halftone = ProceduralTexture('halftone', width = 1024, height = 1024, _ExportN = 8, _Type = 2, _InvertPattern = 1, _DisplaceUV = 0.03, _NoiseAmount = 0.024)
    printSimMat = Material(shader = 'print-sim', texture = offscrBuf, _GlitchTex = glitch, _HalftoneTex = halftone, _PaperOffset = ccPaperOffset, _PaperScale = zoomRaster, _Aspect = screenHeight / screenWidth, _GlitchAmount = ccGlitchPaper, _PaperAmount = ccPaperAmount, _Offset = nnColorOffset)
  ShaderRect ; MaterialRef = printSimMat 


- OFFSCREEN
  Global
    fontTex = LoadTexture('virtual-display-font.png', filter = 'trilinear')
    offscrBuf = ProceduralTexture(width = screenWidth * min(1, zoomRaster / 2), height = screenHeight * min(1, zoomRaster / 2), wrap = 'clamp')
  OffscreenCamera ; ExcludeMask = 1+4 ; RenderTexture = offscrBuf
  CameraControl

  - RenderText1
    Global
      textbuffer1W = 64
      textbuffer1H = 128
      textbuffer1 = TextToTextmode(textbuffer1W, textbuffer1H, LoadString('message.txt'))
      renderText1Mat = Material(shader = 'virtual-display', texture = fontTex, _Color = textColor -> color, _BgColor = bgColor -> color)
    ShaderRect ; MaterialRef = renderText1Mat ; FillWidth = true ; Aspect = 1 ; RenderGroup = 2 ; Mesh = cubeMesh ; UseMainCamera = false
      Matrix = MatrixFromTRS(0,0,2.7,  0,cc3D,0,  cc3DScale)
    TextDisplay ; Columns = textbuffer1W ; Rows = textbuffer1H
      Material = renderText1Mat
      TextBuffer = textbuffer1
      FocusX = ccFocX/2 + 0.5
      FocusY = ccFocY/2 + 0.5 + nnTextBankSwitch * 64
      FocusRows = 10 * zoom
      Rotation = ccFocRot
      LetterAspect =  nnGlyphGlitch
      LetterScale =   nnGlyphScale
      Seed =          nnGlyphNoiseSeed
      Noise =         nnGlyphNoise
      NoiseType =     nnGlyphNoiseType
      NoiseMinLum =   nnGlyphNoiseMinLum
      NoiseMaxLum =   nnGlyphNoiseMaxLum
      NoiseCoord =    nnGlyphNoiseNoiseCoord 

  - RenderText2
    Global
      textbuffer2N = 5
      textbuffer2W = textbuffer2N * 11
      textbuffer2H = textbuffer2N * 7
      // textbuffer2 = TextToTextmode(textbuffer2W, textbuffer2H, LoadString('message.txt'))
      textbuffer2 = ProceduralTexture(width = textbuffer2W, height = textbuffer2H, filter = 'none')
      renderText2Mat = Material(shader = 'virtual-display', texture = fontTex, filter = 'trilinear', _Color = textColor2 -> color, _BgColor = bgColor2 -> color)
    ShaderRect ; MaterialRef = renderText2Mat ; FillWidth = true ; Aspect = 1 ; RenderGroup = 2 ; Mesh = cubeMesh ; UseMainCamera = false
      Matrix = MatrixFromTRS(0,0,8.7,  0,0,0,  5 / 1)
    TextDisplay ; Columns = textbuffer2W ; Rows = textbuffer2H
      Material = renderText2Mat
      TextBuffer = textbuffer2
      FocusX = textbuffer2W / 2 + (((textbuffer2N - 1) / 2)%1)
      FocusY = textbuffer2H / 2 + (((textbuffer2N - 1) / 2)%1)
      FocusRows = (floor(ccText2Scale * 12) + 1) * zoom * (23/2)
      Rotation = ccFocRot
      Seed =          nnGlyphNoiseSeed
      Noise =         nnGlyphNoise2
      NoiseType =     nnGlyphNoiseType
      NoiseMinLum =   nnGlyphNoiseMinLum
      NoiseMaxLum =   nnGlyphNoiseMaxLum
      NoiseCoord =    nnGlyphNoiseNoiseCoord       

- OFFSCREEN FEED TO TEXTBUFFER
  OffscreenCamera ; ExcludeMask = 1+2 ; RenderTexture = textbuffer2
  CameraControl

  - LOGO  
    ShaderRect ; Material = "teadrinker-logo-anim"
      RenderGroup = 4
      Intensity = FrameIntensityFromMidi(3, 28) 
      Aspect = -1/0.636363
      _Size = -0.32  // -0.6666
      _LocalTime = FramePosFromMidi(3, 28) / 90
      _Color = color(0, 4 * ccText2Gain, 3/8, 1)
      RenderQueue = 3006

  - spectograms
    Global
      animMat = Material("EventAnimator", LoadTexture("spectograms.png"))
      colWriteTextMul = [0, 4 * ccText2Gain, 0, 1]
      colWriteTextAdd = [0, 0.01, ccPattern, 1]
    ShaderRect ; MaterialRef = animMat ; RenderGroup = 4 ; CameraDistance = 3
    EventAnimator ; Material = animMat ; Aspect = 0.3 ; ColorMul = colWriteTextMul -> color ; ColorAdd = colWriteTextAdd -> color ; UsePolarCoords = nnPolarCoords
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 36) ; UvRect = vec4( 0/64, 7/8,  12/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 37) ; UvRect = vec4(12/64, 7/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 38) ; UvRect = vec4(18/64, 7/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 39) ; UvRect = vec4(24/64, 7/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 40) ; UvRect = vec4(30/64, 7/8,   3/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 41) ; UvRect = vec4(33/64, 7/8,   3/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 42) ; UvRect = vec4(36/64, 7/8,   3/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 43) ; UvRect = vec4(39/64, 7/8,   3/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 44) ; UvRect = vec4(42/64, 7/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 45) ; UvRect = vec4(48/64, 7/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 46) ; UvRect = vec4(54/64, 7/8,   8/64 - bleedFix, 1/8)

    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 47) ; UvRect = vec4( 0/64, 6/8,   5/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 48) ; UvRect = vec4( 5/64, 6/8,   8/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 49) ; UvRect = vec4(13/64, 6/8,  10/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 50) ; UvRect = vec4(23/64, 6/8,  10/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 51) ; UvRect = vec4(32/64, 6/8,  13/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 52) ; UvRect = vec4(45/64, 6/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 53) ; UvRect = vec4(51/64, 6/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 54) ; UvRect = vec4(57/64, 6/8,   6/64 - bleedFix, 1/8)

    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 55) ; UvRect = vec4( 0/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 56) ; UvRect = vec4( 6/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 57) ; UvRect = vec4(12/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 58) ; UvRect = vec4(18/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 59) ; UvRect = vec4(24/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 60) ; UvRect = vec4(30/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 61) ; UvRect = vec4(36/64, 5/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 62) ; UvRect = vec4(42/64, 5/8,   4/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 63) ; UvRect = vec4(46/64, 5/8,   4/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 64) ; UvRect = vec4(50/64, 5/8,   4/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 65) ; UvRect = vec4(54/64, 5/8,   4/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 66) ; UvRect = vec4(58/64, 5/8,   4/64 - bleedFix, 1/8)

    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 67) ; UvRect = vec4( 0/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 68) ; UvRect = vec4( 6/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 69) ; UvRect = vec4(12/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 70) ; UvRect = vec4(18/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 71) ; UvRect = vec4(24/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 72) ; UvRect = vec4(30/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 73) ; UvRect = vec4(36/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 74) ; UvRect = vec4(42/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 75) ; UvRect = vec4(48/64, 4/8,   6/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 76) ; UvRect = vec4(54/64, 4/8,   4/64 - bleedFix, 1/8)

    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 77) ; UvRect = vec4( 0/64, 3/8,  10/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 78) ; UvRect = vec4(10/64, 3/8,  12/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 79) ; UvRect = vec4(22/64, 3/8,  12/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 80) ; UvRect = vec4(34/64, 3/8,  12/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 81) ; UvRect = vec4(46/64, 3/8,   8/64 - bleedFix, 1/8)

    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 82) ; UvRect = vec4( 0/64, 2/8,  14/64 - bleedFix, 1/8)
    EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 83) ; UvRect = vec4(14/64, 2/8,  10/64 - bleedFix, 1/8)




- cam_base
  CameraControl
    TiltOrbit = 0             
  CameraControl
    FXAmount =   0.0
    FXExposure = fallback(ccExposure * 2 - 1, 0)
    FXGlitch = 6.0 * pow(ccGlitch, 2)
    Orbit =     360 * (ccOrbit-0.5)
    TiltOrbit = 180 * (ccOrbitTilt-0.5)
    Dolly = 10 * (ccDolly-0.5) + Pulse * ccDollyPulse
//    FOV = 1 + 1.95 * (ccFOV-0.5)
    Y = 3  * (ccCamY-0.5)




// - deck
//  MeshStack ; Resource = "deck_chair.obj" ; Material = Material("Unlit", LoadTexture("test.png"))

//- synctest
//  Global ; synctestMat = Material("EventAnimator", LoadTexture("test.png"))
//  ShaderRect ; MaterialRef = synctestMat  
//  EventAnimator ; Material = synctestMat
//  EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 36) ; UvRect = vec4(0,0, 1,1) ; StartHidden = false

//  ProceduralTexture()

//- texturetest
//  Global ; texturetestMat = Material(texture = ProceduralTexture('halftone', width = screenWidth, height = screenHeight, _ExportN = 16, _Type = 2))
//  ShaderRect ; MaterialRef = texturetestMat  

