Demo.prototype.sceneFruitsTunnel = function () {
    this.setScene('fruitsTunnel');
    this.addEffectStarfield(0, 2228*window.pattern, 70, "multiSceneEffects/tex_heartParticle.png", 35, .7);
    this.loader.addAnimation([{

      "object":{
          "name":"obj_peach.obj"
        }
      ,"position":[{
        "x":0,
        "y":0,
        "z":35 ,
      }]
      ,"color":[{
          "r":1.0,
          "g":1.0,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":3.0}]
      ,"angle":[{             
        "degreesX":()=>45+getSceneTimeFromStart()*45,              
        "degreesZ":()=>-getSceneTimeFromStart()*90
          
      }]
    }]);

    this.loader.addAnimation([{
 
      "object":{
          "name":"obj_heartTunnel.obj"
        }
        ,"transparent":true
      ,"position":[{
        "x":0,
        "y":0,
        "z":0,
      }]

      ,"color":[{
          "r":1.0,
          "g":1.0,
          "b":1.0
      }]
      ,"scale":[{"x":10.25,"y":21.25,"z":10.25}]
      ,"angle":[{             
        "degreesZ":()=>90,
        "degreesY":()=>90,         
      }],
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping' }],
      shader: {
        name: 'multiSceneEffects/uvscroll.fs',
        variable: [
          { name: 'sScrollScale', value: [.1] },
          { name: 'fakeTime', value: [() => 2.5*getSceneTimeFromStart()] },
          { name: 'kolor', value: [0.9] }
        ]
      }
      
    }]);
    
    
      let objects = ["obj_kurk.obj", "obj_banana.obj", "obj_carrot.obj", "obj_myski.obj", "obj_munis.obj"];
      let objectSyncs = ["Kurk", "Bana", "Pork", "Mysk", "Muna"];
      let positions =
      [
        0,0,0.866025,
        0.823639, 0, 0.267617,
        0.509037,0,  -0.700629,
        -0.509037, 0, -0.700629,
        -0.823639, 0, 0.267617
      
       
      ];

  
      this.loader.addAnimation([{
        "id":"tunnelParent",
        "object":null
        ,"position":[{
          "x":()=>Sync.get('Tunnel:FruitX'),
          "y":0,
          "z":0,
        }]
        ,"color":[{
            "r":1.0,
            "g":1.0,
            "b":1.0
        }]
        ,"scale":[{"uniform3d":1.50}]
        ,"angle":[{             
          "degreesX":90,              
         "degreesY":()=>getSceneTimeFromStart()*90
        }],
        material:{forceSinglePass:true},
      }]);

        for (let i = 0; i<objects.length;i++)
        {
          let posScaleSyncName = 'VegRot:'+objectSyncs[i]+'PosScale';
          let angleName = 'VegRot:'+objectSyncs[i]+'Angle';
          let KisailuStartName = 'Tunnel:'+objectSyncs[i]+'KisailuStart';
          let x = positions[i*3];
          let y = positions[i*3+1];
          let z = positions[i*3+2];
          this.loader.addAnimation([{

            "parent":"tunnelParent",
            "object":{
                "name":objects[i]
              }
            ,"position":[{
              "x":()=>x * Sync.get(posScaleSyncName),
              "y":()=>y * Sync.get(posScaleSyncName) + 1*Math.sin(Sync.get(KisailuStartName)+(1+Sync.get(KisailuStartName))*getSceneTimeFromStart()) + Sync.get('Tunnel:FallosY'),
              "z":()=>z * Sync.get(posScaleSyncName)
            }]
            ,"color":[{
                "r":1.0,
                "g":1.0,
                "b":1.0
            }]
            ,"scale":[{"uniform3d":.35}]
            ,"angle":[{             
              //"degreesX":()=>getSceneTimeFromStart()*90,              
              "degreesY":()=>-getSceneTimeFromStart()*240         
            }]
          }]);
      }
}


Demo.prototype.addEffectStarfield = function (startTime, durationTime, amountOfParticles, texture, areaSize, particleSize) {


  const recalcThreshold = 0.1;

  let stars = new Array(amountOfParticles);
  const size = areaSize;
  for (let i = 0; i < stars.length; i++) {
    let z1 = Math.random()*3.0
    stars[i] = {
      "x1": Math.random()*size*2-size,
      "y1": Math.random()*size*2-size,
      "z1": z1,
      "z2": z1-1.0
    };
  }

  this.loader.addAnimation({
    "start":startTime, "duration":durationTime,
    "image": texture,
    textureProperties: [{},{minFilter: 'NearestMipmapNearestFilter', magFilter: 'LinearFilter'}],
    "perspective": "3d",
    "billboard": true,
    "material":{
      "blending": 'AdditiveBlending',
      "transparent":true,
      "depthWrite":false,
    },
    "scale":[{"uniform3d":.1}],
    "instancer": {
      "count": stars.length,
      "runInstanceFunction": (properties) => {

        const i = properties.index;
        const count = properties.count;
        const time = properties.time;
        let object = properties.object;
        let color = properties.color;

        const scale = particleSize;
        object.scale.x = scale;
        object.scale.y = scale;
        object.scale.z = scale;   

        const percent = (getSceneTimeFromStart()*.25)%1.0;
        object.position.z = (Utils.mix(stars[i].z1, stars[i].z2, percent)%1.0)*size*40-size*20;;
        object.position.x = stars[i].x1;
        object.position.y = stars[i].y1;
        //object.position.z = stars[i].z1*size*2-size;

        }
      }
    
  });
}