/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import org.joml.Vector3f;

public class Camera {
    private Vector3f position;
    private Vector3f rotation;

    public Camera() {
        this.position = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rotation = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Camera(Vector3f position, Vector3f rotation) {
        this.position = position;
        this.rotation = rotation;
    }

    public void movePosition(float x, float y, float z) {
        if (z != 0.0f) {
            this.position.x += (float)Math.sin(Math.toRadians(this.rotation.y)) * -1.0f * z;
            this.position.z += (float)Math.cos(Math.toRadians(this.rotation.y)) * z;
        }
        if (x != 0.0f) {
            this.position.x += (float)Math.sin(Math.toRadians(this.rotation.y - 90.0f)) * -1.0f * x;
            this.position.z += (float)Math.cos(Math.toRadians(this.rotation.y - 90.0f)) * x;
        }
        this.position.y += y;
    }

    public void setPosition(float x, float y, float z) {
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
    }

    public void setRotation(float x, float y, float z) {
        this.rotation.x = x;
        this.rotation.y = y;
        this.rotation.z = z;
    }

    public void moveRotation(float x, float y, float z) {
        this.rotation.x += x;
        this.rotation.y += y;
        this.rotation.z += z;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }
}

