/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import fi.autiosaari.caccanen.core.entity.Model;
import fi.autiosaari.caccanen.core.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class ObjectLoader {
    private List<Integer> vaos = new ArrayList<Integer>();
    private List<Integer> vbos = new ArrayList<Integer>();
    private List<Integer> textures = new ArrayList<Integer>();

    public Model loadOBJModel(String filename) {
        List<String> lines = Utils.readAllLines(filename);
        ArrayList vertices = new ArrayList();
        ArrayList normals = new ArrayList();
        ArrayList textures = new ArrayList();
        ArrayList faces = new ArrayList();
        lines.stream().map(line -> line.split("\\s+")).forEach(tokens -> {
            if (((String[])tokens).length == 0) {
                return;
            }
            switch (tokens[0]) {
                case "v": {
                    Vector3f verticesVec = new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]));
                    vertices.add(verticesVec);
                    break;
                }
                case "vt": {
                    System.out.println(Arrays.toString(tokens));
                    Vector2f textureVec = new Vector2f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    textures.add(textureVec);
                    break;
                }
                case "vn": {
                    Vector3f normalsVec = new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]));
                    normals.add(normalsVec);
                    break;
                }
                case "f": {
                    ObjectLoader.processFace(tokens[1], faces);
                    ObjectLoader.processFace(tokens[2], faces);
                    ObjectLoader.processFace(tokens[3], faces);
                    break;
                }
            }
        });
        ArrayList indicies = new ArrayList();
        float[] verticiesArr = new float[vertices.size() * 3];
        int i = 0;
        for (Vector3f pos : vertices) {
            verticiesArr[i * 3] = pos.x;
            verticiesArr[i * 3 + 1] = pos.y;
            verticiesArr[i * 3 + 2] = pos.z;
            ++i;
        }
        float[] texCoordArr = new float[vertices.size() * 2];
        float[] normalArr = new float[vertices.size() * 3];
        faces.forEach(face -> ObjectLoader.processVertex(face.x, face.y, face.z, textures, normals, indicies, texCoordArr, normalArr));
        int[] indiciesArr = indicies.stream().mapToInt(Integer::intValue).toArray();
        return this.loadModel(verticiesArr, texCoordArr, normalArr, indiciesArr);
    }

    private static void processVertex(int pos, int texCoord, int normal, List<Vector2f> texCoordList, List<Vector3f> normalList, List<Integer> indiciesList, float[] texCoordArr, float[] normalArr) {
        indiciesList.add(pos);
        if (texCoord >= 0) {
            Vector2f texCoordVec = texCoordList.get(texCoord);
            texCoordArr[pos * 2] = texCoordVec.x;
            texCoordArr[pos * 2 + 1] = 1.0f - texCoordVec.y;
        }
        if (normal >= 0) {
            Vector3f normalVec = normalList.get(normal);
            normalArr[pos * 3] = normalVec.x;
            normalArr[pos * 3 + 1] = normalVec.y;
            normalArr[pos * 3 + 2] = normalVec.z;
        }
    }

    private static void processFace(String token, List<Vector3i> faces) {
        String[] lineToken = token.split("/");
        int length = lineToken.length;
        int pos = Integer.parseInt(lineToken[0]) - 1;
        int coords = -1;
        int normal = -1;
        if (length > 1) {
            String textCoord = lineToken[1];
            int n = coords = textCoord.length() > 0 ? Integer.parseInt(textCoord) - 1 : -1;
            if (length > 2) {
                normal = Integer.parseInt(lineToken[2]) - 1;
            }
        }
        Vector3i facesVec = new Vector3i(pos, coords, normal);
        faces.add(facesVec);
    }

    public Model loadModel(float[] vertices, float[] textureCoords, float[] normals, int[] indices) {
        int id = this.createVAO();
        this.storeIndicesBuffer(indices);
        this.storeDataInAttribList(0, 3, vertices);
        this.storeDataInAttribList(1, 2, textureCoords);
        this.storeDataInAttribList(2, 3, normals);
        this.unbind();
        return new Model(id, indices.length);
    }

    public int loadTexture(String filename) throws Exception {
        int height;
        int width;
        ByteBuffer buffer;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h = stack.mallocInt(1);
            IntBuffer c = stack.mallocInt(1);
            buffer = STBImage.stbi_load((CharSequence)filename, w, h, c, 4);
            if (buffer == null) {
                throw new Exception("Image file %s not loaded, reason: %s".formatted(filename, STBImage.stbi_failure_reason()));
            }
            width = w.get();
            height = h.get();
        }
        int id = GL11.glGenTextures();
        this.textures.add(id);
        GL11.glBindTexture(3553, id);
        GL11.glPixelStorei(3317, 1);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, buffer);
        GL30.glGenerateMipmap(3553);
        STBImage.stbi_image_free(buffer);
        return id;
    }

    private int createVAO() {
        int id = GL30.glGenVertexArrays();
        this.vaos.add(id);
        GL30.glBindVertexArray(id);
        return id;
    }

    private void storeIndicesBuffer(int[] indices) {
        int vbo = GL15.glGenBuffers();
        this.vbos.add(vbo);
        GL15.glBindBuffer(34963, vbo);
        IntBuffer buffer = Utils.storeDataInFloatBuffer(indices);
        GL15.glBufferData(34963, buffer, 35044);
    }

    private void storeDataInAttribList(int attribNo, int vertexCount, float[] data) {
        int vbo = GL15.glGenBuffers();
        this.vbos.add(vbo);
        GL15.glBindBuffer(34962, vbo);
        FloatBuffer buffer = Utils.storeDataInFloatBuffer(data);
        GL15.glBufferData(34962, buffer, 35044);
        GL20.glVertexAttribPointer(attribNo, vertexCount, 5126, false, 0, 0L);
        GL15.glBindBuffer(34962, 0);
    }

    private void unbind() {
        GL30.glBindVertexArray(0);
    }

    public void cleanup() {
        this.vaos.forEach(GL30::glDeleteVertexArrays);
        this.vbos.forEach(GL15::glDeleteBuffers);
        this.textures.forEach(GL11::glDeleteTextures);
    }
}

