/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import fi.autiosaari.caccanen.core.entity.Material;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import java.util.HashMap;
import java.util.Map;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public class ShaderManager {
    private final int programID = GL20.glCreateProgram();
    private int vertexShaderID;
    private int fragmentShaderID;
    private final Map<String, Integer> uniforms;

    public ShaderManager() throws Exception {
        if (this.programID == 0) {
            throw new Exception("Could not create shader!");
        }
        this.uniforms = new HashMap<String, Integer>();
    }

    public void createUniform(String uniformName) throws Exception {
        int uniformLocation = GL20.glGetUniformLocation(this.programID, uniformName);
        if (uniformLocation < 0) {
            throw new Exception("Could not find uniform " + uniformName);
        }
        this.uniforms.put(uniformName, uniformLocation);
    }

    public void createDirectionalLightUniform(String uniformName) throws Exception {
        this.createUniform(uniformName + ".colour");
        this.createUniform(uniformName + ".direction");
        this.createUniform(uniformName + ".intensity");
    }

    public void createMaterialUniform(String uniformName) throws Exception {
        this.createUniform(uniformName + ".ambient");
        this.createUniform(uniformName + ".diffuse");
        this.createUniform(uniformName + ".specular");
        this.createUniform(uniformName + ".hasTexture");
        this.createUniform(uniformName + ".reflectance");
    }

    public void createPointLightUniform(String uniformName) throws Exception {
        this.createUniform(uniformName + ".colour");
        this.createUniform(uniformName + ".position");
        this.createUniform(uniformName + ".intensity");
        this.createUniform(uniformName + ".constant");
        this.createUniform(uniformName + ".linear");
        this.createUniform(uniformName + ".exponent");
    }

    public void createPointLightListUniform(String uniformName, int size) throws Exception {
        for (int i = 0; i < size; ++i) {
            this.createPointLightUniform("%s[%d]".formatted(uniformName, i));
        }
    }

    public void createSpotLightListUniform(String uniformName, int size) throws Exception {
        for (int i = 0; i < size; ++i) {
            this.createSpotLightUniform("%s[%d]".formatted(uniformName, i));
        }
    }

    public void createSpotLightUniform(String uniformName) throws Exception {
        this.createPointLightUniform(uniformName + ".pl");
        this.createUniform(uniformName + ".conedir");
        this.createUniform(uniformName + ".cutoff");
    }

    public void setUniform(String uniformName, Matrix4f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL20.glUniformMatrix4fv((int)this.uniforms.get(uniformName), false, value.get(stack.mallocFloat(16)));
        }
    }

    public void setUniform(String uniformName, Material material) {
        this.setUniform(uniformName + ".ambient", material.getAmbientColour());
        this.setUniform(uniformName + ".diffuse", material.getDiffuseColour());
        this.setUniform(uniformName + ".specular", material.getSpecularColour());
        this.setUniform(uniformName + ".hasTexture", material.hasTexture() ? 1 : 0);
        this.setUniform(uniformName + ".reflectance", material.getReflectance());
    }

    public void setUniform(String uniformName, DirectionalLight directionalLight) {
        this.setUniform(uniformName + ".colour", directionalLight.getColour());
        this.setUniform(uniformName + ".direction", directionalLight.getDirection());
        this.setUniform(uniformName + ".intensity", directionalLight.getIntensity());
    }

    public void setUniform(String uniformName, PointLight pointLight) {
        this.setUniform(uniformName + ".colour", pointLight.getColour());
        this.setUniform(uniformName + ".position", pointLight.getPosition());
        this.setUniform(uniformName + ".intensity", pointLight.getIntensity());
        this.setUniform(uniformName + ".constant", pointLight.getConstant());
        this.setUniform(uniformName + ".linear", pointLight.getLinear());
        this.setUniform(uniformName + ".exponent", pointLight.getExponent());
    }

    public void setUniform(String uniformName, SpotLight spotLight) {
        this.setUniform(uniformName + ".pl", spotLight.getPointLight());
        this.setUniform(uniformName + ".conedir", spotLight.getConeDirection());
        this.setUniform(uniformName + ".cutoff", spotLight.getCutoff());
    }

    public void setUniform(String uniformName, PointLight[] pointLights) {
        int numLights = pointLights != null ? pointLights.length : 0;
        for (int i = 0; i < numLights; ++i) {
            this.setUniform(uniformName, pointLights[i], i);
        }
    }

    public void setUniform(String uniformName, PointLight pointLight, int pos) {
        this.setUniform("%s[%d]".formatted(uniformName, pos), pointLight);
    }

    public void setUniform(String uniformName, SpotLight[] spotLights) {
        int numLights = spotLights != null ? spotLights.length : 0;
        for (int i = 0; i < numLights; ++i) {
            this.setUniform(uniformName, spotLights[i], i);
        }
    }

    public void setUniform(String uniformName, SpotLight spotLight, int pos) {
        this.setUniform("%s[%d]".formatted(uniformName, pos), spotLight);
    }

    public void setUniform(String uniformName, Vector4f value) {
        GL20.glUniform4f(this.uniforms.get(uniformName), value.x, value.y, value.z, value.w);
    }

    public void setUniform(String uniformName, Vector3f value) {
        GL20.glUniform3f(this.uniforms.get(uniformName), value.x, value.y, value.z);
    }

    public void setUniform(String uniformName, boolean value) {
        float res = value ? 1.0f : 0.0f;
        GL20.glUniform1f(this.uniforms.get(uniformName), res);
    }

    public void setUniform(String uniformName, int value) {
        GL20.glUniform1i(this.uniforms.get(uniformName), value);
    }

    public void setUniform(String uniformName, float value) {
        GL20.glUniform1f(this.uniforms.get(uniformName), value);
    }

    public void createVertexShader(String shaderCode) throws Exception {
        this.vertexShaderID = this.createShader(shaderCode, 35633);
    }

    public void createFragmentShader(String shaderCode) throws Exception {
        this.vertexShaderID = this.createShader(shaderCode, 35632);
    }

    public int createShader(String shaderCode, int shaderType) throws Exception {
        int shaderID = GL20.glCreateShader(shaderType);
        if (shaderID == 0) {
            throw new Exception("Error creating shader type=" + shaderType);
        }
        GL20.glShaderSource(shaderID, (CharSequence)shaderCode);
        GL20.glCompileShader(shaderID);
        if (GL20.glGetShaderi(shaderID, 35713) == 0) {
            throw new Exception("Error compiling shader code! type=%d Info: %s".formatted(shaderType, GL20.glGetShaderInfoLog(shaderID, 1024)));
        }
        GL20.glAttachShader(this.programID, shaderID);
        return shaderID;
    }

    public void link() throws Exception {
        GL20.glLinkProgram(this.programID);
        if (GL20.glGetProgrami(this.programID, 35714) == 0) {
            throw new Exception("Error linking shader code! Info: %s".formatted(GL20.glGetProgramInfoLog(this.programID, 1024)));
        }
        if (this.vertexShaderID != 0) {
            GL20.glDetachShader(this.programID, this.vertexShaderID);
        }
        if (this.fragmentShaderID != 0) {
            GL20.glDetachShader(this.programID, this.fragmentShaderID);
        }
        GL20.glValidateProgram(this.programID);
        if (GL20.glGetProgrami(this.programID, 35715) == 0) {
            throw new Exception("Unable to validate shader code: " + GL20.glGetProgramInfoLog(this.programID, 1024));
        }
    }

    public void bind() {
        GL20.glUseProgram(this.programID);
    }

    public void unbind() {
        GL20.glUseProgram(0);
    }

    public void cleanup() {
        this.unbind();
        if (this.programID != 0) {
            GL20.glDeleteProgram(this.programID);
        }
    }
}

