/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import fi.autiosaari.caccanen.core.utils.Consts;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class WindowManager {
    private final String title;
    private int width;
    private int height;
    private long window;
    private boolean resize;
    private boolean vsync;
    private final Matrix4f projectionMatrix;

    public WindowManager(String title, int width, int height, boolean resize) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.resize = resize;
        this.projectionMatrix = new Matrix4f();
    }

    public void init() {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 1);
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 2);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(139270, 1);
        boolean maximized = false;
        if (this.width == 0 || this.height == 0) {
            this.width = 100;
            this.height = 100;
            GLFW.glfwWindowHint(131080, 1);
        }
        this.window = GLFW.glfwCreateWindow(this.width, this.height, this.title, 0L, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to crate GLFW window");
        }
        GLFW.glfwSetFramebufferSizeCallback(this.window, (window, width, height) -> {
            this.width = width;
            this.height = height;
            this.setResize(true);
        });
        GLFW.glfwSetKeyCallback(this.window, (window, key, scancode, action, mods) -> {
            if (key == 256 && action == 0) {
                GLFW.glfwSetWindowShouldClose(window, true);
            }
        });
        if (maximized) {
            GLFW.glfwMaximizeWindow(this.window);
        } else {
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.window, (vidMode.width() - this.width) / 2, (vidMode.height() - this.height) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.window);
        if (this.isVsync()) {
            GLFW.glfwSwapInterval(1);
        }
        GLFW.glfwShowWindow(this.window);
        GL.createCapabilities();
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glEnable(2929);
        GL11.glEnable(2960);
        GL11.glEnable(2884);
        GL11.glCullFace(1029);
    }

    public void update() {
        GLFW.glfwSwapBuffers(this.window);
        GLFW.glfwPollEvents();
    }

    public void cleanup() {
        GLFW.glfwDestroyWindow(this.window);
    }

    public void setClearColour(float r, float g, float b, float a) {
        GL11.glClearColor(r, g, b, a);
    }

    public boolean isKeyPressed(int keycode) {
        return GLFW.glfwGetKey(this.window, keycode) == 1;
    }

    public boolean windowShouldClose() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    public void setTitle(String title) {
        GLFW.glfwSetWindowTitle(this.window, title);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public long getWindowHandle() {
        return this.window;
    }

    public void setWindow(long window) {
        this.window = window;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isVsync() {
        return this.vsync;
    }

    public void setVsync(boolean vsync) {
        this.vsync = vsync;
    }

    public boolean isResized() {
        return this.resize;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
    }

    public Matrix4f updateProjectionMatrix() {
        return this.updateProjectionMatrix(this.projectionMatrix, this.width, this.height);
    }

    public Matrix4f updateProjectionMatrix(Matrix4f matrix, int width, int height) {
        float aspectRatio = (float)width / (float)height;
        return matrix.setPerspective(Consts.FOV, aspectRatio, 0.01f, 1000.0f);
    }
}

