/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.entity;

import fi.autiosaari.caccanen.core.entity.Entity;
import fi.autiosaari.caccanen.core.entity.terrain.Terrain;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import fi.autiosaari.caccanen.core.utils.Consts;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;

public class SceneManager {
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Terrain> terrains = new ArrayList<Terrain>();
    private Vector3f ambientLight;
    private SpotLight[] spotLights;
    private PointLight[] pointLights;
    private DirectionalLight directionalLight;
    private float lightAngle;
    private float spotAngle = 0.0f;
    private float spotInc = 1.0f;

    public SceneManager(float lightAngle) {
        this.lightAngle = lightAngle;
        this.ambientLight = Consts.AMBIENT_LIGHT;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public List<Terrain> getTerrains() {
        return this.terrains;
    }

    public void setTerrains(List<Terrain> terrains) {
        this.terrains = terrains;
    }

    public void addTerrain(Terrain terrain) {
        this.terrains.add(terrain);
    }

    public Vector3f getAmbientLight() {
        return this.ambientLight;
    }

    public void setAmbientLight(Vector3f ambientLight) {
        this.ambientLight = ambientLight;
    }

    public void setAmbientLight(float x, float y, float z) {
        this.ambientLight = new Vector3f(x, y, z);
    }

    public SpotLight[] getSpotLights() {
        return this.spotLights;
    }

    public void setSpotLights(SpotLight[] spotLights) {
        this.spotLights = spotLights;
    }

    public PointLight[] getPointLights() {
        return this.pointLights;
    }

    public void setPointLights(PointLight[] pointLights) {
        this.pointLights = pointLights;
    }

    public DirectionalLight getDirectionalLight() {
        return this.directionalLight;
    }

    public void setDirectionalLight(DirectionalLight directionalLight) {
        this.directionalLight = directionalLight;
    }

    public float getLightAngle() {
        return this.lightAngle;
    }

    public void setLightAngle(float lightAngle) {
        this.lightAngle = lightAngle;
    }

    public void incLightAngle(float increment) {
        this.lightAngle += increment;
    }

    public float getSpotAngle() {
        return this.spotAngle;
    }

    public void setSpotAngle(float spotAngle) {
        this.spotAngle = spotAngle;
    }

    public void incSpotAngle(float increment) {
        this.spotAngle *= increment;
    }

    public float getSpotInc() {
        return this.spotInc;
    }

    public void setSpotInc(float spotInc) {
        this.spotInc = spotInc;
    }
}

