/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.entity.terrain;

import fi.autiosaari.caccanen.core.ObjectLoader;
import fi.autiosaari.caccanen.core.entity.Material;
import fi.autiosaari.caccanen.core.entity.Model;
import fi.autiosaari.caccanen.core.entity.Texture;
import fi.autiosaari.caccanen.core.entity.terrain.BlendMapTerrain;
import fi.autiosaari.caccanen.core.entity.terrain.TerrainTexture;
import org.joml.Vector3f;

public class Terrain {
    private static final float SIZE = 800.0f;
    private static final int VERTEX_COUNT = 128;
    private Vector3f position;
    private Model model;
    private TerrainTexture blendMap;
    private BlendMapTerrain blendMapTerrain;

    public Terrain(Vector3f position, ObjectLoader loader, Material material, BlendMapTerrain blendMapTerrain, TerrainTexture blendMap) {
        this.position = position;
        this.model = this.generateTerrain(loader);
        this.model.setMaterial(material);
        this.blendMapTerrain = blendMapTerrain;
        this.blendMap = blendMap;
    }

    private Model generateTerrain(ObjectLoader loader) {
        int count = 16384;
        float[] vertices = new float[count * 3];
        float[] normals = new float[count * 3];
        float[] textureCoords = new float[count * 2];
        int[] indices = new int[96774];
        int vertexPointer = 0;
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                vertices[vertexPointer * 3] = (float)j / 127.0f * 800.0f;
                vertices[vertexPointer * 3 + 1] = 0.0f;
                vertices[vertexPointer * 3 + 2] = (float)i / 127.0f * 800.0f;
                normals[vertexPointer * 3] = 0.0f;
                normals[vertexPointer * 3 + 1] = 1.0f;
                normals[vertexPointer * 3 + 2] = 0.0f;
                textureCoords[vertexPointer * 2] = (float)j / 127.0f;
                textureCoords[vertexPointer * 2 + 1] = (float)i / 127.0f;
                ++vertexPointer;
            }
        }
        int pointer = 0;
        int z = 0;
        while ((float)z < 127.0f) {
            int x = 0;
            while ((float)x < 127.0f) {
                int topLeft = z * 128 + x;
                int topRight = topLeft + 1;
                int bottomLeft = (z + 1) * 128 + x;
                int bottomRight = bottomLeft + 1;
                indices[pointer++] = topLeft;
                indices[pointer++] = bottomLeft;
                indices[pointer++] = topRight;
                indices[pointer++] = topRight;
                indices[pointer++] = bottomLeft;
                indices[pointer++] = bottomRight;
                ++x;
            }
            ++z;
        }
        return loader.loadModel(vertices, textureCoords, normals, indices);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Model getModel() {
        return this.model;
    }

    public Material getMaterial() {
        return this.model.getMaterial();
    }

    public Texture getTexture() {
        return this.model.getTexture();
    }

    public TerrainTexture getBlendMap() {
        return this.blendMap;
    }

    public BlendMapTerrain getBlendMapTerrain() {
        return this.blendMapTerrain;
    }
}

