/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.rendering;

import fi.autiosaari.caccanen.core.Camera;
import fi.autiosaari.caccanen.core.ShaderManager;
import fi.autiosaari.caccanen.core.entity.Model;
import fi.autiosaari.caccanen.core.entity.terrain.Terrain;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import fi.autiosaari.caccanen.core.rendering.IRenderer;
import fi.autiosaari.caccanen.core.rendering.RenderManager;
import fi.autiosaari.caccanen.core.utils.Transformation;
import fi.autiosaari.caccanen.core.utils.Utils;
import fi.autiosaari.caccanen.test.Main;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class TerrainRenderer
implements IRenderer {
    ShaderManager shader;
    private List<Terrain> terrains = new ArrayList<Terrain>();

    public TerrainRenderer() throws Exception {
        this.shader = new ShaderManager();
    }

    @Override
    public void init() throws Exception {
        this.shader.createVertexShader(Utils.loadResource("/shaders/terrain_vertex.vs"));
        this.shader.createFragmentShader(Utils.loadResource("/shaders/terrain_fragment.fs"));
        this.shader.link();
        this.shader.createUniform("backgroundTexture");
        this.shader.createUniform("redTexture");
        this.shader.createUniform("greenTexture");
        this.shader.createUniform("blueTexture");
        this.shader.createUniform("blendMap");
        this.shader.createUniform("transformationMatrix");
        this.shader.createUniform("projectionMatrix");
        this.shader.createUniform("viewMatrix");
        this.shader.createUniform("ambientLight");
        this.shader.createMaterialUniform("material");
        this.shader.createUniform("specularPower");
        this.shader.createDirectionalLightUniform("directionalLight");
        this.shader.createPointLightListUniform("pointLights", 5);
        this.shader.createSpotLightListUniform("spotLights", 5);
    }

    @Override
    public void render(Camera camera, PointLight[] pointLights, SpotLight[] spotLights, DirectionalLight directionalLight) {
        this.shader.bind();
        this.shader.setUniform("projectionMatrix", Main.getWindow().updateProjectionMatrix());
        RenderManager.renderLights(pointLights, spotLights, directionalLight, this.shader);
        for (Terrain terrain : this.terrains) {
            this.bind(terrain.getModel());
            this.prepare(terrain, camera);
            GL11.glDrawElements(4, terrain.getModel().getVertexCount(), 5125, 0L);
            this.unbind();
        }
        this.terrains.clear();
        this.shader.unbind();
    }

    @Override
    public void bind(Model model) {
        GL30.glBindVertexArray(model.getId());
        GL20.glEnableVertexAttribArray(0);
        GL20.glEnableVertexAttribArray(1);
        GL20.glEnableVertexAttribArray(2);
        this.shader.setUniform("backgroundTexture", 0);
        this.shader.setUniform("redTexture", 1);
        this.shader.setUniform("greenTexture", 2);
        this.shader.setUniform("blueTexture", 3);
        this.shader.setUniform("blendMap", 4);
        this.shader.setUniform("material", model.getMaterial());
    }

    @Override
    public void unbind() {
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL20.glDisableVertexAttribArray(2);
        GL30.glBindVertexArray(0);
    }

    public void prepare(Object terrain, Camera camera) {
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, ((Terrain)terrain).getBlendMapTerrain().getBackground().getId());
        GL13.glActiveTexture(33985);
        GL11.glBindTexture(3553, ((Terrain)terrain).getBlendMapTerrain().getRedTexture().getId());
        GL13.glActiveTexture(33986);
        GL11.glBindTexture(3553, ((Terrain)terrain).getBlendMapTerrain().getGreenTexture().getId());
        GL13.glActiveTexture(33987);
        GL11.glBindTexture(3553, ((Terrain)terrain).getBlendMapTerrain().getBlueTexture().getId());
        GL13.glActiveTexture(33988);
        GL11.glBindTexture(3553, ((Terrain)terrain).getBlendMap().getId());
        this.shader.setUniform("transformationMatrix", Transformation.createTransformationMatrix((Terrain)terrain));
        this.shader.setUniform("viewMatrix", Transformation.getViewMatrix(camera));
    }

    @Override
    public void cleanup() {
        this.shader.cleanup();
    }

    public List<Terrain> getTerrains() {
        return this.terrains;
    }
}

