/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.utils;

import fi.autiosaari.caccanen.core.Camera;
import fi.autiosaari.caccanen.core.entity.Entity;
import fi.autiosaari.caccanen.core.entity.terrain.Terrain;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class Transformation {
    public static Matrix4f createTransformationMatrix(Entity entity) {
        Matrix4f matrix = new Matrix4f();
        matrix.identity().translate(entity.getPos()).rotateX((float)Math.toRadians(entity.getRotation().x)).rotateY((float)Math.toRadians(entity.getRotation().y)).rotateZ((float)Math.toRadians(entity.getRotation().z)).scale(entity.getScale());
        return matrix;
    }

    public static Matrix4f createTransformationMatrix(Terrain terrain) {
        Matrix4f matrix = new Matrix4f();
        matrix.identity().translate(terrain.getPosition()).scale(1.0f);
        return matrix;
    }

    public static Matrix4f getViewMatrix(Camera camera) {
        Vector3f pos = camera.getPosition();
        Vector3f rot = camera.getRotation();
        Matrix4f matrix = new Matrix4f();
        matrix.identity();
        matrix.rotate((float)Math.toRadians(rot.x), new Vector3f(1.0f, 0.0f, 0.0f)).rotate((float)Math.toRadians(rot.y), new Vector3f(0.0f, 1.0f, 0.0f)).rotate((float)Math.toRadians(rot.z), new Vector3f(0.0f, 0.0f, 1.0f));
        matrix.translate(-pos.x, -pos.y, -pos.z);
        return matrix;
    }
}

