/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiColor3D")
public class AIColor3D
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;

    public AIColor3D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIColor3D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return AIColor3D.nr(this.address());
    }

    public float g() {
        return AIColor3D.ng(this.address());
    }

    public float b() {
        return AIColor3D.nb(this.address());
    }

    public static AIColor3D create(long address) {
        return AIColor3D.wrap(AIColor3D.class, address);
    }

    @Nullable
    public static AIColor3D createSafe(long address) {
        return address == 0L ? null : AIColor3D.wrap(AIColor3D.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return AIColor3D.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIColor3D.wrap(Buffer.class, address, capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    static {
        Struct.Layout layout = AIColor3D.__struct(AIColor3D.__member(4), AIColor3D.__member(4), AIColor3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIColor3D, Buffer> {
        private static final AIColor3D ELEMENT_FACTORY = AIColor3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIColor3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return AIColor3D.nr(this.address());
        }

        public float g() {
            return AIColor3D.ng(this.address());
        }

        public float b() {
            return AIColor3D.nb(this.address());
        }
    }
}

