/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiExportFormatDesc")
public class AIExportFormatDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int DESCRIPTION;
    public static final int FILEEXTENSION;

    public AIExportFormatDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIExportFormatDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer id() {
        return AIExportFormatDesc.nid(this.address());
    }

    @NativeType(value="char const *")
    public String idString() {
        return AIExportFormatDesc.nidString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer description() {
        return AIExportFormatDesc.ndescription(this.address());
    }

    @NativeType(value="char const *")
    public String descriptionString() {
        return AIExportFormatDesc.ndescriptionString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer fileExtension() {
        return AIExportFormatDesc.nfileExtension(this.address());
    }

    @NativeType(value="char const *")
    public String fileExtensionString() {
        return AIExportFormatDesc.nfileExtensionString(this.address());
    }

    public AIExportFormatDesc id(@NativeType(value="char const *") ByteBuffer value) {
        AIExportFormatDesc.nid(this.address(), value);
        return this;
    }

    public AIExportFormatDesc description(@NativeType(value="char const *") ByteBuffer value) {
        AIExportFormatDesc.ndescription(this.address(), value);
        return this;
    }

    public AIExportFormatDesc fileExtension(@NativeType(value="char const *") ByteBuffer value) {
        AIExportFormatDesc.nfileExtension(this.address(), value);
        return this;
    }

    public AIExportFormatDesc set(ByteBuffer id, ByteBuffer description, ByteBuffer fileExtension) {
        this.id(id);
        this.description(description);
        this.fileExtension(fileExtension);
        return this;
    }

    public AIExportFormatDesc set(AIExportFormatDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIExportFormatDesc malloc() {
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIExportFormatDesc calloc() {
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIExportFormatDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, MemoryUtil.memAddress(container), container);
    }

    public static AIExportFormatDesc create(long address) {
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, address);
    }

    @Nullable
    public static AIExportFormatDesc createSafe(long address) {
        return address == 0L ? null : AIExportFormatDesc.wrap(AIExportFormatDesc.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIExportFormatDesc.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIExportFormatDesc.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIExportFormatDesc.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIExportFormatDesc.__create(capacity, SIZEOF);
        return AIExportFormatDesc.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIExportFormatDesc.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIExportFormatDesc.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIExportFormatDesc mallocStack() {
        return AIExportFormatDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIExportFormatDesc callocStack() {
        return AIExportFormatDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIExportFormatDesc mallocStack(MemoryStack stack) {
        return AIExportFormatDesc.malloc(stack);
    }

    @Deprecated
    public static AIExportFormatDesc callocStack(MemoryStack stack) {
        return AIExportFormatDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIExportFormatDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIExportFormatDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.calloc(capacity, stack);
    }

    public static AIExportFormatDesc malloc(MemoryStack stack) {
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIExportFormatDesc calloc(MemoryStack stack) {
        return AIExportFormatDesc.wrap(AIExportFormatDesc.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nid(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)ID));
    }

    public static String nidString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)ID));
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static ByteBuffer nfileExtension(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    public static String nfileExtensionString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    public static void nid(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)ID, MemoryUtil.memAddress(value));
    }

    public static void ndescription(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)DESCRIPTION, MemoryUtil.memAddress(value));
    }

    public static void nfileExtension(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)FILEEXTENSION, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ID));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    static {
        Struct.Layout layout = AIExportFormatDesc.__struct(AIExportFormatDesc.__member(POINTER_SIZE), AIExportFormatDesc.__member(POINTER_SIZE), AIExportFormatDesc.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        DESCRIPTION = layout.offsetof(1);
        FILEEXTENSION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIExportFormatDesc, Buffer>
    implements NativeResource {
        private static final AIExportFormatDesc ELEMENT_FACTORY = AIExportFormatDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIExportFormatDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer id() {
            return AIExportFormatDesc.nid(this.address());
        }

        @NativeType(value="char const *")
        public String idString() {
            return AIExportFormatDesc.nidString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer description() {
            return AIExportFormatDesc.ndescription(this.address());
        }

        @NativeType(value="char const *")
        public String descriptionString() {
            return AIExportFormatDesc.ndescriptionString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer fileExtension() {
            return AIExportFormatDesc.nfileExtension(this.address());
        }

        @NativeType(value="char const *")
        public String fileExtensionString() {
            return AIExportFormatDesc.nfileExtensionString(this.address());
        }

        public Buffer id(@NativeType(value="char const *") ByteBuffer value) {
            AIExportFormatDesc.nid(this.address(), value);
            return this;
        }

        public Buffer description(@NativeType(value="char const *") ByteBuffer value) {
            AIExportFormatDesc.ndescription(this.address(), value);
            return this;
        }

        public Buffer fileExtension(@NativeType(value="char const *") ByteBuffer value) {
            AIExportFormatDesc.nfileExtension(this.address(), value);
            return this;
        }
    }
}

