/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFileFlushProc;
import org.lwjgl.assimp.AIFileFlushProcI;
import org.lwjgl.assimp.AIFileReadProc;
import org.lwjgl.assimp.AIFileReadProcI;
import org.lwjgl.assimp.AIFileSeek;
import org.lwjgl.assimp.AIFileSeekI;
import org.lwjgl.assimp.AIFileTellProc;
import org.lwjgl.assimp.AIFileTellProcI;
import org.lwjgl.assimp.AIFileWriteProc;
import org.lwjgl.assimp.AIFileWriteProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFile")
public class AIFile
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READPROC;
    public static final int WRITEPROC;
    public static final int TELLPROC;
    public static final int FILESIZEPROC;
    public static final int SEEKPROC;
    public static final int FLUSHPROC;
    public static final int USERDATA;

    public AIFile(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIFile.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiFileReadProc")
    public AIFileReadProc ReadProc() {
        return AIFile.nReadProc(this.address());
    }

    @NativeType(value="aiFileWriteProc")
    public AIFileWriteProc WriteProc() {
        return AIFile.nWriteProc(this.address());
    }

    @NativeType(value="aiFileTellProc")
    public AIFileTellProc TellProc() {
        return AIFile.nTellProc(this.address());
    }

    @NativeType(value="aiFileTellProc")
    public AIFileTellProc FileSizeProc() {
        return AIFile.nFileSizeProc(this.address());
    }

    @NativeType(value="aiFileSeek")
    public AIFileSeek SeekProc() {
        return AIFile.nSeekProc(this.address());
    }

    @NativeType(value="aiFileFlushProc")
    public AIFileFlushProc FlushProc() {
        return AIFile.nFlushProc(this.address());
    }

    @NativeType(value="aiUserData")
    public long UserData() {
        return AIFile.nUserData(this.address());
    }

    public AIFile ReadProc(@NativeType(value="aiFileReadProc") AIFileReadProcI value) {
        AIFile.nReadProc(this.address(), value);
        return this;
    }

    public AIFile WriteProc(@NativeType(value="aiFileWriteProc") AIFileWriteProcI value) {
        AIFile.nWriteProc(this.address(), value);
        return this;
    }

    public AIFile TellProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
        AIFile.nTellProc(this.address(), value);
        return this;
    }

    public AIFile FileSizeProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
        AIFile.nFileSizeProc(this.address(), value);
        return this;
    }

    public AIFile SeekProc(@NativeType(value="aiFileSeek") AIFileSeekI value) {
        AIFile.nSeekProc(this.address(), value);
        return this;
    }

    public AIFile FlushProc(@NativeType(value="aiFileFlushProc") AIFileFlushProcI value) {
        AIFile.nFlushProc(this.address(), value);
        return this;
    }

    public AIFile UserData(@NativeType(value="aiUserData") long value) {
        AIFile.nUserData(this.address(), value);
        return this;
    }

    public AIFile set(AIFileReadProcI ReadProc, AIFileWriteProcI WriteProc, AIFileTellProcI TellProc, AIFileTellProcI FileSizeProc, AIFileSeekI SeekProc, AIFileFlushProcI FlushProc, long UserData) {
        this.ReadProc(ReadProc);
        this.WriteProc(WriteProc);
        this.TellProc(TellProc);
        this.FileSizeProc(FileSizeProc);
        this.SeekProc(SeekProc);
        this.FlushProc(FlushProc);
        this.UserData(UserData);
        return this;
    }

    public AIFile set(AIFile src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIFile malloc() {
        return AIFile.wrap(AIFile.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIFile calloc() {
        return AIFile.wrap(AIFile.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIFile create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIFile.wrap(AIFile.class, MemoryUtil.memAddress(container), container);
    }

    public static AIFile create(long address) {
        return AIFile.wrap(AIFile.class, address);
    }

    @Nullable
    public static AIFile createSafe(long address) {
        return address == 0L ? null : AIFile.wrap(AIFile.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIFile.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIFile.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIFile.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIFile.__create(capacity, SIZEOF);
        return AIFile.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIFile.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIFile.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIFile mallocStack() {
        return AIFile.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFile callocStack() {
        return AIFile.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFile mallocStack(MemoryStack stack) {
        return AIFile.malloc(stack);
    }

    @Deprecated
    public static AIFile callocStack(MemoryStack stack) {
        return AIFile.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIFile.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIFile.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFile.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFile.calloc(capacity, stack);
    }

    public static AIFile malloc(MemoryStack stack) {
        return AIFile.wrap(AIFile.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFile calloc(MemoryStack stack) {
        return AIFile.wrap(AIFile.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIFile.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIFile.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIFileReadProc nReadProc(long struct) {
        return AIFileReadProc.create(MemoryUtil.memGetAddress(struct + (long)READPROC));
    }

    public static AIFileWriteProc nWriteProc(long struct) {
        return AIFileWriteProc.create(MemoryUtil.memGetAddress(struct + (long)WRITEPROC));
    }

    public static AIFileTellProc nTellProc(long struct) {
        return AIFileTellProc.create(MemoryUtil.memGetAddress(struct + (long)TELLPROC));
    }

    public static AIFileTellProc nFileSizeProc(long struct) {
        return AIFileTellProc.create(MemoryUtil.memGetAddress(struct + (long)FILESIZEPROC));
    }

    public static AIFileSeek nSeekProc(long struct) {
        return AIFileSeek.create(MemoryUtil.memGetAddress(struct + (long)SEEKPROC));
    }

    public static AIFileFlushProc nFlushProc(long struct) {
        return AIFileFlushProc.create(MemoryUtil.memGetAddress(struct + (long)FLUSHPROC));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static void nReadProc(long struct, AIFileReadProcI value) {
        MemoryUtil.memPutAddress(struct + (long)READPROC, value.address());
    }

    public static void nWriteProc(long struct, AIFileWriteProcI value) {
        MemoryUtil.memPutAddress(struct + (long)WRITEPROC, value.address());
    }

    public static void nTellProc(long struct, AIFileTellProcI value) {
        MemoryUtil.memPutAddress(struct + (long)TELLPROC, value.address());
    }

    public static void nFileSizeProc(long struct, AIFileTellProcI value) {
        MemoryUtil.memPutAddress(struct + (long)FILESIZEPROC, value.address());
    }

    public static void nSeekProc(long struct, AIFileSeekI value) {
        MemoryUtil.memPutAddress(struct + (long)SEEKPROC, value.address());
    }

    public static void nFlushProc(long struct, AIFileFlushProcI value) {
        MemoryUtil.memPutAddress(struct + (long)FLUSHPROC, value.address());
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)READPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)WRITEPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TELLPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILESIZEPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SEEKPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FLUSHPROC));
    }

    static {
        Struct.Layout layout = AIFile.__struct(AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE), AIFile.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        READPROC = layout.offsetof(0);
        WRITEPROC = layout.offsetof(1);
        TELLPROC = layout.offsetof(2);
        FILESIZEPROC = layout.offsetof(3);
        SEEKPROC = layout.offsetof(4);
        FLUSHPROC = layout.offsetof(5);
        USERDATA = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<AIFile, Buffer>
    implements NativeResource {
        private static final AIFile ELEMENT_FACTORY = AIFile.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIFile getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiFileReadProc")
        public AIFileReadProc ReadProc() {
            return AIFile.nReadProc(this.address());
        }

        @NativeType(value="aiFileWriteProc")
        public AIFileWriteProc WriteProc() {
            return AIFile.nWriteProc(this.address());
        }

        @NativeType(value="aiFileTellProc")
        public AIFileTellProc TellProc() {
            return AIFile.nTellProc(this.address());
        }

        @NativeType(value="aiFileTellProc")
        public AIFileTellProc FileSizeProc() {
            return AIFile.nFileSizeProc(this.address());
        }

        @NativeType(value="aiFileSeek")
        public AIFileSeek SeekProc() {
            return AIFile.nSeekProc(this.address());
        }

        @NativeType(value="aiFileFlushProc")
        public AIFileFlushProc FlushProc() {
            return AIFile.nFlushProc(this.address());
        }

        @NativeType(value="aiUserData")
        public long UserData() {
            return AIFile.nUserData(this.address());
        }

        public Buffer ReadProc(@NativeType(value="aiFileReadProc") AIFileReadProcI value) {
            AIFile.nReadProc(this.address(), value);
            return this;
        }

        public Buffer WriteProc(@NativeType(value="aiFileWriteProc") AIFileWriteProcI value) {
            AIFile.nWriteProc(this.address(), value);
            return this;
        }

        public Buffer TellProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
            AIFile.nTellProc(this.address(), value);
            return this;
        }

        public Buffer FileSizeProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
            AIFile.nFileSizeProc(this.address(), value);
            return this;
        }

        public Buffer SeekProc(@NativeType(value="aiFileSeek") AIFileSeekI value) {
            AIFile.nSeekProc(this.address(), value);
            return this;
        }

        public Buffer FlushProc(@NativeType(value="aiFileFlushProc") AIFileFlushProcI value) {
            AIFile.nFlushProc(this.address(), value);
            return this;
        }

        public Buffer UserData(@NativeType(value="aiUserData") long value) {
            AIFile.nUserData(this.address(), value);
            return this;
        }
    }
}

