/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMaterial")
public class AIMaterial
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPROPERTIES;
    public static final int MNUMPROPERTIES;
    public static final int MNUMALLOCATED;

    public AIMaterial(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMaterial.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiMaterialProperty **")
    public PointerBuffer mProperties() {
        return AIMaterial.nmProperties(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumProperties() {
        return AIMaterial.nmNumProperties(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumAllocated() {
        return AIMaterial.nmNumAllocated(this.address());
    }

    public AIMaterial mProperties(@NativeType(value="struct aiMaterialProperty **") PointerBuffer value) {
        AIMaterial.nmProperties(this.address(), value);
        return this;
    }

    public AIMaterial mNumAllocated(@NativeType(value="unsigned int") int value) {
        AIMaterial.nmNumAllocated(this.address(), value);
        return this;
    }

    public AIMaterial set(PointerBuffer mProperties, int mNumAllocated) {
        this.mProperties(mProperties);
        this.mNumAllocated(mNumAllocated);
        return this;
    }

    public AIMaterial set(AIMaterial src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMaterial malloc() {
        return AIMaterial.wrap(AIMaterial.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMaterial calloc() {
        return AIMaterial.wrap(AIMaterial.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMaterial create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIMaterial.wrap(AIMaterial.class, MemoryUtil.memAddress(container), container);
    }

    public static AIMaterial create(long address) {
        return AIMaterial.wrap(AIMaterial.class, address);
    }

    @Nullable
    public static AIMaterial createSafe(long address) {
        return address == 0L ? null : AIMaterial.wrap(AIMaterial.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIMaterial.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIMaterial.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMaterial.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMaterial.__create(capacity, SIZEOF);
        return AIMaterial.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIMaterial.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMaterial.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIMaterial mallocStack() {
        return AIMaterial.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMaterial callocStack() {
        return AIMaterial.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMaterial mallocStack(MemoryStack stack) {
        return AIMaterial.malloc(stack);
    }

    @Deprecated
    public static AIMaterial callocStack(MemoryStack stack) {
        return AIMaterial.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMaterial.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMaterial.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMaterial.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMaterial.calloc(capacity, stack);
    }

    public static AIMaterial malloc(MemoryStack stack) {
        return AIMaterial.wrap(AIMaterial.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMaterial calloc(MemoryStack stack) {
        return AIMaterial.wrap(AIMaterial.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIMaterial.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIMaterial.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nmProperties(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MPROPERTIES), AIMaterial.nmNumProperties(struct));
    }

    public static int nmNumProperties(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMPROPERTIES);
    }

    public static int nmNumAllocated(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMALLOCATED);
    }

    public static void nmProperties(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MPROPERTIES, MemoryUtil.memAddress(value));
        AIMaterial.nmNumProperties(struct, value.remaining());
    }

    public static void nmNumProperties(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMPROPERTIES, value);
    }

    public static void nmNumAllocated(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMALLOCATED, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MPROPERTIES));
    }

    static {
        Struct.Layout layout = AIMaterial.__struct(AIMaterial.__member(POINTER_SIZE), AIMaterial.__member(4), AIMaterial.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPROPERTIES = layout.offsetof(0);
        MNUMPROPERTIES = layout.offsetof(1);
        MNUMALLOCATED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMaterial, Buffer>
    implements NativeResource {
        private static final AIMaterial ELEMENT_FACTORY = AIMaterial.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMaterial getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiMaterialProperty **")
        public PointerBuffer mProperties() {
            return AIMaterial.nmProperties(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumProperties() {
            return AIMaterial.nmNumProperties(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumAllocated() {
            return AIMaterial.nmNumAllocated(this.address());
        }

        public Buffer mProperties(@NativeType(value="struct aiMaterialProperty **") PointerBuffer value) {
            AIMaterial.nmProperties(this.address(), value);
            return this;
        }

        public Buffer mNumAllocated(@NativeType(value="unsigned int") int value) {
            AIMaterial.nmNumAllocated(this.address(), value);
            return this;
        }
    }
}

