/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiString")
public class AIString
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int DATA;

    public AIString(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIString.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ai_uint32")
    public int length() {
        return AIString.nlength(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public ByteBuffer data() {
        return AIString.ndata(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public String dataString() {
        return AIString.ndataString(this.address());
    }

    public AIString data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
        AIString.ndata(this.address(), value);
        return this;
    }

    public AIString set(AIString src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIString malloc() {
        return AIString.wrap(AIString.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIString calloc() {
        return AIString.wrap(AIString.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIString create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIString.wrap(AIString.class, MemoryUtil.memAddress(container), container);
    }

    public static AIString create(long address) {
        return AIString.wrap(AIString.class, address);
    }

    @Nullable
    public static AIString createSafe(long address) {
        return address == 0L ? null : AIString.wrap(AIString.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIString.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIString.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIString.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIString.__create(capacity, SIZEOF);
        return AIString.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIString.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIString.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIString mallocStack() {
        return AIString.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIString callocStack() {
        return AIString.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIString mallocStack(MemoryStack stack) {
        return AIString.malloc(stack);
    }

    @Deprecated
    public static AIString callocStack(MemoryStack stack) {
        return AIString.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIString.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIString.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIString.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIString.calloc(capacity, stack);
    }

    public static AIString malloc(MemoryStack stack) {
        return AIString.wrap(AIString.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIString calloc(MemoryStack stack) {
        return AIString.wrap(AIString.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIString.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIString.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlength(long struct) {
        return UNSAFE.getInt(null, struct + (long)LENGTH);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, AIString.nlength(struct));
    }

    public static String ndataString(long struct) {
        return MemoryUtil.memUTF8(AIString.ndata(struct));
    }

    public static void nlength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LENGTH, value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 1024);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining());
        AIString.nlength(struct, value.remaining() - 1);
    }

    static {
        Struct.Layout layout = AIString.__struct(AIString.__member(4), AIString.__array(1, 1024));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIString, Buffer>
    implements NativeResource {
        private static final AIString ELEMENT_FACTORY = AIString.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIString getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ai_uint32")
        public int length() {
            return AIString.nlength(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public ByteBuffer data() {
            return AIString.ndata(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public String dataString() {
            return AIString.ndataString(this.address());
        }

        public Buffer data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
            AIString.ndata(this.address(), value);
            return this;
        }
    }
}

