/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVector2D")
public class AIVector2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public AIVector2D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIVector2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return AIVector2D.nx(this.address());
    }

    public float y() {
        return AIVector2D.ny(this.address());
    }

    public static AIVector2D malloc() {
        return AIVector2D.wrap(AIVector2D.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIVector2D calloc() {
        return AIVector2D.wrap(AIVector2D.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIVector2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIVector2D.wrap(AIVector2D.class, MemoryUtil.memAddress(container), container);
    }

    public static AIVector2D create(long address) {
        return AIVector2D.wrap(AIVector2D.class, address);
    }

    @Nullable
    public static AIVector2D createSafe(long address) {
        return address == 0L ? null : AIVector2D.wrap(AIVector2D.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIVector2D.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIVector2D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVector2D.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVector2D.__create(capacity, SIZEOF);
        return AIVector2D.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIVector2D.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIVector2D.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIVector2D mallocStack() {
        return AIVector2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVector2D callocStack() {
        return AIVector2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVector2D mallocStack(MemoryStack stack) {
        return AIVector2D.malloc(stack);
    }

    @Deprecated
    public static AIVector2D callocStack(MemoryStack stack) {
        return AIVector2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIVector2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIVector2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVector2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVector2D.calloc(capacity, stack);
    }

    public static AIVector2D malloc(MemoryStack stack) {
        return AIVector2D.wrap(AIVector2D.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVector2D calloc(MemoryStack stack) {
        return AIVector2D.wrap(AIVector2D.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIVector2D.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIVector2D.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    static {
        Struct.Layout layout = AIVector2D.__struct(AIVector2D.__member(4), AIVector2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVector2D, Buffer>
    implements NativeResource {
        private static final AIVector2D ELEMENT_FACTORY = AIVector2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIVector2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return AIVector2D.nx(this.address());
        }

        public float y() {
            return AIVector2D.ny(this.address());
        }
    }
}

