/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.bgfx.BGFXAttachment;
import org.lwjgl.bgfx.BGFXCaps;
import org.lwjgl.bgfx.BGFXInit;
import org.lwjgl.bgfx.BGFXInstanceDataBuffer;
import org.lwjgl.bgfx.BGFXMemory;
import org.lwjgl.bgfx.BGFXReleaseFunctionCallbackI;
import org.lwjgl.bgfx.BGFXStats;
import org.lwjgl.bgfx.BGFXTextureInfo;
import org.lwjgl.bgfx.BGFXTransform;
import org.lwjgl.bgfx.BGFXTransientIndexBuffer;
import org.lwjgl.bgfx.BGFXTransientVertexBuffer;
import org.lwjgl.bgfx.BGFXUniformInfo;
import org.lwjgl.bgfx.BGFXVertexLayout;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public class BGFX {
    private static final SharedLibrary BGFX = Library.loadNative(BGFX.class, "org.lwjgl.bgfx", Configuration.BGFX_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("bgfx")), true);
    public static final int BGFX_API_VERSION = 115;
    public static final short BGFX_INVALID_HANDLE = -1;
    public static final long BGFX_STATE_WRITE_R = 1L;
    public static final long BGFX_STATE_WRITE_G = 2L;
    public static final long BGFX_STATE_WRITE_B = 4L;
    public static final long BGFX_STATE_WRITE_A = 8L;
    public static final long BGFX_STATE_WRITE_Z = 0x4000000000L;
    public static final long BGFX_STATE_WRITE_RGB = 7L;
    public static final long BGFX_STATE_WRITE_MASK = 0x400000000FL;
    public static final long BGFX_STATE_DEPTH_TEST_LESS = 16L;
    public static final long BGFX_STATE_DEPTH_TEST_LEQUAL = 32L;
    public static final long BGFX_STATE_DEPTH_TEST_EQUAL = 48L;
    public static final long BGFX_STATE_DEPTH_TEST_GEQUAL = 64L;
    public static final long BGFX_STATE_DEPTH_TEST_GREATER = 80L;
    public static final long BGFX_STATE_DEPTH_TEST_NOTEQUAL = 96L;
    public static final long BGFX_STATE_DEPTH_TEST_NEVER = 112L;
    public static final long BGFX_STATE_DEPTH_TEST_ALWAYS = 128L;
    public static final long BGFX_STATE_BLEND_ZERO = 4096L;
    public static final long BGFX_STATE_BLEND_ONE = 8192L;
    public static final long BGFX_STATE_BLEND_SRC_COLOR = 12288L;
    public static final long BGFX_STATE_BLEND_INV_SRC_COLOR = 16384L;
    public static final long BGFX_STATE_BLEND_SRC_ALPHA = 20480L;
    public static final long BGFX_STATE_BLEND_INV_SRC_ALPHA = 24576L;
    public static final long BGFX_STATE_BLEND_DST_ALPHA = 28672L;
    public static final long BGFX_STATE_BLEND_INV_DST_ALPHA = 32768L;
    public static final long BGFX_STATE_BLEND_DST_COLOR = 36864L;
    public static final long BGFX_STATE_BLEND_INV_DST_COLOR = 40960L;
    public static final long BGFX_STATE_BLEND_SRC_ALPHA_SAT = 45056L;
    public static final long BGFX_STATE_BLEND_FACTOR = 49152L;
    public static final long BGFX_STATE_BLEND_INV_FACTOR = 53248L;
    public static final long BGFX_STATE_BLEND_EQUATION_ADD = 0L;
    public static final long BGFX_STATE_BLEND_EQUATION_SUB = 0x10000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_REVSUB = 0x20000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MIN = 0x30000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MAX = 0x40000000L;
    public static final long BGFX_STATE_CULL_CW = 0x1000000000L;
    public static final long BGFX_STATE_CULL_CCW = 0x2000000000L;
    public static final long BGFX_STATE_PT_TRISTRIP = 0x1000000000000L;
    public static final long BGFX_STATE_PT_LINES = 0x2000000000000L;
    public static final long BGFX_STATE_PT_LINESTRIP = 0x3000000000000L;
    public static final long BGFX_STATE_PT_POINTS = 0x4000000000000L;
    public static final long BGFX_STATE_MSAA = 0x100000000000000L;
    public static final long BGFX_STATE_LINEAA = 0x200000000000000L;
    public static final long BGFX_STATE_CONSERVATIVE_RASTER = 0x400000000000000L;
    public static final long BGFX_STATE_NONE = 0L;
    public static final long BGFX_STATE_FRONT_CCW = 0x8000000000L;
    public static final long BGFX_STATE_BLEND_INDEPENDENT = 0x400000000L;
    public static final long BGFX_STATE_BLEND_ALPHA_TO_COVERAGE = 0x800000000L;
    public static final long BGFX_STATE_DEFAULT = 72057937635311647L;
    public static final long BGFX_STATE_DEPTH_TEST_MASK = 240L;
    public static final long BGFX_STATE_BLEND_MASK = 0xFFFF000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MASK = 0x3F0000000L;
    public static final long BGFX_STATE_CULL_MASK = 0x3000000000L;
    public static final long BGFX_STATE_ALPHA_REF_MASK = 0xFF0000000000L;
    public static final long BGFX_STATE_PT_MASK = 0x7000000000000L;
    public static final long BGFX_STATE_POINT_SIZE_MASK = 0xF0000000000000L;
    public static final long BGFX_STATE_RESERVED_MASK = -2305843009213693952L;
    public static final long BGFX_STATE_MASK = -1L;
    public static final int BGFX_STATE_DEPTH_TEST_SHIFT = 4;
    public static final int BGFX_STATE_BLEND_SHIFT = 12;
    public static final int BGFX_STATE_BLEND_EQUATION_SHIFT = 28;
    public static final int BGFX_STATE_CULL_SHIFT = 36;
    public static final int BGFX_STATE_ALPHA_REF_SHIFT = 40;
    public static final int BGFX_STATE_PT_SHIFT = 48;
    public static final int BGFX_STATE_POINT_SIZE_SHIFT = 52;
    public static final int BGFX_STATE_RESERVED_SHIFT = 61;
    public static final int BGFX_STENCIL_TEST_LESS = 65536;
    public static final int BGFX_STENCIL_TEST_LEQUAL = 131072;
    public static final int BGFX_STENCIL_TEST_EQUAL = 196608;
    public static final int BGFX_STENCIL_TEST_GEQUAL = 262144;
    public static final int BGFX_STENCIL_TEST_GREATER = 327680;
    public static final int BGFX_STENCIL_TEST_NOTEQUAL = 393216;
    public static final int BGFX_STENCIL_TEST_NEVER = 458752;
    public static final int BGFX_STENCIL_TEST_ALWAYS = 524288;
    public static final int BGFX_STENCIL_OP_FAIL_S_ZERO = 0;
    public static final int BGFX_STENCIL_OP_FAIL_S_KEEP = 0x100000;
    public static final int BGFX_STENCIL_OP_FAIL_S_REPLACE = 0x200000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INCR = 0x300000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INCRSAT = 0x400000;
    public static final int BGFX_STENCIL_OP_FAIL_S_DECR = 0x500000;
    public static final int BGFX_STENCIL_OP_FAIL_S_DECRSAT = 0x600000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INVERT = 0x700000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_ZERO = 0;
    public static final int BGFX_STENCIL_OP_FAIL_Z_KEEP = 0x1000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_REPLACE = 0x2000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INCR = 0x3000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INCRSAT = 0x4000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_DECR = 0x5000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_DECRSAT = 0x6000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INVERT = 0x7000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_ZERO = 0;
    public static final int BGFX_STENCIL_OP_PASS_Z_KEEP = 0x10000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_REPLACE = 0x20000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INCR = 0x30000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INCRSAT = 0x40000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_DECR = 0x50000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_DECRSAT = 0x60000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INVERT = 0x70000000;
    public static final int BGFX_STENCIL_NONE = 0;
    public static final int BGFX_STENCIL_DEFAULT = 0;
    public static final int BGFX_STENCIL_FUNC_REF_SHIFT = 0;
    public static final int BGFX_STENCIL_FUNC_REF_MASK = 255;
    public static final int BGFX_STENCIL_FUNC_RMASK_SHIFT = 8;
    public static final int BGFX_STENCIL_FUNC_RMASK_MASK = 65280;
    public static final int BGFX_STENCIL_TEST_SHIFT = 16;
    public static final int BGFX_STENCIL_TEST_MASK = 983040;
    public static final int BGFX_STENCIL_OP_FAIL_S_SHIFT = 20;
    public static final int BGFX_STENCIL_OP_FAIL_S_MASK = 0xF00000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_SHIFT = 24;
    public static final int BGFX_STENCIL_OP_FAIL_Z_MASK = 0xF000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_SHIFT = 28;
    public static final int BGFX_STENCIL_OP_PASS_Z_MASK = -268435456;
    public static final int BGFX_STENCIL_MASK = -1;
    public static final int BGFX_CLEAR_NONE = 0;
    public static final int BGFX_CLEAR_COLOR = 1;
    public static final int BGFX_CLEAR_DEPTH = 2;
    public static final int BGFX_CLEAR_STENCIL = 4;
    public static final int BGFX_CLEAR_DISCARD_COLOR_0 = 8;
    public static final int BGFX_CLEAR_DISCARD_COLOR_1 = 16;
    public static final int BGFX_CLEAR_DISCARD_COLOR_2 = 32;
    public static final int BGFX_CLEAR_DISCARD_COLOR_3 = 64;
    public static final int BGFX_CLEAR_DISCARD_COLOR_4 = 128;
    public static final int BGFX_CLEAR_DISCARD_COLOR_5 = 256;
    public static final int BGFX_CLEAR_DISCARD_COLOR_6 = 512;
    public static final int BGFX_CLEAR_DISCARD_COLOR_7 = 1024;
    public static final int BGFX_CLEAR_DISCARD_DEPTH = 2048;
    public static final int BGFX_CLEAR_DISCARD_STENCIL = 4096;
    public static final int BGFX_CLEAR_DISCARD_COLOR_MASK = 2040;
    public static final int BGFX_CLEAR_DISCARD_MASK = 8184;
    public static final byte BGFX_DISCARD_NONE = 0;
    public static final byte BGFX_DISCARD_BINDINGS = 1;
    public static final byte BGFX_DISCARD_INDEX_BUFFER = 2;
    public static final byte BGFX_DISCARD_INSTANCE_DATA = 4;
    public static final byte BGFX_DISCARD_STATE = 8;
    public static final byte BGFX_DISCARD_TRANSFORM = 16;
    public static final byte BGFX_DISCARD_VERTEX_STREAMS = 32;
    public static final byte BGFX_DISCARD_ALL = -1;
    public static final int BGFX_DEBUG_NONE = 0;
    public static final int BGFX_DEBUG_WIREFRAME = 1;
    public static final int BGFX_DEBUG_IFH = 2;
    public static final int BGFX_DEBUG_STATS = 4;
    public static final int BGFX_DEBUG_TEXT = 8;
    public static final int BGFX_DEBUG_PROFILER = 16;
    public static final int BGFX_BUFFER_NONE = 0;
    public static final int BGFX_BUFFER_COMPUTE_READ = 256;
    public static final int BGFX_BUFFER_COMPUTE_WRITE = 512;
    public static final int BGFX_BUFFER_DRAW_INDIRECT = 1024;
    public static final int BGFX_BUFFER_ALLOW_RESIZE = 2048;
    public static final int BGFX_BUFFER_INDEX32 = 4096;
    public static final int BGFX_BUFFER_COMPUTE_READ_WRITE = 768;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x1 = 1;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x2 = 2;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x4 = 3;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x1 = 4;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x2 = 5;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x4 = 6;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x1 = 7;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x2 = 8;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x4 = 9;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_SHIFT = 0;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_MASK = 15;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_INT = 16;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_UINT = 32;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_FLOAT = 48;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_SHIFT = 4;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_MASK = 48;
    public static final long BGFX_TEXTURE_NONE = 0L;
    public static final long BGFX_TEXTURE_MSAA_SAMPLE = 0x800000000L;
    public static final long BGFX_TEXTURE_RT = 0x1000000000L;
    public static final long BGFX_TEXTURE_RT_MSAA_X2 = 0x2000000000L;
    public static final long BGFX_TEXTURE_RT_MSAA_X4 = 0x3000000000L;
    public static final long BGFX_TEXTURE_RT_MSAA_X8 = 0x4000000000L;
    public static final long BGFX_TEXTURE_RT_MSAA_X16 = 0x5000000000L;
    public static final long BGFX_TEXTURE_RT_WRITE_ONLY = 0x8000000000L;
    public static final long BGFX_TEXTURE_COMPUTE_WRITE = 0x100000000000L;
    public static final long BGFX_TEXTURE_SRGB = 0x200000000000L;
    public static final long BGFX_TEXTURE_BLIT_DST = 0x400000000000L;
    public static final long BGFX_TEXTURE_READ_BACK = 0x800000000000L;
    public static final int BGFX_TEXTURE_RT_MSAA_SHIFT = 36;
    public static final long BGFX_TEXTURE_RT_MSAA_MASK = 0x7000000000L;
    public static final long BGFX_TEXTURE_RT_MASK = 0xF000000000L;
    public static final int BGFX_SAMPLER_NONE = 0;
    public static final int BGFX_SAMPLER_U_MIRROR = 1;
    public static final int BGFX_SAMPLER_U_CLAMP = 2;
    public static final int BGFX_SAMPLER_U_BORDER = 3;
    public static final int BGFX_SAMPLER_V_MIRROR = 4;
    public static final int BGFX_SAMPLER_V_CLAMP = 8;
    public static final int BGFX_SAMPLER_V_BORDER = 12;
    public static final int BGFX_SAMPLER_W_MIRROR = 16;
    public static final int BGFX_SAMPLER_W_CLAMP = 32;
    public static final int BGFX_SAMPLER_W_BORDER = 48;
    public static final int BGFX_SAMPLER_UVW_MIRROR = 21;
    public static final int BGFX_SAMPLER_UVW_CLAMP = 42;
    public static final int BGFX_SAMPLER_UVW_BORDER = 63;
    public static final int BGFX_SAMPLER_MIN_POINT = 64;
    public static final int BGFX_SAMPLER_MIN_ANISOTROPIC = 128;
    public static final int BGFX_SAMPLER_MAG_POINT = 256;
    public static final int BGFX_SAMPLER_MAG_ANISOTROPIC = 512;
    public static final int BGFX_SAMPLER_MIP_POINT = 1024;
    public static final int BGFX_SAMPLER_POINT = 1344;
    public static final int BGFX_SAMPLER_COMPARE_LESS = 65536;
    public static final int BGFX_SAMPLER_COMPARE_LEQUAL = 131072;
    public static final int BGFX_SAMPLER_COMPARE_EQUAL = 196608;
    public static final int BGFX_SAMPLER_COMPARE_GEQUAL = 262144;
    public static final int BGFX_SAMPLER_COMPARE_GREATER = 327680;
    public static final int BGFX_SAMPLER_COMPARE_NOTEQUAL = 393216;
    public static final int BGFX_SAMPLER_COMPARE_NEVER = 458752;
    public static final int BGFX_SAMPLER_COMPARE_ALWAYS = 524288;
    public static final int BGFX_SAMPLER_SAMPLE_STENCIL = 0x100000;
    public static final int BGFX_SAMPLER_U_SHIFT = 0;
    public static final int BGFX_SAMPLER_U_MASK = 3;
    public static final int BGFX_SAMPLER_V_SHIFT = 2;
    public static final int BGFX_SAMPLER_V_MASK = 12;
    public static final int BGFX_SAMPLER_W_SHIFT = 4;
    public static final int BGFX_SAMPLER_W_MASK = 48;
    public static final int BGFX_SAMPLER_MIN_SHIFT = 6;
    public static final int BGFX_SAMPLER_MIN_MASK = 192;
    public static final int BGFX_SAMPLER_MAG_SHIFT = 8;
    public static final int BGFX_SAMPLER_MAG_MASK = 768;
    public static final int BGFX_SAMPLER_MIP_SHIFT = 10;
    public static final int BGFX_SAMPLER_MIP_MASK = 1024;
    public static final int BGFX_SAMPLER_COMPARE_SHIFT = 16;
    public static final int BGFX_SAMPLER_COMPARE_MASK = 983040;
    public static final int BGFX_SAMPLER_BORDER_COLOR_SHIFT = 24;
    public static final int BGFX_SAMPLER_BORDER_COLOR_MASK = 0xF000000;
    public static final int BGFX_SAMPLER_RESERVED_SHIFT = 28;
    public static final int BGFX_SAMPLER_RESERVED_MASK = -268435456;
    public static final int BGFX_SAMPLER_SAMPLER_BITS_MASK = 985087;
    public static final int BGFX_RESET_NONE = 0;
    public static final int BGFX_RESET_FULLSCREEN = 1;
    public static final int BGFX_RESET_FULLSCREEN_SHIFT = 0;
    public static final int BGFX_RESET_FULLSCREEN_MASK = 1;
    public static final int BGFX_RESET_MSAA_X2 = 16;
    public static final int BGFX_RESET_MSAA_X4 = 32;
    public static final int BGFX_RESET_MSAA_X8 = 48;
    public static final int BGFX_RESET_MSAA_X16 = 64;
    public static final int BGFX_RESET_MSAA_SHIFT = 4;
    public static final int BGFX_RESET_MSAA_MASK = 112;
    public static final int BGFX_RESET_VSYNC = 128;
    public static final int BGFX_RESET_MAXANISOTROPY = 256;
    public static final int BGFX_RESET_CAPTURE = 512;
    public static final int BGFX_RESET_FLUSH_AFTER_RENDER = 8192;
    public static final int BGFX_RESET_FLIP_AFTER_RENDER = 16384;
    public static final int BGFX_RESET_SRGB_BACKBUFFER = 32768;
    public static final int BGFX_RESET_HDR10 = 65536;
    public static final int BGFX_RESET_HIDPI = 131072;
    public static final int BGFX_RESET_DEPTH_CLAMP = 262144;
    public static final int BGFX_RESET_SUSPEND = 524288;
    public static final int BGFX_RESET_RESERVED_SHIFT = 31;
    public static final int BGFX_RESET_RESERVED_MASK = Integer.MIN_VALUE;
    public static final long BGFX_CAPS_ALPHA_TO_COVERAGE = 1L;
    public static final long BGFX_CAPS_BLEND_INDEPENDENT = 2L;
    public static final long BGFX_CAPS_COMPUTE = 4L;
    public static final long BGFX_CAPS_CONSERVATIVE_RASTER = 8L;
    public static final long BGFX_CAPS_DRAW_INDIRECT = 16L;
    public static final long BGFX_CAPS_FRAGMENT_DEPTH = 32L;
    public static final long BGFX_CAPS_FRAGMENT_ORDERING = 64L;
    public static final long BGFX_CAPS_GRAPHICS_DEBUGGER = 128L;
    public static final long BGFX_CAPS_HDR10 = 256L;
    public static final long BGFX_CAPS_HIDPI = 512L;
    public static final long BGFX_CAPS_IMAGE_RW = 1024L;
    public static final long BGFX_CAPS_INDEX32 = 2048L;
    public static final long BGFX_CAPS_INSTANCING = 4096L;
    public static final long BGFX_CAPS_OCCLUSION_QUERY = 8192L;
    public static final long BGFX_CAPS_RENDERER_MULTITHREADED = 16384L;
    public static final long BGFX_CAPS_SWAP_CHAIN = 32768L;
    public static final long BGFX_CAPS_TEXTURE_2D_ARRAY = 65536L;
    public static final long BGFX_CAPS_TEXTURE_3D = 131072L;
    public static final long BGFX_CAPS_TEXTURE_BLIT = 262144L;
    public static final long BGFX_CAPS_TEXTURE_COMPARE_RESERVED = 524288L;
    public static final long BGFX_CAPS_TEXTURE_COMPARE_LEQUAL = 0x100000L;
    public static final long BGFX_CAPS_TEXTURE_COMPARE_ALL = 0x180000L;
    public static final long BGFX_CAPS_TEXTURE_CUBE_ARRAY = 0x200000L;
    public static final long BGFX_CAPS_TEXTURE_DIRECT_ACCESS = 0x400000L;
    public static final long BGFX_CAPS_TEXTURE_READ_BACK = 0x800000L;
    public static final long BGFX_CAPS_VERTEX_ATTRIB_HALF = 0x1000000L;
    public static final long BGFX_CAPS_VERTEX_ATTRIB_UINT10 = 0x2000000L;
    public static final long BGFX_CAPS_VERTEX_ID = 0x4000000L;
    public static final long BGFX_CAPS_VIEWPORT_LAYER_ARRAY = 0x8000000L;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_NONE = 0;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_2D = 1;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_2D_SRGB = 2;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_2D_EMULATED = 4;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_3D = 8;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_3D_SRGB = 16;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_3D_EMULATED = 32;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_CUBE = 64;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_CUBE_SRGB = 128;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_CUBE_EMULATED = 256;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_VERTEX = 512;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_IMAGE_READ = 1024;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_IMAGE_WRITE = 2048;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER = 4096;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER_MSAA = 8192;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_MSAA = 16384;
    public static final int BGFX_CAPS_FORMAT_TEXTURE_MIP_AUTOGEN = 32768;
    public static final byte BGFX_RESOLVE_NONE = 0;
    public static final byte BGFX_RESOLVE_AUTO_GEN_MIPS = 1;
    public static final short BGFX_PCI_ID_NONE = 0;
    public static final short BGFX_PCI_ID_SOFTWARE_RASTERIZER = 1;
    public static final short BGFX_PCI_ID_AMD = 4098;
    public static final short BGFX_PCI_ID_APPLE = 4203;
    public static final short BGFX_PCI_ID_INTEL = -32634;
    public static final short BGFX_PCI_ID_NVIDIA = 4318;
    public static final short BGFX_PCI_ID_MICROSOFT = 5140;
    public static final byte BGFX_CUBE_MAP_POSITIVE_X = 0;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_X = 1;
    public static final byte BGFX_CUBE_MAP_POSITIVE_Y = 2;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_Y = 3;
    public static final byte BGFX_CUBE_MAP_POSITIVE_Z = 4;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_Z = 5;
    public static final int BGFX_FATAL_DEBUG_CHECK = 0;
    public static final int BGFX_FATAL_INVALID_SHADER = 1;
    public static final int BGFX_FATAL_UNABLE_TO_INITIALIZE = 2;
    public static final int BGFX_FATAL_UNABLE_TO_CREATE_TEXTURE = 3;
    public static final int BGFX_FATAL_DEVICE_LOST = 4;
    public static final int BGFX_FATAL_COUNT = 5;
    public static final int BGFX_RENDERER_TYPE_NOOP = 0;
    public static final int BGFX_RENDERER_TYPE_AGC = 1;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D9 = 2;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D11 = 3;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D12 = 4;
    public static final int BGFX_RENDERER_TYPE_GNM = 5;
    public static final int BGFX_RENDERER_TYPE_METAL = 6;
    public static final int BGFX_RENDERER_TYPE_NVN = 7;
    public static final int BGFX_RENDERER_TYPE_OPENGLES = 8;
    public static final int BGFX_RENDERER_TYPE_OPENGL = 9;
    public static final int BGFX_RENDERER_TYPE_VULKAN = 10;
    public static final int BGFX_BGFX_RENDERER_TYPE_WEBGPU = 11;
    public static final int BGFX_RENDERER_TYPE_COUNT = 12;
    public static final int BGFX_ACCESS_READ = 0;
    public static final int BGFX_ACCESS_WRITE = 1;
    public static final int BGFX_ACCESS_READWRITE = 2;
    public static final int BGFX_ACCESS_COUNT = 3;
    public static final int BGFX_ATTRIB_POSITION = 0;
    public static final int BGFX_ATTRIB_NORMAL = 1;
    public static final int BGFX_ATTRIB_TANGENT = 2;
    public static final int BGFX_ATTRIB_BITANGENT = 3;
    public static final int BGFX_ATTRIB_COLOR0 = 4;
    public static final int BGFX_ATTRIB_COLOR1 = 5;
    public static final int BGFX_ATTRIB_COLOR2 = 6;
    public static final int BGFX_ATTRIB_COLOR3 = 7;
    public static final int BGFX_ATTRIB_INDICES = 8;
    public static final int BGFX_ATTRIB_WEIGHT = 9;
    public static final int BGFX_ATTRIB_TEXCOORD0 = 10;
    public static final int BGFX_ATTRIB_TEXCOORD1 = 11;
    public static final int BGFX_ATTRIB_TEXCOORD2 = 12;
    public static final int BGFX_ATTRIB_TEXCOORD3 = 13;
    public static final int BGFX_ATTRIB_TEXCOORD4 = 14;
    public static final int BGFX_ATTRIB_TEXCOORD5 = 15;
    public static final int BGFX_ATTRIB_TEXCOORD6 = 16;
    public static final int BGFX_ATTRIB_TEXCOORD7 = 17;
    public static final int BGFX_ATTRIB_COUNT = 18;
    public static final int BGFX_ATTRIB_TYPE_UINT8 = 0;
    public static final int BGFX_ATTRIB_TYPE_UINT10 = 1;
    public static final int BGFX_ATTRIB_TYPE_INT16 = 2;
    public static final int BGFX_ATTRIB_TYPE_HALF = 3;
    public static final int BGFX_ATTRIB_TYPE_FLOAT = 4;
    public static final int BGFX_ATTRIB_TYPE_COUNT = 5;
    public static final int BGFX_TEXTURE_FORMAT_BC1 = 0;
    public static final int BGFX_TEXTURE_FORMAT_BC2 = 1;
    public static final int BGFX_TEXTURE_FORMAT_BC3 = 2;
    public static final int BGFX_TEXTURE_FORMAT_BC4 = 3;
    public static final int BGFX_TEXTURE_FORMAT_BC5 = 4;
    public static final int BGFX_TEXTURE_FORMAT_BC6H = 5;
    public static final int BGFX_TEXTURE_FORMAT_BC7 = 6;
    public static final int BGFX_TEXTURE_FORMAT_ETC1 = 7;
    public static final int BGFX_TEXTURE_FORMAT_ETC2 = 8;
    public static final int BGFX_TEXTURE_FORMAT_ETC2A = 9;
    public static final int BGFX_TEXTURE_FORMAT_ETC2A1 = 10;
    public static final int BGFX_TEXTURE_FORMAT_PTC12 = 11;
    public static final int BGFX_TEXTURE_FORMAT_PTC14 = 12;
    public static final int BGFX_TEXTURE_FORMAT_PTC12A = 13;
    public static final int BGFX_TEXTURE_FORMAT_PTC14A = 14;
    public static final int BGFX_TEXTURE_FORMAT_PTC22 = 15;
    public static final int BGFX_TEXTURE_FORMAT_PTC24 = 16;
    public static final int BGFX_TEXTURE_FORMAT_ATC = 17;
    public static final int BGFX_TEXTURE_FORMAT_ATCE = 18;
    public static final int BGFX_TEXTURE_FORMAT_ATCI = 19;
    public static final int BGFX_TEXTURE_FORMAT_ASTC4x4 = 20;
    public static final int BGFX_TEXTURE_FORMAT_ASTC5x5 = 21;
    public static final int BGFX_TEXTURE_FORMAT_ASTC6x6 = 22;
    public static final int BGFX_TEXTURE_FORMAT_ASTC8x5 = 23;
    public static final int BGFX_TEXTURE_FORMAT_ASTC8x6 = 24;
    public static final int BGFX_TEXTURE_FORMAT_ASTC10x5 = 25;
    public static final int BGFX_TEXTURE_FORMAT_UNKNOWN = 26;
    public static final int BGFX_TEXTURE_FORMAT_R1 = 27;
    public static final int BGFX_TEXTURE_FORMAT_A8 = 28;
    public static final int BGFX_TEXTURE_FORMAT_R8 = 29;
    public static final int BGFX_TEXTURE_FORMAT_R8I = 30;
    public static final int BGFX_TEXTURE_FORMAT_R8U = 31;
    public static final int BGFX_TEXTURE_FORMAT_R8S = 32;
    public static final int BGFX_TEXTURE_FORMAT_R16 = 33;
    public static final int BGFX_TEXTURE_FORMAT_R16I = 34;
    public static final int BGFX_TEXTURE_FORMAT_R16U = 35;
    public static final int BGFX_TEXTURE_FORMAT_R16F = 36;
    public static final int BGFX_TEXTURE_FORMAT_R16S = 37;
    public static final int BGFX_TEXTURE_FORMAT_R32I = 38;
    public static final int BGFX_TEXTURE_FORMAT_R32U = 39;
    public static final int BGFX_TEXTURE_FORMAT_R32F = 40;
    public static final int BGFX_TEXTURE_FORMAT_RG8 = 41;
    public static final int BGFX_TEXTURE_FORMAT_RG8I = 42;
    public static final int BGFX_TEXTURE_FORMAT_RG8U = 43;
    public static final int BGFX_TEXTURE_FORMAT_RG8S = 44;
    public static final int BGFX_TEXTURE_FORMAT_RG16 = 45;
    public static final int BGFX_TEXTURE_FORMAT_RG16I = 46;
    public static final int BGFX_TEXTURE_FORMAT_RG16U = 47;
    public static final int BGFX_TEXTURE_FORMAT_RG16F = 48;
    public static final int BGFX_TEXTURE_FORMAT_RG16S = 49;
    public static final int BGFX_TEXTURE_FORMAT_RG32I = 50;
    public static final int BGFX_TEXTURE_FORMAT_RG32U = 51;
    public static final int BGFX_TEXTURE_FORMAT_RG32F = 52;
    public static final int BGFX_TEXTURE_FORMAT_RGB8 = 53;
    public static final int BGFX_TEXTURE_FORMAT_RGB8I = 54;
    public static final int BGFX_TEXTURE_FORMAT_RGB8U = 55;
    public static final int BGFX_TEXTURE_FORMAT_RGB8S = 56;
    public static final int BGFX_TEXTURE_FORMAT_RGB9E5F = 57;
    public static final int BGFX_TEXTURE_FORMAT_BGRA8 = 58;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8 = 59;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8I = 60;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8U = 61;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8S = 62;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16 = 63;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16I = 64;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16U = 65;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16F = 66;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16S = 67;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32I = 68;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32U = 69;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32F = 70;
    public static final int BGFX_TEXTURE_FORMAT_R5G6B5 = 71;
    public static final int BGFX_TEXTURE_FORMAT_RGBA4 = 72;
    public static final int BGFX_TEXTURE_FORMAT_RGB5A1 = 73;
    public static final int BGFX_TEXTURE_FORMAT_RGB10A2 = 74;
    public static final int BGFX_TEXTURE_FORMAT_RG11B10F = 75;
    public static final int BGFX_TEXTURE_FORMAT_UNKNOWN_DEPTH = 76;
    public static final int BGFX_TEXTURE_FORMAT_D16 = 77;
    public static final int BGFX_TEXTURE_FORMAT_D24 = 78;
    public static final int BGFX_TEXTURE_FORMAT_D24S8 = 79;
    public static final int BGFX_TEXTURE_FORMAT_D32 = 80;
    public static final int BGFX_TEXTURE_FORMAT_D16F = 81;
    public static final int BGFX_TEXTURE_FORMAT_D24F = 82;
    public static final int BGFX_TEXTURE_FORMAT_D32F = 83;
    public static final int BGFX_TEXTURE_FORMAT_D0S8 = 84;
    public static final int BGFX_TEXTURE_FORMAT_COUNT = 85;
    public static final int BGFX_UNIFORM_TYPE_SAMPLER = 0;
    public static final int BGFX_UNIFORM_TYPE_END = 1;
    public static final int BGFX_UNIFORM_TYPE_VEC4 = 2;
    public static final int BGFX_UNIFORM_TYPE_MAT3 = 3;
    public static final int BGFX_UNIFORM_TYPE_MAT4 = 4;
    public static final int BGFX_UNIFORM_TYPE_COUNT = 5;
    public static final int BGFX_BACKBUFFER_RATIO_EQUAL = 0;
    public static final int BGFX_BACKBUFFER_RATIO_HALF = 1;
    public static final int BGFX_BACKBUFFER_RATIO_QUARTER = 2;
    public static final int BGFX_BACKBUFFER_RATIO_EIGHTH = 3;
    public static final int BGFX_BACKBUFFER_RATIO_SIXTEENTH = 4;
    public static final int BGFX_BACKBUFFER_RATIO_DOUBLE = 5;
    public static final int BGFX_BACKBUFFER_RATIO_COUNT = 6;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_INVISIBLE = 0;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_VISIBLE = 1;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_NORESULT = 2;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_COUNT = 3;
    public static final int BGFX_TOPOLOGY_TRI_LIST = 0;
    public static final int BGFX_TOPOLOGY_TRI_STRIP = 1;
    public static final int BGFX_TOPOLOGY_LINE_LIST = 2;
    public static final int BGFX_TOPOLOGY_LINE_STRIP = 3;
    public static final int BGFX_TOPOLOGY_POINT_LIST = 4;
    public static final int BGFX_TOPOLOGY_COUNT = 5;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_LIST_FLIP_WINDING = 0;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_STRIP_FLIP_WINDING = 1;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_LIST_TO_LINE_LIST = 2;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_STRIP_TO_TRI_LIST = 3;
    public static final int BGFX_TOPOLOGY_CONVERT_LINE_STRIP_TO_LINE_LIST = 4;
    public static final int BGFX_TOPOLOGY_CONVERT_COUNT = 5;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_MIN = 0;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_AVG = 1;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_MAX = 2;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_MIN = 3;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_AVG = 4;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_MAX = 5;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_MIN = 6;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_AVG = 7;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_MAX = 8;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_MIN = 9;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_AVG = 10;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_MAX = 11;
    public static final int BGFX_TOPOLOGY_SORT_COUNT = 12;
    public static final int BGFX_VIEW_MODE_DEFAULT = 0;
    public static final int BGFX_VIEW_MODE_SEQUENTIAL = 1;
    public static final int BGFX_VIEW_MODE_DEPTH_ASCENDING = 2;
    public static final int BGFX_VIEW_MODE_DEPTH_DESCENDING = 3;
    public static final int BGFX_VIEW_MODE_COUNT = 4;
    public static final long BGFX_STATE_BLEND_ADD = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L);
    public static final long BGFX_STATE_BLEND_ALPHA = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(20480L, 24576L);
    public static final long BGFX_STATE_BLEND_DARKEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x30000000L);
    public static final long BGFX_STATE_BLEND_LIGHTEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x40000000L);
    public static final long BGFX_STATE_BLEND_MULTIPLY = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(36864L, 4096L);
    public static final long BGFX_STATE_BLEND_NORMAL = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 24576L);
    public static final long BGFX_STATE_BLEND_SCREEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 16384L);
    public static final long BGFX_STATE_BLEND_LINEAR_BURN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(36864L, 40960L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x10000000L);

    public static SharedLibrary getLibrary() {
        return BGFX;
    }

    protected BGFX() {
        throw new UnsupportedOperationException();
    }

    public static void nbgfx_attachment_init(long _this, short _handle, int _access, short _layer, short _numLayers, short _mip, byte _resolve) {
        long __functionAddress = Functions.attachment_init;
        JNI.invokePV(_this, _handle, _access, _layer, _numLayers, _mip, _resolve, __functionAddress);
    }

    public static void bgfx_attachment_init(@NativeType(value="bgfx_attachment_t *") BGFXAttachment _this, @NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access, @NativeType(value="uint16_t") int _layer, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="uint16_t") int _mip, @NativeType(value="uint8_t") int _resolve) {
        org.lwjgl.bgfx.BGFX.nbgfx_attachment_init(_this.address(), _handle, _access, (short)_layer, (short)_numLayers, (short)_mip, (byte)_resolve);
    }

    public static long nbgfx_vertex_layout_begin(long _this, int _renderer) {
        long __functionAddress = Functions.vertex_layout_begin;
        return JNI.invokePP(_this, _renderer, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_vertex_layout_t *")
    public static BGFXVertexLayout bgfx_vertex_layout_begin(@NativeType(value="bgfx_vertex_layout_t *") BGFXVertexLayout _this, @NativeType(value="bgfx_renderer_type_t") int _renderer) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_begin(_this.address(), _renderer);
        return BGFXVertexLayout.createSafe(__result);
    }

    public static long nbgfx_vertex_layout_add(long _this, int _attrib, byte _num, int _type, boolean _normalized, boolean _asInt) {
        long __functionAddress = Functions.vertex_layout_add;
        return JNI.invokePP(_this, _attrib, _num, _type, _normalized, _asInt, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_vertex_layout_t *")
    public static BGFXVertexLayout bgfx_vertex_layout_add(@NativeType(value="bgfx_vertex_layout_t *") BGFXVertexLayout _this, @NativeType(value="bgfx_attrib_t") int _attrib, @NativeType(value="uint8_t") int _num, @NativeType(value="bgfx_attrib_type_t") int _type, @NativeType(value="bool") boolean _normalized, @NativeType(value="bool") boolean _asInt) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_add(_this.address(), _attrib, (byte)_num, _type, _normalized, _asInt);
        return BGFXVertexLayout.createSafe(__result);
    }

    public static void nbgfx_vertex_layout_decode(long _this, int _attrib, long _num, long _type, long _normalized, long _asInt) {
        long __functionAddress = Functions.vertex_layout_decode;
        JNI.invokePPPPPV(_this, _attrib, _num, _type, _normalized, _asInt, __functionAddress);
    }

    public static void bgfx_vertex_layout_decode(@NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _this, @NativeType(value="bgfx_attrib_t") int _attrib, @NativeType(value="uint8_t *") ByteBuffer _num, @NativeType(value="bgfx_attrib_type_t *") IntBuffer _type, @NativeType(value="bool *") ByteBuffer _normalized, @NativeType(value="bool *") ByteBuffer _asInt) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_num, 1);
            Checks.check((Buffer)_type, 1);
            Checks.check((Buffer)_normalized, 1);
            Checks.check((Buffer)_asInt, 1);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_decode(_this.address(), _attrib, MemoryUtil.memAddress(_num), MemoryUtil.memAddress(_type), MemoryUtil.memAddress(_normalized), MemoryUtil.memAddress(_asInt));
    }

    public static boolean nbgfx_vertex_layout_has(long _this, int _attr) {
        long __functionAddress = Functions.vertex_layout_has;
        return JNI.invokePZ(_this, _attr, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean bgfx_vertex_layout_has(@NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _this, @NativeType(value="bgfx_attrib_t") int _attr) {
        return org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_has(_this.address(), _attr);
    }

    public static long nbgfx_vertex_layout_skip(long _this, byte _num) {
        long __functionAddress = Functions.vertex_layout_skip;
        return JNI.invokePP(_this, _num, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_vertex_layout_t *")
    public static BGFXVertexLayout bgfx_vertex_layout_skip(@NativeType(value="bgfx_vertex_layout_t *") BGFXVertexLayout _this, @NativeType(value="uint8_t") int _num) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_skip(_this.address(), (byte)_num);
        return BGFXVertexLayout.createSafe(__result);
    }

    public static void nbgfx_vertex_layout_end(long _this) {
        long __functionAddress = Functions.vertex_layout_end;
        JNI.invokePV(_this, __functionAddress);
    }

    public static void bgfx_vertex_layout_end(@NativeType(value="bgfx_vertex_layout_t *") BGFXVertexLayout _this) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_layout_end(_this.address());
    }

    public static void nbgfx_vertex_pack(long _input, boolean _inputNormalized, int _attr, long _layout, long _data, int _index) {
        long __functionAddress = Functions.vertex_pack;
        JNI.invokePPPV(_input, _inputNormalized, _attr, _layout, _data, _index, __functionAddress);
    }

    public static void bgfx_vertex_pack(@NativeType(value="float const *") FloatBuffer _input, @NativeType(value="bool") boolean _inputNormalized, @NativeType(value="bgfx_attrib_t") int _attr, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void *") ByteBuffer _data, @NativeType(value="uint32_t") int _index) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_input, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_pack(MemoryUtil.memAddress(_input), _inputNormalized, _attr, _layout.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static void nbgfx_vertex_unpack(long _output, int _attr, long _layout, long _data, int _index) {
        long __functionAddress = Functions.vertex_unpack;
        JNI.invokePPPV(_output, _attr, _layout, _data, _index, __functionAddress);
    }

    public static void bgfx_vertex_unpack(@NativeType(value="float *") FloatBuffer _output, @NativeType(value="bgfx_attrib_t") int _attr, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="uint32_t") int _index) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_output, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_unpack(MemoryUtil.memAddress(_output), _attr, _layout.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static void nbgfx_vertex_convert(long _dstLayout, long _dstData, long _srcLayout, long _srcData, int _num) {
        long __functionAddress = Functions.vertex_convert;
        JNI.invokePPPPV(_dstLayout, _dstData, _srcLayout, _srcData, _num, __functionAddress);
    }

    public static void bgfx_vertex_convert(@NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _dstLayout, @NativeType(value="void *") ByteBuffer _dstData, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _srcLayout, @NativeType(value="void const *") ByteBuffer _srcData, @NativeType(value="uint32_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_convert(_dstLayout.address(), MemoryUtil.memAddress(_dstData), _srcLayout.address(), MemoryUtil.memAddress(_srcData), _num);
    }

    public static int nbgfx_weld_vertices(long _output, long _layout, long _data, int _num, boolean _index32, float _epsilon) {
        long __functionAddress = Functions.weld_vertices;
        return JNI.invokePPPI(_output, _layout, _data, _num, _index32, _epsilon, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_weld_vertices(@NativeType(value="void *") ByteBuffer _output, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bool") boolean _index32, float _epsilon) {
        return org.lwjgl.bgfx.BGFX.nbgfx_weld_vertices(MemoryUtil.memAddress(_output), _layout.address(), MemoryUtil.memAddress(_data), _output.remaining() >> (_index32 ? 2 : 1), _index32, _epsilon);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_weld_vertices(@NativeType(value="void *") ShortBuffer _output, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bool") boolean _index32, float _epsilon) {
        return org.lwjgl.bgfx.BGFX.nbgfx_weld_vertices(MemoryUtil.memAddress(_output), _layout.address(), MemoryUtil.memAddress(_data), (int)((long)_output.remaining() << 1 >> (_index32 ? 2 : 1)), _index32, _epsilon);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_weld_vertices(@NativeType(value="void *") IntBuffer _output, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bool") boolean _index32, float _epsilon) {
        return org.lwjgl.bgfx.BGFX.nbgfx_weld_vertices(MemoryUtil.memAddress(_output), _layout.address(), MemoryUtil.memAddress(_data), (int)((long)_output.remaining() << 2 >> (_index32 ? 2 : 1)), _index32, _epsilon);
    }

    public static int nbgfx_topology_convert(int _conversion, long _dst, int _dstSize, long _indices, int _numIndices, boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(_conversion, _dst, _dstSize, _indices, _numIndices, _index32, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_topology_convert(@NativeType(value="bgfx_topology_convert_t") int _conversion, @Nullable @NativeType(value="void *") ByteBuffer _dst, @NativeType(value="void const *") ByteBuffer _indices, @NativeType(value="bool") boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst), MemoryUtil.memAddress(_indices), _indices.remaining() >> (_index32 ? 2 : 1), _index32);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_topology_convert(@NativeType(value="bgfx_topology_convert_t") int _conversion, @Nullable @NativeType(value="void *") ShortBuffer _dst, @NativeType(value="void const *") ShortBuffer _indices, @NativeType(value="bool") boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst) << 1, MemoryUtil.memAddress(_indices), (int)((long)_indices.remaining() << 1 >> (_index32 ? 2 : 1)), _index32);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_topology_convert(@NativeType(value="bgfx_topology_convert_t") int _conversion, @Nullable @NativeType(value="void *") IntBuffer _dst, @NativeType(value="void const *") IntBuffer _indices, @NativeType(value="bool") boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst) << 2, MemoryUtil.memAddress(_indices), (int)((long)_indices.remaining() << 2 >> (_index32 ? 2 : 1)), _index32);
    }

    public static void nbgfx_topology_sort_tri_list(int _sort, long _dst, int _dstSize, long _dir, long _pos, long _vertices, int _stride, long _indices, int _numIndices, boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        JNI.invokePPPPPV(_sort, _dst, _dstSize, _dir, _pos, _vertices, _stride, _indices, _numIndices, _index32, __functionAddress);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") ByteBuffer _dst, @NativeType(value="float const *") FloatBuffer _dir, @NativeType(value="float const *") FloatBuffer _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") ByteBuffer _indices, @NativeType(value="bool") boolean _index32) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining(), MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _indices.remaining() >> (_index32 ? 2 : 1), _index32);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") ShortBuffer _dst, @NativeType(value="float const *") FloatBuffer _dir, @NativeType(value="float const *") FloatBuffer _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") ShortBuffer _indices, @NativeType(value="bool") boolean _index32) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining() << 1, MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), (int)((long)_indices.remaining() << 1 >> (_index32 ? 2 : 1)), _index32);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") IntBuffer _dst, @NativeType(value="float const *") FloatBuffer _dir, @NativeType(value="float const *") FloatBuffer _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") IntBuffer _indices, @NativeType(value="bool") boolean _index32) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining() << 2, MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), (int)((long)_indices.remaining() << 2 >> (_index32 ? 2 : 1)), _index32);
    }

    public static byte nbgfx_get_supported_renderers(byte _max, long _enum) {
        long __functionAddress = Functions.get_supported_renderers;
        return JNI.invokePB(_max, _enum, __functionAddress);
    }

    @NativeType(value="uint8_t")
    public static byte bgfx_get_supported_renderers(@NativeType(value="bgfx_renderer_type_t *") IntBuffer _enum) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_supported_renderers((byte)_enum.remaining(), MemoryUtil.memAddress(_enum));
    }

    public static long nbgfx_get_renderer_name(int _type) {
        long __functionAddress = Functions.get_renderer_name;
        return JNI.invokeP(_type, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String bgfx_get_renderer_name(@NativeType(value="bgfx_renderer_type_t") int _type) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_renderer_name(_type);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static void nbgfx_init_ctor(long _init) {
        long __functionAddress = Functions.init_ctor;
        JNI.invokePV(_init, __functionAddress);
    }

    public static void bgfx_init_ctor(@NativeType(value="bgfx_init_t *") BGFXInit _init) {
        org.lwjgl.bgfx.BGFX.nbgfx_init_ctor(_init.address());
    }

    public static boolean nbgfx_init(long _init) {
        long __functionAddress = Functions.init;
        if (Checks.CHECKS) {
            BGFXInit.validate(_init);
        }
        return JNI.invokePZ(_init, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean bgfx_init(@NativeType(value="bgfx_init_t const *") BGFXInit _init) {
        return org.lwjgl.bgfx.BGFX.nbgfx_init(_init.address());
    }

    public static void bgfx_shutdown() {
        long __functionAddress = Functions.shutdown;
        JNI.invokeV(__functionAddress);
    }

    public static void bgfx_reset(@NativeType(value="uint32_t") int _width, @NativeType(value="uint32_t") int _height, @NativeType(value="uint32_t") int _flags, @NativeType(value="bgfx_texture_format_t") int _format) {
        long __functionAddress = Functions.reset;
        JNI.invokeV(_width, _height, _flags, _format, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_frame(@NativeType(value="bool") boolean _capture) {
        long __functionAddress = Functions.frame;
        return JNI.invokeI(_capture, __functionAddress);
    }

    @NativeType(value="bgfx_renderer_type_t")
    public static int bgfx_get_renderer_type() {
        long __functionAddress = Functions.get_renderer_type;
        return JNI.invokeI(__functionAddress);
    }

    public static long nbgfx_get_caps() {
        long __functionAddress = Functions.get_caps;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_caps_t const *")
    public static BGFXCaps bgfx_get_caps() {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_caps();
        return BGFXCaps.createSafe(__result);
    }

    public static long nbgfx_get_stats() {
        long __functionAddress = Functions.get_stats;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_stats_t const *")
    public static BGFXStats bgfx_get_stats() {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_stats();
        return BGFXStats.createSafe(__result);
    }

    public static long nbgfx_alloc(int _size) {
        long __functionAddress = Functions.alloc;
        return JNI.invokeP(_size, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_alloc(@NativeType(value="uint32_t") int _size) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_alloc(_size);
        return BGFXMemory.createSafe(__result);
    }

    public static long nbgfx_copy(long _data, int _size) {
        long __functionAddress = Functions.copy;
        return JNI.invokePP(_data, _size, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") ByteBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining());
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") ShortBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 1);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") IntBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") LongBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") FloatBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") DoubleBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") PointerBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << MemoryStack.POINTER_SHIFT);
        return BGFXMemory.createSafe(__result);
    }

    public static long nbgfx_make_ref(long _data, int _size) {
        long __functionAddress = Functions.make_ref;
        return JNI.invokePP(_data, _size, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") ByteBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining());
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") ShortBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 1);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") IntBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") LongBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") FloatBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") DoubleBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref(@NativeType(value="void const *") PointerBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << MemoryStack.POINTER_SHIFT);
        return BGFXMemory.createSafe(__result);
    }

    public static long nbgfx_make_ref_release(long _data, int _size, long _releaseFn, long _userData) {
        long __functionAddress = Functions.make_ref_release;
        return JNI.invokePPPP(_data, _size, _releaseFn, _userData, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining(), _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") ShortBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 1, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") IntBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 2, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") LongBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 3, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") FloatBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 2, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") DoubleBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 3, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_make_ref_release(@NativeType(value="void const *") PointerBuffer _data, @NativeType(value="bgfx_release_fn_t") BGFXReleaseFunctionCallbackI _releaseFn, @NativeType(value="void *") long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << MemoryStack.POINTER_SHIFT, _releaseFn.address(), _userData);
        return BGFXMemory.createSafe(__result);
    }

    public static void bgfx_set_debug(@NativeType(value="uint32_t") int _debug) {
        long __functionAddress = Functions.set_debug;
        JNI.invokeV(_debug, __functionAddress);
    }

    public static void nbgfx_dbg_text_clear(byte _attr, boolean _small) {
        long __functionAddress = Functions.dbg_text_clear;
        JNI.invokeV(_attr, _small, __functionAddress);
    }

    public static void bgfx_dbg_text_clear(@NativeType(value="uint8_t") int _attr, @NativeType(value="bool") boolean _small) {
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_clear((byte)_attr, _small);
    }

    public static void nbgfx_dbg_text_printf(short _x, short _y, byte _attr, long _format) {
        long __functionAddress = Functions.dbg_text_printf;
        JNI.invokePV(_x, _y, _attr, _format, __functionAddress);
    }

    public static void bgfx_dbg_text_printf(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint8_t") int _attr, @NativeType(value="char const *") ByteBuffer _format) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_format);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_printf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_dbg_text_printf(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint8_t") int _attr, @NativeType(value="char const *") CharSequence _format) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_format, true);
            long _formatEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_printf((short)_x, (short)_y, (byte)_attr, _formatEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_dbg_text_vprintf(short _x, short _y, byte _attr, long _format, long _argList) {
        long __functionAddress = Functions.dbg_text_vprintf;
        if (Checks.CHECKS) {
            Checks.check(_argList);
        }
        JNI.invokePPV(_x, _y, _attr, _format, _argList, __functionAddress);
    }

    public static void bgfx_dbg_text_vprintf(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint8_t") int _attr, @NativeType(value="char const *") ByteBuffer _format, @NativeType(value="va_list") long _argList) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_format);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_vprintf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_format), _argList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_dbg_text_vprintf(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint8_t") int _attr, @NativeType(value="char const *") CharSequence _format, @NativeType(value="va_list") long _argList) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_format, true);
            long _formatEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_vprintf((short)_x, (short)_y, (byte)_attr, _formatEncoded, _argList);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_dbg_text_image(short _x, short _y, short _width, short _height, long _data, short _pitch) {
        long __functionAddress = Functions.dbg_text_image;
        JNI.invokePV(_x, _y, _width, _height, _data, _pitch, __functionAddress);
    }

    public static void bgfx_dbg_text_image(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="uint16_t") int _pitch) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_data, _height * _pitch);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_image((short)_x, (short)_y, (short)_width, (short)_height, MemoryUtil.memAddress(_data), (short)_pitch);
    }

    public static short nbgfx_create_index_buffer(long _mem, short _flags) {
        long __functionAddress = Functions.create_index_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(_mem, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_index_buffer_handle_t")
    public static short bgfx_create_index_buffer(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_index_buffer(_mem.address(), (short)_flags);
    }

    public static void nbgfx_set_index_buffer_name(short _handle, long _name, int _len) {
        long __functionAddress = Functions.set_index_buffer_name;
        JNI.invokePV(_handle, _name, _len, __functionAddress);
    }

    public static void bgfx_set_index_buffer_name(@NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _name) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_index_buffer_name(_handle, MemoryUtil.memAddress(_name), _name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_index_buffer_name(@NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _nameEncodedLength = stack.nASCII(_name, false);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_index_buffer_name(_handle, _nameEncoded, _nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_destroy_index_buffer(@NativeType(value="bgfx_index_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_index_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_vertex_layout(long _layout) {
        long __functionAddress = Functions.create_vertex_layout;
        return JNI.invokePS(_layout, __functionAddress);
    }

    @NativeType(value="bgfx_vertex_layout_handle_t")
    public static short bgfx_create_vertex_layout(@NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_vertex_layout(_layout.address());
    }

    public static void bgfx_destroy_vertex_layout(@NativeType(value="bgfx_vertex_layout_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_vertex_layout;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_vertex_buffer(long _mem, long _layout, short _flags) {
        long __functionAddress = Functions.create_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePPS(_mem, _layout, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public static short bgfx_create_vertex_buffer(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_vertex_buffer(_mem.address(), _layout.address(), (short)_flags);
    }

    public static void nbgfx_set_vertex_buffer_name(short _handle, long _name, int _len) {
        long __functionAddress = Functions.set_vertex_buffer_name;
        JNI.invokePV(_handle, _name, _len, __functionAddress);
    }

    public static void bgfx_set_vertex_buffer_name(@NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _name) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_vertex_buffer_name(_handle, MemoryUtil.memAddress(_name), _name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_vertex_buffer_name(@NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _nameEncodedLength = stack.nASCII(_name, false);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_vertex_buffer_name(_handle, _nameEncoded, _nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_destroy_vertex_buffer(@NativeType(value="bgfx_vertex_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_vertex_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_dynamic_index_buffer(int _num, short _flags) {
        long __functionAddress = Functions.create_dynamic_index_buffer;
        return JNI.invokeS(_num, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_dynamic_index_buffer_handle_t")
    public static short bgfx_create_dynamic_index_buffer(@NativeType(value="uint32_t") int _num, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_index_buffer(_num, (short)_flags);
    }

    public static short nbgfx_create_dynamic_index_buffer_mem(long _mem, short _flags) {
        long __functionAddress = Functions.create_dynamic_index_buffer_mem;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(_mem, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_dynamic_index_buffer_handle_t")
    public static short bgfx_create_dynamic_index_buffer_mem(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_index_buffer_mem(_mem.address(), (short)_flags);
    }

    public static void nbgfx_update_dynamic_index_buffer(short _handle, int _startIndex, long _mem) {
        long __functionAddress = Functions.update_dynamic_index_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(_handle, _startIndex, _mem, __functionAddress);
    }

    public static void bgfx_update_dynamic_index_buffer(@NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startIndex, @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_dynamic_index_buffer(_handle, _startIndex, _mem.address());
    }

    public static void bgfx_destroy_dynamic_index_buffer(@NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_dynamic_index_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_dynamic_vertex_buffer(int _num, long _layout, short _flags) {
        long __functionAddress = Functions.create_dynamic_vertex_buffer;
        return JNI.invokePS(_num, _layout, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t")
    public static short bgfx_create_dynamic_vertex_buffer(@NativeType(value="uint32_t") int _num, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_vertex_buffer(_num, _layout.address(), (short)_flags);
    }

    public static short nbgfx_create_dynamic_vertex_buffer_mem(long _mem, long _layout, short _flags) {
        long __functionAddress = Functions.create_dynamic_vertex_buffer_mem;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePPS(_mem, _layout, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t")
    public static short bgfx_create_dynamic_vertex_buffer_mem(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="uint16_t") int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_vertex_buffer_mem(_mem.address(), _layout.address(), (short)_flags);
    }

    public static void nbgfx_update_dynamic_vertex_buffer(short _handle, int _startVertex, long _mem) {
        long __functionAddress = Functions.update_dynamic_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(_handle, _startVertex, _mem, __functionAddress);
    }

    public static void bgfx_update_dynamic_vertex_buffer(@NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_dynamic_vertex_buffer(_handle, _startVertex, _mem.address());
    }

    public static void bgfx_destroy_dynamic_vertex_buffer(@NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_dynamic_vertex_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_get_avail_transient_index_buffer(@NativeType(value="uint32_t") int _num, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.get_avail_transient_index_buffer;
        return JNI.invokeI(_num, _index32, __functionAddress);
    }

    public static int nbgfx_get_avail_transient_vertex_buffer(int _num, long _layout) {
        long __functionAddress = Functions.get_avail_transient_vertex_buffer;
        return JNI.invokePI(_num, _layout, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_get_avail_transient_vertex_buffer(@NativeType(value="uint32_t") int _num, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_avail_transient_vertex_buffer(_num, _layout.address());
    }

    public static int nbgfx_get_avail_instance_data_buffer(int _num, short _stride) {
        long __functionAddress = Functions.get_avail_instance_data_buffer;
        return JNI.invokeI(_num, _stride, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_get_avail_instance_data_buffer(@NativeType(value="uint32_t") int _num, @NativeType(value="uint16_t") int _stride) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_avail_instance_data_buffer(_num, (short)_stride);
    }

    public static void nbgfx_alloc_transient_index_buffer(long _tib, int _num, boolean _index32) {
        long __functionAddress = Functions.alloc_transient_index_buffer;
        JNI.invokePV(_tib, _num, _index32, __functionAddress);
    }

    public static void bgfx_alloc_transient_index_buffer(@NativeType(value="bgfx_transient_index_buffer_t *") BGFXTransientIndexBuffer _tib, @NativeType(value="uint32_t") int _num, @NativeType(value="bool") boolean _index32) {
        org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_index_buffer(_tib.address(), _num, _index32);
    }

    public static void nbgfx_alloc_transient_vertex_buffer(long _tvb, int _num, long _layout) {
        long __functionAddress = Functions.alloc_transient_vertex_buffer;
        JNI.invokePPV(_tvb, _num, _layout, __functionAddress);
    }

    public static void bgfx_alloc_transient_vertex_buffer(@NativeType(value="bgfx_transient_vertex_buffer_t *") BGFXTransientVertexBuffer _tvb, @NativeType(value="uint32_t") int _num, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout) {
        org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_vertex_buffer(_tvb.address(), _num, _layout.address());
    }

    public static boolean nbgfx_alloc_transient_buffers(long _tvb, long _layout, int _numVertices, long _tib, int _numIndices, boolean _index32) {
        long __functionAddress = Functions.alloc_transient_buffers;
        return JNI.invokePPPZ(_tvb, _layout, _numVertices, _tib, _numIndices, _index32, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean bgfx_alloc_transient_buffers(@NativeType(value="bgfx_transient_vertex_buffer_t *") BGFXTransientVertexBuffer _tvb, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_transient_index_buffer_t *") BGFXTransientIndexBuffer _tib, @NativeType(value="uint32_t") int _numIndices, @NativeType(value="bool") boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_buffers(_tvb.address(), _layout.address(), _numVertices, _tib.address(), _numIndices, _index32);
    }

    public static void nbgfx_alloc_instance_data_buffer(long _idb, int _num, short _stride) {
        long __functionAddress = Functions.alloc_instance_data_buffer;
        JNI.invokePV(_idb, _num, _stride, __functionAddress);
    }

    public static void bgfx_alloc_instance_data_buffer(@NativeType(value="bgfx_instance_data_buffer_t *") BGFXInstanceDataBuffer _idb, @NativeType(value="uint32_t") int _num, @NativeType(value="uint16_t") int _stride) {
        org.lwjgl.bgfx.BGFX.nbgfx_alloc_instance_data_buffer(_idb.address(), _num, (short)_stride);
    }

    @NativeType(value="bgfx_indirect_buffer_handle_t")
    public static short bgfx_create_indirect_buffer(@NativeType(value="uint32_t") int _num) {
        long __functionAddress = Functions.create_indirect_buffer;
        return JNI.invokeS(_num, __functionAddress);
    }

    public static void bgfx_destroy_indirect_buffer(@NativeType(value="bgfx_indirect_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_indirect_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_shader(long _mem) {
        long __functionAddress = Functions.create_shader;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(_mem, __functionAddress);
    }

    @NativeType(value="bgfx_shader_handle_t")
    public static short bgfx_create_shader(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_shader(_mem.address());
    }

    public static short nbgfx_get_shader_uniforms(short _handle, long _uniforms, short _max) {
        long __functionAddress = Functions.get_shader_uniforms;
        return JNI.invokePS(_handle, _uniforms, _max, __functionAddress);
    }

    @NativeType(value="uint16_t")
    public static short bgfx_get_shader_uniforms(@NativeType(value="bgfx_shader_handle_t") short _handle, @NativeType(value="bgfx_uniform_handle_t *") ShortBuffer _uniforms) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_shader_uniforms(_handle, MemoryUtil.memAddress(_uniforms), (short)_uniforms.remaining());
    }

    public static void nbgfx_set_shader_name(short _handle, long _name, int _len) {
        long __functionAddress = Functions.set_shader_name;
        JNI.invokePV(_handle, _name, _len, __functionAddress);
    }

    public static void bgfx_set_shader_name(@NativeType(value="bgfx_shader_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _name) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_shader_name(_handle, MemoryUtil.memAddress(_name), _name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_shader_name(@NativeType(value="bgfx_shader_handle_t") short _handle, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _nameEncodedLength = stack.nUTF8(_name, false);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_shader_name(_handle, _nameEncoded, _nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_destroy_shader(@NativeType(value="bgfx_shader_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_shader;
        JNI.invokeV(_handle, __functionAddress);
    }

    @NativeType(value="bgfx_program_handle_t")
    public static short bgfx_create_program(@NativeType(value="bgfx_shader_handle_t") short _vsh, @NativeType(value="bgfx_shader_handle_t") short _fsh, @NativeType(value="bool") boolean _destroyShaders) {
        long __functionAddress = Functions.create_program;
        return JNI.invokeS(_vsh, _fsh, _destroyShaders, __functionAddress);
    }

    @NativeType(value="bgfx_program_handle_t")
    public static short bgfx_create_compute_program(@NativeType(value="bgfx_shader_handle_t") short _csh, @NativeType(value="bool") boolean _destroyShaders) {
        long __functionAddress = Functions.create_compute_program;
        return JNI.invokeS(_csh, _destroyShaders, __functionAddress);
    }

    public static void bgfx_destroy_program(@NativeType(value="bgfx_program_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_program;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static boolean nbgfx_is_texture_valid(short _depth, boolean _cubeMap, short _numLayers, int _format, long _flags) {
        long __functionAddress = Functions.is_texture_valid;
        return JNI.invokeJZ(_depth, _cubeMap, _numLayers, _format, _flags, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean bgfx_is_texture_valid(@NativeType(value="uint16_t") int _depth, @NativeType(value="bool") boolean _cubeMap, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_is_texture_valid((short)_depth, _cubeMap, (short)_numLayers, _format, _flags);
    }

    public static boolean nbgfx_is_frame_buffer_valid(byte _num, long _attachment) {
        long __functionAddress = Functions.is_frame_buffer_valid;
        return JNI.invokePZ(_num, _attachment, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean bgfx_is_frame_buffer_valid(@NativeType(value="uint8_t") int _num, @NativeType(value="bgfx_attachment_t const *") BGFXAttachment _attachment) {
        return org.lwjgl.bgfx.BGFX.nbgfx_is_frame_buffer_valid((byte)_num, _attachment.address());
    }

    public static void nbgfx_calc_texture_size(long _info, short _width, short _height, short _depth, boolean _cubeMap, boolean _hasMips, short _numLayers, int _format) {
        long __functionAddress = Functions.calc_texture_size;
        JNI.invokePV(_info, _width, _height, _depth, _cubeMap, _hasMips, _numLayers, _format, __functionAddress);
    }

    public static void bgfx_calc_texture_size(@NativeType(value="bgfx_texture_info_t *") BGFXTextureInfo _info, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint16_t") int _depth, @NativeType(value="bool") boolean _cubeMap, @NativeType(value="bool") boolean _hasMips, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="bgfx_texture_format_t") int _format) {
        org.lwjgl.bgfx.BGFX.nbgfx_calc_texture_size(_info.address(), (short)_width, (short)_height, (short)_depth, _cubeMap, _hasMips, (short)_numLayers, _format);
    }

    public static short nbgfx_create_texture(long _mem, long _flags, byte _skip, long _info) {
        long __functionAddress = Functions.create_texture;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePJPS(_mem, _flags, _skip, _info, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_create_texture(@NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="uint64_t") long _flags, @NativeType(value="uint8_t") int _skip, @Nullable @NativeType(value="bgfx_texture_info_t *") BGFXTextureInfo _info) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture(_mem.address(), _flags, (byte)_skip, MemoryUtil.memAddressSafe(_info));
    }

    public static short nbgfx_create_texture_2d(short _width, short _height, boolean _hasMips, short _numLayers, int _format, long _flags, long _mem) {
        long __functionAddress = Functions.create_texture_2d;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokeJPS(_width, _height, _hasMips, _numLayers, _format, _flags, _mem, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_create_texture_2d(@NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="bool") boolean _hasMips, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags, @Nullable @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_2d((short)_width, (short)_height, _hasMips, (short)_numLayers, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static short nbgfx_create_texture_2d_scaled(int _ratio, boolean _hasMips, short _numLayers, int _format, long _flags) {
        long __functionAddress = Functions.create_texture_2d_scaled;
        return JNI.invokeJS(_ratio, _hasMips, _numLayers, _format, _flags, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_create_texture_2d_scaled(@NativeType(value="bgfx_backbuffer_ratio_t") int _ratio, @NativeType(value="bool") boolean _hasMips, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_2d_scaled(_ratio, _hasMips, (short)_numLayers, _format, _flags);
    }

    public static short nbgfx_create_texture_3d(short _width, short _height, short _depth, boolean _hasMips, int _format, long _flags, long _mem) {
        long __functionAddress = Functions.create_texture_3d;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokeJPS(_width, _height, _depth, _hasMips, _format, _flags, _mem, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_create_texture_3d(@NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint16_t") int _depth, @NativeType(value="bool") boolean _hasMips, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags, @Nullable @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_3d((short)_width, (short)_height, (short)_depth, _hasMips, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static short nbgfx_create_texture_cube(short _size, boolean _hasMips, short _numLayers, int _format, long _flags, long _mem) {
        long __functionAddress = Functions.create_texture_cube;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokeJPS(_size, _hasMips, _numLayers, _format, _flags, _mem, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_create_texture_cube(@NativeType(value="uint16_t") int _size, @NativeType(value="bool") boolean _hasMips, @NativeType(value="uint16_t") int _numLayers, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags, @Nullable @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_cube((short)_size, _hasMips, (short)_numLayers, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static void nbgfx_update_texture_2d(short _handle, short _layer, byte _mip, short _x, short _y, short _width, short _height, long _mem, short _pitch) {
        long __functionAddress = Functions.update_texture_2d;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(_handle, _layer, _mip, _x, _y, _width, _height, _mem, _pitch, __functionAddress);
    }

    public static void bgfx_update_texture_2d(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint16_t") int _layer, @NativeType(value="uint8_t") int _mip, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="uint16_t") int _pitch) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_2d(_handle, (short)_layer, (byte)_mip, (short)_x, (short)_y, (short)_width, (short)_height, _mem.address(), (short)_pitch);
    }

    public static void nbgfx_update_texture_3d(short _handle, byte _mip, short _x, short _y, short _z, short _width, short _height, short _depth, long _mem) {
        long __functionAddress = Functions.update_texture_3d;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(_handle, _mip, _x, _y, _z, _width, _height, _depth, _mem, __functionAddress);
    }

    public static void bgfx_update_texture_3d(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint8_t") int _mip, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _z, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint16_t") int _depth, @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_3d(_handle, (byte)_mip, (short)_x, (short)_y, (short)_z, (short)_width, (short)_height, (short)_depth, _mem.address());
    }

    public static void nbgfx_update_texture_cube(short _handle, short _layer, byte _side, byte _mip, short _x, short _y, short _width, short _height, long _mem, short _pitch) {
        long __functionAddress = Functions.update_texture_cube;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(_handle, _layer, _side, _mip, _x, _y, _width, _height, _mem, _pitch, __functionAddress);
    }

    public static void bgfx_update_texture_cube(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint16_t") int _layer, @NativeType(value="uint8_t") byte _side, @NativeType(value="uint8_t") int _mip, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="bgfx_memory_t const *") BGFXMemory _mem, @NativeType(value="uint16_t") int _pitch) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_cube(_handle, (short)_layer, _side, (byte)_mip, (short)_x, (short)_y, (short)_width, (short)_height, _mem.address(), (short)_pitch);
    }

    public static int nbgfx_read_texture(short _handle, long _data, byte _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(_handle, _data, _mip, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") ByteBuffer _data, @NativeType(value="uint8_t") int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") ShortBuffer _data, @NativeType(value="uint8_t") int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") IntBuffer _data, @NativeType(value="uint8_t") int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") FloatBuffer _data, @NativeType(value="uint8_t") int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    public static void nbgfx_set_texture_name(short _handle, long _name, int _len) {
        long __functionAddress = Functions.set_texture_name;
        JNI.invokePV(_handle, _name, _len, __functionAddress);
    }

    public static void bgfx_set_texture_name(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _name) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_texture_name(_handle, MemoryUtil.memAddress(_name), _name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_texture_name(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _nameEncodedLength = stack.nUTF8(_name, false);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_texture_name(_handle, _nameEncoded, _nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void *")
    public static long bgfx_get_direct_access_ptr(@NativeType(value="bgfx_texture_handle_t") short _handle) {
        long __functionAddress = Functions.get_direct_access_ptr;
        return JNI.invokeP(_handle, __functionAddress);
    }

    public static void bgfx_destroy_texture(@NativeType(value="bgfx_texture_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_texture;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_frame_buffer(short _width, short _height, int _format, long _textureFlags) {
        long __functionAddress = Functions.create_frame_buffer;
        return JNI.invokeJS(_width, _height, _format, _textureFlags, __functionAddress);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer(@NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _textureFlags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer((short)_width, (short)_height, _format, _textureFlags);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer_scaled(@NativeType(value="bgfx_backbuffer_ratio_t") int _ratio, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _textureFlags) {
        long __functionAddress = Functions.create_frame_buffer_scaled;
        return JNI.invokeJS(_ratio, _format, _textureFlags, __functionAddress);
    }

    public static short nbgfx_create_frame_buffer_from_handles(byte _num, long _handles, boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_handles;
        return JNI.invokePS(_num, _handles, _destroyTextures, __functionAddress);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer_from_handles(@NativeType(value="bgfx_texture_handle_t const *") ShortBuffer _handles, @NativeType(value="bool") boolean _destroyTextures) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_handles((byte)_handles.remaining(), MemoryUtil.memAddress(_handles), _destroyTextures);
    }

    public static short nbgfx_create_frame_buffer_from_attachment(byte _num, long _attachment, boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_attachment;
        return JNI.invokePS(_num, _attachment, _destroyTextures, __functionAddress);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer_from_attachment(@NativeType(value="bgfx_attachment_t const *") BGFXAttachment.Buffer _attachment, @NativeType(value="bool") boolean _destroyTextures) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_attachment((byte)_attachment.remaining(), _attachment.address(), _destroyTextures);
    }

    public static short nbgfx_create_frame_buffer_from_nwh(long _nwh, short _width, short _height, int _format, int _depthFormat) {
        long __functionAddress = Functions.create_frame_buffer_from_nwh;
        if (Checks.CHECKS) {
            Checks.check(_nwh);
        }
        return JNI.invokePS(_nwh, _width, _height, _format, _depthFormat, __functionAddress);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer_from_nwh(@NativeType(value="void *") long _nwh, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="bgfx_texture_format_t") int _depthFormat) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_nwh(_nwh, (short)_width, (short)_height, _format, _depthFormat);
    }

    public static void nbgfx_set_frame_buffer_name(short _handle, long _name, int _len) {
        long __functionAddress = Functions.set_frame_buffer_name;
        JNI.invokePV(_handle, _name, _len, __functionAddress);
    }

    public static void bgfx_set_frame_buffer_name(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _name) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_frame_buffer_name(_handle, MemoryUtil.memAddress(_name), _name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_frame_buffer_name(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _nameEncodedLength = stack.nASCII(_name, false);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_frame_buffer_name(_handle, _nameEncoded, _nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static short nbgfx_get_texture(short _handle, byte _attachment) {
        long __functionAddress = Functions.get_texture;
        return JNI.invokeS(_handle, _attachment, __functionAddress);
    }

    @NativeType(value="bgfx_texture_handle_t")
    public static short bgfx_get_texture(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle, @NativeType(value="uint8_t") int _attachment) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_texture(_handle, (byte)_attachment);
    }

    public static void bgfx_destroy_frame_buffer(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_frame_buffer;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static short nbgfx_create_uniform(long _name, int _type, short _num) {
        long __functionAddress = Functions.create_uniform;
        return JNI.invokePS(_name, _type, _num, __functionAddress);
    }

    @NativeType(value="bgfx_uniform_handle_t")
    public static short bgfx_create_uniform(@NativeType(value="char const *") ByteBuffer _name, @NativeType(value="bgfx_uniform_type_t") int _type, @NativeType(value="uint16_t") int _num) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_name);
        }
        return org.lwjgl.bgfx.BGFX.nbgfx_create_uniform(MemoryUtil.memAddress(_name), _type, (short)_num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bgfx_uniform_handle_t")
    public static short bgfx_create_uniform(@NativeType(value="char const *") CharSequence _name, @NativeType(value="bgfx_uniform_type_t") int _type, @NativeType(value="uint16_t") int _num) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_name, true);
            long _nameEncoded = stack.getPointerAddress();
            short s = org.lwjgl.bgfx.BGFX.nbgfx_create_uniform(_nameEncoded, _type, (short)_num);
            return s;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_get_uniform_info(short _handle, long _info) {
        long __functionAddress = Functions.get_uniform_info;
        JNI.invokePV(_handle, _info, __functionAddress);
    }

    public static void bgfx_get_uniform_info(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="bgfx_uniform_info_t *") BGFXUniformInfo _info) {
        org.lwjgl.bgfx.BGFX.nbgfx_get_uniform_info(_handle, _info.address());
    }

    public static void bgfx_destroy_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_uniform;
        JNI.invokeV(_handle, __functionAddress);
    }

    @NativeType(value="bgfx_occlusion_query_handle_t")
    public static short bgfx_create_occlusion_query() {
        long __functionAddress = Functions.create_occlusion_query;
        return JNI.invokeS(__functionAddress);
    }

    public static int nbgfx_get_result(short _handle, long _result) {
        long __functionAddress = Functions.get_result;
        return JNI.invokePI(_handle, _result, __functionAddress);
    }

    @NativeType(value="bgfx_occlusion_query_result_t")
    public static int bgfx_get_result(@NativeType(value="bgfx_occlusion_query_handle_t") short _handle, @Nullable @NativeType(value="int32_t *") IntBuffer _result) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_result, 1);
        }
        return org.lwjgl.bgfx.BGFX.nbgfx_get_result(_handle, MemoryUtil.memAddressSafe(_result));
    }

    public static void bgfx_destroy_occlusion_query(@NativeType(value="bgfx_occlusion_query_handle_t") short _handle) {
        long __functionAddress = Functions.destroy_occlusion_query;
        JNI.invokeV(_handle, __functionAddress);
    }

    public static void nbgfx_set_palette_color(byte _index, long _rgba) {
        long __functionAddress = Functions.set_palette_color;
        JNI.invokePV(_index, _rgba, __functionAddress);
    }

    public static void bgfx_set_palette_color(@NativeType(value="uint8_t") int _index, @NativeType(value="float const *") FloatBuffer _rgba) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_rgba, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_palette_color((byte)_index, MemoryUtil.memAddress(_rgba));
    }

    public static void nbgfx_set_palette_color_rgba8(byte _index, int _rgba) {
        long __functionAddress = Functions.set_palette_color_rgba8;
        JNI.invokeV(_index, _rgba, __functionAddress);
    }

    public static void bgfx_set_palette_color_rgba8(@NativeType(value="uint8_t") int _index, @NativeType(value="uint32_t") int _rgba) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_palette_color_rgba8((byte)_index, _rgba);
    }

    public static void nbgfx_set_view_name(short _id, long _name) {
        long __functionAddress = Functions.set_view_name;
        JNI.invokePV(_id, _name, __functionAddress);
    }

    public static void bgfx_set_view_name(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="char const *") ByteBuffer _name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_name);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_name((short)_id, MemoryUtil.memAddress(_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_view_name(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="char const *") CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_name, true);
            long _nameEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_view_name((short)_id, _nameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_set_view_rect(short _id, short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_view_rect;
        JNI.invokeV(_id, _x, _y, _width, _height, __functionAddress);
    }

    public static void bgfx_set_view_rect(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_rect((short)_id, (short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_view_rect_ratio(short _id, short _x, short _y, int _ratio) {
        long __functionAddress = Functions.set_view_rect_ratio;
        JNI.invokeV(_id, _x, _y, _ratio, __functionAddress);
    }

    public static void bgfx_set_view_rect_ratio(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="bgfx_backbuffer_ratio_t") int _ratio) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_rect_ratio((short)_id, (short)_x, (short)_y, _ratio);
    }

    public static void nbgfx_set_view_scissor(short _id, short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_view_scissor;
        JNI.invokeV(_id, _x, _y, _width, _height, __functionAddress);
    }

    public static void bgfx_set_view_scissor(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_scissor((short)_id, (short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_view_clear(short _id, short _flags, int _rgba, float _depth, byte _stencil) {
        long __functionAddress = Functions.set_view_clear;
        JNI.invokeV(_id, _flags, _rgba, _depth, _stencil, __functionAddress);
    }

    public static void bgfx_set_view_clear(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _flags, @NativeType(value="uint32_t") int _rgba, float _depth, @NativeType(value="uint8_t") int _stencil) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_clear((short)_id, (short)_flags, _rgba, _depth, (byte)_stencil);
    }

    public static void nbgfx_set_view_clear_mrt(short _id, short _flags, float _depth, byte _stencil, byte _0, byte _1, byte _2, byte _3, byte _4, byte _5, byte _6, byte _7) {
        long __functionAddress = Functions.set_view_clear_mrt;
        JNI.invokeV(_id, _flags, _depth, _stencil, _0, _1, _2, _3, _4, _5, _6, _7, __functionAddress);
    }

    public static void bgfx_set_view_clear_mrt(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _flags, float _depth, @NativeType(value="uint8_t") int _stencil, @NativeType(value="uint8_t") byte _0, @NativeType(value="uint8_t") byte _1, @NativeType(value="uint8_t") byte _2, @NativeType(value="uint8_t") byte _3, @NativeType(value="uint8_t") byte _4, @NativeType(value="uint8_t") byte _5, @NativeType(value="uint8_t") byte _6, @NativeType(value="uint8_t") byte _7) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_clear_mrt((short)_id, (short)_flags, _depth, (byte)_stencil, _0, _1, _2, _3, _4, _5, _6, _7);
    }

    public static void nbgfx_set_view_mode(short _id, int _mode) {
        long __functionAddress = Functions.set_view_mode;
        JNI.invokeV(_id, _mode, __functionAddress);
    }

    public static void bgfx_set_view_mode(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_view_mode_t") int _mode) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_mode((short)_id, _mode);
    }

    public static void nbgfx_set_view_frame_buffer(short _id, short _handle) {
        long __functionAddress = Functions.set_view_frame_buffer;
        JNI.invokeV(_id, _handle, __functionAddress);
    }

    public static void bgfx_set_view_frame_buffer(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_frame_buffer_handle_t") short _handle) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_frame_buffer((short)_id, _handle);
    }

    public static void nbgfx_set_view_transform(short _id, long _view, long _proj) {
        long __functionAddress = Functions.set_view_transform;
        JNI.invokePPV(_id, _view, _proj, __functionAddress);
    }

    public static void bgfx_set_view_transform(@NativeType(value="bgfx_view_id_t") int _id, @Nullable @NativeType(value="void const *") ByteBuffer _view, @Nullable @NativeType(value="void const *") ByteBuffer _proj) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 64);
            Checks.checkSafe((Buffer)_proj, 64);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform((short)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_proj));
    }

    public static void bgfx_set_view_transform(@NativeType(value="bgfx_view_id_t") int _id, @Nullable @NativeType(value="void const *") FloatBuffer _view, @Nullable @NativeType(value="void const *") FloatBuffer _proj) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 16);
            Checks.checkSafe((Buffer)_proj, 16);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform((short)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_proj));
    }

    public static void nbgfx_set_view_order(short _id, short _num, long _order) {
        long __functionAddress = Functions.set_view_order;
        JNI.invokePV(_id, _num, _order, __functionAddress);
    }

    public static void bgfx_set_view_order(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _num, @Nullable @NativeType(value="bgfx_view_id_t const *") ShortBuffer _order) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_order, _num);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_order((short)_id, (short)_num, MemoryUtil.memAddressSafe(_order));
    }

    public static void nbgfx_reset_view(short _id) {
        long __functionAddress = Functions.reset_view;
        JNI.invokeV(_id, __functionAddress);
    }

    public static void bgfx_reset_view(@NativeType(value="bgfx_view_id_t") int _id) {
        org.lwjgl.bgfx.BGFX.nbgfx_reset_view((short)_id);
    }

    @NativeType(value="struct bgfx_encoder_s *")
    public static long bgfx_encoder_begin(@NativeType(value="bool") boolean _forThread) {
        long __functionAddress = Functions.encoder_begin;
        return JNI.invokeP(_forThread, __functionAddress);
    }

    public static void bgfx_encoder_end(@NativeType(value="struct bgfx_encoder_s *") long _encoder) {
        long __functionAddress = Functions.encoder_end;
        if (Checks.CHECKS) {
            Checks.check(_encoder);
        }
        JNI.invokePV(_encoder, __functionAddress);
    }

    public static void nbgfx_encoder_set_marker(long _this, long _marker) {
        long __functionAddress = Functions.encoder_set_marker;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _marker, __functionAddress);
    }

    public static void bgfx_encoder_set_marker(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="char const *") ByteBuffer _marker) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_marker);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_marker(_this, MemoryUtil.memAddress(_marker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_encoder_set_marker(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="char const *") CharSequence _marker) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_marker, true);
            long _markerEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_marker(_this, _markerEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_encoder_set_state(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint64_t") long _state, @NativeType(value="uint32_t") int _rgba) {
        long __functionAddress = Functions.encoder_set_state;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePJV(_this, _state, _rgba, __functionAddress);
    }

    public static void bgfx_encoder_set_condition(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_occlusion_query_handle_t") short _handle, @NativeType(value="bool") boolean _visible) {
        long __functionAddress = Functions.encoder_set_condition;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _handle, _visible, __functionAddress);
    }

    public static void bgfx_encoder_set_stencil(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint32_t") int _fstencil, @NativeType(value="uint32_t") int _bstencil) {
        long __functionAddress = Functions.encoder_set_stencil;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _fstencil, _bstencil, __functionAddress);
    }

    public static short nbgfx_encoder_set_scissor(long _this, short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.encoder_set_scissor;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        return JNI.invokePS(_this, _x, _y, _width, _height, __functionAddress);
    }

    @NativeType(value="uint16_t")
    public static short bgfx_encoder_set_scissor(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height) {
        return org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_scissor(_this, (short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_encoder_set_scissor_cached(long _this, short _cache) {
        long __functionAddress = Functions.encoder_set_scissor_cached;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _cache, __functionAddress);
    }

    public static void bgfx_encoder_set_scissor_cached(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint16_t") int _cache) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_scissor_cached(_this, (short)_cache);
    }

    public static int nbgfx_encoder_set_transform(long _this, long _mtx, short _num) {
        long __functionAddress = Functions.encoder_set_transform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        return JNI.invokePPI(_this, _mtx, _num, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_encoder_set_transform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="void const *") ByteBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transform(_this, MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 6));
    }

    @NativeType(value="uint32_t")
    public static int bgfx_encoder_set_transform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="void const *") FloatBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transform(_this, MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 4));
    }

    public static void nbgfx_encoder_set_transform_cached(long _this, int _cache, short _num) {
        long __functionAddress = Functions.encoder_set_transform_cached;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _cache, _num, __functionAddress);
    }

    public static void bgfx_encoder_set_transform_cached(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint32_t") int _cache, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transform_cached(_this, _cache, (short)_num);
    }

    public static int nbgfx_encoder_alloc_transform(long _this, long _transform, short _num) {
        long __functionAddress = Functions.encoder_alloc_transform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        return JNI.invokePPI(_this, _transform, _num, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_encoder_alloc_transform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_transform_t *") BGFXTransform _transform, @NativeType(value="uint16_t") int _num) {
        return org.lwjgl.bgfx.BGFX.nbgfx_encoder_alloc_transform(_this, _transform.address(), (short)_num);
    }

    public static void nbgfx_encoder_set_uniform(long _this, short _handle, long _value, short _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, _num, __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") ByteBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") ShortBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") IntBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") LongBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") FloatBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") DoubleBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_uniform(_this, _handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_encoder_set_index_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        long __functionAddress = Functions.encoder_set_index_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _handle, _firstIndex, _numIndices, __functionAddress);
    }

    public static void bgfx_encoder_set_dynamic_index_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        long __functionAddress = Functions.encoder_set_dynamic_index_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _handle, _firstIndex, _numIndices, __functionAddress);
    }

    public static void nbgfx_encoder_set_transient_index_buffer(long _this, long _tib, int _firstIndex, int _numIndices) {
        long __functionAddress = Functions.encoder_set_transient_index_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
            BGFXTransientIndexBuffer.validate(_tib);
        }
        JNI.invokePPV(_this, _tib, _firstIndex, _numIndices, __functionAddress);
    }

    public static void bgfx_encoder_set_transient_index_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_transient_index_buffer_t const *") BGFXTransientIndexBuffer _tib, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transient_index_buffer(_this, _tib.address(), _firstIndex, _numIndices);
    }

    public static void nbgfx_encoder_set_vertex_buffer(long _this, byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.encoder_set_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stream, _handle, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_encoder_set_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_vertex_buffer(_this, (byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_encoder_set_vertex_buffer_with_layout(long _this, byte _stream, short _handle, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.encoder_set_vertex_buffer_with_layout;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stream, _handle, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_encoder_set_vertex_buffer_with_layout(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_vertex_buffer_with_layout(_this, (byte)_stream, _handle, _startVertex, _numVertices, _layoutHandle);
    }

    public static void nbgfx_encoder_set_dynamic_vertex_buffer(long _this, byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.encoder_set_dynamic_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stream, _handle, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_encoder_set_dynamic_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_dynamic_vertex_buffer(_this, (byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_encoder_set_dynamic_vertex_buffer_with_layout(long _this, byte _stream, short _handle, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.encoder_set_dynamic_vertex_buffer_with_layout;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stream, _handle, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_encoder_set_dynamic_vertex_buffer_with_layout(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_dynamic_vertex_buffer_with_layout(_this, (byte)_stream, _handle, _startVertex, _numVertices, _layoutHandle);
    }

    public static void nbgfx_encoder_set_transient_vertex_buffer(long _this, byte _stream, long _tvb, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.encoder_set_transient_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
            BGFXTransientVertexBuffer.validate(_tvb);
        }
        JNI.invokePPV(_this, _stream, _tvb, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_encoder_set_transient_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_transient_vertex_buffer_t const *") BGFXTransientVertexBuffer _tvb, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transient_vertex_buffer(_this, (byte)_stream, _tvb.address(), _startVertex, _numVertices);
    }

    public static void nbgfx_encoder_set_transient_vertex_buffer_with_layout(long _this, byte _stream, long _tvb, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.encoder_set_transient_vertex_buffer_with_layout;
        if (Checks.CHECKS) {
            Checks.check(_this);
            BGFXTransientVertexBuffer.validate(_tvb);
        }
        JNI.invokePPV(_this, _stream, _tvb, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_encoder_set_transient_vertex_buffer_with_layout(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_transient_vertex_buffer_t const *") BGFXTransientVertexBuffer _tvb, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_transient_vertex_buffer_with_layout(_this, (byte)_stream, _tvb.address(), _startVertex, _numVertices, _layoutHandle);
    }

    public static void bgfx_encoder_set_vertex_count(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint32_t") int _numVertices) {
        long __functionAddress = Functions.encoder_set_vertex_count;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _numVertices, __functionAddress);
    }

    public static void nbgfx_encoder_set_instance_data_buffer(long _this, long _idb, int _start, int _num) {
        long __functionAddress = Functions.encoder_set_instance_data_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
            BGFXInstanceDataBuffer.validate(_idb);
        }
        JNI.invokePPV(_this, _idb, _start, _num, __functionAddress);
    }

    public static void bgfx_encoder_set_instance_data_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_instance_data_buffer_t const *") BGFXInstanceDataBuffer _idb, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_instance_data_buffer(_this, _idb.address(), _start, _num);
    }

    public static void bgfx_encoder_set_instance_data_from_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        long __functionAddress = Functions.encoder_set_instance_data_from_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _handle, _start, _num, __functionAddress);
    }

    public static void bgfx_encoder_set_instance_data_from_dynamic_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        long __functionAddress = Functions.encoder_set_instance_data_from_dynamic_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _handle, _start, _num, __functionAddress);
    }

    public static void bgfx_encoder_set_instance_count(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint32_t") int _numInstances) {
        long __functionAddress = Functions.encoder_set_instance_count;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _numInstances, __functionAddress);
    }

    public static void nbgfx_encoder_set_texture(long _this, byte _stage, short _sampler, short _handle, int _flags) {
        long __functionAddress = Functions.encoder_set_texture;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _sampler, _handle, _flags, __functionAddress);
    }

    public static void bgfx_encoder_set_texture(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_uniform_handle_t") short _sampler, @NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint32_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_texture(_this, (byte)_stage, _sampler, _handle, _flags);
    }

    public static void nbgfx_encoder_touch(long _this, short _id) {
        long __functionAddress = Functions.encoder_touch;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, __functionAddress);
    }

    public static void bgfx_encoder_touch(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_touch(_this, (short)_id);
    }

    public static void nbgfx_encoder_submit(long _this, short _id, short _handle, int _depth, byte _flags) {
        long __functionAddress = Functions.encoder_submit;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _handle, _depth, _flags, __functionAddress);
    }

    public static void bgfx_encoder_submit(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _handle, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_submit(_this, (short)_id, _handle, _depth, (byte)_flags);
    }

    public static void nbgfx_encoder_submit_occlusion_query(long _this, short _id, short _program, short _occlusionQuery, int _depth, byte _flags) {
        long __functionAddress = Functions.encoder_submit_occlusion_query;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _program, _occlusionQuery, _depth, _flags, __functionAddress);
    }

    public static void bgfx_encoder_submit_occlusion_query(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="bgfx_occlusion_query_handle_t") short _occlusionQuery, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_submit_occlusion_query(_this, (short)_id, _program, _occlusionQuery, _depth, (byte)_flags);
    }

    public static void nbgfx_encoder_submit_indirect(long _this, short _id, short _handle, short _indirectHandle, short _start, short _num, int _depth, byte _flags) {
        long __functionAddress = Functions.encoder_submit_indirect;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _handle, _indirectHandle, _start, _num, _depth, _flags, __functionAddress);
    }

    public static void bgfx_encoder_submit_indirect(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _handle, @NativeType(value="bgfx_indirect_buffer_handle_t") short _indirectHandle, @NativeType(value="uint16_t") int _start, @NativeType(value="uint16_t") int _num, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_submit_indirect(_this, (short)_id, _handle, _indirectHandle, (short)_start, (short)_num, _depth, (byte)_flags);
    }

    public static void nbgfx_encoder_set_compute_index_buffer(long _this, byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.encoder_set_compute_index_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_encoder_set_compute_index_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_compute_index_buffer(_this, (byte)_stage, _handle, _access);
    }

    public static void nbgfx_encoder_set_compute_vertex_buffer(long _this, byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.encoder_set_compute_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_encoder_set_compute_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_compute_vertex_buffer(_this, (byte)_stage, _handle, _access);
    }

    public static void nbgfx_encoder_set_compute_dynamic_index_buffer(long _this, byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.encoder_set_compute_dynamic_index_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_encoder_set_compute_dynamic_index_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_compute_dynamic_index_buffer(_this, (byte)_stage, _handle, _access);
    }

    public static void nbgfx_encoder_set_compute_dynamic_vertex_buffer(long _this, byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.encoder_set_compute_dynamic_vertex_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_encoder_set_compute_dynamic_vertex_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_compute_dynamic_vertex_buffer(_this, (byte)_stage, _handle, _access);
    }

    public static void nbgfx_encoder_set_compute_indirect_buffer(long _this, byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.encoder_set_compute_indirect_buffer;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_encoder_set_compute_indirect_buffer(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_indirect_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_compute_indirect_buffer(_this, (byte)_stage, _handle, _access);
    }

    public static void nbgfx_encoder_set_image(long _this, byte _stage, short _handle, byte _mip, int _access, int _format) {
        long __functionAddress = Functions.encoder_set_image;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _stage, _handle, _mip, _access, _format, __functionAddress);
    }

    public static void bgfx_encoder_set_image(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint8_t") int _mip, @NativeType(value="bgfx_access_t") int _access, @NativeType(value="bgfx_texture_format_t") int _format) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_set_image(_this, (byte)_stage, _handle, (byte)_mip, _access, _format);
    }

    public static void nbgfx_encoder_dispatch(long _this, short _id, short _handle, int _numX, int _numY, int _numZ, byte _flags) {
        long __functionAddress = Functions.encoder_dispatch;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _handle, _numX, _numY, _numZ, _flags, __functionAddress);
    }

    public static void bgfx_encoder_dispatch(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _handle, @NativeType(value="uint32_t") int _numX, @NativeType(value="uint32_t") int _numY, @NativeType(value="uint32_t") int _numZ, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_dispatch(_this, (short)_id, _handle, _numX, _numY, _numZ, (byte)_flags);
    }

    public static void nbgfx_encoder_dispatch_indirect(long _this, short _id, short _handle, short _indirectHandle, short _start, short _num, byte _flags) {
        long __functionAddress = Functions.encoder_dispatch_indirect;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _handle, _indirectHandle, _start, _num, _flags, __functionAddress);
    }

    public static void bgfx_encoder_dispatch_indirect(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _handle, @NativeType(value="bgfx_indirect_buffer_handle_t") short _indirectHandle, @NativeType(value="uint16_t") int _start, @NativeType(value="uint16_t") int _num, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_dispatch_indirect(_this, (short)_id, _handle, _indirectHandle, (short)_start, (short)_num, (byte)_flags);
    }

    public static void nbgfx_encoder_discard(long _this, byte _flags) {
        long __functionAddress = Functions.encoder_discard;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _flags, __functionAddress);
    }

    public static void bgfx_encoder_discard(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_discard(_this, (byte)_flags);
    }

    public static void nbgfx_encoder_blit(long _this, short _id, short _dst, byte _dstMip, short _dstX, short _dstY, short _dstZ, short _src, byte _srcMip, short _srcX, short _srcY, short _srcZ, short _width, short _height, short _depth) {
        long __functionAddress = Functions.encoder_blit;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePV(_this, _id, _dst, _dstMip, _dstX, _dstY, _dstZ, _src, _srcMip, _srcX, _srcY, _srcZ, _width, _height, _depth, __functionAddress);
    }

    public static void bgfx_encoder_blit(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_texture_handle_t") short _dst, @NativeType(value="uint8_t") int _dstMip, @NativeType(value="uint16_t") int _dstX, @NativeType(value="uint16_t") int _dstY, @NativeType(value="uint16_t") int _dstZ, @NativeType(value="bgfx_texture_handle_t") short _src, @NativeType(value="uint8_t") int _srcMip, @NativeType(value="uint16_t") int _srcX, @NativeType(value="uint16_t") int _srcY, @NativeType(value="uint16_t") int _srcZ, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint16_t") int _depth) {
        org.lwjgl.bgfx.BGFX.nbgfx_encoder_blit(_this, (short)_id, _dst, (byte)_dstMip, (short)_dstX, (short)_dstY, (short)_dstZ, _src, (byte)_srcMip, (short)_srcX, (short)_srcY, (short)_srcZ, (short)_width, (short)_height, (short)_depth);
    }

    public static void nbgfx_request_screen_shot(short _handle, long _filePath) {
        long __functionAddress = Functions.request_screen_shot;
        JNI.invokePV(_handle, _filePath, __functionAddress);
    }

    public static void bgfx_request_screen_shot(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle, @NativeType(value="char const *") ByteBuffer _filePath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_filePath);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_request_screen_shot(_handle, MemoryUtil.memAddress(_filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_request_screen_shot(@NativeType(value="bgfx_frame_buffer_handle_t") short _handle, @NativeType(value="char const *") CharSequence _filePath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_filePath, true);
            long _filePathEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_request_screen_shot(_handle, _filePathEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_set_marker(long _marker) {
        long __functionAddress = Functions.set_marker;
        JNI.invokePV(_marker, __functionAddress);
    }

    public static void bgfx_set_marker(@NativeType(value="char const *") ByteBuffer _marker) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_marker);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_marker(MemoryUtil.memAddress(_marker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_marker(@NativeType(value="char const *") CharSequence _marker) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_marker, true);
            long _markerEncoded = stack.getPointerAddress();
            org.lwjgl.bgfx.BGFX.nbgfx_set_marker(_markerEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_set_state(@NativeType(value="uint64_t") long _state, @NativeType(value="uint32_t") int _rgba) {
        long __functionAddress = Functions.set_state;
        JNI.invokeJV(_state, _rgba, __functionAddress);
    }

    public static void bgfx_set_condition(@NativeType(value="bgfx_occlusion_query_handle_t") short _handle, @NativeType(value="bool") boolean _visible) {
        long __functionAddress = Functions.set_condition;
        JNI.invokeV(_handle, _visible, __functionAddress);
    }

    public static void bgfx_set_stencil(@NativeType(value="uint32_t") int _fstencil, @NativeType(value="uint32_t") int _bstencil) {
        long __functionAddress = Functions.set_stencil;
        JNI.invokeV(_fstencil, _bstencil, __functionAddress);
    }

    public static short nbgfx_set_scissor(short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_scissor;
        return JNI.invokeS(_x, _y, _width, _height, __functionAddress);
    }

    @NativeType(value="uint16_t")
    public static short bgfx_set_scissor(@NativeType(value="uint16_t") int _x, @NativeType(value="uint16_t") int _y, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_scissor((short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_scissor_cached(short _cache) {
        long __functionAddress = Functions.set_scissor_cached;
        JNI.invokeV(_cache, __functionAddress);
    }

    public static void bgfx_set_scissor_cached(@NativeType(value="uint16_t") int _cache) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_scissor_cached((short)_cache);
    }

    public static int nbgfx_set_transform(long _mtx, short _num) {
        long __functionAddress = Functions.set_transform;
        return JNI.invokePI(_mtx, _num, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_set_transform(@NativeType(value="void const *") ByteBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_transform(MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 6));
    }

    @NativeType(value="uint32_t")
    public static int bgfx_set_transform(@NativeType(value="void const *") FloatBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_transform(MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 4));
    }

    public static void nbgfx_set_transform_cached(int _cache, short _num) {
        long __functionAddress = Functions.set_transform_cached;
        JNI.invokeV(_cache, _num, __functionAddress);
    }

    public static void bgfx_set_transform_cached(@NativeType(value="uint32_t") int _cache, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transform_cached(_cache, (short)_num);
    }

    public static int nbgfx_alloc_transform(long _transform, short _num) {
        long __functionAddress = Functions.alloc_transform;
        return JNI.invokePI(_transform, _num, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_alloc_transform(@NativeType(value="bgfx_transform_t *") BGFXTransform _transform, @NativeType(value="uint16_t") int _num) {
        return org.lwjgl.bgfx.BGFX.nbgfx_alloc_transform(_transform.address(), (short)_num);
    }

    public static void nbgfx_set_uniform(short _handle, long _value, short _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, _num, __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") ByteBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") ShortBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") IntBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") LongBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") FloatBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") DoubleBuffer _value, @NativeType(value="uint16_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_index_buffer(@NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        long __functionAddress = Functions.set_index_buffer;
        JNI.invokeV(_handle, _firstIndex, _numIndices, __functionAddress);
    }

    public static void bgfx_set_dynamic_index_buffer(@NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        long __functionAddress = Functions.set_dynamic_index_buffer;
        JNI.invokeV(_handle, _firstIndex, _numIndices, __functionAddress);
    }

    public static void nbgfx_set_transient_index_buffer(long _tib, int _firstIndex, int _numIndices) {
        long __functionAddress = Functions.set_transient_index_buffer;
        if (Checks.CHECKS) {
            BGFXTransientIndexBuffer.validate(_tib);
        }
        JNI.invokePV(_tib, _firstIndex, _numIndices, __functionAddress);
    }

    public static void bgfx_set_transient_index_buffer(@NativeType(value="bgfx_transient_index_buffer_t const *") BGFXTransientIndexBuffer _tib, @NativeType(value="uint32_t") int _firstIndex, @NativeType(value="uint32_t") int _numIndices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transient_index_buffer(_tib.address(), _firstIndex, _numIndices);
    }

    public static void nbgfx_set_vertex_buffer(byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_vertex_buffer;
        JNI.invokeV(_stream, _handle, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_set_vertex_buffer(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_vertex_buffer((byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_set_vertex_buffer_with_layout(byte _stream, short _handle, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.set_vertex_buffer_with_layout;
        JNI.invokeV(_stream, _handle, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_set_vertex_buffer_with_layout(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_vertex_buffer_with_layout((byte)_stream, _handle, _startVertex, _numVertices, _layoutHandle);
    }

    public static void nbgfx_set_dynamic_vertex_buffer(byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_dynamic_vertex_buffer;
        JNI.invokeV(_stream, _handle, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_set_dynamic_vertex_buffer(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_dynamic_vertex_buffer((byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_set_dynamic_vertex_buffer_with_layout(byte _stream, short _handle, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.set_dynamic_vertex_buffer_with_layout;
        JNI.invokeV(_stream, _handle, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_set_dynamic_vertex_buffer_with_layout(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_dynamic_vertex_buffer_with_layout((byte)_stream, _handle, _startVertex, _numVertices, _layoutHandle);
    }

    public static void nbgfx_set_transient_vertex_buffer(byte _stream, long _tvb, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_transient_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXTransientVertexBuffer.validate(_tvb);
        }
        JNI.invokePV(_stream, _tvb, _startVertex, _numVertices, __functionAddress);
    }

    public static void bgfx_set_transient_vertex_buffer(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_transient_vertex_buffer_t const *") BGFXTransientVertexBuffer _tvb, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transient_vertex_buffer((byte)_stream, _tvb.address(), _startVertex, _numVertices);
    }

    public static void nbgfx_set_transient_vertex_buffer_with_layout(byte _stream, long _tvb, int _startVertex, int _numVertices, short _layoutHandle) {
        long __functionAddress = Functions.set_transient_vertex_buffer_with_layout;
        if (Checks.CHECKS) {
            BGFXTransientVertexBuffer.validate(_tvb);
        }
        JNI.invokePV(_stream, _tvb, _startVertex, _numVertices, _layoutHandle, __functionAddress);
    }

    public static void bgfx_set_transient_vertex_buffer_with_layout(@NativeType(value="uint8_t") int _stream, @NativeType(value="bgfx_transient_vertex_buffer_t const *") BGFXTransientVertexBuffer _tvb, @NativeType(value="uint32_t") int _startVertex, @NativeType(value="uint32_t") int _numVertices, @NativeType(value="bgfx_vertex_layout_handle_t") short _layoutHandle) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transient_vertex_buffer_with_layout((byte)_stream, _tvb.address(), _startVertex, _numVertices, _layoutHandle);
    }

    public static void bgfx_set_vertex_count(@NativeType(value="uint32_t") int _numVertices) {
        long __functionAddress = Functions.set_vertex_count;
        JNI.invokeV(_numVertices, __functionAddress);
    }

    public static void nbgfx_set_instance_data_buffer(long _idb, int _start, int _num) {
        long __functionAddress = Functions.set_instance_data_buffer;
        if (Checks.CHECKS) {
            BGFXInstanceDataBuffer.validate(_idb);
        }
        JNI.invokePV(_idb, _start, _num, __functionAddress);
    }

    public static void bgfx_set_instance_data_buffer(@NativeType(value="bgfx_instance_data_buffer_t const *") BGFXInstanceDataBuffer _idb, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_instance_data_buffer(_idb.address(), _start, _num);
    }

    public static void bgfx_set_instance_data_from_vertex_buffer(@NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        long __functionAddress = Functions.set_instance_data_from_vertex_buffer;
        JNI.invokeV(_handle, _start, _num, __functionAddress);
    }

    public static void bgfx_set_instance_data_from_dynamic_vertex_buffer(@NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="uint32_t") int _start, @NativeType(value="uint32_t") int _num) {
        long __functionAddress = Functions.set_instance_data_from_dynamic_vertex_buffer;
        JNI.invokeV(_handle, _start, _num, __functionAddress);
    }

    public static void bgfx_set_instance_count(@NativeType(value="uint32_t") int _numInstances) {
        long __functionAddress = Functions.set_instance_count;
        JNI.invokeV(_numInstances, __functionAddress);
    }

    public static void nbgfx_set_texture(byte _stage, short _sampler, short _handle, int _flags) {
        long __functionAddress = Functions.set_texture;
        JNI.invokeV(_stage, _sampler, _handle, _flags, __functionAddress);
    }

    public static void bgfx_set_texture(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_uniform_handle_t") short _sampler, @NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint32_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_texture((byte)_stage, _sampler, _handle, _flags);
    }

    public static void nbgfx_touch(short _id) {
        long __functionAddress = Functions.touch;
        JNI.invokeV(_id, __functionAddress);
    }

    public static void bgfx_touch(@NativeType(value="bgfx_view_id_t") int _id) {
        org.lwjgl.bgfx.BGFX.nbgfx_touch((short)_id);
    }

    public static void nbgfx_submit(short _id, short _program, int _depth, byte _flags) {
        long __functionAddress = Functions.submit;
        JNI.invokeV(_id, _program, _depth, _flags, __functionAddress);
    }

    public static void bgfx_submit(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_submit((short)_id, _program, _depth, (byte)_flags);
    }

    public static void nbgfx_submit_occlusion_query(short _id, short _program, short _occlusionQuery, int _depth, byte _flags) {
        long __functionAddress = Functions.submit_occlusion_query;
        JNI.invokeV(_id, _program, _occlusionQuery, _depth, _flags, __functionAddress);
    }

    public static void bgfx_submit_occlusion_query(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="bgfx_occlusion_query_handle_t") short _occlusionQuery, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_submit_occlusion_query((short)_id, _program, _occlusionQuery, _depth, (byte)_flags);
    }

    public static void nbgfx_submit_indirect(short _id, short _program, short _indirectHandle, short _start, short _num, int _depth, byte _flags) {
        long __functionAddress = Functions.submit_indirect;
        JNI.invokeV(_id, _program, _indirectHandle, _start, _num, _depth, _flags, __functionAddress);
    }

    public static void bgfx_submit_indirect(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="bgfx_indirect_buffer_handle_t") short _indirectHandle, @NativeType(value="uint16_t") int _start, @NativeType(value="uint16_t") int _num, @NativeType(value="uint32_t") int _depth, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_submit_indirect((short)_id, _program, _indirectHandle, (short)_start, (short)_num, _depth, (byte)_flags);
    }

    public static void nbgfx_set_compute_index_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_index_buffer;
        JNI.invokeV(_stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_set_compute_index_buffer(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_index_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_index_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_vertex_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_vertex_buffer;
        JNI.invokeV(_stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_set_compute_vertex_buffer(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_vertex_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_vertex_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_dynamic_index_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_dynamic_index_buffer;
        JNI.invokeV(_stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_set_compute_dynamic_index_buffer(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_dynamic_index_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_dynamic_index_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_dynamic_vertex_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_dynamic_vertex_buffer;
        JNI.invokeV(_stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_set_compute_dynamic_vertex_buffer(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_dynamic_vertex_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_dynamic_vertex_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_indirect_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_indirect_buffer;
        JNI.invokeV(_stage, _handle, _access, __functionAddress);
    }

    public static void bgfx_set_compute_indirect_buffer(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_indirect_buffer_handle_t") short _handle, @NativeType(value="bgfx_access_t") int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_indirect_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_image(byte _stage, short _handle, byte _mip, int _access, int _format) {
        long __functionAddress = Functions.set_image;
        JNI.invokeV(_stage, _handle, _mip, _access, _format, __functionAddress);
    }

    public static void bgfx_set_image(@NativeType(value="uint8_t") int _stage, @NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint8_t") int _mip, @NativeType(value="bgfx_access_t") int _access, @NativeType(value="bgfx_texture_format_t") int _format) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_image((byte)_stage, _handle, (byte)_mip, _access, _format);
    }

    public static void nbgfx_dispatch(short _id, short _program, int _numX, int _numY, int _numZ, byte _flags) {
        long __functionAddress = Functions.dispatch;
        JNI.invokeV(_id, _program, _numX, _numY, _numZ, _flags, __functionAddress);
    }

    public static void bgfx_dispatch(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="uint32_t") int _numX, @NativeType(value="uint32_t") int _numY, @NativeType(value="uint32_t") int _numZ, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_dispatch((short)_id, _program, _numX, _numY, _numZ, (byte)_flags);
    }

    public static void nbgfx_dispatch_indirect(short _id, short _program, short _indirectHandle, short _start, short _num, byte _flags) {
        long __functionAddress = Functions.dispatch_indirect;
        JNI.invokeV(_id, _program, _indirectHandle, _start, _num, _flags, __functionAddress);
    }

    public static void bgfx_dispatch_indirect(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_program_handle_t") short _program, @NativeType(value="bgfx_indirect_buffer_handle_t") short _indirectHandle, @NativeType(value="uint16_t") int _start, @NativeType(value="uint16_t") int _num, @NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_dispatch_indirect((short)_id, _program, _indirectHandle, (short)_start, (short)_num, (byte)_flags);
    }

    public static void nbgfx_discard(byte _flags) {
        long __functionAddress = Functions.discard;
        JNI.invokeV(_flags, __functionAddress);
    }

    public static void bgfx_discard(@NativeType(value="uint8_t") int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_discard((byte)_flags);
    }

    public static void nbgfx_blit(short _id, short _dst, byte _dstMip, short _dstX, short _dstY, short _dstZ, short _src, byte _srcMip, short _srcX, short _srcY, short _srcZ, short _width, short _height, short _depth) {
        long __functionAddress = Functions.blit;
        JNI.invokeV(_id, _dst, _dstMip, _dstX, _dstY, _dstZ, _src, _srcMip, _srcX, _srcY, _srcZ, _width, _height, _depth, __functionAddress);
    }

    public static void bgfx_blit(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="bgfx_texture_handle_t") short _dst, @NativeType(value="uint8_t") int _dstMip, @NativeType(value="uint16_t") int _dstX, @NativeType(value="uint16_t") int _dstY, @NativeType(value="uint16_t") int _dstZ, @NativeType(value="bgfx_texture_handle_t") short _src, @NativeType(value="uint8_t") int _srcMip, @NativeType(value="uint16_t") int _srcX, @NativeType(value="uint16_t") int _srcY, @NativeType(value="uint16_t") int _srcZ, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint16_t") int _depth) {
        org.lwjgl.bgfx.BGFX.nbgfx_blit((short)_id, _dst, (byte)_dstMip, (short)_dstX, (short)_dstY, (short)_dstZ, _src, (byte)_srcMip, (short)_srcX, (short)_srcY, (short)_srcZ, (short)_width, (short)_height, (short)_depth);
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_ALPHA_REF(@NativeType(value="uint64_t") long _ref) {
        return _ref << 40 & 0xFF0000000000L;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_POINT_SIZE(@NativeType(value="uint64_t") long _size) {
        return _size << 52 & 0xF0000000000000L;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_SEPARATE(@NativeType(value="uint64_t") long _srcRGB, @NativeType(value="uint64_t") long _dstRGB, @NativeType(value="uint64_t") long _srcA, @NativeType(value="uint64_t") long _dstA) {
        return _srcRGB | _dstRGB << 4 | (_srcA | _dstA << 4) << 8;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_EQUATION_SEPARATE(@NativeType(value="uint64_t") long _rgb, @NativeType(value="uint64_t") long _a) {
        return _rgb | _a << 3;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_SEPARATE(_src, _dst, _src, _dst);
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_EQUATION(@NativeType(value="uint64_t") long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION_SEPARATE(_equation, _equation);
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_x(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst) {
        return _src >> 12 | _dst >> 12 << 4;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_xE(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst, @NativeType(value="uint64_t") long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) | _equation >> 28 << 8;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_1(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 0;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_2(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 11;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_3(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 22;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_1E(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst, @NativeType(value="uint64_t") long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 0;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_2E(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst, @NativeType(value="uint64_t") long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 11;
    }

    @NativeType(value="uint64_t")
    public static long BGFX_STATE_BLEND_FUNC_RT_3E(@NativeType(value="uint64_t") long _src, @NativeType(value="uint64_t") long _dst, @NativeType(value="uint64_t") long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 22;
    }

    @NativeType(value="uint32_t")
    public static int BGFX_STENCIL_FUNC_REF(@NativeType(value="uint32_t") int _ref) {
        return _ref << 0 & 0xFF;
    }

    @NativeType(value="uint32_t")
    public static int BGFX_STENCIL_FUNC_RMASK(@NativeType(value="uint32_t") int _mask) {
        return _mask << 8 & 0xFF00;
    }

    @NativeType(value="uint32_t")
    public static int BGFX_SAMPLER_BORDER_COLOR(@NativeType(value="uint32_t") int _index) {
        return _index << 24 & 0xF000000;
    }

    @NativeType(value="bool")
    public static boolean BGFX_HANDLE_IS_VALID(@NativeType(value="uint16_t") short h) {
        return Short.toUnsignedInt(h) != 65535;
    }

    public static void bgfx_vertex_layout_decode(@NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _this, @NativeType(value="bgfx_attrib_t") int _attrib, @NativeType(value="uint8_t *") ByteBuffer _num, @NativeType(value="bgfx_attrib_type_t *") int[] _type, @NativeType(value="bool *") ByteBuffer _normalized, @NativeType(value="bool *") ByteBuffer _asInt) {
        long __functionAddress = Functions.vertex_layout_decode;
        if (Checks.CHECKS) {
            Checks.check((Buffer)_num, 1);
            Checks.check(_type, 1);
            Checks.check((Buffer)_normalized, 1);
            Checks.check((Buffer)_asInt, 1);
        }
        JNI.invokePPPPPV(_this.address(), _attrib, MemoryUtil.memAddress(_num), _type, MemoryUtil.memAddress(_normalized), MemoryUtil.memAddress(_asInt), __functionAddress);
    }

    public static void bgfx_vertex_pack(@NativeType(value="float const *") float[] _input, @NativeType(value="bool") boolean _inputNormalized, @NativeType(value="bgfx_attrib_t") int _attr, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void *") ByteBuffer _data, @NativeType(value="uint32_t") int _index) {
        long __functionAddress = Functions.vertex_pack;
        if (Checks.CHECKS) {
            Checks.check(_input, 4);
        }
        JNI.invokePPPV(_input, _inputNormalized, _attr, _layout.address(), MemoryUtil.memAddress(_data), _index, __functionAddress);
    }

    public static void bgfx_vertex_unpack(@NativeType(value="float *") float[] _output, @NativeType(value="bgfx_attrib_t") int _attr, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="uint32_t") int _index) {
        long __functionAddress = Functions.vertex_unpack;
        if (Checks.CHECKS) {
            Checks.check(_output, 4);
        }
        JNI.invokePPPV(_output, _attr, _layout.address(), MemoryUtil.memAddress(_data), _index, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_weld_vertices(@NativeType(value="void *") short[] _output, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bool") boolean _index32, float _epsilon) {
        long __functionAddress = Functions.weld_vertices;
        return JNI.invokePPPI(_output, _layout.address(), MemoryUtil.memAddress(_data), _output.length, _index32, _epsilon, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_weld_vertices(@NativeType(value="void *") int[] _output, @NativeType(value="bgfx_vertex_layout_t const *") BGFXVertexLayout _layout, @NativeType(value="void const *") ByteBuffer _data, @NativeType(value="bool") boolean _index32, float _epsilon) {
        long __functionAddress = Functions.weld_vertices;
        return JNI.invokePPPI(_output, _layout.address(), MemoryUtil.memAddress(_data), _output.length, _index32, _epsilon, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_topology_convert(@NativeType(value="bgfx_topology_convert_t") int _conversion, @Nullable @NativeType(value="void *") short[] _dst, @NativeType(value="void const *") short[] _indices, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(_conversion, _dst, Checks.lengthSafe(_dst) << 1, _indices, _indices.length, _index32, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_topology_convert(@NativeType(value="bgfx_topology_convert_t") int _conversion, @Nullable @NativeType(value="void *") int[] _dst, @NativeType(value="void const *") int[] _indices, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(_conversion, _dst, Checks.lengthSafe(_dst) << 2, _indices, _indices.length, _index32, __functionAddress);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") ByteBuffer _dst, @NativeType(value="float const *") float[] _dir, @NativeType(value="float const *") float[] _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") ByteBuffer _indices, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
        }
        JNI.invokePPPPPV(_sort, MemoryUtil.memAddress(_dst), _dst.remaining(), _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _indices.remaining() >> (_index32 ? 2 : 1), _index32, __functionAddress);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") short[] _dst, @NativeType(value="float const *") float[] _dir, @NativeType(value="float const *") float[] _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") short[] _indices, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
        }
        JNI.invokePPPPPV(_sort, _dst, _dst.length << 1, _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, _indices, _indices.length, _index32, __functionAddress);
    }

    public static void bgfx_topology_sort_tri_list(@NativeType(value="bgfx_topology_sort_t") int _sort, @NativeType(value="void *") int[] _dst, @NativeType(value="float const *") float[] _dir, @NativeType(value="float const *") float[] _pos, @NativeType(value="void const *") ByteBuffer _vertices, @NativeType(value="uint32_t") int _stride, @NativeType(value="void const *") int[] _indices, @NativeType(value="bool") boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
        }
        JNI.invokePPPPPV(_sort, _dst, _dst.length << 2, _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, _indices, _indices.length, _index32, __functionAddress);
    }

    @NativeType(value="uint8_t")
    public static byte bgfx_get_supported_renderers(@NativeType(value="bgfx_renderer_type_t *") int[] _enum) {
        long __functionAddress = Functions.get_supported_renderers;
        return JNI.invokePB((byte)_enum.length, _enum, __functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") short[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(_data, _data.length << 1, __functionAddress);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") int[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(_data, _data.length << 2, __functionAddress);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") long[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(_data, _data.length << 3, __functionAddress);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") float[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(_data, _data.length << 2, __functionAddress);
        return BGFXMemory.createSafe(__result);
    }

    @Nullable
    @NativeType(value="bgfx_memory_t const *")
    public static BGFXMemory bgfx_copy(@NativeType(value="void const *") double[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(_data, _data.length << 3, __functionAddress);
        return BGFXMemory.createSafe(__result);
    }

    @NativeType(value="uint16_t")
    public static short bgfx_get_shader_uniforms(@NativeType(value="bgfx_shader_handle_t") short _handle, @NativeType(value="bgfx_uniform_handle_t *") short[] _uniforms) {
        long __functionAddress = Functions.get_shader_uniforms;
        return JNI.invokePS(_handle, _uniforms, (short)_uniforms.length, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") short[] _data, @NativeType(value="uint8_t") int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(_handle, _data, (byte)_mip, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") int[] _data, @NativeType(value="uint8_t") int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(_handle, _data, (byte)_mip, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_read_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="void *") float[] _data, @NativeType(value="uint8_t") int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(_handle, _data, (byte)_mip, __functionAddress);
    }

    @NativeType(value="bgfx_frame_buffer_handle_t")
    public static short bgfx_create_frame_buffer_from_handles(@NativeType(value="bgfx_texture_handle_t const *") short[] _handles, @NativeType(value="bool") boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_handles;
        return JNI.invokePS((byte)_handles.length, _handles, _destroyTextures, __functionAddress);
    }

    @NativeType(value="bgfx_occlusion_query_result_t")
    public static int bgfx_get_result(@NativeType(value="bgfx_occlusion_query_handle_t") short _handle, @Nullable @NativeType(value="int32_t *") int[] _result) {
        long __functionAddress = Functions.get_result;
        if (Checks.CHECKS) {
            Checks.checkSafe(_result, 1);
        }
        return JNI.invokePI(_handle, _result, __functionAddress);
    }

    public static void bgfx_set_palette_color(@NativeType(value="uint8_t") int _index, @NativeType(value="float const *") float[] _rgba) {
        long __functionAddress = Functions.set_palette_color;
        if (Checks.CHECKS) {
            Checks.check(_rgba, 4);
        }
        JNI.invokePV((byte)_index, _rgba, __functionAddress);
    }

    public static void bgfx_set_view_transform(@NativeType(value="bgfx_view_id_t") int _id, @Nullable @NativeType(value="void const *") float[] _view, @Nullable @NativeType(value="void const *") float[] _proj) {
        long __functionAddress = Functions.set_view_transform;
        if (Checks.CHECKS) {
            Checks.checkSafe(_view, 16);
            Checks.checkSafe(_proj, 16);
        }
        JNI.invokePPV((short)_id, _view, _proj, __functionAddress);
    }

    public static void bgfx_set_view_order(@NativeType(value="bgfx_view_id_t") int _id, @NativeType(value="uint16_t") int _num, @Nullable @NativeType(value="bgfx_view_id_t const *") short[] _order) {
        long __functionAddress = Functions.set_view_order;
        if (Checks.CHECKS) {
            Checks.checkSafe(_order, _num);
        }
        JNI.invokePV((short)_id, (short)_num, _order, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_encoder_set_transform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="void const *") float[] _mtx) {
        long __functionAddress = Functions.encoder_set_transform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        return JNI.invokePPI(_this, _mtx, (short)(_mtx.length >> 4), __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") short[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") int[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") long[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") float[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_encoder_set_uniform(@NativeType(value="struct bgfx_encoder_s *") long _this, @NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") double[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.encoder_set_uniform;
        if (Checks.CHECKS) {
            Checks.check(_this);
        }
        JNI.invokePPV(_this, _handle, _value, (short)_num, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int bgfx_set_transform(@NativeType(value="void const *") float[] _mtx) {
        long __functionAddress = Functions.set_transform;
        return JNI.invokePI(_mtx, (short)(_mtx.length >> 4), __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") short[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") int[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") long[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") float[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, (short)_num, __functionAddress);
    }

    public static void bgfx_set_uniform(@NativeType(value="bgfx_uniform_handle_t") short _handle, @NativeType(value="void const *") double[] _value, @NativeType(value="uint16_t") int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(_handle, _value, (short)_num, __functionAddress);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return BGFX;
    }

    public static final class Functions {
        public static final long attachment_init = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_attachment_init");
        public static final long vertex_layout_begin = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_begin");
        public static final long vertex_layout_add = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_add");
        public static final long vertex_layout_decode = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_decode");
        public static final long vertex_layout_has = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_has");
        public static final long vertex_layout_skip = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_skip");
        public static final long vertex_layout_end = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_layout_end");
        public static final long vertex_pack = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_pack");
        public static final long vertex_unpack = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_unpack");
        public static final long vertex_convert = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_convert");
        public static final long weld_vertices = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_weld_vertices");
        public static final long topology_convert = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_topology_convert");
        public static final long topology_sort_tri_list = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_topology_sort_tri_list");
        public static final long get_supported_renderers = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_supported_renderers");
        public static final long get_renderer_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_renderer_name");
        public static final long init_ctor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_init_ctor");
        public static final long init = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_init");
        public static final long shutdown = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_shutdown");
        public static final long reset = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_reset");
        public static final long frame = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_frame");
        public static final long get_renderer_type = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_renderer_type");
        public static final long get_caps = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_caps");
        public static final long get_stats = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_stats");
        public static final long alloc = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc");
        public static final long copy = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_copy");
        public static final long make_ref = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_make_ref");
        public static final long make_ref_release = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_make_ref_release");
        public static final long set_debug = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_debug");
        public static final long dbg_text_clear = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_clear");
        public static final long dbg_text_printf = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_printf");
        public static final long dbg_text_vprintf = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_vprintf");
        public static final long dbg_text_image = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_image");
        public static final long create_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_index_buffer");
        public static final long set_index_buffer_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_index_buffer_name");
        public static final long destroy_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_index_buffer");
        public static final long create_vertex_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_vertex_layout");
        public static final long destroy_vertex_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_vertex_layout");
        public static final long create_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_vertex_buffer");
        public static final long set_vertex_buffer_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_vertex_buffer_name");
        public static final long destroy_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_vertex_buffer");
        public static final long create_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_index_buffer");
        public static final long create_dynamic_index_buffer_mem = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_index_buffer_mem");
        public static final long update_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_dynamic_index_buffer");
        public static final long destroy_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_dynamic_index_buffer");
        public static final long create_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_vertex_buffer");
        public static final long create_dynamic_vertex_buffer_mem = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_vertex_buffer_mem");
        public static final long update_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_dynamic_vertex_buffer");
        public static final long destroy_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_dynamic_vertex_buffer");
        public static final long get_avail_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_transient_index_buffer");
        public static final long get_avail_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_transient_vertex_buffer");
        public static final long get_avail_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_instance_data_buffer");
        public static final long alloc_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_index_buffer");
        public static final long alloc_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_vertex_buffer");
        public static final long alloc_transient_buffers = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_buffers");
        public static final long alloc_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_instance_data_buffer");
        public static final long create_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_indirect_buffer");
        public static final long destroy_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_indirect_buffer");
        public static final long create_shader = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_shader");
        public static final long get_shader_uniforms = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_shader_uniforms");
        public static final long set_shader_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_shader_name");
        public static final long destroy_shader = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_shader");
        public static final long create_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_program");
        public static final long create_compute_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_compute_program");
        public static final long destroy_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_program");
        public static final long is_texture_valid = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_is_texture_valid");
        public static final long is_frame_buffer_valid = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_is_frame_buffer_valid");
        public static final long calc_texture_size = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_calc_texture_size");
        public static final long create_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture");
        public static final long create_texture_2d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_2d");
        public static final long create_texture_2d_scaled = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_2d_scaled");
        public static final long create_texture_3d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_3d");
        public static final long create_texture_cube = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_cube");
        public static final long update_texture_2d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_2d");
        public static final long update_texture_3d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_3d");
        public static final long update_texture_cube = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_cube");
        public static final long read_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_read_texture");
        public static final long set_texture_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_texture_name");
        public static final long get_direct_access_ptr = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_direct_access_ptr");
        public static final long destroy_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_texture");
        public static final long create_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer");
        public static final long create_frame_buffer_scaled = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_scaled");
        public static final long create_frame_buffer_from_handles = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_handles");
        public static final long create_frame_buffer_from_attachment = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_attachment");
        public static final long create_frame_buffer_from_nwh = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_nwh");
        public static final long set_frame_buffer_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_frame_buffer_name");
        public static final long get_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_texture");
        public static final long destroy_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_frame_buffer");
        public static final long create_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_uniform");
        public static final long get_uniform_info = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_uniform_info");
        public static final long destroy_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_uniform");
        public static final long create_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_occlusion_query");
        public static final long get_result = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_result");
        public static final long destroy_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_occlusion_query");
        public static final long set_palette_color = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_palette_color");
        public static final long set_palette_color_rgba8 = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_palette_color_rgba8");
        public static final long set_view_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_name");
        public static final long set_view_rect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_rect");
        public static final long set_view_rect_ratio = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_rect_ratio");
        public static final long set_view_scissor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_scissor");
        public static final long set_view_clear = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_clear");
        public static final long set_view_clear_mrt = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_clear_mrt");
        public static final long set_view_mode = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_mode");
        public static final long set_view_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_frame_buffer");
        public static final long set_view_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_transform");
        public static final long set_view_order = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_order");
        public static final long reset_view = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_reset_view");
        public static final long encoder_begin = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_begin");
        public static final long encoder_end = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_end");
        public static final long encoder_set_marker = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_marker");
        public static final long encoder_set_state = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_state");
        public static final long encoder_set_condition = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_condition");
        public static final long encoder_set_stencil = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_stencil");
        public static final long encoder_set_scissor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_scissor");
        public static final long encoder_set_scissor_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_scissor_cached");
        public static final long encoder_set_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_transform");
        public static final long encoder_set_transform_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_transform_cached");
        public static final long encoder_alloc_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_alloc_transform");
        public static final long encoder_set_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_uniform");
        public static final long encoder_set_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_index_buffer");
        public static final long encoder_set_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_dynamic_index_buffer");
        public static final long encoder_set_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_transient_index_buffer");
        public static final long encoder_set_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_vertex_buffer");
        public static final long encoder_set_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_vertex_buffer_with_layout");
        public static final long encoder_set_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_dynamic_vertex_buffer");
        public static final long encoder_set_dynamic_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_dynamic_vertex_buffer_with_layout");
        public static final long encoder_set_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_transient_vertex_buffer");
        public static final long encoder_set_transient_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_transient_vertex_buffer_with_layout");
        public static final long encoder_set_vertex_count = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_vertex_count");
        public static final long encoder_set_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_instance_data_buffer");
        public static final long encoder_set_instance_data_from_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_instance_data_from_vertex_buffer");
        public static final long encoder_set_instance_data_from_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_instance_data_from_dynamic_vertex_buffer");
        public static final long encoder_set_instance_count = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_instance_count");
        public static final long encoder_set_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_texture");
        public static final long encoder_touch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_touch");
        public static final long encoder_submit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_submit");
        public static final long encoder_submit_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_submit_occlusion_query");
        public static final long encoder_submit_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_submit_indirect");
        public static final long encoder_set_compute_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_compute_index_buffer");
        public static final long encoder_set_compute_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_compute_vertex_buffer");
        public static final long encoder_set_compute_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_compute_dynamic_index_buffer");
        public static final long encoder_set_compute_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_compute_dynamic_vertex_buffer");
        public static final long encoder_set_compute_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_compute_indirect_buffer");
        public static final long encoder_set_image = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_set_image");
        public static final long encoder_dispatch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_dispatch");
        public static final long encoder_dispatch_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_dispatch_indirect");
        public static final long encoder_discard = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_discard");
        public static final long encoder_blit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_encoder_blit");
        public static final long request_screen_shot = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_request_screen_shot");
        public static final long set_marker = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_marker");
        public static final long set_state = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_state");
        public static final long set_condition = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_condition");
        public static final long set_stencil = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_stencil");
        public static final long set_scissor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_scissor");
        public static final long set_scissor_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_scissor_cached");
        public static final long set_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transform");
        public static final long set_transform_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transform_cached");
        public static final long alloc_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transform");
        public static final long set_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_uniform");
        public static final long set_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_index_buffer");
        public static final long set_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_dynamic_index_buffer");
        public static final long set_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transient_index_buffer");
        public static final long set_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_vertex_buffer");
        public static final long set_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_vertex_buffer_with_layout");
        public static final long set_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_dynamic_vertex_buffer");
        public static final long set_dynamic_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_dynamic_vertex_buffer_with_layout");
        public static final long set_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transient_vertex_buffer");
        public static final long set_transient_vertex_buffer_with_layout = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transient_vertex_buffer_with_layout");
        public static final long set_vertex_count = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_vertex_count");
        public static final long set_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_buffer");
        public static final long set_instance_data_from_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_from_vertex_buffer");
        public static final long set_instance_data_from_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_from_dynamic_vertex_buffer");
        public static final long set_instance_count = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_count");
        public static final long set_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_texture");
        public static final long touch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_touch");
        public static final long submit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit");
        public static final long submit_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit_occlusion_query");
        public static final long submit_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit_indirect");
        public static final long set_compute_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_index_buffer");
        public static final long set_compute_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_vertex_buffer");
        public static final long set_compute_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_dynamic_index_buffer");
        public static final long set_compute_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_dynamic_vertex_buffer");
        public static final long set_compute_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_indirect_buffer");
        public static final long set_image = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_image");
        public static final long dispatch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dispatch");
        public static final long dispatch_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dispatch_indirect");
        public static final long discard = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_discard");
        public static final long blit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_blit");

        private Functions() {
        }
    }
}

