/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY_DESCRIPTOR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int FORMAT;
    public static final int NUMCHANNELS;

    public CUDA_ARRAY_DESCRIPTOR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_ARRAY_DESCRIPTOR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long Width() {
        return CUDA_ARRAY_DESCRIPTOR.nWidth(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_ARRAY_DESCRIPTOR.nHeight(this.address());
    }

    @NativeType(value="CUarray_format")
    public int Format() {
        return CUDA_ARRAY_DESCRIPTOR.nFormat(this.address());
    }

    @NativeType(value="unsigned int")
    public int NumChannels() {
        return CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address());
    }

    public CUDA_ARRAY_DESCRIPTOR Width(@NativeType(value="size_t") long value) {
        CUDA_ARRAY_DESCRIPTOR.nWidth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR Height(@NativeType(value="size_t") long value) {
        CUDA_ARRAY_DESCRIPTOR.nHeight(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR Format(@NativeType(value="CUarray_format") int value) {
        CUDA_ARRAY_DESCRIPTOR.nFormat(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR NumChannels(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR set(long Width, long Height, int Format, int NumChannels) {
        this.Width(Width);
        this.Height(Height);
        this.Format(Format);
        this.NumChannels(NumChannels);
        return this;
    }

    public CUDA_ARRAY_DESCRIPTOR set(CUDA_ARRAY_DESCRIPTOR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_ARRAY_DESCRIPTOR malloc() {
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUDA_ARRAY_DESCRIPTOR calloc() {
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUDA_ARRAY_DESCRIPTOR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, MemoryUtil.memAddress(container), container);
    }

    public static CUDA_ARRAY_DESCRIPTOR create(long address) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, address);
    }

    @Nullable
    public static CUDA_ARRAY_DESCRIPTOR createSafe(long address) {
        return address == 0L ? null : CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUDA_ARRAY_DESCRIPTOR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY_DESCRIPTOR.__create(capacity, SIZEOF);
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR mallocStack() {
        return CUDA_ARRAY_DESCRIPTOR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR callocStack() {
        return CUDA_ARRAY_DESCRIPTOR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR mallocStack(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(stack);
    }

    @Deprecated
    public static CUDA_ARRAY_DESCRIPTOR callocStack(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.calloc(capacity, stack);
    }

    public static CUDA_ARRAY_DESCRIPTOR malloc(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_ARRAY_DESCRIPTOR calloc(MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(CUDA_ARRAY_DESCRIPTOR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_DESCRIPTOR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nWidth(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WIDTH);
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HEIGHT);
    }

    public static int nFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nNumChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMCHANNELS);
    }

    public static void nWidth(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTH, value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HEIGHT, value);
    }

    public static void nFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nNumChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMCHANNELS, value);
    }

    static {
        Struct.Layout layout = CUDA_ARRAY_DESCRIPTOR.__struct(CUDA_ARRAY_DESCRIPTOR.__member(POINTER_SIZE), CUDA_ARRAY_DESCRIPTOR.__member(POINTER_SIZE), CUDA_ARRAY_DESCRIPTOR.__member(4), CUDA_ARRAY_DESCRIPTOR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        NUMCHANNELS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY_DESCRIPTOR, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY_DESCRIPTOR ELEMENT_FACTORY = CUDA_ARRAY_DESCRIPTOR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUDA_ARRAY_DESCRIPTOR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long Width() {
            return CUDA_ARRAY_DESCRIPTOR.nWidth(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_ARRAY_DESCRIPTOR.nHeight(this.address());
        }

        @NativeType(value="CUarray_format")
        public int Format() {
            return CUDA_ARRAY_DESCRIPTOR.nFormat(this.address());
        }

        @NativeType(value="unsigned int")
        public int NumChannels() {
            return CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address());
        }

        public Buffer Width(@NativeType(value="size_t") long value) {
            CUDA_ARRAY_DESCRIPTOR.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_ARRAY_DESCRIPTOR.nHeight(this.address(), value);
            return this;
        }

        public Buffer Format(@NativeType(value="CUarray_format") int value) {
            CUDA_ARRAY_DESCRIPTOR.nFormat(this.address(), value);
            return this;
        }

        public Buffer NumChannels(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_DESCRIPTOR.nNumChannels(this.address(), value);
            return this;
        }
    }
}

