/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY_SPARSE_PROPERTIES
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TILEEXTENT;
    public static final int TILEEXTENT_WIDTH;
    public static final int TILEEXTENT_HEIGHT;
    public static final int TILEEXTENT_DEPTH;
    public static final int MIPTAILFIRSTLEVEL;
    public static final int MIPTAILSIZE;
    public static final int FLAGS;
    public static final int RESERVED;

    public CUDA_ARRAY_SPARSE_PROPERTIES(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_ARRAY_SPARSE_PROPERTIES.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int tileExtent_width() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address());
    }

    @NativeType(value="unsigned int")
    public int tileExtent_height() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address());
    }

    @NativeType(value="unsigned int")
    public int tileExtent_depth() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address());
    }

    @NativeType(value="unsigned int")
    public int miptailFirstLevel() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address());
    }

    @NativeType(value="unsigned long long")
    public long miptailSize() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address());
    }

    @NativeType(value="unsigned int[4]")
    public IntBuffer reserved() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index);
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_width(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_height(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_depth(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES miptailFirstLevel(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES miptailSize(@NativeType(value="unsigned long long") long value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES flags(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES reserved(@NativeType(value="unsigned int[4]") IntBuffer value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES reserved(int index, @NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES set(int tileExtent_width, int tileExtent_height, int tileExtent_depth, int miptailFirstLevel, long miptailSize, int flags, IntBuffer reserved) {
        this.tileExtent_width(tileExtent_width);
        this.tileExtent_height(tileExtent_height);
        this.tileExtent_depth(tileExtent_depth);
        this.miptailFirstLevel(miptailFirstLevel);
        this.miptailSize(miptailSize);
        this.flags(flags);
        this.reserved(reserved);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES set(CUDA_ARRAY_SPARSE_PROPERTIES src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES malloc() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES calloc() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, MemoryUtil.memAddress(container), container);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES create(long address) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, address);
    }

    @Nullable
    public static CUDA_ARRAY_SPARSE_PROPERTIES createSafe(long address) {
        return address == 0L ? null : CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUDA_ARRAY_SPARSE_PROPERTIES.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY_SPARSE_PROPERTIES.__create(capacity, SIZEOF);
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, address, capacity);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES malloc(MemoryStack stack) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES calloc(MemoryStack stack) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(CUDA_ARRAY_SPARSE_PROPERTIES.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntileExtent_width(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILEEXTENT_WIDTH);
    }

    public static int ntileExtent_height(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILEEXTENT_HEIGHT);
    }

    public static int ntileExtent_depth(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILEEXTENT_DEPTH);
    }

    public static int nmiptailFirstLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPTAILFIRSTLEVEL);
    }

    public static long nmiptailSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MIPTAILSIZE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 4);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check(index, 4) * 4L);
    }

    public static void ntileExtent_width(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILEEXTENT_WIDTH, value);
    }

    public static void ntileExtent_height(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILEEXTENT_HEIGHT, value);
    }

    public static void ntileExtent_depth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILEEXTENT_DEPTH, value);
    }

    public static void nmiptailFirstLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPTAILFIRSTLEVEL, value);
    }

    public static void nmiptailSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MIPTAILSIZE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check(index, 4) * 4L, value);
    }

    static {
        Struct.Layout layout = CUDA_ARRAY_SPARSE_PROPERTIES.__struct(CUDA_ARRAY_SPARSE_PROPERTIES.__struct(CUDA_ARRAY_SPARSE_PROPERTIES.__member(4), CUDA_ARRAY_SPARSE_PROPERTIES.__member(4), CUDA_ARRAY_SPARSE_PROPERTIES.__member(4)), CUDA_ARRAY_SPARSE_PROPERTIES.__member(4), CUDA_ARRAY_SPARSE_PROPERTIES.__member(8), CUDA_ARRAY_SPARSE_PROPERTIES.__member(4), CUDA_ARRAY_SPARSE_PROPERTIES.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TILEEXTENT = layout.offsetof(0);
        TILEEXTENT_WIDTH = layout.offsetof(1);
        TILEEXTENT_HEIGHT = layout.offsetof(2);
        TILEEXTENT_DEPTH = layout.offsetof(3);
        MIPTAILFIRSTLEVEL = layout.offsetof(4);
        MIPTAILSIZE = layout.offsetof(5);
        FLAGS = layout.offsetof(6);
        RESERVED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY_SPARSE_PROPERTIES, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY_SPARSE_PROPERTIES ELEMENT_FACTORY = CUDA_ARRAY_SPARSE_PROPERTIES.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUDA_ARRAY_SPARSE_PROPERTIES getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int tileExtent_width() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address());
        }

        @NativeType(value="unsigned int")
        public int tileExtent_height() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address());
        }

        @NativeType(value="unsigned int")
        public int tileExtent_depth() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address());
        }

        @NativeType(value="unsigned int")
        public int miptailFirstLevel() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address());
        }

        @NativeType(value="unsigned long long")
        public long miptailSize() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address());
        }

        @NativeType(value="unsigned int[4]")
        public IntBuffer reserved() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index);
        }

        public Buffer tileExtent_width(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address(), value);
            return this;
        }

        public Buffer tileExtent_height(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address(), value);
            return this;
        }

        public Buffer tileExtent_depth(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address(), value);
            return this;
        }

        public Buffer miptailFirstLevel(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address(), value);
            return this;
        }

        public Buffer miptailSize(@NativeType(value="unsigned long long") long value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[4]") IntBuffer value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index, value);
            return this;
        }
    }
}

