/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_RESOURCE_DESC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESTYPE;
    public static final int RES;
    public static final int RES_ARRAY;
    public static final int RES_ARRAY_HARRAY;
    public static final int RES_MIPMAP;
    public static final int RES_MIPMAP_HMIPMAPPEDARRAY;
    public static final int RES_LINEAR;
    public static final int RES_LINEAR_DEVPTR;
    public static final int RES_LINEAR_FORMAT;
    public static final int RES_LINEAR_NUMCHANNELS;
    public static final int RES_LINEAR_SIZEINBYTES;
    public static final int RES_PITCH2D;
    public static final int RES_PITCH2D_DEVPTR;
    public static final int RES_PITCH2D_FORMAT;
    public static final int RES_PITCH2D_NUMCHANNELS;
    public static final int RES_PITCH2D_WIDTH;
    public static final int RES_PITCH2D_HEIGHT;
    public static final int RES_PITCH2D_PITCHINBYTES;
    public static final int RES_RESERVED;
    public static final int RES_RESERVED_RESERVED;
    public static final int FLAGS;

    public CUDA_RESOURCE_DESC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_RESOURCE_DESC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUresourcetype")
    public int resType() {
        return CUDA_RESOURCE_DESC.nresType(this.address());
    }

    @NativeType(value="CUarray")
    public long res_array_hArray() {
        return CUDA_RESOURCE_DESC.nres_array_hArray(this.address());
    }

    @NativeType(value="CUmipmappedArray")
    public long res_mipmap_hMipmappedArray() {
        return CUDA_RESOURCE_DESC.nres_mipmap_hMipmappedArray(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long res_linear_devPtr() {
        return CUDA_RESOURCE_DESC.nres_linear_devPtr(this.address());
    }

    @NativeType(value="CUarray_format")
    public int res_linear_format() {
        return CUDA_RESOURCE_DESC.nres_linear_format(this.address());
    }

    @NativeType(value="unsigned int")
    public int res_linear_numChannels() {
        return CUDA_RESOURCE_DESC.nres_linear_numChannels(this.address());
    }

    @NativeType(value="size_t")
    public long res_linear_sizeInBytes() {
        return CUDA_RESOURCE_DESC.nres_linear_sizeInBytes(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long res_pitch2D_devPtr() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_devPtr(this.address());
    }

    @NativeType(value="CUarray_format")
    public int res_pitch2D_format() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_format(this.address());
    }

    @NativeType(value="unsigned int")
    public int res_pitch2D_numChannels() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_numChannels(this.address());
    }

    @NativeType(value="size_t")
    public long res_pitch2D_width() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_width(this.address());
    }

    @NativeType(value="size_t")
    public long res_pitch2D_height() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_height(this.address());
    }

    @NativeType(value="size_t")
    public long res_pitch2D_pitchInBytes() {
        return CUDA_RESOURCE_DESC.nres_pitch2D_pitchInBytes(this.address());
    }

    @NativeType(value="int[32]")
    public IntBuffer res_reserved_reserved() {
        return CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address());
    }

    public int res_reserved_reserved(int index) {
        return CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), index);
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_RESOURCE_DESC.nflags(this.address());
    }

    public CUDA_RESOURCE_DESC resType(@NativeType(value="CUresourcetype") int value) {
        CUDA_RESOURCE_DESC.nresType(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_array_hArray(@NativeType(value="CUarray") long value) {
        CUDA_RESOURCE_DESC.nres_array_hArray(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_mipmap_hMipmappedArray(@NativeType(value="CUmipmappedArray") long value) {
        CUDA_RESOURCE_DESC.nres_mipmap_hMipmappedArray(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_linear_devPtr(@NativeType(value="CUdeviceptr") long value) {
        CUDA_RESOURCE_DESC.nres_linear_devPtr(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_linear_format(@NativeType(value="CUarray_format") int value) {
        CUDA_RESOURCE_DESC.nres_linear_format(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_linear_numChannels(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_DESC.nres_linear_numChannels(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_linear_sizeInBytes(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_DESC.nres_linear_sizeInBytes(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_devPtr(@NativeType(value="CUdeviceptr") long value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_devPtr(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_format(@NativeType(value="CUarray_format") int value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_format(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_numChannels(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_numChannels(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_width(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_width(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_height(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_height(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_pitch2D_pitchInBytes(@NativeType(value="size_t") long value) {
        CUDA_RESOURCE_DESC.nres_pitch2D_pitchInBytes(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_reserved_reserved(@NativeType(value="int[32]") IntBuffer value) {
        CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC res_reserved_reserved(int index, int value) {
        CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), index, value);
        return this;
    }

    public CUDA_RESOURCE_DESC flags(@NativeType(value="unsigned int") int value) {
        CUDA_RESOURCE_DESC.nflags(this.address(), value);
        return this;
    }

    public CUDA_RESOURCE_DESC set(CUDA_RESOURCE_DESC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_RESOURCE_DESC malloc() {
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUDA_RESOURCE_DESC calloc() {
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUDA_RESOURCE_DESC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, MemoryUtil.memAddress(container), container);
    }

    public static CUDA_RESOURCE_DESC create(long address) {
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, address);
    }

    @Nullable
    public static CUDA_RESOURCE_DESC createSafe(long address) {
        return address == 0L ? null : CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUDA_RESOURCE_DESC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_RESOURCE_DESC.__create(capacity, SIZEOF);
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUDA_RESOURCE_DESC.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CUDA_RESOURCE_DESC mallocStack() {
        return CUDA_RESOURCE_DESC.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_RESOURCE_DESC callocStack() {
        return CUDA_RESOURCE_DESC.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_RESOURCE_DESC mallocStack(MemoryStack stack) {
        return CUDA_RESOURCE_DESC.malloc(stack);
    }

    @Deprecated
    public static CUDA_RESOURCE_DESC callocStack(MemoryStack stack) {
        return CUDA_RESOURCE_DESC.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_RESOURCE_DESC.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_RESOURCE_DESC.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_DESC.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_DESC.calloc(capacity, stack);
    }

    public static CUDA_RESOURCE_DESC malloc(MemoryStack stack) {
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_RESOURCE_DESC calloc(MemoryStack stack) {
        return CUDA_RESOURCE_DESC.wrap(CUDA_RESOURCE_DESC.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUDA_RESOURCE_DESC.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nresType(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESTYPE);
    }

    public static long nres_array_hArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_ARRAY_HARRAY);
    }

    public static long nres_mipmap_hMipmappedArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_MIPMAP_HMIPMAPPEDARRAY);
    }

    public static long nres_linear_devPtr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_LINEAR_DEVPTR);
    }

    public static int nres_linear_format(long struct) {
        return UNSAFE.getInt(null, struct + (long)RES_LINEAR_FORMAT);
    }

    public static int nres_linear_numChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)RES_LINEAR_NUMCHANNELS);
    }

    public static long nres_linear_sizeInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_LINEAR_SIZEINBYTES);
    }

    public static long nres_pitch2D_devPtr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_PITCH2D_DEVPTR);
    }

    public static int nres_pitch2D_format(long struct) {
        return UNSAFE.getInt(null, struct + (long)RES_PITCH2D_FORMAT);
    }

    public static int nres_pitch2D_numChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)RES_PITCH2D_NUMCHANNELS);
    }

    public static long nres_pitch2D_width(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_PITCH2D_WIDTH);
    }

    public static long nres_pitch2D_height(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_PITCH2D_HEIGHT);
    }

    public static long nres_pitch2D_pitchInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RES_PITCH2D_PITCHINBYTES);
    }

    public static IntBuffer nres_reserved_reserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RES_RESERVED_RESERVED, 32);
    }

    public static int nres_reserved_reserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RES_RESERVED_RESERVED + Checks.check(index, 32) * 4L);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nresType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESTYPE, value);
    }

    public static void nres_array_hArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_ARRAY_HARRAY, value);
    }

    public static void nres_mipmap_hMipmappedArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_MIPMAP_HMIPMAPPEDARRAY, value);
    }

    public static void nres_linear_devPtr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_LINEAR_DEVPTR, value);
    }

    public static void nres_linear_format(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RES_LINEAR_FORMAT, value);
    }

    public static void nres_linear_numChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RES_LINEAR_NUMCHANNELS, value);
    }

    public static void nres_linear_sizeInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_LINEAR_SIZEINBYTES, value);
    }

    public static void nres_pitch2D_devPtr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_PITCH2D_DEVPTR, value);
    }

    public static void nres_pitch2D_format(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RES_PITCH2D_FORMAT, value);
    }

    public static void nres_pitch2D_numChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RES_PITCH2D_NUMCHANNELS, value);
    }

    public static void nres_pitch2D_width(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_PITCH2D_WIDTH, value);
    }

    public static void nres_pitch2D_height(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_PITCH2D_HEIGHT, value);
    }

    public static void nres_pitch2D_pitchInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RES_PITCH2D_PITCHINBYTES, value);
    }

    public static void nres_reserved_reserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 32);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RES_RESERVED_RESERVED, value.remaining() * 4);
    }

    public static void nres_reserved_reserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RES_RESERVED_RESERVED + Checks.check(index, 32) * 4L, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__member(4), CUDA_RESOURCE_DESC.__union(CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__member(POINTER_SIZE)), CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__member(POINTER_SIZE)), CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__member(POINTER_SIZE), CUDA_RESOURCE_DESC.__member(4), CUDA_RESOURCE_DESC.__member(4), CUDA_RESOURCE_DESC.__member(POINTER_SIZE)), CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__member(POINTER_SIZE), CUDA_RESOURCE_DESC.__member(4), CUDA_RESOURCE_DESC.__member(4), CUDA_RESOURCE_DESC.__member(POINTER_SIZE), CUDA_RESOURCE_DESC.__member(POINTER_SIZE), CUDA_RESOURCE_DESC.__member(POINTER_SIZE)), CUDA_RESOURCE_DESC.__struct(CUDA_RESOURCE_DESC.__array(4, 32))), CUDA_RESOURCE_DESC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESTYPE = layout.offsetof(0);
        RES = layout.offsetof(1);
        RES_ARRAY = layout.offsetof(2);
        RES_ARRAY_HARRAY = layout.offsetof(3);
        RES_MIPMAP = layout.offsetof(4);
        RES_MIPMAP_HMIPMAPPEDARRAY = layout.offsetof(5);
        RES_LINEAR = layout.offsetof(6);
        RES_LINEAR_DEVPTR = layout.offsetof(7);
        RES_LINEAR_FORMAT = layout.offsetof(8);
        RES_LINEAR_NUMCHANNELS = layout.offsetof(9);
        RES_LINEAR_SIZEINBYTES = layout.offsetof(10);
        RES_PITCH2D = layout.offsetof(11);
        RES_PITCH2D_DEVPTR = layout.offsetof(12);
        RES_PITCH2D_FORMAT = layout.offsetof(13);
        RES_PITCH2D_NUMCHANNELS = layout.offsetof(14);
        RES_PITCH2D_WIDTH = layout.offsetof(15);
        RES_PITCH2D_HEIGHT = layout.offsetof(16);
        RES_PITCH2D_PITCHINBYTES = layout.offsetof(17);
        RES_RESERVED = layout.offsetof(18);
        RES_RESERVED_RESERVED = layout.offsetof(19);
        FLAGS = layout.offsetof(20);
    }

    public static class Buffer
    extends StructBuffer<CUDA_RESOURCE_DESC, Buffer>
    implements NativeResource {
        private static final CUDA_RESOURCE_DESC ELEMENT_FACTORY = CUDA_RESOURCE_DESC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUDA_RESOURCE_DESC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUresourcetype")
        public int resType() {
            return CUDA_RESOURCE_DESC.nresType(this.address());
        }

        @NativeType(value="CUarray")
        public long res_array_hArray() {
            return CUDA_RESOURCE_DESC.nres_array_hArray(this.address());
        }

        @NativeType(value="CUmipmappedArray")
        public long res_mipmap_hMipmappedArray() {
            return CUDA_RESOURCE_DESC.nres_mipmap_hMipmappedArray(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long res_linear_devPtr() {
            return CUDA_RESOURCE_DESC.nres_linear_devPtr(this.address());
        }

        @NativeType(value="CUarray_format")
        public int res_linear_format() {
            return CUDA_RESOURCE_DESC.nres_linear_format(this.address());
        }

        @NativeType(value="unsigned int")
        public int res_linear_numChannels() {
            return CUDA_RESOURCE_DESC.nres_linear_numChannels(this.address());
        }

        @NativeType(value="size_t")
        public long res_linear_sizeInBytes() {
            return CUDA_RESOURCE_DESC.nres_linear_sizeInBytes(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long res_pitch2D_devPtr() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_devPtr(this.address());
        }

        @NativeType(value="CUarray_format")
        public int res_pitch2D_format() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_format(this.address());
        }

        @NativeType(value="unsigned int")
        public int res_pitch2D_numChannels() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_numChannels(this.address());
        }

        @NativeType(value="size_t")
        public long res_pitch2D_width() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_width(this.address());
        }

        @NativeType(value="size_t")
        public long res_pitch2D_height() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_height(this.address());
        }

        @NativeType(value="size_t")
        public long res_pitch2D_pitchInBytes() {
            return CUDA_RESOURCE_DESC.nres_pitch2D_pitchInBytes(this.address());
        }

        @NativeType(value="int[32]")
        public IntBuffer res_reserved_reserved() {
            return CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address());
        }

        public int res_reserved_reserved(int index) {
            return CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), index);
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_RESOURCE_DESC.nflags(this.address());
        }

        public Buffer resType(@NativeType(value="CUresourcetype") int value) {
            CUDA_RESOURCE_DESC.nresType(this.address(), value);
            return this;
        }

        public Buffer res_array_hArray(@NativeType(value="CUarray") long value) {
            CUDA_RESOURCE_DESC.nres_array_hArray(this.address(), value);
            return this;
        }

        public Buffer res_mipmap_hMipmappedArray(@NativeType(value="CUmipmappedArray") long value) {
            CUDA_RESOURCE_DESC.nres_mipmap_hMipmappedArray(this.address(), value);
            return this;
        }

        public Buffer res_linear_devPtr(@NativeType(value="CUdeviceptr") long value) {
            CUDA_RESOURCE_DESC.nres_linear_devPtr(this.address(), value);
            return this;
        }

        public Buffer res_linear_format(@NativeType(value="CUarray_format") int value) {
            CUDA_RESOURCE_DESC.nres_linear_format(this.address(), value);
            return this;
        }

        public Buffer res_linear_numChannels(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_DESC.nres_linear_numChannels(this.address(), value);
            return this;
        }

        public Buffer res_linear_sizeInBytes(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_DESC.nres_linear_sizeInBytes(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_devPtr(@NativeType(value="CUdeviceptr") long value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_devPtr(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_format(@NativeType(value="CUarray_format") int value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_format(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_numChannels(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_numChannels(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_width(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_width(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_height(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_height(this.address(), value);
            return this;
        }

        public Buffer res_pitch2D_pitchInBytes(@NativeType(value="size_t") long value) {
            CUDA_RESOURCE_DESC.nres_pitch2D_pitchInBytes(this.address(), value);
            return this;
        }

        public Buffer res_reserved_reserved(@NativeType(value="int[32]") IntBuffer value) {
            CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), value);
            return this;
        }

        public Buffer res_reserved_reserved(int index, int value) {
            CUDA_RESOURCE_DESC.nres_reserved_reserved(this.address(), index, value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_RESOURCE_DESC.nflags(this.address(), value);
            return this;
        }
    }
}

