/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUaccessPolicyWindow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BASE_PTR;
    public static final int NUM_BYTES;
    public static final int HITRATIO;
    public static final int HITPROP;
    public static final int MISSPROP;

    public CUaccessPolicyWindow(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUaccessPolicyWindow.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long base_ptr() {
        return CUaccessPolicyWindow.nbase_ptr(this.address());
    }

    @NativeType(value="size_t")
    public long num_bytes() {
        return CUaccessPolicyWindow.nnum_bytes(this.address());
    }

    public float hitRatio() {
        return CUaccessPolicyWindow.nhitRatio(this.address());
    }

    @NativeType(value="CUaccessProperty")
    public int hitProp() {
        return CUaccessPolicyWindow.nhitProp(this.address());
    }

    @NativeType(value="CUaccessProperty")
    public int missProp() {
        return CUaccessPolicyWindow.nmissProp(this.address());
    }

    public CUaccessPolicyWindow base_ptr(@NativeType(value="void *") long value) {
        CUaccessPolicyWindow.nbase_ptr(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow num_bytes(@NativeType(value="size_t") long value) {
        CUaccessPolicyWindow.nnum_bytes(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow hitRatio(float value) {
        CUaccessPolicyWindow.nhitRatio(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow hitProp(@NativeType(value="CUaccessProperty") int value) {
        CUaccessPolicyWindow.nhitProp(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow missProp(@NativeType(value="CUaccessProperty") int value) {
        CUaccessPolicyWindow.nmissProp(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow set(long base_ptr, long num_bytes, float hitRatio, int hitProp, int missProp) {
        this.base_ptr(base_ptr);
        this.num_bytes(num_bytes);
        this.hitRatio(hitRatio);
        this.hitProp(hitProp);
        this.missProp(missProp);
        return this;
    }

    public CUaccessPolicyWindow set(CUaccessPolicyWindow src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUaccessPolicyWindow malloc() {
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUaccessPolicyWindow calloc() {
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUaccessPolicyWindow create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, MemoryUtil.memAddress(container), container);
    }

    public static CUaccessPolicyWindow create(long address) {
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, address);
    }

    @Nullable
    public static CUaccessPolicyWindow createSafe(long address) {
        return address == 0L ? null : CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUaccessPolicyWindow.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUaccessPolicyWindow.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUaccessPolicyWindow.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUaccessPolicyWindow.__create(capacity, SIZEOF);
        return CUaccessPolicyWindow.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUaccessPolicyWindow.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUaccessPolicyWindow.wrap(Buffer.class, address, capacity);
    }

    public static CUaccessPolicyWindow malloc(MemoryStack stack) {
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUaccessPolicyWindow calloc(MemoryStack stack) {
        return CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUaccessPolicyWindow.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUaccessPolicyWindow.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbase_ptr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASE_PTR);
    }

    public static long nnum_bytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NUM_BYTES);
    }

    public static float nhitRatio(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HITRATIO);
    }

    public static int nhitProp(long struct) {
        return UNSAFE.getInt(null, struct + (long)HITPROP);
    }

    public static int nmissProp(long struct) {
        return UNSAFE.getInt(null, struct + (long)MISSPROP);
    }

    public static void nbase_ptr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BASE_PTR, Checks.check(value));
    }

    public static void nnum_bytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NUM_BYTES, value);
    }

    public static void nhitRatio(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HITRATIO, value);
    }

    public static void nhitProp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HITPROP, value);
    }

    public static void nmissProp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MISSPROP, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASE_PTR));
    }

    static {
        Struct.Layout layout = CUaccessPolicyWindow.__struct(CUaccessPolicyWindow.__member(POINTER_SIZE), CUaccessPolicyWindow.__member(POINTER_SIZE), CUaccessPolicyWindow.__member(4), CUaccessPolicyWindow.__member(4), CUaccessPolicyWindow.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BASE_PTR = layout.offsetof(0);
        NUM_BYTES = layout.offsetof(1);
        HITRATIO = layout.offsetof(2);
        HITPROP = layout.offsetof(3);
        MISSPROP = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUaccessPolicyWindow, Buffer>
    implements NativeResource {
        private static final CUaccessPolicyWindow ELEMENT_FACTORY = CUaccessPolicyWindow.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUaccessPolicyWindow getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long base_ptr() {
            return CUaccessPolicyWindow.nbase_ptr(this.address());
        }

        @NativeType(value="size_t")
        public long num_bytes() {
            return CUaccessPolicyWindow.nnum_bytes(this.address());
        }

        public float hitRatio() {
            return CUaccessPolicyWindow.nhitRatio(this.address());
        }

        @NativeType(value="CUaccessProperty")
        public int hitProp() {
            return CUaccessPolicyWindow.nhitProp(this.address());
        }

        @NativeType(value="CUaccessProperty")
        public int missProp() {
            return CUaccessPolicyWindow.nmissProp(this.address());
        }

        public Buffer base_ptr(@NativeType(value="void *") long value) {
            CUaccessPolicyWindow.nbase_ptr(this.address(), value);
            return this;
        }

        public Buffer num_bytes(@NativeType(value="size_t") long value) {
            CUaccessPolicyWindow.nnum_bytes(this.address(), value);
            return this;
        }

        public Buffer hitRatio(float value) {
            CUaccessPolicyWindow.nhitRatio(this.address(), value);
            return this;
        }

        public Buffer hitProp(@NativeType(value="CUaccessProperty") int value) {
            CUaccessPolicyWindow.nhitProp(this.address(), value);
            return this;
        }

        public Buffer missProp(@NativeType(value="CUaccessProperty") int value) {
            CUaccessPolicyWindow.nmissProp(this.address(), value);
            return this;
        }
    }
}

