/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUexecAffinitySmCount;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUexecAffinityParam
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int PARAM;
    public static final int PARAM_SMCOUNT;

    public CUexecAffinityParam(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUexecAffinityParam.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexecAffinityType")
    public int type() {
        return CUexecAffinityParam.ntype(this.address());
    }

    public CUexecAffinitySmCount param_smCount() {
        return CUexecAffinityParam.nparam_smCount(this.address());
    }

    public CUexecAffinityParam type(@NativeType(value="CUexecAffinityType") int value) {
        CUexecAffinityParam.ntype(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(CUexecAffinitySmCount value) {
        CUexecAffinityParam.nparam_smCount(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
        consumer.accept(this.param_smCount());
        return this;
    }

    public CUexecAffinityParam set(CUexecAffinityParam src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUexecAffinityParam malloc() {
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUexecAffinityParam calloc() {
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUexecAffinityParam create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, MemoryUtil.memAddress(container), container);
    }

    public static CUexecAffinityParam create(long address) {
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, address);
    }

    @Nullable
    public static CUexecAffinityParam createSafe(long address) {
        return address == 0L ? null : CUexecAffinityParam.wrap(CUexecAffinityParam.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUexecAffinityParam.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUexecAffinityParam.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUexecAffinityParam.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUexecAffinityParam.__create(capacity, SIZEOF);
        return CUexecAffinityParam.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUexecAffinityParam.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUexecAffinityParam.wrap(Buffer.class, address, capacity);
    }

    public static CUexecAffinityParam malloc(MemoryStack stack) {
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUexecAffinityParam calloc(MemoryStack stack) {
        return CUexecAffinityParam.wrap(CUexecAffinityParam.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUexecAffinityParam.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUexecAffinityParam.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static CUexecAffinitySmCount nparam_smCount(long struct) {
        return CUexecAffinitySmCount.create(struct + (long)PARAM_SMCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nparam_smCount(long struct, CUexecAffinitySmCount value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARAM_SMCOUNT, CUexecAffinitySmCount.SIZEOF);
    }

    static {
        Struct.Layout layout = CUexecAffinityParam.__struct(CUexecAffinityParam.__member(4), CUexecAffinityParam.__union(CUexecAffinityParam.__member(CUexecAffinitySmCount.SIZEOF, CUexecAffinitySmCount.ALIGNOF)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PARAM = layout.offsetof(1);
        PARAM_SMCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUexecAffinityParam, Buffer>
    implements NativeResource {
        private static final CUexecAffinityParam ELEMENT_FACTORY = CUexecAffinityParam.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUexecAffinityParam getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexecAffinityType")
        public int type() {
            return CUexecAffinityParam.ntype(this.address());
        }

        public CUexecAffinitySmCount param_smCount() {
            return CUexecAffinityParam.nparam_smCount(this.address());
        }

        public Buffer type(@NativeType(value="CUexecAffinityType") int value) {
            CUexecAffinityParam.ntype(this.address(), value);
            return this;
        }

        public Buffer param_smCount(CUexecAffinitySmCount value) {
            CUexecAffinityParam.nparam_smCount(this.address(), value);
            return this;
        }

        public Buffer param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
            consumer.accept(this.param_smCount());
            return this;
        }
    }
}

