/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCompletionResult;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCodeCompleteResults
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESULTS;
    public static final int NUMRESULTS;

    public CXCodeCompleteResults(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXCodeCompleteResults.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXCompletionResult *")
    public CXCompletionResult.Buffer Results() {
        return CXCodeCompleteResults.nResults(this.address());
    }

    @NativeType(value="unsigned")
    public int NumResults() {
        return CXCodeCompleteResults.nNumResults(this.address());
    }

    public static CXCodeCompleteResults malloc() {
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXCodeCompleteResults calloc() {
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXCodeCompleteResults create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, MemoryUtil.memAddress(container), container);
    }

    public static CXCodeCompleteResults create(long address) {
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, address);
    }

    @Nullable
    public static CXCodeCompleteResults createSafe(long address) {
        return address == 0L ? null : CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXCodeCompleteResults.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXCodeCompleteResults.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXCodeCompleteResults.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCodeCompleteResults.__create(capacity, SIZEOF);
        return CXCodeCompleteResults.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXCodeCompleteResults.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXCodeCompleteResults.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXCodeCompleteResults mallocStack() {
        return CXCodeCompleteResults.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCodeCompleteResults callocStack() {
        return CXCodeCompleteResults.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCodeCompleteResults mallocStack(MemoryStack stack) {
        return CXCodeCompleteResults.malloc(stack);
    }

    @Deprecated
    public static CXCodeCompleteResults callocStack(MemoryStack stack) {
        return CXCodeCompleteResults.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCodeCompleteResults.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCodeCompleteResults.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.calloc(capacity, stack);
    }

    public static CXCodeCompleteResults malloc(MemoryStack stack) {
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCodeCompleteResults calloc(MemoryStack stack) {
        return CXCodeCompleteResults.wrap(CXCodeCompleteResults.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CXCompletionResult.Buffer nResults(long struct) {
        return CXCompletionResult.create(MemoryUtil.memGetAddress(struct + (long)RESULTS), CXCodeCompleteResults.nNumResults(struct));
    }

    public static int nNumResults(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMRESULTS);
    }

    static {
        Struct.Layout layout = CXCodeCompleteResults.__struct(CXCodeCompleteResults.__member(POINTER_SIZE), CXCodeCompleteResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESULTS = layout.offsetof(0);
        NUMRESULTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCodeCompleteResults, Buffer>
    implements NativeResource {
        private static final CXCodeCompleteResults ELEMENT_FACTORY = CXCodeCompleteResults.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXCodeCompleteResults getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXCompletionResult *")
        public CXCompletionResult.Buffer Results() {
            return CXCodeCompleteResults.nResults(this.address());
        }

        @NativeType(value="unsigned")
        public int NumResults() {
            return CXCodeCompleteResults.nNumResults(this.address());
        }
    }
}

