/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCompletionResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURSORKIND;
    public static final int COMPLETIONSTRING;

    public CXCompletionResult(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXCompletionResult.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXCursorKind")
    public int CursorKind() {
        return CXCompletionResult.nCursorKind(this.address());
    }

    @NativeType(value="CXCompletionString")
    public long CompletionString() {
        return CXCompletionResult.nCompletionString(this.address());
    }

    public static CXCompletionResult malloc() {
        return CXCompletionResult.wrap(CXCompletionResult.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXCompletionResult calloc() {
        return CXCompletionResult.wrap(CXCompletionResult.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXCompletionResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXCompletionResult.wrap(CXCompletionResult.class, MemoryUtil.memAddress(container), container);
    }

    public static CXCompletionResult create(long address) {
        return CXCompletionResult.wrap(CXCompletionResult.class, address);
    }

    @Nullable
    public static CXCompletionResult createSafe(long address) {
        return address == 0L ? null : CXCompletionResult.wrap(CXCompletionResult.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXCompletionResult.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXCompletionResult.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXCompletionResult.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCompletionResult.__create(capacity, SIZEOF);
        return CXCompletionResult.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXCompletionResult.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXCompletionResult.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXCompletionResult mallocStack() {
        return CXCompletionResult.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCompletionResult callocStack() {
        return CXCompletionResult.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCompletionResult mallocStack(MemoryStack stack) {
        return CXCompletionResult.malloc(stack);
    }

    @Deprecated
    public static CXCompletionResult callocStack(MemoryStack stack) {
        return CXCompletionResult.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCompletionResult.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCompletionResult.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCompletionResult.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCompletionResult.calloc(capacity, stack);
    }

    public static CXCompletionResult malloc(MemoryStack stack) {
        return CXCompletionResult.wrap(CXCompletionResult.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCompletionResult calloc(MemoryStack stack) {
        return CXCompletionResult.wrap(CXCompletionResult.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXCompletionResult.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXCompletionResult.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nCursorKind(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORKIND);
    }

    public static long nCompletionString(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COMPLETIONSTRING);
    }

    static {
        Struct.Layout layout = CXCompletionResult.__struct(CXCompletionResult.__member(4), CXCompletionResult.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURSORKIND = layout.offsetof(0);
        COMPLETIONSTRING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCompletionResult, Buffer>
    implements NativeResource {
        private static final CXCompletionResult ELEMENT_FACTORY = CXCompletionResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXCompletionResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXCursorKind")
        public int CursorKind() {
            return CXCompletionResult.nCursorKind(this.address());
        }

        @NativeType(value="CXCompletionString")
        public long CompletionString() {
            return CXCompletionResult.nCompletionString(this.address());
        }
    }
}

