/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursorAndRangeVisit;
import org.lwjgl.llvm.CXCursorAndRangeVisitI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCursorAndRangeVisitor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int VISIT;

    public CXCursorAndRangeVisitor(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXCursorAndRangeVisitor.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long context() {
        return CXCursorAndRangeVisitor.ncontext(this.address());
    }

    @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
    public CXCursorAndRangeVisit visit() {
        return CXCursorAndRangeVisitor.nvisit(this.address());
    }

    public CXCursorAndRangeVisitor context(@NativeType(value="void *") long value) {
        CXCursorAndRangeVisitor.ncontext(this.address(), value);
        return this;
    }

    public CXCursorAndRangeVisitor visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
        CXCursorAndRangeVisitor.nvisit(this.address(), value);
        return this;
    }

    public CXCursorAndRangeVisitor set(long context, CXCursorAndRangeVisitI visit) {
        this.context(context);
        this.visit(visit);
        return this;
    }

    public CXCursorAndRangeVisitor set(CXCursorAndRangeVisitor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CXCursorAndRangeVisitor malloc() {
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXCursorAndRangeVisitor calloc() {
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXCursorAndRangeVisitor create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, MemoryUtil.memAddress(container), container);
    }

    public static CXCursorAndRangeVisitor create(long address) {
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, address);
    }

    @Nullable
    public static CXCursorAndRangeVisitor createSafe(long address) {
        return address == 0L ? null : CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXCursorAndRangeVisitor.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXCursorAndRangeVisitor.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXCursorAndRangeVisitor.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCursorAndRangeVisitor.__create(capacity, SIZEOF);
        return CXCursorAndRangeVisitor.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXCursorAndRangeVisitor.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXCursorAndRangeVisitor.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXCursorAndRangeVisitor mallocStack() {
        return CXCursorAndRangeVisitor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursorAndRangeVisitor callocStack() {
        return CXCursorAndRangeVisitor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursorAndRangeVisitor mallocStack(MemoryStack stack) {
        return CXCursorAndRangeVisitor.malloc(stack);
    }

    @Deprecated
    public static CXCursorAndRangeVisitor callocStack(MemoryStack stack) {
        return CXCursorAndRangeVisitor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCursorAndRangeVisitor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCursorAndRangeVisitor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.calloc(capacity, stack);
    }

    public static CXCursorAndRangeVisitor malloc(MemoryStack stack) {
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCursorAndRangeVisitor calloc(MemoryStack stack) {
        return CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    public static CXCursorAndRangeVisit nvisit(long struct) {
        return CXCursorAndRangeVisit.create(MemoryUtil.memGetAddress(struct + (long)VISIT));
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONTEXT, Checks.check(value));
    }

    public static void nvisit(long struct, CXCursorAndRangeVisitI value) {
        MemoryUtil.memPutAddress(struct + (long)VISIT, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONTEXT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VISIT));
    }

    static {
        Struct.Layout layout = CXCursorAndRangeVisitor.__struct(CXCursorAndRangeVisitor.__member(POINTER_SIZE), CXCursorAndRangeVisitor.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTEXT = layout.offsetof(0);
        VISIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCursorAndRangeVisitor, Buffer>
    implements NativeResource {
        private static final CXCursorAndRangeVisitor ELEMENT_FACTORY = CXCursorAndRangeVisitor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXCursorAndRangeVisitor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long context() {
            return CXCursorAndRangeVisitor.ncontext(this.address());
        }

        @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
        public CXCursorAndRangeVisit visit() {
            return CXCursorAndRangeVisitor.nvisit(this.address());
        }

        public Buffer context(@NativeType(value="void *") long value) {
            CXCursorAndRangeVisitor.ncontext(this.address(), value);
            return this;
        }

        public Buffer visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
            CXCursorAndRangeVisitor.nvisit(this.address(), value);
            return this;
        }
    }
}

