/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXFileUniqueID
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;

    public CXFileUniqueID(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXFileUniqueID.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long[3]")
    public LongBuffer data() {
        return CXFileUniqueID.ndata(this.address());
    }

    @NativeType(value="unsigned long long")
    public long data(int index) {
        return CXFileUniqueID.ndata(this.address(), index);
    }

    public static CXFileUniqueID malloc() {
        return CXFileUniqueID.wrap(CXFileUniqueID.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXFileUniqueID calloc() {
        return CXFileUniqueID.wrap(CXFileUniqueID.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXFileUniqueID create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXFileUniqueID.wrap(CXFileUniqueID.class, MemoryUtil.memAddress(container), container);
    }

    public static CXFileUniqueID create(long address) {
        return CXFileUniqueID.wrap(CXFileUniqueID.class, address);
    }

    @Nullable
    public static CXFileUniqueID createSafe(long address) {
        return address == 0L ? null : CXFileUniqueID.wrap(CXFileUniqueID.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXFileUniqueID.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXFileUniqueID.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXFileUniqueID.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXFileUniqueID.__create(capacity, SIZEOF);
        return CXFileUniqueID.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXFileUniqueID.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXFileUniqueID.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXFileUniqueID mallocStack() {
        return CXFileUniqueID.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXFileUniqueID callocStack() {
        return CXFileUniqueID.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXFileUniqueID mallocStack(MemoryStack stack) {
        return CXFileUniqueID.malloc(stack);
    }

    @Deprecated
    public static CXFileUniqueID callocStack(MemoryStack stack) {
        return CXFileUniqueID.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXFileUniqueID.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXFileUniqueID.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXFileUniqueID.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXFileUniqueID.calloc(capacity, stack);
    }

    public static CXFileUniqueID malloc(MemoryStack stack) {
        return CXFileUniqueID.wrap(CXFileUniqueID.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXFileUniqueID calloc(MemoryStack stack) {
        return CXFileUniqueID.wrap(CXFileUniqueID.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXFileUniqueID.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXFileUniqueID.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LongBuffer ndata(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)DATA, 3);
    }

    public static long ndata(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)DATA + Checks.check(index, 3) * 8L);
    }

    static {
        Struct.Layout layout = CXFileUniqueID.__struct(CXFileUniqueID.__array(8, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CXFileUniqueID, Buffer>
    implements NativeResource {
        private static final CXFileUniqueID ELEMENT_FACTORY = CXFileUniqueID.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXFileUniqueID getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long[3]")
        public LongBuffer data() {
            return CXFileUniqueID.ndata(this.address());
        }

        @NativeType(value="unsigned long long")
        public long data(int index) {
            return CXFileUniqueID.ndata(this.address(), index);
        }
    }
}

