/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxAttrInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int CURSOR;
    public static final int LOC;

    public CXIdxAttrInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxAttrInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxAttrKind")
    public int kind() {
        return CXIdxAttrInfo.nkind(this.address());
    }

    public CXCursor cursor() {
        return CXIdxAttrInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxAttrInfo.nloc(this.address());
    }

    public static CXIdxAttrInfo malloc() {
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXIdxAttrInfo calloc() {
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXIdxAttrInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static CXIdxAttrInfo create(long address) {
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, address);
    }

    @Nullable
    public static CXIdxAttrInfo createSafe(long address) {
        return address == 0L ? null : CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXIdxAttrInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXIdxAttrInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXIdxAttrInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxAttrInfo.__create(capacity, SIZEOF);
        return CXIdxAttrInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXIdxAttrInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXIdxAttrInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXIdxAttrInfo mallocStack() {
        return CXIdxAttrInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxAttrInfo callocStack() {
        return CXIdxAttrInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxAttrInfo mallocStack(MemoryStack stack) {
        return CXIdxAttrInfo.malloc(stack);
    }

    @Deprecated
    public static CXIdxAttrInfo callocStack(MemoryStack stack) {
        return CXIdxAttrInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxAttrInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxAttrInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxAttrInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxAttrInfo.calloc(capacity, stack);
    }

    public static CXIdxAttrInfo malloc(MemoryStack stack) {
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxAttrInfo calloc(MemoryStack stack) {
        return CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXIdxAttrInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXIdxAttrInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    static {
        Struct.Layout layout = CXIdxAttrInfo.__struct(CXIdxAttrInfo.__member(4), CXIdxAttrInfo.__member(CXCursor.SIZEOF, CXCursor.ALIGNOF), CXIdxAttrInfo.__member(CXIdxLoc.SIZEOF, CXIdxLoc.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXIdxAttrInfo, Buffer>
    implements NativeResource {
        private static final CXIdxAttrInfo ELEMENT_FACTORY = CXIdxAttrInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXIdxAttrInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxAttrKind")
        public int kind() {
            return CXIdxAttrInfo.nkind(this.address());
        }

        public CXCursor cursor() {
            return CXIdxAttrInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxAttrInfo.nloc(this.address());
        }
    }
}

