/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxEntityInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int TEMPLATEKIND;
    public static final int LANG;
    public static final int NAME;
    public static final int USR;
    public static final int CURSOR;
    public static final int ATTRIBUTES;
    public static final int NUMATTRIBUTES;

    public CXIdxEntityInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxEntityInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityKind")
    public int kind() {
        return CXIdxEntityInfo.nkind(this.address());
    }

    @NativeType(value="CXIdxEntityCXXTemplateKind")
    public int templateKind() {
        return CXIdxEntityInfo.ntemplateKind(this.address());
    }

    @NativeType(value="CXIdxEntityLanguage")
    public int lang() {
        return CXIdxEntityInfo.nlang(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return CXIdxEntityInfo.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return CXIdxEntityInfo.nnameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer USR() {
        return CXIdxEntityInfo.nUSR(this.address());
    }

    @NativeType(value="char const *")
    public String USRString() {
        return CXIdxEntityInfo.nUSRString(this.address());
    }

    public CXCursor cursor() {
        return CXIdxEntityInfo.ncursor(this.address());
    }

    @NativeType(value="CXIdxAttrInfo const * const *")
    public PointerBuffer attributes() {
        return CXIdxEntityInfo.nattributes(this.address());
    }

    @NativeType(value="unsigned")
    public int numAttributes() {
        return CXIdxEntityInfo.nnumAttributes(this.address());
    }

    public static CXIdxEntityInfo malloc() {
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXIdxEntityInfo calloc() {
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXIdxEntityInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static CXIdxEntityInfo create(long address) {
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, address);
    }

    @Nullable
    public static CXIdxEntityInfo createSafe(long address) {
        return address == 0L ? null : CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXIdxEntityInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXIdxEntityInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXIdxEntityInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxEntityInfo.__create(capacity, SIZEOF);
        return CXIdxEntityInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXIdxEntityInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXIdxEntityInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXIdxEntityInfo mallocStack() {
        return CXIdxEntityInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxEntityInfo callocStack() {
        return CXIdxEntityInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxEntityInfo mallocStack(MemoryStack stack) {
        return CXIdxEntityInfo.malloc(stack);
    }

    @Deprecated
    public static CXIdxEntityInfo callocStack(MemoryStack stack) {
        return CXIdxEntityInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxEntityInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxEntityInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxEntityInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxEntityInfo.calloc(capacity, stack);
    }

    public static CXIdxEntityInfo malloc(MemoryStack stack) {
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxEntityInfo calloc(MemoryStack stack) {
        return CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXIdxEntityInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXIdxEntityInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static int ntemplateKind(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEMPLATEKIND);
    }

    public static int nlang(long struct) {
        return UNSAFE.getInt(null, struct + (long)LANG);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nUSR(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)USR));
    }

    public static String nUSRString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)USR));
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static PointerBuffer nattributes(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ATTRIBUTES), CXIdxEntityInfo.nnumAttributes(struct));
    }

    public static int nnumAttributes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMATTRIBUTES);
    }

    static {
        Struct.Layout layout = CXIdxEntityInfo.__struct(CXIdxEntityInfo.__member(4), CXIdxEntityInfo.__member(4), CXIdxEntityInfo.__member(4), CXIdxEntityInfo.__member(POINTER_SIZE), CXIdxEntityInfo.__member(POINTER_SIZE), CXIdxEntityInfo.__member(CXCursor.SIZEOF, CXCursor.ALIGNOF), CXIdxEntityInfo.__member(POINTER_SIZE), CXIdxEntityInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        TEMPLATEKIND = layout.offsetof(1);
        LANG = layout.offsetof(2);
        NAME = layout.offsetof(3);
        USR = layout.offsetof(4);
        CURSOR = layout.offsetof(5);
        ATTRIBUTES = layout.offsetof(6);
        NUMATTRIBUTES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<CXIdxEntityInfo, Buffer>
    implements NativeResource {
        private static final CXIdxEntityInfo ELEMENT_FACTORY = CXIdxEntityInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXIdxEntityInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityKind")
        public int kind() {
            return CXIdxEntityInfo.nkind(this.address());
        }

        @NativeType(value="CXIdxEntityCXXTemplateKind")
        public int templateKind() {
            return CXIdxEntityInfo.ntemplateKind(this.address());
        }

        @NativeType(value="CXIdxEntityLanguage")
        public int lang() {
            return CXIdxEntityInfo.nlang(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return CXIdxEntityInfo.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return CXIdxEntityInfo.nnameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer USR() {
            return CXIdxEntityInfo.nUSR(this.address());
        }

        @NativeType(value="char const *")
        public String USRString() {
            return CXIdxEntityInfo.nUSRString(this.address());
        }

        public CXCursor cursor() {
            return CXIdxEntityInfo.ncursor(this.address());
        }

        @NativeType(value="CXIdxAttrInfo const * const *")
        public PointerBuffer attributes() {
            return CXIdxEntityInfo.nattributes(this.address());
        }

        @NativeType(value="unsigned")
        public int numAttributes() {
            return CXIdxEntityInfo.nnumAttributes(this.address());
        }
    }
}

