/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceLocation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int INT_DATA;

    public CXSourceLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXSourceLocation.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *[2]")
    public PointerBuffer ptr_data() {
        return CXSourceLocation.nptr_data(this.address());
    }

    @NativeType(value="void const *")
    public long ptr_data(int index) {
        return CXSourceLocation.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int int_data() {
        return CXSourceLocation.nint_data(this.address());
    }

    public static CXSourceLocation malloc() {
        return CXSourceLocation.wrap(CXSourceLocation.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXSourceLocation calloc() {
        return CXSourceLocation.wrap(CXSourceLocation.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXSourceLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXSourceLocation.wrap(CXSourceLocation.class, MemoryUtil.memAddress(container), container);
    }

    public static CXSourceLocation create(long address) {
        return CXSourceLocation.wrap(CXSourceLocation.class, address);
    }

    @Nullable
    public static CXSourceLocation createSafe(long address) {
        return address == 0L ? null : CXSourceLocation.wrap(CXSourceLocation.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXSourceLocation.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXSourceLocation.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXSourceLocation.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXSourceLocation.__create(capacity, SIZEOF);
        return CXSourceLocation.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXSourceLocation.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXSourceLocation.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXSourceLocation mallocStack() {
        return CXSourceLocation.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceLocation callocStack() {
        return CXSourceLocation.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceLocation mallocStack(MemoryStack stack) {
        return CXSourceLocation.malloc(stack);
    }

    @Deprecated
    public static CXSourceLocation callocStack(MemoryStack stack) {
        return CXSourceLocation.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXSourceLocation.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXSourceLocation.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXSourceLocation.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXSourceLocation.calloc(capacity, stack);
    }

    public static CXSourceLocation malloc(MemoryStack stack) {
        return CXSourceLocation.wrap(CXSourceLocation.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXSourceLocation calloc(MemoryStack stack) {
        return CXSourceLocation.wrap(CXSourceLocation.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXSourceLocation.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXSourceLocation.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PTR_DATA, 2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PTR_DATA + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static int nint_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)INT_DATA);
    }

    static {
        Struct.Layout layout = CXSourceLocation.__struct(CXSourceLocation.__array(POINTER_SIZE, 2), CXSourceLocation.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        INT_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXSourceLocation, Buffer>
    implements NativeResource {
        private static final CXSourceLocation ELEMENT_FACTORY = CXSourceLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXSourceLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *[2]")
        public PointerBuffer ptr_data() {
            return CXSourceLocation.nptr_data(this.address());
        }

        @NativeType(value="void const *")
        public long ptr_data(int index) {
            return CXSourceLocation.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int int_data() {
            return CXSourceLocation.nint_data(this.address());
        }
    }
}

