/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int BEGIN_INT_DATA;
    public static final int END_INT_DATA;

    public CXSourceRange(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXSourceRange.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *[2]")
    public PointerBuffer ptr_data() {
        return CXSourceRange.nptr_data(this.address());
    }

    @NativeType(value="void const *")
    public long ptr_data(int index) {
        return CXSourceRange.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int begin_int_data() {
        return CXSourceRange.nbegin_int_data(this.address());
    }

    @NativeType(value="unsigned")
    public int end_int_data() {
        return CXSourceRange.nend_int_data(this.address());
    }

    public static CXSourceRange malloc() {
        return CXSourceRange.wrap(CXSourceRange.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXSourceRange calloc() {
        return CXSourceRange.wrap(CXSourceRange.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXSourceRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXSourceRange.wrap(CXSourceRange.class, MemoryUtil.memAddress(container), container);
    }

    public static CXSourceRange create(long address) {
        return CXSourceRange.wrap(CXSourceRange.class, address);
    }

    @Nullable
    public static CXSourceRange createSafe(long address) {
        return address == 0L ? null : CXSourceRange.wrap(CXSourceRange.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXSourceRange.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXSourceRange.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXSourceRange.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXSourceRange.__create(capacity, SIZEOF);
        return CXSourceRange.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXSourceRange.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXSourceRange.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXSourceRange mallocStack() {
        return CXSourceRange.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceRange callocStack() {
        return CXSourceRange.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceRange mallocStack(MemoryStack stack) {
        return CXSourceRange.malloc(stack);
    }

    @Deprecated
    public static CXSourceRange callocStack(MemoryStack stack) {
        return CXSourceRange.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXSourceRange.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXSourceRange.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXSourceRange.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXSourceRange.calloc(capacity, stack);
    }

    public static CXSourceRange malloc(MemoryStack stack) {
        return CXSourceRange.wrap(CXSourceRange.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXSourceRange calloc(MemoryStack stack) {
        return CXSourceRange.wrap(CXSourceRange.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXSourceRange.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXSourceRange.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PTR_DATA, 2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PTR_DATA + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static int nbegin_int_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)BEGIN_INT_DATA);
    }

    public static int nend_int_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)END_INT_DATA);
    }

    static {
        Struct.Layout layout = CXSourceRange.__struct(CXSourceRange.__array(POINTER_SIZE, 2), CXSourceRange.__member(4), CXSourceRange.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        BEGIN_INT_DATA = layout.offsetof(1);
        END_INT_DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXSourceRange, Buffer>
    implements NativeResource {
        private static final CXSourceRange ELEMENT_FACTORY = CXSourceRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXSourceRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *[2]")
        public PointerBuffer ptr_data() {
            return CXSourceRange.nptr_data(this.address());
        }

        @NativeType(value="void const *")
        public long ptr_data(int index) {
            return CXSourceRange.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int begin_int_data() {
            return CXSourceRange.nbegin_int_data(this.address());
        }

        @NativeType(value="unsigned")
        public int end_int_data() {
            return CXSourceRange.nend_int_data(this.address());
        }
    }
}

