/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXString
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int PRIVATE_FLAGS;

    public CXString(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXString.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer data(int capacity) {
        return CXString.ndata(this.address(), capacity);
    }

    @NativeType(value="unsigned")
    public int private_flags() {
        return CXString.nprivate_flags(this.address());
    }

    public static CXString malloc() {
        return CXString.wrap(CXString.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXString calloc() {
        return CXString.wrap(CXString.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXString create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXString.wrap(CXString.class, MemoryUtil.memAddress(container), container);
    }

    public static CXString create(long address) {
        return CXString.wrap(CXString.class, address);
    }

    @Nullable
    public static CXString createSafe(long address) {
        return address == 0L ? null : CXString.wrap(CXString.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXString.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXString.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXString.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXString.__create(capacity, SIZEOF);
        return CXString.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXString.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXString.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXString mallocStack() {
        return CXString.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXString callocStack() {
        return CXString.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXString mallocStack(MemoryStack stack) {
        return CXString.malloc(stack);
    }

    @Deprecated
    public static CXString callocStack(MemoryStack stack) {
        return CXString.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXString.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXString.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXString.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXString.calloc(capacity, stack);
    }

    public static CXString malloc(MemoryStack stack) {
        return CXString.wrap(CXString.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXString calloc(MemoryStack stack) {
        return CXString.wrap(CXString.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXString.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXString.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), capacity);
    }

    public static int nprivate_flags(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIVATE_FLAGS);
    }

    static {
        Struct.Layout layout = CXString.__struct(CXString.__member(POINTER_SIZE), CXString.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        PRIVATE_FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXString, Buffer>
    implements NativeResource {
        private static final CXString ELEMENT_FACTORY = CXString.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXString getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer data(int capacity) {
            return CXString.ndata(this.address(), capacity);
        }

        @NativeType(value="unsigned")
        public int private_flags() {
            return CXString.nprivate_flags(this.address());
        }
    }
}

