/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXTUResourceUsageEntry;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXTUResourceUsage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUMENTRIES;
    public static final int ENTRIES;

    public CXTUResourceUsage(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXTUResourceUsage.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long data() {
        return CXTUResourceUsage.ndata(this.address());
    }

    @NativeType(value="unsigned")
    public int numEntries() {
        return CXTUResourceUsage.nnumEntries(this.address());
    }

    @NativeType(value="CXTUResourceUsageEntry *")
    public CXTUResourceUsageEntry.Buffer entries() {
        return CXTUResourceUsage.nentries(this.address());
    }

    public static CXTUResourceUsage malloc() {
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXTUResourceUsage calloc() {
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXTUResourceUsage create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, MemoryUtil.memAddress(container), container);
    }

    public static CXTUResourceUsage create(long address) {
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, address);
    }

    @Nullable
    public static CXTUResourceUsage createSafe(long address) {
        return address == 0L ? null : CXTUResourceUsage.wrap(CXTUResourceUsage.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXTUResourceUsage.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXTUResourceUsage.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXTUResourceUsage.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXTUResourceUsage.__create(capacity, SIZEOF);
        return CXTUResourceUsage.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXTUResourceUsage.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXTUResourceUsage.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXTUResourceUsage mallocStack() {
        return CXTUResourceUsage.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsage callocStack() {
        return CXTUResourceUsage.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsage mallocStack(MemoryStack stack) {
        return CXTUResourceUsage.malloc(stack);
    }

    @Deprecated
    public static CXTUResourceUsage callocStack(MemoryStack stack) {
        return CXTUResourceUsage.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXTUResourceUsage.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXTUResourceUsage.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.calloc(capacity, stack);
    }

    public static CXTUResourceUsage malloc(MemoryStack stack) {
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXTUResourceUsage calloc(MemoryStack stack) {
        return CXTUResourceUsage.wrap(CXTUResourceUsage.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndata(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATA);
    }

    public static int nnumEntries(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMENTRIES);
    }

    public static CXTUResourceUsageEntry.Buffer nentries(long struct) {
        return CXTUResourceUsageEntry.create(MemoryUtil.memGetAddress(struct + (long)ENTRIES), CXTUResourceUsage.nnumEntries(struct));
    }

    static {
        Struct.Layout layout = CXTUResourceUsage.__struct(CXTUResourceUsage.__member(POINTER_SIZE), CXTUResourceUsage.__member(4), CXTUResourceUsage.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUMENTRIES = layout.offsetof(1);
        ENTRIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXTUResourceUsage, Buffer>
    implements NativeResource {
        private static final CXTUResourceUsage ELEMENT_FACTORY = CXTUResourceUsage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXTUResourceUsage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long data() {
            return CXTUResourceUsage.ndata(this.address());
        }

        @NativeType(value="unsigned")
        public int numEntries() {
            return CXTUResourceUsage.nnumEntries(this.address());
        }

        @NativeType(value="CXTUResourceUsageEntry *")
        public CXTUResourceUsageEntry.Buffer entries() {
            return CXTUResourceUsage.nentries(this.address());
        }
    }
}

