/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXTUResourceUsageEntry
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int AMOUNT;

    public CXTUResourceUsageEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXTUResourceUsageEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXTUResourceUsageKind")
    public int kind() {
        return CXTUResourceUsageEntry.nkind(this.address());
    }

    @NativeType(value="unsigned long")
    public long amount() {
        return CXTUResourceUsageEntry.namount(this.address());
    }

    public static CXTUResourceUsageEntry create(long address) {
        return CXTUResourceUsageEntry.wrap(CXTUResourceUsageEntry.class, address);
    }

    @Nullable
    public static CXTUResourceUsageEntry createSafe(long address) {
        return address == 0L ? null : CXTUResourceUsageEntry.wrap(CXTUResourceUsageEntry.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return CXTUResourceUsageEntry.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXTUResourceUsageEntry.wrap(Buffer.class, address, capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static long namount(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)AMOUNT);
    }

    static {
        Struct.Layout layout = CXTUResourceUsageEntry.__struct(CXTUResourceUsageEntry.__member(4), CXTUResourceUsageEntry.__member(CLONG_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        AMOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXTUResourceUsageEntry, Buffer> {
        private static final CXTUResourceUsageEntry ELEMENT_FACTORY = CXTUResourceUsageEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXTUResourceUsageEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXTUResourceUsageKind")
        public int kind() {
            return CXTUResourceUsageEntry.nkind(this.address());
        }

        @NativeType(value="unsigned long")
        public long amount() {
            return CXTUResourceUsageEntry.namount(this.address());
        }
    }
}

