/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.llvm.CXString;
import org.lwjgl.llvm.ClangIndex;
import org.lwjgl.llvm.LibLLVM;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ClangCompilationDatabase {
    public static final int CXCompilationDatabase_NoError = 0;
    public static final int CXCompilationDatabase_CanNotLoadDatabase = 1;

    protected ClangCompilationDatabase() {
        throw new UnsupportedOperationException();
    }

    public static long nclang_CompilationDatabase_fromDirectory(long BuildDir, long ErrorCode) {
        long __functionAddress = Functions.CompilationDatabase_fromDirectory;
        return JNI.invokePPP(BuildDir, ErrorCode, __functionAddress);
    }

    @NativeType(value="CXCompilationDatabase")
    public static long clang_CompilationDatabase_fromDirectory(@NativeType(value="char const *") ByteBuffer BuildDir, @NativeType(value="CXCompilationDatabase_Error *") IntBuffer ErrorCode) {
        if (Checks.CHECKS) {
            Checks.checkNT1(BuildDir);
            Checks.check((Buffer)ErrorCode, 1);
        }
        return ClangCompilationDatabase.nclang_CompilationDatabase_fromDirectory(MemoryUtil.memAddress(BuildDir), MemoryUtil.memAddress(ErrorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CXCompilationDatabase")
    public static long clang_CompilationDatabase_fromDirectory(@NativeType(value="char const *") CharSequence BuildDir, @NativeType(value="CXCompilationDatabase_Error *") IntBuffer ErrorCode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)ErrorCode, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(BuildDir, true);
            long BuildDirEncoded = stack.getPointerAddress();
            long l = ClangCompilationDatabase.nclang_CompilationDatabase_fromDirectory(BuildDirEncoded, MemoryUtil.memAddress(ErrorCode));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void clang_CompilationDatabase_dispose(@NativeType(value="CXCompilationDatabase") long database) {
        long __functionAddress = Functions.CompilationDatabase_dispose;
        if (Checks.CHECKS) {
            Checks.check(database);
        }
        JNI.invokePV(database, __functionAddress);
    }

    public static long nclang_CompilationDatabase_getCompileCommands(long database, long CompleteFileName) {
        long __functionAddress = Functions.CompilationDatabase_getCompileCommands;
        if (Checks.CHECKS) {
            Checks.check(database);
        }
        return JNI.invokePPP(database, CompleteFileName, __functionAddress);
    }

    @NativeType(value="CXCompileCommands")
    public static long clang_CompilationDatabase_getCompileCommands(@NativeType(value="CXCompilationDatabase") long database, @NativeType(value="char const *") ByteBuffer CompleteFileName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(CompleteFileName);
        }
        return ClangCompilationDatabase.nclang_CompilationDatabase_getCompileCommands(database, MemoryUtil.memAddress(CompleteFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CXCompileCommands")
    public static long clang_CompilationDatabase_getCompileCommands(@NativeType(value="CXCompilationDatabase") long database, @NativeType(value="char const *") CharSequence CompleteFileName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(CompleteFileName, true);
            long CompleteFileNameEncoded = stack.getPointerAddress();
            long l = ClangCompilationDatabase.nclang_CompilationDatabase_getCompileCommands(database, CompleteFileNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="CXCompileCommands")
    public static long clang_CompilationDatabase_getAllCompileCommands(@NativeType(value="CXCompilationDatabase") long database) {
        long __functionAddress = Functions.CompilationDatabase_getAllCompileCommands;
        if (Checks.CHECKS) {
            Checks.check(database);
        }
        return JNI.invokePP(database, __functionAddress);
    }

    public static void clang_CompileCommands_dispose(@NativeType(value="CXCompileCommands") long commands) {
        long __functionAddress = Functions.CompileCommands_dispose;
        if (Checks.CHECKS) {
            Checks.check(commands);
        }
        JNI.invokePV(commands, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int clang_CompileCommands_getSize(@NativeType(value="CXCompileCommands") long commands) {
        long __functionAddress = Functions.CompileCommands_getSize;
        if (Checks.CHECKS) {
            Checks.check(commands);
        }
        return JNI.invokePI(commands, __functionAddress);
    }

    @NativeType(value="CXCompileCommand")
    public static long clang_CompileCommands_getCommand(@NativeType(value="CXCompileCommands") long commands, @NativeType(value="unsigned int") int I) {
        long __functionAddress = Functions.CompileCommands_getCommand;
        if (Checks.CHECKS) {
            Checks.check(commands);
        }
        return JNI.invokePP(commands, I, __functionAddress);
    }

    public static native void nclang_CompileCommand_getDirectory(long var0, long var2, long var4);

    public static void nclang_CompileCommand_getDirectory(long command, long __result) {
        long __functionAddress = Functions.CompileCommand_getDirectory;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        ClangCompilationDatabase.nclang_CompileCommand_getDirectory(command, __functionAddress, __result);
    }

    public static CXString clang_CompileCommand_getDirectory(@NativeType(value="CXCompileCommand") long command, CXString __result) {
        ClangCompilationDatabase.nclang_CompileCommand_getDirectory(command, __result.address());
        return __result;
    }

    public static native void nclang_CompileCommand_getFilename(long var0, long var2, long var4);

    public static void nclang_CompileCommand_getFilename(long command, long __result) {
        long __functionAddress = Functions.CompileCommand_getFilename;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        ClangCompilationDatabase.nclang_CompileCommand_getFilename(command, __functionAddress, __result);
    }

    public static CXString clang_CompileCommand_getFilename(@NativeType(value="CXCompileCommand") long command, CXString __result) {
        ClangCompilationDatabase.nclang_CompileCommand_getFilename(command, __result.address());
        return __result;
    }

    @NativeType(value="unsigned int")
    public static int clang_CompileCommand_getNumArgs(@NativeType(value="CXCompileCommand") long command) {
        long __functionAddress = Functions.CompileCommand_getNumArgs;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        return JNI.invokePI(command, __functionAddress);
    }

    public static native void nclang_CompileCommand_getArg(long var0, int var2, long var3, long var5);

    public static void nclang_CompileCommand_getArg(long command, int I, long __result) {
        long __functionAddress = Functions.CompileCommand_getArg;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        ClangCompilationDatabase.nclang_CompileCommand_getArg(command, I, __functionAddress, __result);
    }

    public static CXString clang_CompileCommand_getArg(@NativeType(value="CXCompileCommand") long command, @NativeType(value="unsigned int") int I, CXString __result) {
        ClangCompilationDatabase.nclang_CompileCommand_getArg(command, I, __result.address());
        return __result;
    }

    @NativeType(value="unsigned int")
    public static int clang_CompileCommand_getNumMappedSources(@NativeType(value="CXCompileCommand") long command) {
        long __functionAddress = Functions.CompileCommand_getNumMappedSources;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        return JNI.invokePI(command, __functionAddress);
    }

    public static native void nclang_CompileCommand_getMappedSourcePath(long var0, int var2, long var3, long var5);

    public static void nclang_CompileCommand_getMappedSourcePath(long command, int I, long __result) {
        long __functionAddress = Functions.CompileCommand_getMappedSourcePath;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        ClangCompilationDatabase.nclang_CompileCommand_getMappedSourcePath(command, I, __functionAddress, __result);
    }

    public static CXString clang_CompileCommand_getMappedSourcePath(@NativeType(value="CXCompileCommand") long command, @NativeType(value="unsigned int") int I, CXString __result) {
        ClangCompilationDatabase.nclang_CompileCommand_getMappedSourcePath(command, I, __result.address());
        return __result;
    }

    public static native void nclang_CompileCommand_getMappedSourceContent(long var0, int var2, long var3, long var5);

    public static void nclang_CompileCommand_getMappedSourceContent(long command, int I, long __result) {
        long __functionAddress = Functions.CompileCommand_getMappedSourceContent;
        if (Checks.CHECKS) {
            Checks.check(command);
        }
        ClangCompilationDatabase.nclang_CompileCommand_getMappedSourceContent(command, I, __functionAddress, __result);
    }

    public static CXString clang_CompileCommand_getMappedSourceContent(@NativeType(value="CXCompileCommand") long command, @NativeType(value="unsigned int") int I, CXString __result) {
        ClangCompilationDatabase.nclang_CompileCommand_getMappedSourceContent(command, I, __result.address());
        return __result;
    }

    static {
        LibLLVM.initialize();
    }

    public static final class Functions {
        public static final long CompilationDatabase_fromDirectory = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompilationDatabase_fromDirectory");
        public static final long CompilationDatabase_dispose = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompilationDatabase_dispose");
        public static final long CompilationDatabase_getCompileCommands = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompilationDatabase_getCompileCommands");
        public static final long CompilationDatabase_getAllCompileCommands = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompilationDatabase_getAllCompileCommands");
        public static final long CompileCommands_dispose = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommands_dispose");
        public static final long CompileCommands_getSize = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommands_getSize");
        public static final long CompileCommands_getCommand = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommands_getCommand");
        public static final long CompileCommand_getDirectory = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getDirectory");
        public static final long CompileCommand_getFilename = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getFilename");
        public static final long CompileCommand_getNumArgs = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getNumArgs");
        public static final long CompileCommand_getArg = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getArg");
        public static final long CompileCommand_getNumMappedSources = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getNumMappedSources");
        public static final long CompileCommand_getMappedSourcePath = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getMappedSourcePath");
        public static final long CompileCommand_getMappedSourceContent = APIUtil.apiGetFunctionAddress(ClangIndex.getLibrary(), "clang_CompileCommand_getMappedSourceContent");

        private Functions() {
        }
    }
}

