/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.CXSourceLocation;
import org.lwjgl.llvm.CXSourceRange;
import org.lwjgl.llvm.LibLLVM;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class ClangRewrite {
    private static final SharedLibrary CLANG;

    public static SharedLibrary getLibrary() {
        return CLANG;
    }

    protected ClangRewrite() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="CXRewriter")
    public static long clang_CXRewriter_create(@NativeType(value="CXTranslationUnit") long TU) {
        long __functionAddress = Functions.create;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(TU);
        }
        return JNI.invokePP(TU, __functionAddress);
    }

    public static native void nclang_CXRewriter_insertTextBefore(long var0, long var2, long var4, long var6);

    public static void nclang_CXRewriter_insertTextBefore(long Rew, long Loc, long Insert) {
        long __functionAddress = Functions.insertTextBefore;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        ClangRewrite.nclang_CXRewriter_insertTextBefore(Rew, Loc, Insert, __functionAddress);
    }

    public static void clang_CXRewriter_insertTextBefore(@NativeType(value="CXRewriter") long Rew, CXSourceLocation Loc, @NativeType(value="char const *") ByteBuffer Insert) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Insert);
        }
        ClangRewrite.nclang_CXRewriter_insertTextBefore(Rew, Loc.address(), MemoryUtil.memAddress(Insert));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clang_CXRewriter_insertTextBefore(@NativeType(value="CXRewriter") long Rew, CXSourceLocation Loc, @NativeType(value="char const *") CharSequence Insert) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Insert, true);
            long InsertEncoded = stack.getPointerAddress();
            ClangRewrite.nclang_CXRewriter_insertTextBefore(Rew, Loc.address(), InsertEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nclang_CXRewriter_replaceText(long var0, long var2, long var4, long var6);

    public static void nclang_CXRewriter_replaceText(long Rew, long ToBeReplaced, long Replacement) {
        long __functionAddress = Functions.replaceText;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        ClangRewrite.nclang_CXRewriter_replaceText(Rew, ToBeReplaced, Replacement, __functionAddress);
    }

    public static void clang_CXRewriter_replaceText(@NativeType(value="CXRewriter") long Rew, CXSourceRange ToBeReplaced, @NativeType(value="char const *") ByteBuffer Replacement) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Replacement);
        }
        ClangRewrite.nclang_CXRewriter_replaceText(Rew, ToBeReplaced.address(), MemoryUtil.memAddress(Replacement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clang_CXRewriter_replaceText(@NativeType(value="CXRewriter") long Rew, CXSourceRange ToBeReplaced, @NativeType(value="char const *") CharSequence Replacement) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Replacement, true);
            long ReplacementEncoded = stack.getPointerAddress();
            ClangRewrite.nclang_CXRewriter_replaceText(Rew, ToBeReplaced.address(), ReplacementEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nclang_CXRewriter_removeText(long var0, long var2, long var4);

    public static void nclang_CXRewriter_removeText(long Rew, long ToBeRemoved) {
        long __functionAddress = Functions.removeText;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        ClangRewrite.nclang_CXRewriter_removeText(Rew, ToBeRemoved, __functionAddress);
    }

    public static void clang_CXRewriter_removeText(@NativeType(value="CXRewriter") long Rew, CXSourceRange ToBeRemoved) {
        ClangRewrite.nclang_CXRewriter_removeText(Rew, ToBeRemoved.address());
    }

    @NativeType(value="int")
    public static boolean clang_CXRewriter_overwriteChangedFiles(@NativeType(value="CXRewriter") long Rew) {
        long __functionAddress = Functions.overwriteChangedFiles;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        return JNI.invokePI(Rew, __functionAddress) != 0;
    }

    public static void clang_CXRewriter_writeMainFileToStdOut(@NativeType(value="CXRewriter") long Rew) {
        long __functionAddress = Functions.writeMainFileToStdOut;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        JNI.invokePV(Rew, __functionAddress);
    }

    public static void clang_CXRewriter_dispose(@NativeType(value="CXRewriter") long Rew) {
        long __functionAddress = Functions.dispose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Rew);
        }
        JNI.invokePV(Rew, __functionAddress);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return CLANG;
    }

    static {
        LibLLVM.initialize();
        CLANG = Library.loadNative(ClangRewrite.class, "org.lwjgl.llvm", Configuration.LLVM_CLANG_LIBRARY_NAME, "clang", "libclang");
    }

    public static final class Functions {
        public static final long create = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_create");
        public static final long insertTextBefore = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_insertTextBefore");
        public static final long replaceText = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_replaceText");
        public static final long removeText = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_removeText");
        public static final long overwriteChangedFiles = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_overwriteChangedFiles");
        public static final long writeMainFileToStdOut = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_writeMainFileToStdOut");
        public static final long dispose = ClangRewrite.access$000().getFunctionAddress("clang_CXRewriter_dispose");

        private Functions() {
        }
    }
}

