/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMError {
    public static final int LLVMErrorSuccess = 0;

    protected LLVMError() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetErrorTypeId(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.GetErrorTypeId;
        if (Checks.CHECKS) {
            Checks.check(Err);
        }
        return JNI.invokePP(Err, __functionAddress);
    }

    public static void LLVMConsumeError(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.ConsumeError;
        if (Checks.CHECKS) {
            Checks.check(Err);
        }
        JNI.invokePV(Err, __functionAddress);
    }

    public static long nLLVMGetErrorMessage(long Err) {
        long __functionAddress = Functions.GetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check(Err);
        }
        return JNI.invokePP(Err, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer LLVMGetErrorMessage(@NativeType(value="LLVMErrorRef") long Err) {
        long __result = LLVMError.nLLVMGetErrorMessage(Err);
        return MemoryUtil.memByteBufferNT1Safe(__result);
    }

    public static void nLLVMDisposeErrorMessage(long ErrMsg) {
        long __functionAddress = Functions.DisposeErrorMessage;
        JNI.invokePV(ErrMsg, __functionAddress);
    }

    public static void LLVMDisposeErrorMessage(@NativeType(value="char *") ByteBuffer ErrMsg) {
        LLVMError.nLLVMDisposeErrorMessage(MemoryUtil.memAddress(ErrMsg));
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetStringErrorTypeId() {
        long __functionAddress = Functions.GetStringErrorTypeId;
        return JNI.invokeP(__functionAddress);
    }

    public static long nLLVMCreateStringError(long ErrMsg) {
        long __functionAddress = Functions.CreateStringError;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(ErrMsg, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMCreateStringError(@NativeType(value="char const *") ByteBuffer ErrMsg) {
        if (Checks.CHECKS) {
            Checks.checkNT1(ErrMsg);
        }
        return LLVMError.nLLVMCreateStringError(MemoryUtil.memAddress(ErrMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMCreateStringError(@NativeType(value="char const *") CharSequence ErrMsg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ErrMsg, true);
            long ErrMsgEncoded = stack.getPointerAddress();
            long l = LLVMError.nLLVMCreateStringError(ErrMsgEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long GetErrorTypeId = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetErrorTypeId");
        public static final long ConsumeError = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMConsumeError");
        public static final long GetErrorMessage = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetErrorMessage");
        public static final long DisposeErrorMessage = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeErrorMessage");
        public static final long GetStringErrorTypeId = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetStringErrorTypeId");
        public static final long CreateStringError = LLVMCore.getLibrary().getFunctionAddress("LLVMCreateStringError");

        private Functions() {
        }
    }
}

