/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunctionI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMLLJIT {
    protected LLVMLLJIT() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMOrcLLJITBuilderRef")
    public static long LLVMOrcCreateLLJITBuilder() {
        long __functionAddress = Functions.OrcCreateLLJITBuilder;
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMOrcDisposeLLJITBuilder(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder2) {
        long __functionAddress = Functions.OrcDisposeLLJITBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        JNI.invokePV(Builder2, __functionAddress);
    }

    public static void LLVMOrcLLJITBuilderSetJITTargetMachineBuilder(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder2, @NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __functionAddress = Functions.OrcLLJITBuilderSetJITTargetMachineBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(JTMB);
        }
        JNI.invokePPV(Builder2, JTMB, __functionAddress);
    }

    public static void nLLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(long Builder2, long F, long Ctx) {
        long __functionAddress = Functions.OrcLLJITBuilderSetObjectLinkingLayerCreator;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ctx);
        }
        JNI.invokePPPV(Builder2, F, Ctx, __functionAddress);
    }

    public static void LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder2, @NativeType(value="LLVMOrcObjectLayerRef (*) (void *, LLVMOrcExecutionSessionRef, char const *)") LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunctionI F, @NativeType(value="void *") long Ctx) {
        LLVMLLJIT.nLLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(Builder2, F.address(), Ctx);
    }

    public static long nLLVMOrcCreateLLJIT(long Result, long Builder2) {
        long __functionAddress = Functions.OrcCreateLLJIT;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPP(Result, Builder2, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLLJIT(@NativeType(value="LLVMOrcLLJITRef *") PointerBuffer Result, @NativeType(value="LLVMOrcLLJITBuilderRef") long Builder2) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
        }
        return LLVMLLJIT.nLLVMOrcCreateLLJIT(MemoryUtil.memAddress(Result), Builder2);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcDisposeLLJIT(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcDisposeLLJIT;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @NativeType(value="LLVMOrcExecutionSessionRef")
    public static long LLVMOrcLLJITGetExecutionSession(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetExecutionSession;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcLLJITGetMainJITDylib(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetMainJITDylib;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    public static long nLLVMOrcLLJITGetTripleString(long J) {
        long __functionAddress = Functions.OrcLLJITGetTripleString;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOrcLLJITGetTripleString(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __result = LLVMLLJIT.nLLVMOrcLLJITGetTripleString(J);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="char")
    public static byte LLVMOrcLLJITGetGlobalPrefix(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetGlobalPrefix;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePB(J, __functionAddress);
    }

    public static long nLLVMOrcLLJITMangleAndIntern(long J, long UnmangledName) {
        long __functionAddress = Functions.OrcLLJITMangleAndIntern;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePPP(J, UnmangledName, __functionAddress);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcLLJITMangleAndIntern(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="char const *") ByteBuffer UnmangledName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(UnmangledName);
        }
        return LLVMLLJIT.nLLVMOrcLLJITMangleAndIntern(J, MemoryUtil.memAddress(UnmangledName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcLLJITMangleAndIntern(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="char const *") CharSequence UnmangledName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(UnmangledName, true);
            long UnmangledNameEncoded = stack.getPointerAddress();
            long l = LLVMLLJIT.nLLVMOrcLLJITMangleAndIntern(J, UnmangledNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddObjectFile(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcLLJITAddObjectFile;
        if (Checks.CHECKS) {
            Checks.check(J);
            Checks.check(JD);
            Checks.check(ObjBuffer);
        }
        return JNI.invokePPPP(J, JD, ObjBuffer, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddObjectFileWithRT(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcResourceTrackerRef") long RT, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcLLJITAddObjectFileWithRT;
        if (Checks.CHECKS) {
            Checks.check(J);
            Checks.check(RT);
            Checks.check(ObjBuffer);
        }
        return JNI.invokePPPP(J, RT, ObjBuffer, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddLLVMIRModule(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcLLJITAddLLVMIRModule;
        if (Checks.CHECKS) {
            Checks.check(J);
            Checks.check(JD);
            Checks.check(TSM);
        }
        return JNI.invokePPPP(J, JD, TSM, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddLLVMIRModuleWithRT(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcResourceTrackerRef") long JD, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcLLJITAddLLVMIRModuleWithRT;
        if (Checks.CHECKS) {
            Checks.check(J);
            Checks.check(JD);
            Checks.check(TSM);
        }
        return JNI.invokePPPP(J, JD, TSM, __functionAddress);
    }

    public static long nLLVMOrcLLJITLookup(long J, long Result, long Name2) {
        long __functionAddress = Functions.OrcLLJITLookup;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePPPP(J, Result, Name2, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITLookup(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcExecutorAddress *") LongBuffer Result, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Result, 1);
            Checks.checkNT1(Name2);
        }
        return LLVMLLJIT.nLLVMOrcLLJITLookup(J, MemoryUtil.memAddress(Result), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITLookup(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcExecutorAddress *") LongBuffer Result, @NativeType(value="char const *") CharSequence Name2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Result, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMLLJIT.nLLVMOrcLLJITLookup(J, MemoryUtil.memAddress(Result), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMOrcObjectLayerRef")
    public static long LLVMOrcLLJITGetObjLinkingLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetObjLinkingLayer;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @NativeType(value="LLVMOrcObjectTransformLayerRef")
    public static long LLVMOrcLLJITGetObjTransformLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetObjTransformLayer;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @NativeType(value="LLVMOrcIRTransformLayerRef")
    public static long LLVMOrcLLJITGetIRTransformLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetIRTransformLayer;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    public static long nLLVMOrcLLJITGetDataLayoutStr(long J) {
        long __functionAddress = Functions.OrcLLJITGetDataLayoutStr;
        if (Checks.CHECKS) {
            Checks.check(J);
        }
        return JNI.invokePP(J, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOrcLLJITGetDataLayoutStr(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __result = LLVMLLJIT.nLLVMOrcLLJITGetDataLayoutStr(J);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static final class Functions {
        public static final long OrcCreateLLJITBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateLLJITBuilder");
        public static final long OrcDisposeLLJITBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeLLJITBuilder");
        public static final long OrcLLJITBuilderSetJITTargetMachineBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITBuilderSetJITTargetMachineBuilder");
        public static final long OrcLLJITBuilderSetObjectLinkingLayerCreator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator");
        public static final long OrcCreateLLJIT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateLLJIT");
        public static final long OrcDisposeLLJIT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeLLJIT");
        public static final long OrcLLJITGetExecutionSession = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetExecutionSession");
        public static final long OrcLLJITGetMainJITDylib = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetMainJITDylib");
        public static final long OrcLLJITGetTripleString = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetTripleString");
        public static final long OrcLLJITGetGlobalPrefix = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetGlobalPrefix");
        public static final long OrcLLJITMangleAndIntern = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITMangleAndIntern");
        public static final long OrcLLJITAddObjectFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITAddObjectFile");
        public static final long OrcLLJITAddObjectFileWithRT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITAddObjectFileWithRT");
        public static final long OrcLLJITAddLLVMIRModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITAddLLVMIRModule");
        public static final long OrcLLJITAddLLVMIRModuleWithRT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITAddLLVMIRModuleWithRT");
        public static final long OrcLLJITLookup = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITLookup");
        public static final long OrcLLJITGetObjLinkingLayer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetObjLinkingLayer");
        public static final long OrcLLJITGetObjTransformLayer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetObjTransformLayer");
        public static final long OrcLLJITGetIRTransformLayer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetIRTransformLayer");
        public static final long OrcLLJITGetDataLayoutStr = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcLLJITGetDataLayoutStr");

        private Functions() {
        }
    }
}

