/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LLVMMCJITCompilerOptions")
public class LLVMMCJITCompilerOptions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPTLEVEL;
    public static final int CODEMODEL;
    public static final int NOFRAMEPOINTERELIM;
    public static final int ENABLEFASTISEL;
    public static final int MCJMM;

    public LLVMMCJITCompilerOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMMCJITCompilerOptions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int OptLevel() {
        return LLVMMCJITCompilerOptions.nOptLevel(this.address());
    }

    @NativeType(value="LLVMCodeModel")
    public int CodeModel() {
        return LLVMMCJITCompilerOptions.nCodeModel(this.address());
    }

    @NativeType(value="LLVMBool")
    public boolean NoFramePointerElim() {
        return LLVMMCJITCompilerOptions.nNoFramePointerElim(this.address()) != 0;
    }

    @NativeType(value="LLVMBool")
    public boolean EnableFastISel() {
        return LLVMMCJITCompilerOptions.nEnableFastISel(this.address()) != 0;
    }

    @NativeType(value="LLVMMCJITMemoryManagerRef")
    public long MCJMM() {
        return LLVMMCJITCompilerOptions.nMCJMM(this.address());
    }

    public LLVMMCJITCompilerOptions OptLevel(@NativeType(value="unsigned int") int value) {
        LLVMMCJITCompilerOptions.nOptLevel(this.address(), value);
        return this;
    }

    public LLVMMCJITCompilerOptions CodeModel(@NativeType(value="LLVMCodeModel") int value) {
        LLVMMCJITCompilerOptions.nCodeModel(this.address(), value);
        return this;
    }

    public LLVMMCJITCompilerOptions NoFramePointerElim(@NativeType(value="LLVMBool") boolean value) {
        LLVMMCJITCompilerOptions.nNoFramePointerElim(this.address(), value ? 1 : 0);
        return this;
    }

    public LLVMMCJITCompilerOptions EnableFastISel(@NativeType(value="LLVMBool") boolean value) {
        LLVMMCJITCompilerOptions.nEnableFastISel(this.address(), value ? 1 : 0);
        return this;
    }

    public LLVMMCJITCompilerOptions MCJMM(@NativeType(value="LLVMMCJITMemoryManagerRef") long value) {
        LLVMMCJITCompilerOptions.nMCJMM(this.address(), value);
        return this;
    }

    public LLVMMCJITCompilerOptions set(int OptLevel, int CodeModel, boolean NoFramePointerElim, boolean EnableFastISel, long MCJMM) {
        this.OptLevel(OptLevel);
        this.CodeModel(CodeModel);
        this.NoFramePointerElim(NoFramePointerElim);
        this.EnableFastISel(EnableFastISel);
        this.MCJMM(MCJMM);
        return this;
    }

    public LLVMMCJITCompilerOptions set(LLVMMCJITCompilerOptions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMMCJITCompilerOptions malloc() {
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMMCJITCompilerOptions calloc() {
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMMCJITCompilerOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMMCJITCompilerOptions create(long address) {
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, address);
    }

    @Nullable
    public static LLVMMCJITCompilerOptions createSafe(long address) {
        return address == 0L ? null : LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMMCJITCompilerOptions.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMMCJITCompilerOptions.__create(capacity, SIZEOF);
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMMCJITCompilerOptions.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static LLVMMCJITCompilerOptions mallocStack() {
        return LLVMMCJITCompilerOptions.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMMCJITCompilerOptions callocStack() {
        return LLVMMCJITCompilerOptions.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMMCJITCompilerOptions mallocStack(MemoryStack stack) {
        return LLVMMCJITCompilerOptions.malloc(stack);
    }

    @Deprecated
    public static LLVMMCJITCompilerOptions callocStack(MemoryStack stack) {
        return LLVMMCJITCompilerOptions.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LLVMMCJITCompilerOptions.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LLVMMCJITCompilerOptions.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LLVMMCJITCompilerOptions.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LLVMMCJITCompilerOptions.calloc(capacity, stack);
    }

    public static LLVMMCJITCompilerOptions malloc(MemoryStack stack) {
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMMCJITCompilerOptions calloc(MemoryStack stack) {
        return LLVMMCJITCompilerOptions.wrap(LLVMMCJITCompilerOptions.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMMCJITCompilerOptions.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nOptLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)OPTLEVEL);
    }

    public static int nCodeModel(long struct) {
        return UNSAFE.getInt(null, struct + (long)CODEMODEL);
    }

    public static int nNoFramePointerElim(long struct) {
        return UNSAFE.getInt(null, struct + (long)NOFRAMEPOINTERELIM);
    }

    public static int nEnableFastISel(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEFASTISEL);
    }

    public static long nMCJMM(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MCJMM);
    }

    public static void nOptLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OPTLEVEL, value);
    }

    public static void nCodeModel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CODEMODEL, value);
    }

    public static void nNoFramePointerElim(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NOFRAMEPOINTERELIM, value);
    }

    public static void nEnableFastISel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEFASTISEL, value);
    }

    public static void nMCJMM(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MCJMM, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MCJMM));
    }

    static {
        Struct.Layout layout = LLVMMCJITCompilerOptions.__struct(LLVMMCJITCompilerOptions.__member(4), LLVMMCJITCompilerOptions.__member(4), LLVMMCJITCompilerOptions.__member(4), LLVMMCJITCompilerOptions.__member(4), LLVMMCJITCompilerOptions.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPTLEVEL = layout.offsetof(0);
        CODEMODEL = layout.offsetof(1);
        NOFRAMEPOINTERELIM = layout.offsetof(2);
        ENABLEFASTISEL = layout.offsetof(3);
        MCJMM = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<LLVMMCJITCompilerOptions, Buffer>
    implements NativeResource {
        private static final LLVMMCJITCompilerOptions ELEMENT_FACTORY = LLVMMCJITCompilerOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMMCJITCompilerOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int OptLevel() {
            return LLVMMCJITCompilerOptions.nOptLevel(this.address());
        }

        @NativeType(value="LLVMCodeModel")
        public int CodeModel() {
            return LLVMMCJITCompilerOptions.nCodeModel(this.address());
        }

        @NativeType(value="LLVMBool")
        public boolean NoFramePointerElim() {
            return LLVMMCJITCompilerOptions.nNoFramePointerElim(this.address()) != 0;
        }

        @NativeType(value="LLVMBool")
        public boolean EnableFastISel() {
            return LLVMMCJITCompilerOptions.nEnableFastISel(this.address()) != 0;
        }

        @NativeType(value="LLVMMCJITMemoryManagerRef")
        public long MCJMM() {
            return LLVMMCJITCompilerOptions.nMCJMM(this.address());
        }

        public Buffer OptLevel(@NativeType(value="unsigned int") int value) {
            LLVMMCJITCompilerOptions.nOptLevel(this.address(), value);
            return this;
        }

        public Buffer CodeModel(@NativeType(value="LLVMCodeModel") int value) {
            LLVMMCJITCompilerOptions.nCodeModel(this.address(), value);
            return this;
        }

        public Buffer NoFramePointerElim(@NativeType(value="LLVMBool") boolean value) {
            LLVMMCJITCompilerOptions.nNoFramePointerElim(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer EnableFastISel(@NativeType(value="LLVMBool") boolean value) {
            LLVMMCJITCompilerOptions.nEnableFastISel(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer MCJMM(@NativeType(value="LLVMMCJITMemoryManagerRef") long value) {
            LLVMMCJITCompilerOptions.nMCJMM(this.address(), value);
            return this;
        }
    }
}

